/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.openhft.chronicle.bytes.MethodId;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.util.Annotations;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.IntConversion;
import net.openhft.chronicle.wire.IntConverter;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.LongConverter;
import net.openhft.chronicle.wire.MethodFilterOnFirstArg;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ReflectionUtil;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.utils.JavaSourceCodeFormatter;
import net.openhft.chronicle.wire.utils.SourceCodeFormatter;
import net.openhft.compiler.CompilerUtils;

public class GenerateMethodReader {
    private static final boolean DUMP_CODE = Jvm.getBoolean((String)"dumpCode");
    private final WireType wireType;
    private final Object[] instances;
    private final Set<String> handledMethodNames = new HashSet<String>();
    private final Set<String> handledMethodSignatures = new HashSet<String>();
    private final Set<Class<?>> handledInterfaces = new HashSet();
    private final Set<String> handledChainedInterfaces = new HashSet<String>();
    private final SourceCodeFormatter sourceCode = new JavaSourceCodeFormatter();
    private final SourceCodeFormatter fields = new JavaSourceCodeFormatter();
    private final SourceCodeFormatter eventNameSwitchBlock = new JavaSourceCodeFormatter();
    private final SourceCodeFormatter eventIdSwitchBlock = new JavaSourceCodeFormatter();
    private final SourceCodeFormatter numericConverters = new JavaSourceCodeFormatter();
    private final SourceCodeFormatter chainedCallResults = new JavaSourceCodeFormatter();
    private boolean methodFilterPresent;
    private boolean isSourceCodeGenerated;

    public GenerateMethodReader(WireType wireType, Object ... instances) {
        this.wireType = wireType;
        this.instances = instances;
    }

    public Class<?> createClass() {
        if (!this.isSourceCodeGenerated) {
            this.generateSourceCode();
        }
        if (DUMP_CODE) {
            System.out.println(this.sourceCode);
        }
        ClassLoader classLoader = this.instances[0].getClass().getClassLoader();
        try {
            return CompilerUtils.CACHED_COMPILER.loadFromJava(classLoader, this.packageName() + '.' + this.generatedClassName(), this.sourceCode.toString());
        }
        catch (LinkageError e) {
            try {
                return Class.forName(this.packageName() + '.' + this.generatedClassName(), true, classLoader);
            }
            catch (ClassNotFoundException x) {
                throw Jvm.rethrow((Throwable)x);
            }
        }
        catch (Throwable e) {
            throw Jvm.rethrow((Throwable)new ClassNotFoundException(e.getMessage() + '\n' + this.sourceCode, e));
        }
    }

    private void generateSourceCode() {
        int i;
        for (i = 0; i < this.instances.length; ++i) {
            Class<?> aClass = this.instances[i].getClass();
            boolean methodFilter = this.instances[i] instanceof MethodFilterOnFirstArg;
            this.methodFilterPresent |= methodFilter;
            for (Class<?> anInterface : ReflectionUtil.interfaces(aClass)) {
                this.handleInterface(anInterface, "instance" + i, methodFilter);
            }
        }
        if (!this.packageName().isEmpty()) {
            this.sourceCode.append(String.format("package %s;\n", this.packageName()));
        }
        this.sourceCode.append("import net.openhft.chronicle.bytes.MethodReader;\nimport net.openhft.chronicle.core.Jvm;\nimport net.openhft.chronicle.core.util.ObjectUtils;\nimport net.openhft.chronicle.wire.*;\n\nimport java.util.function.Supplier;\n\n");
        this.sourceCode.append(String.format("public class %s extends AbstractGeneratedMethodReader {\n", this.generatedClassName()));
        this.sourceCode.append("// instances on which parsed calls are invoked\n");
        for (i = 0; i < this.instances.length; ++i) {
            this.sourceCode.append(String.format("private final Object instance%d;\n", i));
        }
        this.sourceCode.append("\n");
        this.sourceCode.append(this.fields);
        if (this.methodFilterPresent) {
            this.sourceCode.append("// flag for handling ignoreMethodBasedOnFirstArg\n");
            this.sourceCode.append("private boolean ignored;\n\n");
        }
        if (this.numericConverters.length() > 0) {
            this.sourceCode.append("// numeric converters\n");
            this.sourceCode.append(this.numericConverters);
            this.sourceCode.append("\n");
        }
        if (!this.handledChainedInterfaces.isEmpty()) {
            this.sourceCode.append("// chained call results\n");
            this.sourceCode.append(this.chainedCallResults);
            this.sourceCode.append("\n");
        }
        this.sourceCode.append(String.format("public %s(MarshallableIn in, WireParselet debugLoggingParselet,Supplier<MethodReader> delegateSupplier, Object... instances) {\nsuper(in, debugLoggingParselet, delegateSupplier);\n", this.generatedClassName()));
        for (i = 0; i < this.instances.length - 1; ++i) {
            this.sourceCode.append(String.format("instance%d = instances[%d];\n", i, i));
        }
        this.sourceCode.append(String.format("instance%d = instances[%d];\n}\n\n", this.instances.length - 1, this.instances.length - 1));
        this.sourceCode.append("@Override\nprotected boolean readOneCall(WireIn wireIn) {\nString lastEventName = \"\";\nif (wireIn.bytes().peekUnsignedByte() == BinaryWireCode.FIELD_NUMBER) {\nint methodId = (int) wireIn.readEventNumber();\nswitch (methodId) {\n");
        this.sourceCode.append(this.eventIdSwitchBlock);
        this.sourceCode.append("default:\nreturn false;\n}\n}\nelse {\nlastEventName = wireIn.readEvent(String.class);\n}\nValueIn valueIn = wireIn.getValueIn();\ntry {\nif (Jvm.isDebug())\ndebugLoggingParselet.accept(lastEventName, valueIn);\nswitch (lastEventName) {\ncase MethodReader.HISTORY:\nvalueIn.marshallable(messageHistory);\nbreak;\n\n");
        this.sourceCode.append(this.eventNameSwitchBlock);
        this.sourceCode.append("default:\nreturn false;\n}\nreturn true;\n} \ncatch (Exception e) {\nJvm.warn().on(this.getClass(), \"Failure to dispatch message, will retry to process without generated code: \" + lastEventName + \"()\", e);\nreturn false;\n}\n}\n}\n");
        this.isSourceCodeGenerated = true;
    }

    private void handleInterface(Class<?> anInterface, String instanceFieldName, boolean methodFilter) {
        if (!this.handledInterfaces.add(anInterface)) {
            return;
        }
        for (Method m : anInterface.getMethods()) {
            Class<?> declaringClass = m.getDeclaringClass();
            if (declaringClass == Object.class || Modifier.isStatic(m.getModifiers()) || "ignoreMethodBasedOnFirstArg".equals(m.getName()) || !this.handledMethodSignatures.add(GenerateMethodReader.signature(m))) continue;
            try {
                Object.class.getMethod(m.getName(), m.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (!this.handledMethodNames.add(m.getName())) {
                    throw new IllegalStateException("MethodReader does not support overloaded methods. Method: " + m.toString());
                }
                this.handleMethod(m, anInterface, instanceFieldName, methodFilter);
            }
        }
    }

    private void handleMethod(Method m, Class<?> anInterface, String instanceFieldName, boolean methodFilter) {
        MethodId methodIdAnnotation;
        Jvm.setAccessible((AccessibleObject)m);
        Class<?>[] parameterTypes = m.getParameterTypes();
        Class<?> chainReturnType = m.getReturnType();
        if (!chainReturnType.isInterface() || Jvm.dontChain(chainReturnType)) {
            chainReturnType = null;
        }
        if (parameterTypes.length > 0) {
            this.fields.append(String.format("// %s\n", m.getName()));
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            String typeName = parameterType.getCanonicalName();
            if (parameterType.isPrimitive()) {
                this.fields.append(String.format("private %s %sarg%d;\n", typeName, m.getName(), i));
                continue;
            }
            this.fields.append(String.format("private %s %sarg%dtype = ObjectUtils.implementationToUse(%s.class);\n", "Class", m.getName(), i, typeName));
            Class implToUse = ObjectUtils.implementationToUse(parameterType);
            if (ReadMarshallable.class.isAssignableFrom(implToUse)) {
                this.fields.append(String.format("private %s %sarg%d = ObjectUtils.newInstance(%s.class);\n", typeName, m.getName(), i, implToUse.getCanonicalName()));
                continue;
            }
            this.fields.append(String.format("private %s %sarg%d;\n", typeName, m.getName(), i));
        }
        if (chainReturnType != null && this.handledChainedInterfaces.add(chainReturnType.getSimpleName())) {
            this.chainedCallResults.append(String.format("private %s res%s;\n", chainReturnType.getCanonicalName(), chainReturnType.getSimpleName()));
        }
        if (parameterTypes.length > 0) {
            this.fields.append("\n");
        }
        if ((methodIdAnnotation = (MethodId)Annotations.getAnnotation((Method)m, MethodId.class)) != null) {
            int methodId = Maths.toInt32((long)methodIdAnnotation.value());
            this.eventIdSwitchBlock.append(String.format("case %d:\n", methodId));
            this.eventIdSwitchBlock.append(String.format("lastEventName = \"%s\";\n", m.getName()));
            this.eventIdSwitchBlock.append("break;\n\n");
        }
        String chainedCallPrefix = chainReturnType != null ? String.format("res%s = ", chainReturnType.getSimpleName()) : "";
        this.eventNameSwitchBlock.append(String.format("case \"%s\":\n", m.getName()));
        if (parameterTypes.length == 0) {
            this.eventNameSwitchBlock.append("valueIn.skipValue();\n");
            this.eventNameSwitchBlock.append(String.format("%s((%s) %s).%s();\n", chainedCallPrefix, anInterface.getCanonicalName(), instanceFieldName, m.getName()));
        } else if (parameterTypes.length == 1) {
            this.eventNameSwitchBlock.append(this.argumentRead(m, 0, false));
            this.eventNameSwitchBlock.append(String.format("%s((%s) %s).%s(%sarg%d);\n", chainedCallPrefix, anInterface.getCanonicalName(), instanceFieldName, m.getName(), m.getName(), 0));
        } else {
            int i;
            if (methodFilter) {
                this.eventNameSwitchBlock.append("ignored = false;\n");
                this.eventNameSwitchBlock.append("valueIn.sequence(this, (f, v) -> {\n");
                this.eventNameSwitchBlock.append(this.argumentRead(m, 0, true));
                this.eventNameSwitchBlock.append(String.format("if (((MethodFilterOnFirstArg) f.%s).ignoreMethodBasedOnFirstArg(\"%s\", f.%sarg%d)) {\n", instanceFieldName, m.getName(), m.getName(), 0));
                this.eventNameSwitchBlock.append("f.ignored = true;\n");
                this.eventNameSwitchBlock.append("}\n");
                this.eventNameSwitchBlock.append("else {\n");
                for (i = 1; i < parameterTypes.length; ++i) {
                    this.eventNameSwitchBlock.append(this.argumentRead(m, i, true));
                }
                this.eventNameSwitchBlock.append("}\n");
                this.eventNameSwitchBlock.append("});\n");
                this.eventNameSwitchBlock.append("if (!ignored)\n");
            } else {
                this.eventNameSwitchBlock.append("valueIn.sequence(this, (f, v) -> { // todo optimize megamorphic lambda call\n");
                for (i = 0; i < parameterTypes.length; ++i) {
                    this.eventNameSwitchBlock.append(this.argumentRead(m, i, true));
                }
                this.eventNameSwitchBlock.append("});\n");
            }
            ArrayList<String> args = new ArrayList<String>();
            for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
                args.add(m.getName() + "arg" + i2);
            }
            this.eventNameSwitchBlock.append(String.format("%s((%s) %s).%s(%s);\n", chainedCallPrefix, anInterface.getCanonicalName(), instanceFieldName, m.getName(), String.join((CharSequence)", ", args)));
        }
        this.eventNameSwitchBlock.append("break;\n\n");
        if (chainReturnType != null) {
            this.handleInterface(chainReturnType, "res" + chainReturnType.getSimpleName(), false);
        }
    }

    private String argumentRead(Method m, int argIndex, boolean inLambda) {
        String valueInName;
        Class<Object> numericConversionClass = null;
        if (this.wireType == WireType.TEXT || this.wireType == WireType.YAML) {
            Annotation[] annotations;
            for (Annotation a : annotations = m.getParameterAnnotations()[argIndex]) {
                if (a instanceof IntConversion) {
                    numericConversionClass = ((IntConversion)a).value();
                    break;
                }
                if (!(a instanceof LongConversion)) continue;
                numericConversionClass = ((LongConversion)a).value();
                break;
            }
        }
        Class<?> argumentType = m.getParameterTypes()[argIndex];
        String trueArgumentName = m.getName() + "arg" + argIndex;
        String argumentName = (inLambda ? "f." : "") + trueArgumentName;
        String string = valueInName = inLambda ? "v" : "valueIn";
        if (Boolean.TYPE.equals(argumentType)) {
            return String.format("%s = %s.bool();\n", argumentName, valueInName);
        }
        if (Byte.TYPE.equals(argumentType)) {
            return String.format("%s = %s.readByte();\n", argumentName, valueInName);
        }
        if (Character.TYPE.equals(argumentType)) {
            return String.format("%s = %s.character();\n", argumentName, valueInName);
        }
        if (Short.TYPE.equals(argumentType)) {
            return String.format("%s = %s.int16();\n", argumentName, valueInName);
        }
        if (Integer.TYPE.equals(argumentType)) {
            if (numericConversionClass != null && IntConverter.class.isAssignableFrom(numericConversionClass)) {
                this.numericConverters.append(String.format("private final %s %sConverter = ObjectUtils.newInstance(%s.class);\n", numericConversionClass.getCanonicalName(), trueArgumentName, numericConversionClass.getCanonicalName()));
                return String.format("%s = %sConverter.parse(%s.text());\n", argumentName, argumentName, valueInName);
            }
            return String.format("%s = %s.int32();\n", argumentName, valueInName);
        }
        if (Long.TYPE.equals(argumentType)) {
            if (numericConversionClass != null && LongConverter.class.isAssignableFrom(numericConversionClass)) {
                this.numericConverters.append(String.format("private final %s %sConverter = ObjectUtils.newInstance(%s.class);\n", numericConversionClass.getCanonicalName(), trueArgumentName, numericConversionClass.getCanonicalName()));
                return String.format("%s = %sConverter.parse(%s.text());\n", argumentName, argumentName, valueInName);
            }
            return String.format("%s = %s.int64();\n", argumentName, valueInName);
        }
        if (Float.TYPE.equals(argumentType)) {
            return String.format("%s = %s.float32();\n", argumentName, valueInName);
        }
        if (Double.TYPE.equals(argumentType)) {
            return String.format("%s = %s.float64();\n", argumentName, valueInName);
        }
        if (CharSequence.class.isAssignableFrom(argumentType)) {
            return String.format("%s = %s.text();\n", argumentName, valueInName);
        }
        return String.format("%s = %s.object(checkRecycle(%s), %stype);\n", argumentName, valueInName, argumentName, argumentName);
    }

    public String packageName() {
        Class<?> firstClass = this.instances[0].getClass();
        String firstClassFullName = firstClass.getName();
        int lastDot = firstClassFullName.lastIndexOf(46);
        if (lastDot != -1) {
            return firstClassFullName.substring(0, lastDot);
        }
        return "";
    }

    public String generatedClassName() {
        StringBuilder sb = new StringBuilder();
        for (Object i : this.instances) {
            int lambdaSlashIndex;
            String name;
            int packageDelimeterIndex;
            String nameWithoutPackage;
            Class<?> aClass = i.getClass();
            if (aClass.getEnclosingClass() != null) {
                sb.append(aClass.getEnclosingClass().getSimpleName());
            }
            String string = nameWithoutPackage = (packageDelimeterIndex = (name = aClass.getName()).lastIndexOf(46)) == -1 ? name : name.substring(packageDelimeterIndex + 1);
            if (aClass.isSynthetic() && !aClass.isAnonymousClass() && !aClass.isLocalClass() && (lambdaSlashIndex = nameWithoutPackage.lastIndexOf("/")) != -1) {
                nameWithoutPackage = nameWithoutPackage.substring(0, lambdaSlashIndex);
            }
            sb.append(nameWithoutPackage);
        }
        if (this.wireType != null) {
            sb.append(this.wireType.toString().replace("_", ""));
        }
        sb.append("MethodReader");
        return sb.toString();
    }

    private static String signature(Method m) {
        return m.getReturnType() + " " + m.getName() + " " + Arrays.toString(m.getParameterTypes());
    }
}

