/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.openhft.chronicle.bytes.UpdateInterceptor;
import net.openhft.chronicle.wire.AbstractClassGenerator;
import net.openhft.chronicle.wire.utils.SourceCodeFormatter;

public class GenerateMethodBridge
extends AbstractClassGenerator<MethodBridgeMetaData> {
    private List<String> fnameList;

    public GenerateMethodBridge() {
        super(new MethodBridgeMetaData());
    }

    public static Object bridgeFor(Class destType, List<Object> toInvoke, UpdateInterceptor ui) {
        GenerateMethodBridge gmb = new GenerateMethodBridge();
        MethodBridgeMetaData md = (MethodBridgeMetaData)gmb.metaData();
        md.packageName(destType.getPackage().getName());
        md.baseClassName(destType.getSimpleName());
        md.invokes(toInvoke.stream().map(o -> GenerateMethodBridge.findClass(o)).collect(Collectors.toList()));
        md.interfaces().add(destType);
        md.useUpdateInterceptor(ui != null);
        Class aClass = gmb.acquireClass(destType.getClassLoader());
        try {
            return ui == null ? aClass.getConstructor(List.class).newInstance(toInvoke) : aClass.getConstructor(List.class, UpdateInterceptor.class).newInstance(toInvoke, ui);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Class<?> findClass(Object o) {
        Class<?> aClass = o.getClass();
        Class<?>[] interfaces = aClass.getInterfaces();
        if (interfaces != null && interfaces.length > 0) {
            return interfaces[0];
        }
        return aClass;
    }

    @Override
    protected void generateFields(SourceCodeFormatter mainCode) {
        MethodBridgeMetaData md = (MethodBridgeMetaData)this.metaData();
        List handlers = md.invokes;
        this.fnameList = new ArrayList<String>();
        for (int i = 0; i < handlers.size(); ++i) {
            Class handler = (Class)handlers.get(i);
            String fname = this.fieldCase(handler);
            if (this.fnameList.contains(fname)) {
                fname = fname + this.fnameList.size();
            }
            this.fnameList.add(fname);
            if (i == 0) {
                this.withLineNumber(mainCode);
            }
            mainCode.append("private final ").append(this.nameForClass(handler)).append(' ').append(fname).append(";\n");
        }
    }

    @Override
    protected void generateConstructors(SourceCodeFormatter mainCode) {
        MethodBridgeMetaData md = (MethodBridgeMetaData)this.metaData();
        this.withLineNumber(mainCode).append("public ").append(this.className()).append("(").append(this.nameForClass(List.class)).append(" handlers");
        if (md.useUpdateInterceptor()) {
            mainCode.append(", ").append(this.nameForClass(UpdateInterceptor.class)).append(" updateInterceptor");
        }
        mainCode.append(") {\n");
        List handlers = ((MethodBridgeMetaData)this.metaData()).invokes;
        for (int i = 0; i < handlers.size(); ++i) {
            Class handler = (Class)handlers.get(i);
            mainCode.append("this.").append(this.fieldCase(handler)).append(" = (").append(this.nameForClass(handler)).append(") handlers.get(").append(i).append(");\n");
        }
        if (md.useUpdateInterceptor()) {
            mainCode.append("this.updateInterceptor = updateInterceptor;\n");
        }
        mainCode.append("}\n");
    }

    @Override
    protected void generateMethod(Method method, StringBuilder params, List<String> paramList, SourceCodeFormatter mainCode) {
        MethodBridgeMetaData md = (MethodBridgeMetaData)this.metaData();
        String name = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        List handlers = md.invokes;
        boolean first = true;
        for (int i = 0; i < handlers.size(); ++i) {
            Class handler = (Class)handlers.get(i);
            String fname = this.fnameList.get(i);
            try {
                handler.getMethod(name, parameterTypes);
                if (first) {
                    this.withLineNumber(mainCode);
                }
                first = false;
                mainCode.append("this.").append(fname).append(".").append(name).append("(").append(params).append(");\n");
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    static class MethodBridgeMetaData
    extends AbstractClassGenerator.MetaData<MethodBridgeMetaData> {
        private List<Class<?>> invokes = new ArrayList();

        MethodBridgeMetaData() {
        }

        public List<Class<?>> invokes() {
            return this.invokes;
        }

        public MethodBridgeMetaData invokes(List<Class<?>> handlers) {
            this.invokes = handlers;
            return this;
        }
    }
}

