/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.YamlKeys;
import net.openhft.chronicle.wire.YamlToken;
import org.jetbrains.annotations.NotNull;

public class YamlTokeniser {
    private static final int INIT_SIZE = 7;
    private static final int NO_INDENT = -1;
    static final Set<YamlToken> NO_TEXT = EnumSet.of(YamlToken.SEQUENCE_START, new YamlToken[]{YamlToken.SEQUENCE_ENTRY, YamlToken.SEQUENCE_END, YamlToken.MAPPING_START, YamlToken.MAPPING_KEY, YamlToken.MAPPING_END, YamlToken.DIRECTIVES_END});
    private final BytesIn in;
    private Bytes temp = null;
    private final List<YamlToken> pushed = new ArrayList<YamlToken>();
    private int lastContext = 0;
    private YamlToken[] contextArray = new YamlToken[7];
    private int[] contextIndent = new int[7];
    private YamlKeys[] contextKeys = new YamlKeys[7];
    @NotNull
    private YamlToken last = YamlToken.NONE;
    private long lineStart = 0L;
    private long blockStart = 0L;
    private long blockEnd = 0L;
    private int flowDepth = Integer.MAX_VALUE;
    private char blockQuote = '\u0000';

    public void reset() {
        this.pushed.clear();
        this.lastContext = 0;
        this.last = YamlToken.NONE;
        this.flowDepth = Integer.MAX_VALUE;
        this.blockQuote = '\u0000';
        this.blockStart = this.blockEnd = (long)'\u0000';
        this.lineStart = this.blockEnd;
    }

    public YamlToken context() {
        return this.contextArray[this.lastContext];
    }

    public YamlToken current() {
        if (this.last == YamlToken.NONE) {
            this.next();
        }
        return this.last;
    }

    @NotNull
    public YamlToken next() {
        YamlToken next;
        if (!this.pushed.isEmpty()) {
            YamlToken next2;
            this.last = next2 = this.popPushed();
            return this.last;
        }
        this.last = next = this.next0();
        return this.last;
    }

    public YamlTokeniser(BytesIn in) {
        this.in = in;
        this.contextArray[0] = YamlToken.NONE;
        this.contextIndent[0] = -1;
    }

    private YamlToken next0() {
        this.consumeWhitespace();
        this.blockStart = this.blockEnd = this.in.readPosition();
        if (this.temp != null) {
            this.temp.clear();
        }
        int indent = Math.toIntExact(this.in.readPosition() - this.lineStart);
        int ch = this.in.readUnsignedByte();
        switch (ch) {
            case -1: {
                if (this.context() == YamlToken.NONE) {
                    return YamlToken.NONE;
                }
                this.popAll();
                this.context(YamlToken.NONE);
                return this.popPushed();
            }
            case 35: {
                this.readComment();
                return YamlToken.COMMENT;
            }
            case 34: {
                this.readQuoted('\"');
                if (this.isFieldEnd()) {
                    return this.indent(YamlToken.MAPPING_START, YamlToken.MAPPING_KEY, YamlToken.TEXT, indent * 2);
                }
                return YamlToken.TEXT;
            }
            case 39: {
                this.readQuoted('\'');
                if (this.isFieldEnd()) {
                    return this.indent(YamlToken.MAPPING_START, YamlToken.MAPPING_KEY, YamlToken.TEXT, indent * 2);
                }
                return YamlToken.TEXT;
            }
            case 63: {
                YamlToken indent2 = this.indent(YamlToken.MAPPING_START, YamlToken.MAPPING_KEY, YamlToken.NONE, indent * 2);
                this.contextPush(YamlToken.MAPPING_KEY, indent * 2);
                return indent2;
            }
            case 45: {
                int next = this.in.peekUnsignedByte();
                if (next <= 32) {
                    return this.indent(YamlToken.SEQUENCE_START, YamlToken.SEQUENCE_ENTRY, YamlToken.NONE, indent * 2 + 1);
                }
                if (next == 45 && this.in.peekUnsignedByte(this.in.readPosition() + 1L) == 45 && this.in.peekUnsignedByte(this.in.readPosition() + 2L) <= 32) {
                    this.in.readSkip(2L);
                    this.pushed.add(YamlToken.DIRECTIVES_END);
                    this.popAll();
                    this.contextPush(YamlToken.DIRECTIVES_END, -1);
                    return this.popPushed();
                }
                this.unreadLast();
                return this.readText(indent);
            }
            case 46: {
                int next = this.in.peekUnsignedByte();
                if (next == 46 && this.in.peekUnsignedByte(this.in.readPosition() + 1L) == 46 && this.in.peekUnsignedByte(this.in.readPosition() + 2L) <= 32) {
                    this.in.readSkip(2L);
                    this.popAll();
                    this.context(YamlToken.NONE);
                    return this.popPushed();
                }
                this.unreadLast();
                return this.readText(indent);
            }
            case 124: {
                if (this.in.peekUnsignedByte() > 32) break;
                this.readLiteral();
                return YamlToken.TEXT;
            }
            case 62: {
                if (this.in.peekUnsignedByte() <= 32) {
                    this.readFolded();
                    return YamlToken.TEXT;
                }
            }
            case 37: {
                this.readDirective();
                return YamlToken.DIRECTIVE;
            }
            case 64: 
            case 96: {
                this.readReserved();
                return YamlToken.RESERVED;
            }
            case 33: {
                this.readWord();
                return YamlToken.TAG;
            }
            case 123: {
                return this.flow(YamlToken.MAPPING_START, indent);
            }
            case 125: {
                return this.flowPop(YamlToken.MAPPING_START, '}');
            }
            case 91: {
                return this.flow(YamlToken.SEQUENCE_START, indent);
            }
            case 93: {
                return this.flowPop(YamlToken.SEQUENCE_START, ']');
            }
            case 44: {
                return this.next0();
            }
            case 58: {
                if (this.in.peekUnsignedByte() > 32) break;
                int pos = this.pushed.size();
                while (this.context() != YamlToken.MAPPING_KEY && this.lastContext > 0) {
                    this.contextPop();
                }
                if (this.lastContext > 0) {
                    this.contextPop();
                }
                this.reversePushed(pos);
                return this.pushed.isEmpty() ? this.next0() : this.popPushed();
            }
        }
        this.unreadLast();
        return this.readText(indent);
    }

    private YamlToken flowPop(YamlToken start, char end) {
        int pos = this.pushed.size();
        while (this.context() != start) {
            if (this.lastContext == 0) {
                throw new IllegalArgumentException("Unexpected '" + end + '\'');
            }
            this.contextPop();
        }
        this.contextPop();
        this.reversePushed(pos);
        return this.popPushed();
    }

    private void readReserved() {
        throw new UnsupportedOperationException();
    }

    private void readDirective() {
        this.readWords();
    }

    private void readFolded() {
        this.readLiteral(false);
    }

    private Bytes temp() {
        if (this.temp == null) {
            this.temp = Bytes.elasticHeapByteBuffer((int)32);
        }
        this.temp.clear();
        return this.temp;
    }

    private void readLiteral() {
        this.readLiteral(true);
    }

    private void readLiteral(boolean withNewLines) {
        this.readNewline();
        this.readIndent();
        int indent2 = Math.toIntExact(this.in.readPosition() - this.lineStart);
        this.blockEnd = -1L;
        this.blockStart = -1L;
        Bytes temp = this.temp();
        long start = this.in.readPosition();
        while (true) {
            int ch;
            if ((ch = this.in.readUnsignedByte()) < 0) break;
            if (ch != 13 && ch != 10) continue;
            this.unreadLast();
            if (withNewLines) {
                this.readNewline();
            }
            temp.write((RandomDataInput)this.in, start, this.in.readPosition() - start);
            if (!withNewLines && temp.peekUnsignedByte(temp.writePosition() - 1L) > 32) {
                temp.append(' ');
            }
            this.readIndent();
            int indent3 = Math.toIntExact(this.in.readPosition() - this.lineStart);
            if (indent3 < indent2) {
                return;
            }
            if (indent3 > indent2) {
                this.in.readPosition(this.lineStart + (long)indent2);
            }
            start = this.in.readPosition();
        }
        temp.write((RandomDataInput)this.in, start, this.in.readPosition() - start);
    }

    private void readIndent() {
        int ch;
        while ((ch = this.in.peekUnsignedByte()) >= 0 && ch <= 32) {
            this.in.readSkip(1L);
            if (ch != 13 && ch != 10) continue;
            this.lineStart = this.in.readPosition();
        }
    }

    private void readNewline() {
        int ch;
        while ((ch = this.in.peekUnsignedByte()) >= 0 && ch < 32) {
            this.in.readSkip(1L);
            this.lineStart = this.in.readPosition();
        }
    }

    private void readAnchor() {
        int ch;
        this.blockStart = this.in.readPosition();
        do {
            this.blockEnd = this.in.readPosition();
        } while ((ch = this.in.readUnsignedByte()) > 32);
    }

    private YamlToken flow(YamlToken token, int indent) {
        this.pushed.add(token);
        if (this.context() == YamlToken.SEQUENCE_START) {
            this.pushed.add(YamlToken.SEQUENCE_ENTRY);
        }
        this.contextPush(token, indent);
        if (this.flowDepth > this.lastContext) {
            this.flowDepth = this.lastContext;
        }
        return this.popPushed();
    }

    private YamlToken readText(int indent) {
        this.blockQuote = '\u0000';
        this.readWords();
        if (this.isFieldEnd()) {
            return this.indent(YamlToken.MAPPING_START, YamlToken.MAPPING_KEY, YamlToken.TEXT, indent * 2);
        }
        if (this.context() == YamlToken.SEQUENCE_START && this.isInFlow()) {
            this.pushed.add(YamlToken.TEXT);
            return YamlToken.SEQUENCE_ENTRY;
        }
        return YamlToken.TEXT;
    }

    private void unreadLast() {
        this.in.readSkip(-1L);
    }

    private YamlToken indent(@NotNull YamlToken indented, @NotNull YamlToken key, @NotNull YamlToken push, int indent) {
        if (push != YamlToken.NONE) {
            this.pushed.add(push);
        }
        if (this.isInFlow()) {
            return key;
        }
        int pos = this.pushed.size();
        while (indent < this.contextIndent()) {
            this.contextPop();
        }
        if (indent != this.contextIndent()) {
            this.pushed.add(indented);
        }
        this.pushed.add(key);
        this.reversePushed(pos);
        if (indent > this.contextIndent()) {
            this.contextPush(indented, indent);
        }
        return this.popPushed();
    }

    private boolean isInFlow() {
        return this.lastContext >= this.flowDepth;
    }

    private void reversePushed(int pos) {
        int i = pos;
        for (int j = this.pushed.size() - 1; i < j; ++i, --j) {
            this.pushed.set(i, this.pushed.set(j, this.pushed.get(i)));
        }
    }

    private void popAll() {
        int pos = this.pushed.size();
        while (this.lastContext > 0) {
            this.contextPop();
        }
        this.reversePushed(pos);
    }

    private void readWord() {
        int ch;
        boolean isQuote;
        this.blockStart = this.in.readPosition();
        boolean bl = isQuote = this.in.peekUnsignedByte() == 60;
        do {
            if ((ch = this.in.readUnsignedByte()) <= 32 || ch == 44 && !isQuote) {
                this.unreadLast();
                break;
            }
            this.blockEnd = this.in.readPosition();
        } while (!isQuote || ch != 62);
    }

    private void readWords() {
        this.blockStart = this.in.readPosition();
        block6: while (this.in.readRemaining() > 0L) {
            int ch = this.in.readUnsignedByte();
            switch (ch) {
                case 58: {
                    if (this.in.peekUnsignedByte() > 32) continue block6;
                    this.unreadLast();
                    return;
                }
                case 44: {
                    if (this.context() != YamlToken.SEQUENCE_START && this.context() != YamlToken.MAPPING_START) continue block6;
                    this.unreadLast();
                    return;
                }
                case 91: {
                    long pos = this.in.readPosition();
                    if (this.in.peekUnsignedByte(pos - 2L) > 32 && this.in.peekUnsignedByte() == 93) {
                        this.in.readSkip(1L);
                        this.blockEnd = pos + 1L;
                        return;
                    }
                    this.unreadLast();
                    return;
                }
                case 10: 
                case 13: 
                case 35: 
                case 93: 
                case 123: 
                case 125: {
                    this.unreadLast();
                    return;
                }
            }
            if (ch <= 32) continue;
            this.blockEnd = this.in.readPosition();
        }
    }

    private YamlToken popPushed() {
        return this.pushed.isEmpty() ? YamlToken.NONE : this.pushed.remove(this.pushed.size() - 1);
    }

    private void contextPop() {
        YamlToken context = this.context();
        --this.lastContext;
        if (this.flowDepth == this.lastContext) {
            this.flowDepth = Integer.MAX_VALUE;
        }
        switch (context) {
            case MAPPING_START: {
                this.pushed.add(YamlToken.MAPPING_END);
                break;
            }
            case SEQUENCE_START: {
                this.pushed.add(YamlToken.SEQUENCE_END);
                break;
            }
            case DIRECTIVES_END: {
                this.pushed.add(YamlToken.DOCUMENT_END);
                break;
            }
            case MAPPING_KEY: {
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException("context: " + (Object)((Object)context));
            }
        }
    }

    private void contextPush0(YamlToken indented, int indent) {
        if (this.lastContext == this.contextArray.length) {
            int newLength = 2 * this.lastContext;
            this.contextArray = Arrays.copyOf(this.contextArray, newLength);
            this.contextIndent = Arrays.copyOf(this.contextIndent, newLength);
            this.contextKeys = Arrays.copyOf(this.contextKeys, newLength);
        }
        ++this.lastContext;
        this.contextArray[this.lastContext] = indented;
        this.contextIndent[this.lastContext] = indent;
        if (this.contextKeys[this.lastContext] != null) {
            this.contextKeys[this.lastContext].reset();
        }
    }

    private int contextIndent() {
        return this.contextIndent[this.lastContext];
    }

    private void readQuoted(char stop) {
        this.blockQuote = stop;
        this.blockStart = this.in.readPosition();
        while (this.in.readRemaining() > 0L) {
            int ch = this.in.readUnsignedByte();
            if (ch == 92) {
                ch = this.in.readUnsignedByte();
            }
            if (ch == stop) {
                int ch2 = this.in.peekUnsignedByte();
                if (ch2 == stop) {
                    this.in.readSkip(1L);
                    continue;
                }
                this.blockEnd = this.in.readPosition() - 1L;
                return;
            }
            if (ch >= 0) continue;
            throw new IllegalStateException("Unterminated quotes " + this.in.subBytes(this.blockStart - 1L, this.in.readPosition()));
        }
    }

    private boolean isFieldEnd() {
        this.consumeSpaces();
        if (this.in.peekUnsignedByte() == 58) {
            int ch = this.in.peekUnsignedByte(this.in.readPosition() + 1L);
            this.in.readSkip(ch == 9 || ch == 32 ? 2L : 1L);
            return true;
        }
        return false;
    }

    private void readComment() {
        this.in.readSkip(1L);
        this.consumeSpaces();
        this.blockStart = this.blockEnd = this.in.readPosition();
        int ch;
        while ((ch = this.in.readUnsignedByte()) >= 0) {
            if (ch == 10 || ch == 13) {
                this.unreadLast();
                return;
            }
            if (ch <= 32) continue;
            this.blockEnd = this.in.readPosition();
        }
        return;
    }

    private void consumeSpaces() {
        int ch;
        while ((ch = this.in.peekUnsignedByte()) == 32 || ch == 9) {
            this.in.readSkip(1L);
        }
    }

    private void consumeWhitespace() {
        int ch;
        while ((ch = this.in.peekUnsignedByte()) >= 0 && ch <= 32) {
            this.in.readSkip(1L);
            if (ch != 10 && ch != 13) continue;
            this.lineStart = this.in.readPosition();
        }
    }

    public long lineStart() {
        return this.lineStart;
    }

    public long blockStart() {
        return this.blockStart;
    }

    public long blockEnd() {
        return this.blockEnd;
    }

    private void contextPush(YamlToken context, int indent) {
        if (this.context() == YamlToken.NONE && context != YamlToken.DIRECTIVES_END) {
            this.contextPush0(YamlToken.DIRECTIVES_END, -1);
            this.contextPush0(context, indent);
            this.push(YamlToken.DIRECTIVES_END);
            return;
        }
        this.contextPush0(context, indent);
    }

    public char blockQuote() {
        return this.blockQuote;
    }

    public String text() {
        StringBuilder sb = Wires.acquireStringBuilder();
        this.text(sb);
        return sb.length() == 0 ? "" : sb.toString();
    }

    public void text(StringBuilder sb) {
        if (this.blockEnd < 0L && this.temp != null) {
            sb.append(this.temp.toString());
            return;
        }
        sb.setLength(0);
        if (this.blockStart == this.blockEnd || NO_TEXT.contains((Object)this.last)) {
            return;
        }
        long pos = this.in.readPosition();
        this.in.readPosition(this.blockStart);
        this.in.parseUtf8((Appendable)sb, Math.toIntExact(this.blockEnd - this.blockStart));
        this.in.readPosition(pos);
    }

    public void push(YamlToken token) {
        this.pushed.add(token);
    }

    public void context(YamlToken token) {
        this.contextArray[this.lastContext] = token;
    }

    public boolean isText(String s) {
        return this.text().equals(s);
    }

    public String toString() {
        return (Object)((Object)this.current()) + " " + (this.blockQuote == '\u0000' || this.current().name().endsWith("_END") ? "" : this.blockQuote + " ") + this.text();
    }

    public int lastContext() {
        return this.lastContext;
    }

    public YamlKeys keys() {
        YamlKeys key = this.contextKeys[this.lastContext];
        if (key == null) {
            this.contextKeys[this.lastContext] = key = new YamlKeys();
        }
        return key;
    }
}

