/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.AbstractMethodWriterInvocationHandler;
import net.openhft.chronicle.wire.IntConversion;
import net.openhft.chronicle.wire.IntConverter;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.LongConverter;
import net.openhft.chronicle.wire.RawText;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public class TextMethodWriterInvocationHandler
extends AbstractMethodWriterInvocationHandler {
    public static boolean ENABLE_EOD = true;
    @NotNull
    private final TextWire wire;
    private final Map<Method, Consumer<Object[]>> visitorConverter = new LinkedHashMap<Method, Consumer<Object[]>>();

    TextMethodWriterInvocationHandler(@NotNull TextWire wire) {
        this.wire = wire;
        this.recordHistory = wire.recordHistory();
    }

    @Override
    protected Object doInvoke(Object proxy, Method method, Object[] args) {
        if (method.getName().equals("writingDocument") && method.getParameterCount() == 0) {
            throw new UnsupportedOperationException();
        }
        return super.doInvoke(proxy, method, args);
    }

    @Override
    protected void handleInvoke(Method method, Object[] args) {
        this.visitorConverter.computeIfAbsent(method, this::buildConverter).accept(args);
        this.handleInvoke(method, args, this.wire);
        this.wire.getValueOut().resetBetweenDocuments();
        Bytes<?> bytes = this.wire.bytes();
        if (bytes.peekUnsignedByte(bytes.writePosition() - 1L) >= 32) {
            bytes.append('\n');
        }
        if (ENABLE_EOD) {
            bytes.append((CharSequence)"---\n");
        }
    }

    private Consumer<Object[]> buildConverter(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations.length <= 0) {
            return NoOp.INSTANCE;
        }
        for (Annotation anno : parameterAnnotations[0]) {
            if (anno instanceof LongConversion) {
                LongConversion longConversion = (LongConversion)anno;
                LongConverter ic = (LongConverter)ObjectUtils.newInstance(longConversion.value());
                return a -> {
                    if (a[0] instanceof Number) {
                        StringBuilder sb = Wires.acquireStringBuilder();
                        ic.append(sb, ((Number)a[0]).longValue());
                        a[0] = new RawText(sb);
                    }
                };
            }
            if (!(anno instanceof IntConversion)) continue;
            IntConversion intConversion = (IntConversion)anno;
            IntConverter ic = (IntConverter)ObjectUtils.newInstance(intConversion.value());
            return a -> {
                if (a[0] instanceof Number) {
                    StringBuilder sb = Wires.acquireStringBuilder();
                    ic.append(sb, ((Number)a[0]).intValue());
                    a[0] = new RawText(sb);
                }
            };
        }
        return NoOp.INSTANCE;
    }

    static enum NoOp implements Consumer<Object[]>
    {
        INSTANCE;


        @Override
        public void accept(Object[] objects) {
        }
    }
}

