/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.LinkedHashSet;
import java.util.Set;
import net.openhft.chronicle.core.Jvm;
import net.openhft.compiler.CachedCompiler;
import net.openhft.compiler.CompilerUtils;
import sun.reflect.generics.reflectiveObjects.TypeVariableImpl;

public enum GeneratedProxyClass {


    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class from(String packageName, Set<Class> interfaces, String className) {
        int maxArgs = 0;
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>(16);
        StringBuilder sb = new StringBuilder("package " + packageName + ";\n\nimport net.openhft.chronicle.core.Jvm;\nimport java.lang.reflect.InvocationHandler;\nimport java.lang.reflect.Method;\nimport java.util.ArrayList;\nimport java.util.List;\n");
        sb.append("public class ").append(className).append(" implements ");
        StringBuilder methodArray = new StringBuilder();
        int count = 0;
        String sep = "";
        for (Class interfaceClazz : interfaces) {
            sb.append(sep);
            String interfaceName = interfaceClazz.getName().replace('$', '.');
            sb.append(interfaceName);
            if (!interfaceClazz.isInterface()) {
                throw new IllegalArgumentException("expecting and interface instead of class=" + interfaceClazz.getName());
            }
            int i = 0;
            for (Method dm : interfaceClazz.getMethods()) {
                ++i;
                if (dm.isDefault() || Modifier.isStatic(dm.getModifiers())) continue;
                if (dm.getGenericReturnType() instanceof TypeVariableImpl) {
                    return null;
                }
                if (!methods.add(dm)) continue;
                maxArgs = Math.max(maxArgs, dm.getParameterCount());
                methodArray.append("\n    //").append(GeneratedProxyClass.createMethodSignature(dm, dm.getReturnType())).append("    methods[").append(count++).append("]=").append(interfaceName).append(".class.getMethods()[").append(i).append("];\n");
            }
            sep = ",\n              ";
        }
        sb.append(" {\n\n");
        GeneratedProxyClass.addFieldsAndConstructor(maxArgs, methods, sb, className, methodArray);
        GeneratedProxyClass.createProxyMethods(methods, sb);
        sb.append("}\n");
        try {
            CachedCompiler cachedCompiler = CompilerUtils.CACHED_COMPILER;
            synchronized (cachedCompiler) {
                return CompilerUtils.CACHED_COMPILER.loadFromJava(GeneratedProxyClass.class.getClassLoader(), packageName + '.' + className, sb.toString());
            }
        }
        catch (Throwable e) {
            throw Jvm.rethrow((Throwable)new ClassNotFoundException(e.getMessage() + '\n' + sb, e));
        }
    }

    private static void addFieldsAndConstructor(int maxArgs, Set<Method> declaredMethods, StringBuilder sb, String className, StringBuilder methodArray) {
        sb.append("  private final Object proxy;\n  private final InvocationHandler handler;\n  private Method[] methods = new  Method[").append(declaredMethods.size()).append("];\n").append("  private List<Object[]> args = new ArrayList<Object[]>(").append(maxArgs + 1).append(");\n\n").append("  public ").append(className).append("(Object proxy, InvocationHandler handler) {\n").append("    this.proxy = proxy;\n").append("    this.handler = handler;\n");
        for (int j = 0; j <= maxArgs; ++j) {
            sb.append("    args.add(new Object[").append(j).append("]);\n");
        }
        sb.append((CharSequence)methodArray);
        sb.append("  }\n\n");
    }

    private static void createProxyMethods(Set<Method> declaredMethods, StringBuilder sb) {
        int methodIndex = -1;
        for (Method dm : declaredMethods) {
            Class<?> returnType = dm.getReturnType();
            sb.append(GeneratedProxyClass.createMethodSignature(dm, returnType));
            sb.append("    Method method = this.methods[").append(++methodIndex).append("];\n");
            sb.append("    Object[] a = this.args.get(").append(dm.getParameterCount()).append(");\n");
            GeneratedProxyClass.assignParametersToArgs(sb, dm);
            GeneratedProxyClass.callInvoke(sb, returnType);
        }
    }

    private static void callInvoke(StringBuilder sb, Class<?> returnType) {
        sb.append("    try {\n      ");
        if (returnType != Void.TYPE) {
            sb.append("return (").append(returnType.getName()).append(')');
        }
        sb.append(" handler.invoke(proxy,method,a);\n    } catch (Throwable throwable) {\n       throw Jvm.rethrow(throwable);\n    }\n  }\n");
    }

    private static void assignParametersToArgs(StringBuilder sb, Method dm) {
        int len = dm.getParameters().length;
        for (int j = 0; j < len; ++j) {
            String paramName = dm.getParameters()[j].getName();
            sb.append("    a[").append(j).append("] = ").append(paramName).append(";\n");
        }
    }

    private static CharSequence createMethodSignature(Method dm, Class<?> returnType) {
        int len = dm.getParameters().length;
        StringBuilder result = new StringBuilder();
        String typeName = returnType.getName();
        result.append("  public ").append(typeName).append(' ').append(dm.getName()).append('(');
        for (int j = 0; j < len; ++j) {
            Parameter p = dm.getParameters()[j];
            String className = p.getType().getTypeName().replace('$', '.');
            result.append(className).append(' ').append(p.getName());
            if (j == len - 1) break;
            result.append(',');
        }
        result.append(") {\n");
        return result;
    }
}

