/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.BitSet;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import net.openhft.chronicle.bytes.ref.LongReference;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.Marshallable;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractLongValueBitSet
implements Marshallable {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final long WORD_MASK = -1L;
    LongValue[] words;
    IntValue wordsInUse = this.newIntValue();
    private transient boolean sizeIsSticky = false;
    private static final long serialVersionUID = 7997698588986878753L;

    @NotNull
    abstract IntValue newIntValue();

    private static int wordIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    private void checkInvariants() {
        assert (this.wordsInUse.getValue() == 0 || this.words[this.wordsInUse.getValue() - 1].getValue() != 0L);
        assert (this.wordsInUse.getValue() >= 0 && this.wordsInUse.getValue() <= this.words.length);
        assert (this.wordsInUse.getValue() == this.words.length || this.words[this.wordsInUse.getValue()].getValue() == 0L);
    }

    private void recalculatewordsInUse() {
        int i;
        for (i = this.wordsInUse.getValue() - 1; i >= 0 && this.words[i].getValue() == 0L; --i) {
        }
        this.wordsInUse.setValue(i + 1);
    }

    public AbstractLongValueBitSet(LongReference[] words) {
        this.words = words;
    }

    public static BitSet valueOf(byte[] bytes) {
        return BitSet.valueOf(ByteBuffer.wrap(bytes));
    }

    public byte[] toByteArray() {
        int n = this.wordsInUse.getValue();
        if (n == 0) {
            return new byte[0];
        }
        int len = 8 * (n - 1);
        for (long x = this.words[n - 1].getValue(); x != 0L; x >>>= 8) {
            ++len;
        }
        byte[] bytes = new byte[len];
        ByteBuffer bb = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < n - 1; ++i) {
            bb.putLong(this.words[i].getValue());
        }
        for (long x = this.words[n - 1].getValue(); x != 0L; x >>>= 8) {
            bb.put((byte)(x & 0xFFL));
        }
        return bytes;
    }

    private void ensureCapacity(int wordsRequired) {
        if (this.words.length < wordsRequired) {
            int request = Math.max(2 * this.words.length, wordsRequired);
            this.words = Arrays.copyOf(this.words, request);
            this.sizeIsSticky = false;
        }
    }

    private void expandTo(int wordIndex) {
        int wordsRequired = wordIndex + 1;
        if (this.wordsInUse.getValue() < wordsRequired) {
            this.ensureCapacity(wordsRequired);
            this.wordsInUse.setValue(wordsRequired);
        }
    }

    private static void checkRange(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
    }

    public void flip(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = AbstractLongValueBitSet.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        this.words[wordIndex].setValue(this.words[wordIndex].getValue() ^ 1L << bitIndex);
        this.recalculatewordsInUse();
        this.checkInvariants();
    }

    public void flip(int fromIndex, int toIndex) {
        AbstractLongValueBitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = AbstractLongValueBitSet.wordIndex(fromIndex);
        int endWordIndex = AbstractLongValueBitSet.wordIndex(toIndex - 1);
        this.expandTo(endWordIndex);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            this.words[startWordIndex].setValue(this.words[startWordIndex].getValue() ^ firstWordMask & lastWordMask);
        } else {
            this.words[startWordIndex].setValue(this.words[startWordIndex].getValue() ^ firstWordMask);
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words[i].setValue(this.words[i].getValue() ^ 0xFFFFFFFFFFFFFFFFL);
            }
            this.words[endWordIndex].setValue(this.words[endWordIndex].getValue() ^ lastWordMask);
        }
        this.recalculatewordsInUse();
        this.checkInvariants();
    }

    public void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = AbstractLongValueBitSet.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        this.words[wordIndex].setValue(this.words[wordIndex].getValue() | 1L << bitIndex);
        this.checkInvariants();
    }

    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    public void set(int fromIndex, int toIndex) {
        AbstractLongValueBitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = AbstractLongValueBitSet.wordIndex(fromIndex);
        int endWordIndex = AbstractLongValueBitSet.wordIndex(toIndex - 1);
        this.expandTo(endWordIndex);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            this.words[startWordIndex].setValue(this.words[startWordIndex].getValue() | firstWordMask & lastWordMask);
        } else {
            this.words[startWordIndex].setValue(this.words[startWordIndex].getValue() | firstWordMask);
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words[i].setValue(-1L);
            }
            this.words[endWordIndex].setValue(this.words[endWordIndex].getValue() | lastWordMask);
        }
        this.checkInvariants();
    }

    public void set(int fromIndex, int toIndex, boolean value) {
        if (value) {
            this.set(fromIndex, toIndex);
        } else {
            this.clear(fromIndex, toIndex);
        }
    }

    public void clear(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = AbstractLongValueBitSet.wordIndex(bitIndex);
        if (wordIndex >= this.wordsInUse.getValue()) {
            return;
        }
        this.words[wordIndex].setValue(this.words[wordIndex].getValue() & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL));
        this.recalculatewordsInUse();
        this.checkInvariants();
    }

    public void clear(int fromIndex, int toIndex) {
        AbstractLongValueBitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = AbstractLongValueBitSet.wordIndex(fromIndex);
        if (startWordIndex >= this.wordsInUse.getValue()) {
            return;
        }
        int endWordIndex = AbstractLongValueBitSet.wordIndex(toIndex - 1);
        if (endWordIndex >= this.wordsInUse.getValue()) {
            toIndex = this.length();
            endWordIndex = this.wordsInUse.getValue() - 1;
        }
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            this.words[startWordIndex].setValue(this.words[startWordIndex].getValue() & (firstWordMask & lastWordMask ^ 0xFFFFFFFFFFFFFFFFL));
        } else {
            this.words[startWordIndex].setValue(this.words[startWordIndex].getValue() & (firstWordMask ^ 0xFFFFFFFFFFFFFFFFL));
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words[i].setValue(0L);
            }
            this.words[endWordIndex].setValue(this.words[endWordIndex].getValue() & (lastWordMask ^ 0xFFFFFFFFFFFFFFFFL));
        }
        this.recalculatewordsInUse();
        this.checkInvariants();
    }

    public void clear() {
        int value = this.wordsInUse.getValue();
        while (value > 0) {
            this.words[--value].setValue(0L);
        }
        this.wordsInUse.setValue(value);
    }

    public boolean get(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        this.checkInvariants();
        int wordIndex = AbstractLongValueBitSet.wordIndex(bitIndex);
        return wordIndex < this.wordsInUse.getValue() && (this.words[wordIndex].getValue() & 1L << bitIndex) != 0L;
    }

    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        this.checkInvariants();
        int u = AbstractLongValueBitSet.wordIndex(fromIndex);
        if (u >= this.wordsInUse.getValue()) {
            return -1;
        }
        long word = this.words[u].getValue() & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.wordsInUse.getValue()) {
                return -1;
            }
            word = this.words[u].getValue();
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    public int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        this.checkInvariants();
        int u = AbstractLongValueBitSet.wordIndex(fromIndex);
        if (u >= this.wordsInUse.getValue()) {
            return fromIndex;
        }
        long word = (this.words[u].getValue() ^ 0xFFFFFFFFFFFFFFFFL) & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.wordsInUse.getValue()) {
                return this.wordsInUse.getValue() * 64;
            }
            word = this.words[u].getValue() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    public int previousSetBit(int fromIndex) {
        if (fromIndex < 0) {
            if (fromIndex == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException("fromIndex < -1: " + fromIndex);
        }
        this.checkInvariants();
        int u = AbstractLongValueBitSet.wordIndex(fromIndex);
        if (u >= this.wordsInUse.getValue()) {
            return this.length() - 1;
        }
        long word = this.words[u].getValue() & -1L >>> -(fromIndex + 1);
        while (word == 0L) {
            if (u-- == 0) {
                return -1;
            }
            word = this.words[u].getValue();
        }
        return (u + 1) * 64 - 1 - Long.numberOfLeadingZeros(word);
    }

    public int previousClearBit(int fromIndex) {
        if (fromIndex < 0) {
            if (fromIndex == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException("fromIndex < -1: " + fromIndex);
        }
        this.checkInvariants();
        int u = AbstractLongValueBitSet.wordIndex(fromIndex);
        if (u >= this.wordsInUse.getValue()) {
            return fromIndex;
        }
        long word = (this.words[u].getValue() ^ 0xFFFFFFFFFFFFFFFFL) & -1L >>> -(fromIndex + 1);
        while (word == 0L) {
            if (u-- == 0) {
                return -1;
            }
            word = this.words[u].getValue() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return (u + 1) * 64 - 1 - Long.numberOfLeadingZeros(word);
    }

    public int length() {
        if (this.wordsInUse.getValue() == 0) {
            return 0;
        }
        return 64 * (this.wordsInUse.getValue() - 1) + (64 - Long.numberOfLeadingZeros(this.words[this.wordsInUse.getValue() - 1].getValue()));
    }

    public boolean isEmpty() {
        return this.wordsInUse.getValue() == 0;
    }

    public boolean intersects(AbstractLongValueBitSet set) {
        for (int i = Math.min(this.wordsInUse.getValue(), set.wordsInUse.getValue()) - 1; i >= 0; --i) {
            if ((this.words[i].getValue() & set.words[i].getValue()) == 0L) continue;
            return true;
        }
        return false;
    }

    public int cardinality() {
        int sum = 0;
        for (int i = 0; i < this.wordsInUse.getValue(); ++i) {
            sum += Long.bitCount(this.words[i].getValue());
        }
        return sum;
    }

    public void and(AbstractLongValueBitSet set) {
        if (this == set) {
            return;
        }
        int value = this.wordsInUse.getValue();
        while (this.wordsInUse.getValue() > set.wordsInUse.getValue()) {
            this.words[--value].setValue(0L);
        }
        this.wordsInUse.setValue(value);
        for (int i = 0; i < this.wordsInUse.getValue(); ++i) {
            this.words[i].setValue(this.words[i].getValue() & set.words[i].getValue());
        }
        this.recalculatewordsInUse();
        this.checkInvariants();
    }

    public void or(AbstractLongValueBitSet set) {
        if (this == set) {
            return;
        }
        int wordsInCommon = Math.min(this.wordsInUse.getValue(), set.wordsInUse.getValue());
        if (this.wordsInUse.getValue() < set.wordsInUse.getValue()) {
            this.ensureCapacity(set.wordsInUse.getValue());
            this.wordsInUse.setValue(set.wordsInUse.getValue());
        }
        for (int i = 0; i < wordsInCommon; ++i) {
            this.words[i].setValue(this.words[i].getValue() | set.words[i].getValue());
        }
        if (wordsInCommon < set.wordsInUse.getValue()) {
            System.arraycopy(set.words, wordsInCommon, this.words, wordsInCommon, this.wordsInUse.getValue() - wordsInCommon);
        }
        this.checkInvariants();
    }

    public void xor(AbstractLongValueBitSet set) {
        int wordsInCommon = Math.min(this.wordsInUse.getValue(), set.wordsInUse.getValue());
        if (this.wordsInUse.getValue() < set.wordsInUse.getValue()) {
            this.ensureCapacity(set.wordsInUse.getValue());
            this.wordsInUse.setValue(set.wordsInUse.getValue());
        }
        for (int i = 0; i < wordsInCommon; ++i) {
            this.words[i].setValue(this.words[i].getValue() ^ set.words[i].getValue());
        }
        if (wordsInCommon < set.wordsInUse.getValue()) {
            System.arraycopy(set.words, wordsInCommon, this.words, wordsInCommon, set.wordsInUse.getValue() - wordsInCommon);
        }
        this.recalculatewordsInUse();
        this.checkInvariants();
    }

    public void andNot(AbstractLongValueBitSet set) {
        for (int i = Math.min(this.wordsInUse.getValue(), set.wordsInUse.getValue()) - 1; i >= 0; --i) {
            this.words[i].setValue(this.words[i].getValue() & (set.words[i].getValue() ^ 0xFFFFFFFFFFFFFFFFL));
        }
        this.recalculatewordsInUse();
        this.checkInvariants();
    }

    public int hashCode() {
        long h = 1234L;
        int i = this.wordsInUse.getValue();
        while (--i >= 0) {
            h ^= this.words[i].getValue() * (long)(i + 1);
        }
        return (int)(h >> 32 ^ h);
    }

    public int size() {
        return this.words.length * 64;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractLongValueBitSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AbstractLongValueBitSet set = (AbstractLongValueBitSet)obj;
        this.checkInvariants();
        set.checkInvariants();
        if (this.wordsInUse.getValue() != set.wordsInUse.getValue()) {
            return false;
        }
        for (int i = 0; i < this.wordsInUse.getValue(); ++i) {
            if (this.words[i] == set.words[i]) continue;
            return false;
        }
        return true;
    }

    private void trimToSize() {
        if (this.wordsInUse.getValue() != this.words.length) {
            this.words = Arrays.copyOf(this.words, this.wordsInUse.getValue());
            this.checkInvariants();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.checkInvariants();
        if (!this.sizeIsSticky) {
            this.trimToSize();
        }
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put("bits", this.words);
        s.writeFields();
    }

    public String toString() {
        this.checkInvariants();
        int numBits = this.wordsInUse.getValue() > 128 ? this.cardinality() : this.wordsInUse.getValue() * 64;
        StringBuilder b = new StringBuilder(6 * numBits + 2);
        b.append('{');
        int i = this.nextSetBit(0);
        if (i != -1) {
            b.append(i);
            while (++i >= 0 && (i = this.nextSetBit(i)) >= 0) {
                int endOfRun = this.nextClearBit(i);
                do {
                    b.append(", ").append(i);
                } while (++i != endOfRun);
            }
        }
        b.append('}');
        return b.toString();
    }

    public IntStream stream() {
        return StreamSupport.intStream(() -> {
            class BitSetIterator
            implements PrimitiveIterator.OfInt {
                int next;

                BitSetIterator() {
                    this.next = AbstractLongValueBitSet.this.nextSetBit(0);
                }

                @Override
                public boolean hasNext() {
                    return this.next != -1;
                }

                @Override
                public int nextInt() {
                    if (this.next != -1) {
                        int ret = this.next;
                        this.next = AbstractLongValueBitSet.this.nextSetBit(this.next + 1);
                        return ret;
                    }
                    throw new NoSuchElementException();
                }
            }
            return Spliterators.spliterator(new BitSetIterator(), (long)this.cardinality(), 21);
        }, 16469, false);
    }
}

