/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.MethodInterceptorFactory;
import net.openhft.chronicle.wire.MethodReader;
import net.openhft.chronicle.wire.MethodWriterInvocationHandler;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMethodWriterInvocationHandler
implements MethodWriterInvocationHandler {
    private final Map<Method, Class[]> parameterMap = new ConcurrentHashMap<Method, Class[]>();
    protected boolean recordHistory;
    private Closeable closeable;
    private Map<Method, Consumer<Object[]>> methodConsumerMap;
    private Function<Method, Consumer<Object[]>> methodFactoryLambda;

    @Override
    @Nullable
    public Object invoke(Object proxy, @NotNull Method method, Object[] args) throws Throwable {
        Consumer<Object[]> consumer;
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass == Object.class) {
            return method.invoke((Object)this, args);
        }
        if (declaringClass == Closeable.class && method.getName().equals("close")) {
            Closeable.closeQuietly((Object)this.closeable);
            return null;
        }
        if (args == null) {
            args = MethodReader.NO_ARGS;
        }
        if (this.methodFactoryLambda != null && (consumer = this.methodConsumerMap.computeIfAbsent(method, this.methodFactoryLambda)) != null) {
            consumer.accept(args);
        }
        this.handleInvoke(method, args);
        return ObjectUtils.defaultValue(method.getReturnType());
    }

    protected abstract void handleInvoke(Method var1, Object[] var2);

    protected void handleInvoke(@NotNull Method method, Object[] args, Wire wire) {
        if (this.recordHistory) {
            wire.write("history").marshallable(MessageHistory.get());
        }
        ValueOut valueOut = wire.writeEventName(method.getName());
        Class[] parameterTypes = this.parameterMap.computeIfAbsent(method, Method::getParameterTypes);
        switch (parameterTypes.length) {
            case 0: {
                valueOut.text("");
                break;
            }
            case 1: {
                valueOut.object(parameterTypes[0], args[0]);
                break;
            }
            default: {
                Class[] finalParameterTypes = parameterTypes;
                valueOut.sequence(args, (a, v) -> {
                    for (int i = 0; i < finalParameterTypes.length; ++i) {
                        v.object(finalParameterTypes[i], a[i]);
                    }
                });
            }
        }
    }

    @Override
    public void recordHistory(boolean recordHistory) {
        this.recordHistory = recordHistory;
    }

    @Override
    public void onClose(Closeable closeable) {
        this.closeable = closeable;
    }

    @Override
    public void methodInterceptorFactory(MethodInterceptorFactory methodInterceptorFactory) {
        this.methodConsumerMap = new LinkedHashMap<Method, Consumer<Object[]>>();
        this.methodFactoryLambda = methodInterceptorFactory == null ? null : methodInterceptorFactory::create;
    }
}

