/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.function.BiConsumer;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MethodWriterBuilder;
import net.openhft.chronicle.wire.MethodWriterInvocationHandler;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public interface MarshallableOut {
    public DocumentContext writingDocument() throws UnrecoverableTimeoutException;

    public boolean recordHistory();

    default public void writeMessage(WireKey key, Object value) throws UnrecoverableTimeoutException {
        try (DocumentContext dc = this.writingDocument();){
            Wire wire = dc.wire();
            wire.write(key).object(value);
        }
    }

    default public void writeDocument(WriteMarshallable writer) throws UnrecoverableTimeoutException {
        try (DocumentContext dc = this.writingDocument();){
            Wire wire = dc.wire();
            writer.writeMarshallable(wire);
        }
    }

    default public void writeBytes(@NotNull WriteBytesMarshallable marshallable) throws UnrecoverableTimeoutException {
        try (DocumentContext dc = this.writingDocument();){
            marshallable.writeMarshallable(dc.wire().bytes());
        }
    }

    default public <T> void writeDocument(T t, BiConsumer<ValueOut, T> writer) throws UnrecoverableTimeoutException {
        try (DocumentContext dc = this.writingDocument();){
            Wire wire = dc.wire();
            writer.accept(wire.getValueOut(), (ValueOut)t);
        }
    }

    default public void writeText(CharSequence text) throws UnrecoverableTimeoutException {
        try (DocumentContext dc = this.writingDocument();){
            dc.wire().bytes().append8bit(text);
        }
    }

    default public void writeMap(Map<?, ?> map) throws UnrecoverableTimeoutException {
        try (DocumentContext dc = this.writingDocument();){
            Wire wire = dc.wire();
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                wire.writeEvent(Object.class, entry.getKey()).object(Object.class, entry.getValue());
            }
        }
    }

    default public <T> T methodWriter(Class<T> tClass, Class ... additional) {
        Class[] interfaces = (Class[])ObjectUtils.addAll(tClass, (Object[])additional);
        return (T)Proxy.newProxyInstance(tClass.getClassLoader(), interfaces, (InvocationHandler)new MethodWriterInvocationHandler(this));
    }

    default public <T> MethodWriterBuilder<T> methodWriterBuilder(Class<T> tClass) {
        return new MethodWriterBuilder<T>(this, tClass);
    }
}

