/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharTesters;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MethodReader;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MarshallableIn {
    @NotNull
    public DocumentContext readingDocument();

    default public boolean readDocument(@NotNull ReadMarshallable reader) {
        try (DocumentContext dc = this.readingDocument();){
            if (!dc.isPresent()) {
                boolean bl = false;
                return bl;
            }
            reader.readMarshallable(dc.wire());
        }
        return true;
    }

    default public boolean readBytes(@NotNull ReadBytesMarshallable reader) {
        try (DocumentContext dc = this.readingDocument();){
            if (!dc.isPresent()) {
                boolean bl = false;
                return bl;
            }
            reader.readMarshallable(dc.wire().bytes());
        }
        return true;
    }

    default public boolean readBytes(@NotNull Bytes using) {
        using.clear();
        try (DocumentContext dc = this.readingDocument();){
            if (!dc.isPresent()) {
                boolean bl = false;
                return bl;
            }
            using.write(dc.wire().bytes());
        }
        return true;
    }

    @Nullable
    default public String readText() {
        try (DocumentContext dc = this.readingDocument();){
            if (!dc.isPresent()) {
                String string = null;
                return string;
            }
            StringBuilder sb = Wires.acquireStringBuilder();
            dc.wire().bytes().parse8bit((Appendable)sb, (StopCharTester)StopCharTesters.ALL);
            String string = WireInternal.INTERNER.intern((CharSequence)sb);
            return string;
        }
    }

    default public boolean readText(@NotNull StringBuilder sb) {
        try (DocumentContext dc = this.readingDocument();){
            if (!dc.isPresent()) {
                sb.setLength(0);
                boolean bl = false;
                return bl;
            }
            dc.wire().bytes().parse8bit((Appendable)sb, (StopCharTester)StopCharTesters.ALL);
        }
        return true;
    }

    @Nullable
    default public <K, V> Map<K, V> readMap() {
        try (DocumentContext dc = this.readingDocument();){
            if (!dc.isPresent()) {
                Map<K, V> map = null;
                return map;
            }
            Wire wire = dc.wire();
            if (!wire.hasMore()) {
                Map map = Collections.emptyMap();
                return map;
            }
            LinkedHashMap<Object, Object> ret = new LinkedHashMap<Object, Object>();
            while (wire.hasMore()) {
                Object key = wire.readEvent(Object.class);
                Object value = wire.getValueIn().object();
                ret.put(key, value);
            }
            LinkedHashMap<Object, Object> linkedHashMap = ret;
            return linkedHashMap;
        }
    }

    @NotNull
    default public MethodReader methodReader(Object ... objects) {
        return new MethodReader(this, objects);
    }
}

