/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.Wires;

public class WireDumper {
    private final WireIn wireIn;
    private final Bytes bytes;
    private long headerNumber = -1L;

    private WireDumper(WireIn wireIn, Bytes bytes) {
        if (wireIn == null) {
            wireIn = new BinaryWire(bytes);
        }
        this.wireIn = wireIn;
        this.bytes = bytes;
    }

    public static WireDumper of(WireIn wireIn) {
        return new WireDumper(wireIn, wireIn.bytes());
    }

    public static WireDumper of(Bytes bytes) {
        return new WireDumper(new BinaryWire(bytes), bytes);
    }

    public String asString() {
        return this.asString(this.bytes.readPosition(), this.bytes.readRemaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String asString(long position, long length) {
        StringBuilder sb = new StringBuilder();
        long limit0 = this.bytes.readLimit();
        long position0 = this.bytes.readPosition();
        try {
            this.bytes.readPosition(position);
            long limit2 = Math.min(limit0, position + length);
            this.bytes.readLimit(limit2);
            long missing = position + length - limit2;
            while (this.bytes.readRemaining() >= 4L && !this.dumpOne(sb)) {
            }
            if (missing > 0L) {
                sb.append(" # missing: ").append(missing);
            }
        }
        catch (Throwable t) {
            sb.append(" ").append(t);
        }
        finally {
            this.bytes.readPositionRemaining(position0, limit0 - position0);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dumpOne(StringBuilder sb) {
        int len;
        long start = this.bytes.readPosition();
        int header = this.bytes.readInt();
        if (header == 0) {
            sb.append("...\n");
            sb.append("# ").append(this.bytes.readRemaining()).append(" bytes remaining\n");
            return true;
        }
        if (Wires.isReadyData(header)) {
            ++this.headerNumber;
        }
        if (start > 0L) {
            sb.append("# position: ").append(start).append(", header: ");
            sb.append(this.headerNumber);
            if (Wires.isNotComplete(header)) {
                sb.append(" or ").append(this.headerNumber + 1L);
            }
            sb.append("\n");
        }
        if ((long)(len = Wires.lengthOf(header)) > this.bytes.readRemaining()) {
            sb.append("#  has a 4 byte size prefix, ").append(len).append(" > ").append(this.bytes.readRemaining()).append(" len is ").append(Integer.toString(len));
            return true;
        }
        String type = Wires.isData(header) ? (Wires.isReady(header) ? "!!data" : "!!not-ready-data!") : (Wires.isReady(header) ? "!!meta-data" : "!!not-ready-meta-data!");
        byte firstByte = this.bytes.readByte(this.bytes.readPosition());
        boolean binary = firstByte < 32 && firstByte != 10;
        sb.append("--- ").append(type).append(binary ? " #binary" : "");
        if ((long)len > this.bytes.readRemaining()) {
            sb.append(" # len: ").append(len).append(", remaining: ").append(this.bytes.readRemaining());
        }
        sb.append("\n");
        if (len == 0) {
            sb.append("...\n");
            sb.append("# ").append(this.bytes.readRemaining()).append(" bytes remaining\n");
            return true;
        }
        Bytes textBytes = this.bytes;
        if (binary) {
            long readPosition = this.bytes.readPosition();
            long readLimit = this.bytes.readLimit();
            int sblen = sb.length();
            Bytes bytes2 = Bytes.elasticByteBuffer();
            TextWire textWire = new TextWire(bytes2);
            try {
                this.bytes.readLimit(readPosition + (long)len);
                this.wireIn.copyTo(textWire);
            }
            catch (Exception e) {
                this.bytes.readPositionRemaining(readPosition, (long)len);
                sb.setLength(sblen);
                sb.append(this.bytes.toHexString(readPosition, Integer.MAX_VALUE));
                this.bytes.readPosition(readPosition + (long)len);
                boolean bl = false;
                return bl;
            }
            finally {
                this.bytes.readLimit(readLimit);
            }
            textBytes = bytes2;
            len = (int)textBytes.readRemaining();
        }
        try {
            for (int i = 0; i < len; ++i) {
                int ch = textBytes.readUnsignedByte();
                sb.append((char)ch);
            }
        }
        catch (Exception e) {
            sb.append(" ").append(e);
        }
        if (sb.charAt(sb.length() - 1) != '\n') {
            sb.append('\n');
        }
        return false;
    }
}

