/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.FieldInfo;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.WireMarshaller;
import net.openhft.chronicle.wire.Wires;

public class VanillaFieldInfo
extends AbstractMarshallable
implements FieldInfo {
    private final String name;
    private final Class type;
    private final BracketType bracketType;
    private final Class parent;
    private transient Field field;

    public VanillaFieldInfo(String name, Class type, BracketType bracketType, Field field) {
        this.name = name;
        this.type = type;
        this.bracketType = bracketType;
        this.parent = field.getDeclaringClass();
        this.field = field;
    }

    public static Wires.FieldInfoPair lookupClass(Class aClass) {
        SerializationStrategy ss = (SerializationStrategy)Wires.CLASS_STRATEGY.get(aClass);
        if (ss.bracketType() != BracketType.MAP) {
            return Wires.FieldInfoPair.EMPTY;
        }
        ArrayList<VanillaFieldInfo> fields = new ArrayList<VanillaFieldInfo>();
        WireMarshaller marshaller = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(aClass);
        for (WireMarshaller.FieldAccess fa : marshaller.fields) {
            String name = fa.field.getName();
            Class<?> type = fa.field.getType();
            SerializationStrategy ss2 = (SerializationStrategy)Wires.CLASS_STRATEGY.get(type);
            BracketType bracketType = ss2.bracketType();
            fields.add(new VanillaFieldInfo(name, type, bracketType, fa.field));
        }
        return new Wires.FieldInfoPair(Collections.unmodifiableList(fields), fields.stream().collect(Collectors.toMap(FieldInfo::name, f -> f)));
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Class type() {
        return this.type;
    }

    @Override
    public BracketType bracketType() {
        return this.bracketType;
    }

    @Override
    public Object get(Object value) {
        try {
            return this.getField().get(value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            Jvm.debug().on(VanillaFieldInfo.class, (Throwable)e);
            return null;
        }
    }

    @Override
    public void set(Object object, Object value) {
        Object value2 = ObjectUtils.convertTo((Class)this.type, (Object)value);
        try {
            this.getField().set(object, value2);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Field getField() throws NoSuchFieldException {
        if (this.field == null) {
            this.field = this.parent.getDeclaredField(this.name);
            this.field.setAccessible(true);
        }
        return this.field;
    }
}

