/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.nio.BufferUnderflowException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.BitSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharTesters;
import net.openhft.chronicle.bytes.StopCharsTester;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.ref.TextIntReference;
import net.openhft.chronicle.bytes.ref.TextLongArrayReference;
import net.openhft.chronicle.bytes.ref.TextLongReference;
import net.openhft.chronicle.bytes.util.Compression;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.core.util.BooleanConsumer;
import net.openhft.chronicle.core.util.ObjBooleanConsumer;
import net.openhft.chronicle.core.util.ObjByteConsumer;
import net.openhft.chronicle.core.util.ObjFloatConsumer;
import net.openhft.chronicle.core.util.ObjShortConsumer;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.DefaultValueIn;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.Quotes;
import net.openhft.chronicle.wire.ReadDocumentContext;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.SerializationStrategies;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.TextStopCharTesters;
import net.openhft.chronicle.wire.TextStopCharsTesters;
import net.openhft.chronicle.wire.TriConsumer;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueInStack;
import net.openhft.chronicle.wire.ValueInState;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteDocumentContext;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;

public class TextWire
extends AbstractWire
implements Wire {
    public static final BytesStore TYPE = BytesStore.wrap((CharSequence)"!type ");
    static final String SEQ_MAP = "!seqmap";
    static final String NULL = "!null \"\"";
    static final BitSet STARTS_QUOTE_CHARS = new BitSet();
    static final BitSet QUOTE_CHARS = new BitSet();
    static final Logger LOG = LoggerFactory.getLogger(TextWire.class);
    static final ThreadLocal<StopCharTester> ESCAPED_QUOTES = ThreadLocal.withInitial(() -> ((StopCharTesters)StopCharTesters.QUOTES).escaping());
    static final ThreadLocal<StopCharTester> ESCAPED_SINGLE_QUOTES = ThreadLocal.withInitial(() -> StopCharTesters.SINGLE_QUOTES.escaping());
    static final ThreadLocal<StopCharsTester> ESCAPED_END_OF_TEXT = ThreadLocal.withInitial(() -> TextStopCharsTesters.END_OF_TEXT.escaping());
    static final BytesStore COMMA_SPACE = BytesStore.from((CharSequence)", ");
    static final BytesStore COMMA_NEW_LINE = BytesStore.from((CharSequence)",\n");
    static final BytesStore NEW_LINE = BytesStore.from((CharSequence)"\n");
    static final BytesStore EMPTY_AFTER_COMMENT = BytesStore.from((CharSequence)"");
    static final BytesStore EMPTY = BytesStore.from((CharSequence)"");
    static final BytesStore SPACE = BytesStore.from((CharSequence)" ");
    static final BytesStore END_FIELD = NEW_LINE;
    protected final TextValueOut valueOut = this.createValueOut();
    protected final TextValueIn valueIn = this.createValueIn();
    private final WriteDocumentContext writeContext = new WriteDocumentContext(this);
    private final ReadDocumentContext readContext = new ReadDocumentContext(this);
    private final StringBuilder sb = new StringBuilder();
    protected long lineStart = 0L;
    DefaultValueIn defaultValueIn;

    public TextWire(Bytes bytes, boolean use8bit) {
        super(bytes, use8bit);
    }

    public TextWire(Bytes bytes) {
        this(bytes, false);
    }

    public static TextWire fromFile(String name) throws IOException {
        return new TextWire(Bytes.wrapForRead((byte[])IOTools.readFile((String)name)), true);
    }

    @NotNull
    public static TextWire from(@NotNull String text) {
        return new TextWire(Bytes.from((CharSequence)text));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String asText(@NotNull Wire wire) {
        assert (wire.startUse());
        try {
            long pos = wire.bytes().readPosition();
            TextWire tw = new TextWire((Bytes)NativeBytes.nativeBytes());
            wire.copyTo(tw);
            wire.bytes().readPosition(pos);
            String string = tw.toString();
            return string;
        }
        finally {
            assert (wire.endUse());
        }
    }

    public static <ACS extends Appendable & CharSequence> void unescape(@NotNull ACS sb) {
        int end = 0;
        int length = ((CharSequence)sb).length();
        for (int i = 0; i < length; ++i) {
            int ch = ((CharSequence)sb).charAt(i);
            if (ch == 92 && i < length - 1) {
                char ch3 = ((CharSequence)sb).charAt(++i);
                switch (ch3) {
                    case 'b': {
                        ch = 8;
                        break;
                    }
                    case 'r': {
                        ch = 13;
                        break;
                    }
                    case 'n': {
                        ch = 10;
                        break;
                    }
                    case 't': {
                        ch = 9;
                        break;
                    }
                    case 'x': {
                        ch = (char)(Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 16 + Character.getNumericValue(((CharSequence)sb).charAt(++i)));
                        break;
                    }
                    case 'u': {
                        ch = (char)(Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 4096 + Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 256 + Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 16 + Character.getNumericValue(((CharSequence)sb).charAt(++i)));
                        break;
                    }
                    case '0': {
                        ch = 0;
                        break;
                    }
                    default: {
                        ch = ch3;
                    }
                }
            }
            AppendableUtil.setCharAt(sb, (int)end++, (char)ch);
        }
        if (length != ((CharSequence)sb).length()) {
            throw new IllegalStateException("Length changed from " + length + " to " + ((CharSequence)sb).length() + " for " + sb);
        }
        AppendableUtil.setLength(sb, (int)end);
    }

    @Override
    public void classLookup(ClassLookup classLookup) {
        this.classLookup = classLookup;
    }

    @Override
    public ClassLookup classLookup() {
        return this.classLookup;
    }

    @Override
    public DocumentContext writingDocument(boolean metaData) {
        this.writeContext.start(metaData);
        return this.writeContext;
    }

    @Override
    public DocumentContext readingDocument() {
        this.readContext.start();
        return this.readContext;
    }

    @Override
    public DocumentContext readingDocument(long readLocation) {
        long readPosition = this.bytes().readPosition();
        long readLimit = this.bytes().readLimit();
        this.bytes().readPosition(readLocation);
        this.readContext.start();
        this.readContext.closeReadLimit(readLimit);
        this.readContext.closeReadPosition(readPosition);
        return this.readContext;
    }

    @NotNull
    protected TextValueOut createValueOut() {
        return new TextValueOut();
    }

    @NotNull
    protected TextValueIn createValueIn() {
        return new TextValueIn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.bytes.readRemaining() > 10240L) {
            long l = this.bytes.readLimit();
            try {
                this.bytes.readLimit(this.bytes.readPosition() + 10240L);
                String string = this.bytes.toString() + "..";
                return string;
            }
            finally {
                this.bytes.readLimit(l);
            }
        }
        return this.bytes.toString();
    }

    @Override
    public void copyTo(@NotNull WireOut wire) {
        wire.bytes().write((BytesStore)this.bytes, this.bytes().readPosition(), this.bytes().readLimit());
    }

    @Override
    @NotNull
    public ValueIn read() {
        this.readField(this.acquireStringBuilder());
        return this.valueIn;
    }

    private StringBuilder acquireStringBuilder() {
        StringUtils.setCount((StringBuilder)this.sb, (int)0);
        return this.sb;
    }

    @NotNull
    protected StringBuilder readField(@NotNull StringBuilder sb) {
        this.consumePadding();
        try {
            int ch = this.peekCode();
            if (ch > 128 && ((ch & 0xC0) == 128 || (ch & 0xF0) == 240)) {
                throw new IllegalStateException("Attempting to read binary as TextWire ch=" + Integer.toHexString(ch));
            }
            if (ch == 63) {
                this.bytes.readSkip(1L);
                this.consumePadding();
                ch = this.peekCode();
            }
            if (ch == 34) {
                this.bytes.readSkip(1L);
                this.parseUntil(sb, this.getEscapingQuotes());
                this.consumePadding();
                ch = this.readCode();
                if (ch != 58) {
                    throw new UnsupportedOperationException("Expected a : at " + this.bytes.toDebugString() + " was " + (char)ch);
                }
            } else {
                if (ch < 0) {
                    sb.setLength(0);
                    return sb;
                }
                this.parseUntil(sb, this.getEscapingEndOfText());
            }
            TextWire.unescape(sb);
        }
        catch (BufferUnderflowException e) {
            Jvm.debug().on(this.getClass(), (Throwable)e);
        }
        return sb;
    }

    @Override
    public <K> K readEvent(Class<K> expectedClass) {
        this.consumePadding(0);
        StringBuilder sb = this.acquireStringBuilder();
        try {
            int ch = this.peekCode();
            if (ch > 128 && ((ch & 0xC0) == 128 || (ch & 0xF0) == 240)) {
                throw new IllegalStateException("Attempting to read binary as TextWire ch=" + Integer.toHexString(ch));
            }
            if (ch == 63) {
                this.bytes.readSkip(1L);
                this.consumePadding();
                K object = this.valueIn.object(expectedClass);
                this.consumePadding();
                ch = this.readCode();
                if (ch != 58) {
                    throw new IllegalStateException("Unexpected character after field " + ch + " '" + (char)ch + "'");
                }
                return object;
            }
            if (ch == 34 || ch == 39) {
                this.bytes.readSkip(1L);
                StopCharTester escapingQuotes = ch == 34 ? this.getEscapingQuotes() : this.getEscapingSingleQuotes();
                this.parseUntil(sb, escapingQuotes);
                this.consumePadding(1);
                ch = this.readCode();
                if (ch != 58) {
                    throw new UnsupportedOperationException("Expected a : at " + this.bytes.toDebugString());
                }
            } else {
                if (ch < 0) {
                    sb.setLength(0);
                    return null;
                }
                this.parseUntil(sb, this.getEscapingEndOfText());
            }
            TextWire.unescape(sb);
        }
        catch (BufferUnderflowException e) {
            Jvm.debug().on(this.getClass(), (Throwable)e);
        }
        return this.toExpected(expectedClass, sb);
    }

    private <K> K toExpected(Class<K> expectedClass, StringBuilder sb) {
        return (K)ObjectUtils.convertTo(expectedClass, (Object)WireInternal.INTERNER.intern((CharSequence)sb));
    }

    @NotNull
    protected StopCharsTester getEscapingEndOfText() {
        StopCharsTester escaping = ESCAPED_END_OF_TEXT.get();
        escaping.isStopChar(32, 32);
        return escaping;
    }

    protected StopCharTester getEscapingQuotes() {
        StopCharTester sct = ESCAPED_QUOTES.get();
        sct.isStopChar(32);
        return sct;
    }

    private StopCharTester getEscapingSingleQuotes() {
        StopCharTester sct = ESCAPED_SINGLE_QUOTES.get();
        sct.isStopChar(32);
        return sct;
    }

    @Override
    public void consumePadding() {
        this.consumePadding(0);
    }

    public void consumePadding(int commas) {
        while (true) {
            int codePoint;
            if ((codePoint = this.peekCode()) == 35) {
                while (this.readCode() >= 32) {
                }
                this.lineStart = this.bytes.readPosition();
                continue;
            }
            if (codePoint == 44) {
                if (commas-- <= 0) {
                    return;
                }
                this.bytes.readSkip(1L);
                if (commas != 0) continue;
                return;
            }
            if (!Character.isWhitespace(codePoint)) break;
            if (codePoint == 10 || codePoint == 13) {
                this.lineStart = this.bytes.readPosition() + 1L;
            }
            this.bytes.readSkip(1L);
        }
    }

    protected void consumeDocumentStart() {
        long pos;
        if (this.bytes.readRemaining() > 4L && this.bytes.readByte(pos = this.bytes.readPosition()) == 45 && this.bytes.readByte(pos + 1L) == 45 && this.bytes.readByte(pos + 2L) == 45) {
            this.bytes.readSkip(3L);
        }
    }

    int peekCode() {
        return this.bytes.peekUnsignedByte();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean peekStringIgnoreCase(@NotNull String source) {
        if (source.isEmpty()) {
            return true;
        }
        if (this.bytes.readRemaining() < 1L) {
            return false;
        }
        long pos = this.bytes.readPosition();
        try {
            for (int i = 0; i < source.length(); ++i) {
                if (Character.toLowerCase(source.charAt(i)) == Character.toLowerCase(this.bytes.readByte())) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.bytes.readPosition(pos);
        }
        return true;
    }

    protected int readCode() {
        if (this.bytes.readRemaining() < 1L) {
            return -1;
        }
        return this.bytes.readUnsignedByte();
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        this.consumePadding();
        ValueInState curr = this.valueIn.curr();
        StringBuilder sb = this.acquireStringBuilder();
        if (curr.savedPosition() > 0L) {
            this.bytes.readPosition(curr.savedPosition() - 1L);
            curr.savedPosition(0L);
        }
        CharSequence name = key.name();
        while (this.bytes.readRemaining() > 0L) {
            long position = this.bytes.readPosition();
            this.readField(sb);
            if (sb.length() == 0 || StringUtils.isEqual((CharSequence)sb, (CharSequence)name)) {
                return this.valueIn;
            }
            curr.addUnexpected(position);
            long toSkip = this.valueIn.readLengthMarshallable();
            this.bytes.readSkip(toSkip);
            this.consumePadding(1);
        }
        return this.read2(key, curr, sb, name);
    }

    protected ValueIn read2(@NotNull WireKey key, ValueInState curr, StringBuilder sb, CharSequence name) {
        long position2 = this.bytes.readPosition();
        for (int i = 0; i < curr.unexpectedSize(); ++i) {
            this.bytes.readPosition(curr.unexpected(i));
            this.readField(sb);
            if (sb.length() != 0 && !StringUtils.isEqual((CharSequence)sb, (CharSequence)name)) continue;
            curr.removeUnexpected(i);
            curr.savedPosition(position2 + 1L);
            return this.valueIn;
        }
        this.bytes.readPosition(position2);
        if (this.defaultValueIn == null) {
            this.defaultValueIn = new DefaultValueIn(this);
        }
        this.defaultValueIn.wireKey = key;
        return this.defaultValueIn;
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        this.consumePadding();
        this.readField(name);
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn getValueIn() {
        return this.valueIn;
    }

    @Override
    @NotNull
    public Wire readComment(@NotNull StringBuilder s) {
        this.consumeWhiteSpace();
        if (this.peekCode() == 35) {
            this.bytes.readSkip(1L);
            this.consumeWhiteSpace();
            this.bytes.parseUtf8((Appendable)s, (StopCharTester)StopCharTesters.CONTROL_STOP);
        }
        return this;
    }

    public void consumeWhiteSpace() {
        while (Character.isWhitespace(this.peekCode())) {
            this.bytes.readSkip(1L);
        }
    }

    @Override
    public void clear() {
        this.bytes.clear();
        this.valueIn.resetState();
        this.valueOut.resetState();
    }

    @Override
    @NotNull
    public Bytes<?> bytes() {
        return this.bytes;
    }

    @Override
    public boolean hasMore() {
        this.consumePadding();
        return this.bytes.readRemaining() > 0L;
    }

    @Override
    @NotNull
    public ValueOut write() {
        return this.valueOut.write();
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull WireKey key) {
        return this.valueOut.write(key);
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull CharSequence name) {
        return this.valueOut.write(name);
    }

    @Override
    public ValueOut writeEvent(Class expectedType, Object eventKey) {
        if (eventKey instanceof WireKey) {
            return this.writeEventName((WireKey)eventKey);
        }
        if (eventKey instanceof CharSequence) {
            return this.writeEventName((CharSequence)eventKey);
        }
        this.valueOut.leaf(true);
        return this.valueOut.write(expectedType, eventKey);
    }

    @Override
    @NotNull
    public ValueOut getValueOut() {
        return this.valueOut;
    }

    @Override
    @NotNull
    public Wire writeComment(@NotNull CharSequence s) {
        this.valueOut.writeComment(s);
        return this;
    }

    @Override
    @NotNull
    public WireOut addPadding(int paddingToAdd) {
        for (int i = 0; i < paddingToAdd; ++i) {
            this.bytes.writeUnsignedByte((this.bytes.writePosition() & 0x3FL) == 0L ? 10 : 32);
        }
        return this;
    }

    void escape(@NotNull CharSequence s) {
        Quotes quotes = this.needsQuotes(s);
        if (quotes == Quotes.NONE) {
            this.escape0(s, quotes);
            return;
        }
        this.bytes.writeUnsignedByte((int)quotes.q);
        this.escape0(s, quotes);
        this.bytes.writeUnsignedByte((int)quotes.q);
    }

    protected void escape0(@NotNull CharSequence s, Quotes quotes) {
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    if (ch == quotes.q) {
                        ((Bytes)this.bytes.writeUnsignedByte(92)).writeUnsignedByte((int)ch);
                        continue block10;
                    }
                    this.bytes.writeUnsignedByte((int)ch);
                    continue block10;
                }
                case '\'': {
                    if (ch == quotes.q) {
                        ((Bytes)this.bytes.writeUnsignedByte(92)).writeUnsignedByte((int)ch);
                        continue block10;
                    }
                    this.bytes.writeUnsignedByte((int)ch);
                    continue block10;
                }
                case '\\': {
                    ((Bytes)this.bytes.writeUnsignedByte(92)).writeUnsignedByte((int)ch);
                    continue block10;
                }
                case '\b': {
                    this.bytes.appendUtf8((CharSequence)"\\b");
                    continue block10;
                }
                case '\t': {
                    this.bytes.appendUtf8((CharSequence)"\\t");
                    continue block10;
                }
                case '\r': {
                    this.bytes.appendUtf8((CharSequence)"\\r");
                    continue block10;
                }
                case '\n': {
                    this.bytes.appendUtf8((CharSequence)"\\n");
                    continue block10;
                }
                case '\u0000': {
                    this.bytes.appendUtf8((CharSequence)"\\0");
                    continue block10;
                }
                default: {
                    this.bytes.appendUtf8((int)ch);
                }
            }
        }
    }

    protected Quotes needsQuotes(@NotNull CharSequence s) {
        Quotes quotes = Quotes.NONE;
        if (s.length() == 0) {
            return Quotes.DOUBLE;
        }
        if (STARTS_QUOTE_CHARS.get(s.charAt(0))) {
            return Quotes.DOUBLE;
        }
        if (s.charAt(0) == '\"') {
            return Quotes.SINGLE;
        }
        if (Character.isWhitespace(s.charAt(s.length() - 1))) {
            return Quotes.DOUBLE;
        }
        for (int i = 1; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (QUOTE_CHARS.get(ch)) {
                return Quotes.DOUBLE;
            }
            if (ch != '\"') continue;
            quotes = Quotes.SINGLE;
        }
        return quotes;
    }

    @Override
    @NotNull
    public LongValue newLongReference() {
        return new TextLongReference();
    }

    @Override
    @NotNull
    public IntValue newIntReference() {
        return new TextIntReference();
    }

    @Override
    @NotNull
    public LongArrayValues newLongArrayReference() {
        return new TextLongArrayReference();
    }

    public void parseWord(StringBuilder sb) {
        this.parseUntil(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
    }

    public void parseUntil(StringBuilder sb, StopCharTester testers) {
        if (this.use8bit) {
            this.bytes.parse8bit((Appendable)sb, testers);
        } else {
            this.bytes.parseUtf8((Appendable)sb, testers);
        }
    }

    public void parseUntil(StringBuilder sb, StopCharsTester testers) {
        sb.setLength(0);
        if (this.use8bit) {
            AppendableUtil.read8bitAndAppend((StreamingDataInput)this.bytes, (StringBuilder)sb, (StopCharsTester)testers);
        } else {
            AppendableUtil.readUTFAndAppend((StreamingDataInput)this.bytes, (Appendable)sb, (StopCharsTester)testers);
        }
    }

    public void append(CharSequence cs) {
        if (this.use8bit) {
            this.bytes.append8bit(cs);
        } else {
            this.bytes.appendUtf8(cs);
        }
    }

    public void append(CharSequence cs, int offset, int length) {
        if (this.use8bit) {
            this.bytes.append8bit(cs, offset, offset + length);
        } else {
            this.bytes.appendUtf8(cs, offset, length);
        }
    }

    public Object readObject() {
        this.consumePadding();
        this.consumeDocumentStart();
        return this.readObject(0);
    }

    Object readObject(int indentation) {
        this.consumePadding();
        int code = this.peekCode();
        int indentation2 = this.indentation();
        if (indentation2 < indentation) {
            return NoObject.NO_OBJECT;
        }
        switch (code) {
            case 45: {
                if (this.bytes.readByte(this.bytes.readPosition() + 1L) == 45) {
                    return NoObject.NO_OBJECT;
                }
                return this.readList(indentation2, null);
            }
            case 91: {
                return this.readList();
            }
            case 123: {
                return this.valueIn.marshallableAsMap(Object.class, Object.class);
            }
            case 33: {
                return this.readTypedObject();
            }
        }
        return this.readMap(indentation2, null);
    }

    private int indentation() {
        return Maths.toInt32((long)(this.bytes.readPosition() - this.lineStart));
    }

    private Object readTypedObject() {
        return this.valueIn.object(Object.class);
    }

    private List readList() {
        throw new UnsupportedOperationException();
    }

    List readList(int indentation, Class elementType) {
        ArrayList<Object> objects = new ArrayList<Object>();
        while (this.peekCode() == 45 && this.indentation() >= indentation && this.bytes.readByte(this.bytes.readPosition() + 1L) != 45) {
            long ls = this.lineStart;
            this.bytes.readSkip(1L);
            this.consumePadding();
            if (this.lineStart == ls) {
                objects.add(this.valueIn.objectWithInferredType(null, SerializationStrategies.ANY_OBJECT, elementType));
            } else {
                Object e = this.readObject(indentation);
                if (e != NoObject.NO_OBJECT) {
                    objects.add(e);
                }
            }
            this.consumePadding(1);
        }
        return objects;
    }

    private Map readMap(int indentation, Class valueType) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        StringBuilder sb = WireInternal.acquireAnotherStringBuilder(this.acquireStringBuilder());
        this.consumePadding();
        while (this.bytes.readRemaining() > 0L && this.indentation() >= indentation && this.bytes.readRemaining() != 0L) {
            this.read(sb);
            String key = WireInternal.INTERNER.intern((CharSequence)sb);
            if (key.equals("...")) break;
            Object value = this.valueIn.objectWithInferredType(null, SerializationStrategies.ANY_OBJECT, valueType);
            map.put(key, value);
            this.consumePadding(1);
        }
        return map;
    }

    public void writeObject(Object o) {
        if (o instanceof Iterable) {
            for (Object o2 : (Iterable)o) {
                this.writeObject(o2, 2);
            }
        } else if (o instanceof Map) {
            for (Map.Entry entry : ((Map)o).entrySet()) {
                this.write(() -> entry.getKey().toString()).object(entry.getValue());
            }
        } else if (o instanceof WriteMarshallable) {
            this.valueOut.typedMarshallable((WriteMarshallable)o);
        } else {
            this.valueOut.object(o);
        }
    }

    private void writeObject(Object o, int indentation) {
        this.writeTwo('-', ' ');
        this.indentation(indentation - 2);
        this.valueOut.object(o);
    }

    private void indentation(int indentation) {
        while (indentation-- > 0) {
            this.bytes.writeUnsignedByte(32);
        }
    }

    @Override
    public void startEvent() {
        this.valueOut.prependSeparator();
        this.writeTwo('?', ' ');
    }

    @Override
    public void endEvent() {
        this.valueOut.endEvent();
    }

    void writeTwo(char ch1, char ch2) {
        this.bytes.writeUnsignedByte((int)ch1);
        this.bytes.writeUnsignedByte((int)ch2);
    }

    static {
        for (char ch : "?0123456789+- \t',#:{}[]|>!\u0000\b\\".toCharArray()) {
            STARTS_QUOTE_CHARS.set(ch);
        }
        for (char ch : "?,#:{}[]|>\u0000\b\\".toCharArray()) {
            QUOTE_CHARS.set(ch);
        }
        WireInternal.INTERNER.valueCount();
    }

    class TextValueIn
    implements ValueIn {
        final ValueInStack stack = new ValueInStack();

        TextValueIn() {
        }

        @Override
        public void resetState() {
            this.stack.reset();
        }

        public void pushState() {
            this.stack.push();
        }

        public void popState() {
            this.stack.pop();
        }

        public ValueInState curr() {
            return this.stack.curr();
        }

        @Override
        public String text() {
            CharSequence cs = this.textTo0(TextWire.this.acquireStringBuilder());
            return cs == null ? null : WireInternal.INTERNER.intern(cs);
        }

        @Override
        @Nullable
        public StringBuilder textTo(@NotNull StringBuilder sb) {
            CharSequence cs = this.textTo0(sb);
            if (cs == null) {
                return null;
            }
            if (cs != sb) {
                sb.setLength(0);
                sb.append(cs);
            }
            return sb;
        }

        @Override
        @Nullable
        public Bytes textTo(@NotNull Bytes bytes) {
            CharSequence cs = this.textTo0(bytes);
            if (cs == null) {
                return null;
            }
            if (cs != bytes) {
                bytes.clear();
                bytes.writeUtf8(cs);
            }
            return bytes;
        }

        @Override
        public BracketType getBracketType() {
            TextWire.this.consumePadding();
            switch (TextWire.this.peekCode()) {
                case 123: {
                    return BracketType.MAP;
                }
                case 91: {
                    return BracketType.SEQ;
                }
            }
            return BracketType.NONE;
        }

        @Nullable
        <ACS extends Appendable & CharSequence> CharSequence textTo0(@NotNull ACS a) {
            TextWire.this.consumePadding();
            int ch = TextWire.this.peekCode();
            CharSequence ret = a;
            switch (ch) {
                case 123: {
                    long len = this.readLength();
                    try {
                        a.append(Bytes.toString((Bytes)TextWire.this.bytes, (long)TextWire.this.bytes.readPosition(), (long)len));
                    }
                    catch (IOException e) {
                        throw new AssertionError((Object)e);
                    }
                    TextWire.this.bytes.readSkip(len);
                    TextWire.this.bytes.skipTo((StopCharTester)StopCharTesters.COMMA_STOP);
                    return a;
                }
                case 34: {
                    this.readText(a, TextWire.this.getEscapingQuotes());
                    break;
                }
                case 39: {
                    this.readText(a, TextWire.this.getEscapingSingleQuotes());
                    break;
                }
                case 33: {
                    TextWire.this.bytes.readSkip(1L);
                    StringBuilder sb = TextWire.this.acquireStringBuilder();
                    TextWire.this.parseWord(sb);
                    if (StringUtils.isEqual((CharSequence)sb, (CharSequence)"!null")) {
                        this.textTo(sb);
                        ret = null;
                        break;
                    }
                    if (StringUtils.isEqual((CharSequence)sb, (CharSequence)"snappy")) {
                        this.textTo(sb);
                        try {
                            byte[] decodedBytes = Base64.getDecoder().decode(sb.toString().getBytes(StandardCharsets.ISO_8859_1));
                            String csq = Snappy.uncompressString((byte[])decodedBytes);
                            ret = TextWire.this.acquireStringBuilder().append(csq);
                            break;
                        }
                        catch (IOException e) {
                            throw new AssertionError((Object)e);
                        }
                    }
                    if (a instanceof StringBuilder) {
                        this.textTo((StringBuilder)a);
                        break;
                    }
                    this.textTo(sb);
                    ret = sb;
                    break;
                }
                default: {
                    if (TextWire.this.bytes.readRemaining() > 0L) {
                        if (a instanceof Bytes || TextWire.this.use8bit) {
                            TextWire.this.bytes.parse8bit(a, TextWire.this.getEscapingEndOfText());
                        } else {
                            TextWire.this.bytes.parseUtf8(a, TextWire.this.getEscapingEndOfText());
                        }
                    } else {
                        AppendableUtil.setLength(a, (int)0);
                    }
                    while (((CharSequence)a).length() > 0 && Character.isWhitespace(((CharSequence)a).charAt(((CharSequence)a).length() - 1))) {
                        AppendableUtil.setLength(a, (int)(((CharSequence)a).length() - 1));
                    }
                    break block2;
                }
            }
            int prev = this.peekBack();
            if (prev == 58 || prev == 35 || prev == 125 || prev == 93) {
                TextWire.this.bytes.readSkip(-1L);
            }
            return ret;
        }

        private <ACS extends Appendable & CharSequence> void readText(@NotNull ACS a, StopCharTester quotes) {
            TextWire.this.bytes.readSkip(1L);
            if (TextWire.this.use8bit) {
                TextWire.this.bytes.parse8bit(a, quotes);
            } else {
                TextWire.this.bytes.parseUtf8(a, quotes);
            }
            TextWire.unescape(a);
            TextWire.this.consumePadding(1);
        }

        protected int peekBack() {
            while (TextWire.this.bytes.readPosition() >= TextWire.this.bytes.start()) {
                int prev = TextWire.this.bytes.readUnsignedByte(TextWire.this.bytes.readPosition() - 1L);
                if (prev != 32) {
                    if (prev == 10 || prev == 13) {
                        TextWire.this.lineStart = TextWire.this.bytes.readPosition();
                    }
                    return prev;
                }
                TextWire.this.bytes.readSkip(-1L);
            }
            return -1;
        }

        @Override
        @NotNull
        public WireIn bytesMatch(@NotNull BytesStore compareBytes, BooleanConsumer consumer) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireIn bytes(@NotNull BytesOut toBytes) {
            return this.bytes(b -> toBytes.write((BytesStore)b));
        }

        @Override
        @Nullable
        public WireIn bytesSet(@NotNull PointerBytesStore toBytes) {
            return this.bytes(bytes -> {
                long capacity = bytes.readRemaining();
                VanillaBytes bytes2 = Bytes.allocateDirect((long)capacity);
                bytes2.write((BytesStore)bytes);
                toBytes.set(bytes2.address(bytes2.start()), capacity);
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public WireIn bytes(@NotNull ReadBytesMarshallable bytesConsumer) {
            TextWire.this.consumePadding();
            try {
                StringBuilder sb = TextWire.this.acquireStringBuilder();
                if (TextWire.this.peekCode() == 33) {
                    TextWire.this.bytes.readSkip(1L);
                    TextWire.this.parseWord(sb);
                    byte[] uncompressed = Compression.uncompress((CharSequence)sb, (Object)TextWire.this, t -> {
                        StringBuilder sb2 = TextWire.this.acquireStringBuilder();
                        AppendableUtil.setLength((Appendable)sb2, (int)0);
                        t.parseWord(sb2);
                        byte[] decode = Base64.getDecoder().decode(sb2.toString());
                        return decode;
                    });
                    if (uncompressed != null) {
                        bytesConsumer.readMarshallable((BytesIn)Bytes.wrapForRead((byte[])uncompressed));
                    } else {
                        if (!StringUtils.isEqual((CharSequence)sb, (CharSequence)"!null")) throw new IORuntimeException("Unsupported type=" + sb);
                        bytesConsumer.readMarshallable(null);
                        TextWire.this.parseWord(sb);
                    }
                } else {
                    this.textTo(sb);
                    bytesConsumer.readMarshallable((BytesIn)Bytes.wrapForRead((byte[])sb.toString().getBytes(StandardCharsets.ISO_8859_1)));
                }
                TextWire textWire = TextWire.this;
                return textWire;
            }
            finally {
                TextWire.this.consumePadding(1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public byte[] bytes() {
            TextWire.this.consumePadding();
            try {
                StringBuilder sb = TextWire.this.acquireStringBuilder();
                if (TextWire.this.peekCode() == 33) {
                    byte[] bytes;
                    TextWire.this.bytes.readSkip(1L);
                    TextWire.this.parseWord(sb);
                    if ("byte[]".contentEquals(sb)) {
                        TextWire.this.bytes.readSkip(1L);
                        TextWire.this.parseWord(sb);
                    }
                    if ((bytes = Compression.uncompress((CharSequence)sb, (Object)this, t -> {
                        StringBuilder sb0 = TextWire.this.acquireStringBuilder();
                        AppendableUtil.setLength((Appendable)sb0, (int)0);
                        TextWire.this.parseWord(sb0);
                        return Base64.getDecoder().decode(WireInternal.INTERNER.intern((CharSequence)sb));
                    })) != null) {
                        byte[] byArray = bytes;
                        return byArray;
                    }
                    if ("!null".contentEquals(sb)) {
                        TextWire.this.parseWord(sb);
                        byte[] byArray = null;
                        return byArray;
                    }
                    throw new IllegalStateException("unsupported type=" + sb);
                }
                this.textTo(sb);
                byte[] byArray = sb.toString().getBytes(StandardCharsets.ISO_8859_1);
                return byArray;
            }
            finally {
                TextWire.this.consumePadding(1);
            }
        }

        @Override
        @NotNull
        public WireIn wireIn() {
            return TextWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long readLength() {
            long start = TextWire.this.bytes.readPosition();
            try {
                this.skipValue();
                long l = TextWire.this.bytes.readPosition() - start;
                return l;
            }
            finally {
                TextWire.this.bytes.readPosition(start);
            }
        }

        @Override
        public WireIn skipValue() {
            TextWire.this.consumePadding();
            int code = TextWire.this.readCode();
            switch (code) {
                case 123: {
                    int count = 1;
                    while (true) {
                        byte b;
                        if ((b = TextWire.this.bytes.readByte()) == 123) {
                            ++count;
                            continue;
                        }
                        if (b == 125) {
                            if (--count != 0) continue;
                            return TextWire.this;
                        }
                        if (b == 0) break;
                    }
                    TextWire.this.bytes.readSkip(-1L);
                    return TextWire.this;
                }
                case 45: {
                    byte b;
                    while ((b = TextWire.this.bytes.readByte()) >= 32) {
                    }
                    TextWire.this.bytes.readSkip(-1L);
                    return TextWire.this;
                }
            }
            this.bytes();
            return TextWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long readLengthMarshallable() {
            long start = TextWire.this.bytes.readPosition();
            try {
                TextWire.this.consumePadding();
                int code = TextWire.this.peekCode();
                switch (code) {
                    case 123: {
                        TextWire.this.bytes.readSkip(1L);
                        int count = 1;
                        while (true) {
                            byte b;
                            if ((b = TextWire.this.bytes.readByte()) == 123) {
                                ++count;
                                continue;
                            }
                            if (b == 125) {
                                if (--count != 0) continue;
                                long l = TextWire.this.bytes.readPosition() - start;
                                return l;
                            }
                            if (b != 0) continue;
                            long l = TextWire.this.bytes.readPosition() - start - 1L;
                            return l;
                        }
                    }
                }
                this.consumeValue();
                long l = TextWire.this.bytes.readPosition() - start;
                return l;
            }
            finally {
                TextWire.this.bytes.readPosition(start);
            }
        }

        private void consumeValue() {
            TextWire.this.consumePadding();
            StringBuilder sb = TextWire.this.acquireStringBuilder();
            if (TextWire.this.peekCode() == 33) {
                TextWire.this.bytes.readSkip(1L);
                TextWire.this.parseWord(sb);
                TextWire.this.parseWord(sb);
            } else {
                this.textTo(sb);
            }
        }

        @Override
        @NotNull
        public <T> WireIn bool(T t, @NotNull ObjBooleanConsumer<T> tFlag) {
            TextWire.this.consumePadding();
            StringBuilder sb = TextWire.this.acquireStringBuilder();
            if (this.textTo(sb) == null) {
                tFlag.accept(t, null);
                return TextWire.this;
            }
            tFlag.accept(t, Boolean.valueOf(StringUtils.isEqual((CharSequence)sb, (CharSequence)"true")));
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int8(@NotNull T t, @NotNull ObjByteConsumer<T> tb) {
            TextWire.this.consumePadding();
            tb.accept(t, (byte)this.getALong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint8(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            TextWire.this.consumePadding();
            ti.accept(t, (short)this.getALong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int16(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            TextWire.this.consumePadding();
            ti.accept(t, (short)this.getALong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint16(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            TextWire.this.consumePadding();
            ti.accept(t, (int)this.getALong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int32(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            TextWire.this.consumePadding();
            ti.accept(t, (int)this.getALong());
            return TextWire.this;
        }

        long getALong() {
            int code = TextWire.this.peekCode();
            switch (code) {
                case 34: 
                case 39: {
                    TextWire.this.bytes.readSkip(1L);
                    break;
                }
                case 70: 
                case 84: 
                case 102: 
                case 116: {
                    return this.bool() ? 1L : 0L;
                }
                case 91: 
                case 123: {
                    throw new IORuntimeException("Cannot read a " + (char)code + " as a number");
                }
            }
            return TextWire.this.bytes.parseLong();
        }

        @Override
        @NotNull
        public <T> WireIn uint32(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            TextWire.this.consumePadding();
            tl.accept(t, this.getALong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            TextWire.this.consumePadding();
            tl.accept(t, this.getALong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn float32(@NotNull T t, @NotNull ObjFloatConsumer<T> tf) {
            TextWire.this.consumePadding();
            tf.accept(t, (float)TextWire.this.bytes.parseDouble());
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn float64(@NotNull T t, @NotNull ObjDoubleConsumer<T> td) {
            TextWire.this.consumePadding();
            td.accept(t, TextWire.this.bytes.parseDouble());
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn time(@NotNull T t, @NotNull BiConsumer<T, LocalTime> setLocalTime) {
            TextWire.this.consumePadding();
            StringBuilder sb = TextWire.this.acquireStringBuilder();
            this.textTo(sb);
            setLocalTime.accept(t, LocalTime.parse(WireInternal.INTERNER.intern((CharSequence)sb)));
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn zonedDateTime(@NotNull T t, @NotNull BiConsumer<T, ZonedDateTime> tZonedDateTime) {
            TextWire.this.consumePadding();
            StringBuilder sb = TextWire.this.acquireStringBuilder();
            this.textTo(sb);
            tZonedDateTime.accept(t, ZonedDateTime.parse(WireInternal.INTERNER.intern((CharSequence)sb)));
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn date(@NotNull T t, @NotNull BiConsumer<T, LocalDate> tLocalDate) {
            TextWire.this.consumePadding();
            StringBuilder sb = TextWire.this.acquireStringBuilder();
            this.textTo(sb);
            tLocalDate.accept(t, LocalDate.parse(WireInternal.INTERNER.intern((CharSequence)sb)));
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uuid(@NotNull T t, @NotNull BiConsumer<T, UUID> tuuid) {
            TextWire.this.consumePadding();
            StringBuilder sb = TextWire.this.acquireStringBuilder();
            this.textTo(sb);
            tuuid.accept(t, UUID.fromString(WireInternal.INTERNER.intern((CharSequence)sb)));
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64array(@Nullable LongArrayValues values, T t, @NotNull BiConsumer<T, LongArrayValues> setter) {
            TextWire.this.consumePadding();
            if (!(values instanceof TextLongArrayReference)) {
                values = new TextLongArrayReference();
                setter.accept(t, values);
            }
            Byteable b = (Byteable)values;
            long length = TextLongArrayReference.peakLength((BytesStore)TextWire.this.bytes, (long)TextWire.this.bytes.readPosition());
            b.bytesStore((BytesStore)TextWire.this.bytes, TextWire.this.bytes.readPosition(), length);
            TextWire.this.bytes.readSkip(length);
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireIn int64(@Nullable LongValue value) {
            TextWire.this.consumePadding();
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)TextWire.this.bytes, TextWire.this.bytes.readPosition(), length);
            TextWire.this.bytes.readSkip(length);
            TextWire.this.consumePadding(1);
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64(@Nullable LongValue value, T t, @NotNull BiConsumer<T, LongValue> setter) {
            if (!(value instanceof TextLongReference)) {
                value = new TextLongReference();
                setter.accept(t, value);
            }
            return this.int64(value);
        }

        @Override
        @NotNull
        public <T> WireIn int32(@Nullable IntValue value, T t, @NotNull BiConsumer<T, IntValue> setter) {
            TextWire.this.consumePadding();
            if (!(value instanceof TextIntReference)) {
                value = new TextIntReference();
                setter.accept(t, value);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)TextWire.this.bytes, TextWire.this.bytes.readPosition(), length);
            TextWire.this.bytes.readSkip(length);
            TextWire.this.consumePadding(1);
            return TextWire.this;
        }

        @Override
        @NotNull
        public <T> boolean sequence(@NotNull T t, @NotNull BiConsumer<T, ValueIn> tReader) {
            TextWire.this.consumePadding();
            char code = (char)TextWire.this.readCode();
            if (code == '!') {
                TextWire.this.bytes.readSkip(-1L);
                Class typePrefix = this.typePrefix();
                if (typePrefix == Void.TYPE) {
                    this.text();
                    return false;
                }
                TextWire.this.consumePadding();
                code = (char)TextWire.this.readCode();
            }
            if (code != '[') {
                throw new IORuntimeException("Unsupported type " + code + " (" + code + ")");
            }
            tReader.accept(t, TextWire.this.valueIn);
            TextWire.this.consumePadding(1);
            code = (char)TextWire.this.readCode();
            if (code != ']') {
                throw new IORuntimeException("Expected a ] but got " + code + " (" + code + ")");
            }
            TextWire.this.consumePadding(1);
            return true;
        }

        @Override
        @NotNull
        public <T, K> WireIn sequence(@NotNull T t, K kls, @NotNull TriConsumer<T, K, ValueIn> tReader) {
            TextWire.this.consumePadding();
            char code = (char)TextWire.this.readCode();
            if (code != '[') {
                throw new IORuntimeException("Unsupported type " + code + " (" + code + ")");
            }
            TextWire.this.consumePadding();
            code = (char)TextWire.this.peekCode();
            if (code == ']') {
                TextWire.this.readCode();
                return TextWire.this;
            }
            tReader.accept(t, kls, TextWire.this.valueIn);
            TextWire.this.consumePadding();
            code = (char)TextWire.this.readCode();
            if (code != ']') {
                throw new IORuntimeException("Expected a ] but got " + code + " (" + code + ")");
            }
            return TextWire.this;
        }

        @Override
        public boolean hasNext() {
            TextWire.this.consumePadding();
            return TextWire.this.bytes.readRemaining() > 0L;
        }

        @Override
        public boolean hasNextSequenceItem() {
            TextWire.this.consumePadding();
            int ch = TextWire.this.peekCode();
            if (ch == 44) {
                TextWire.this.bytes.readSkip(1L);
                return true;
            }
            return ch > 0 && ch != 93;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T applyToMarshallable(@NotNull Function<WireIn, T> marshallableReader) {
            this.pushState();
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            if (code != 123) {
                throw new IORuntimeException("Unsupported type " + (char)code);
            }
            long len = this.readLengthMarshallable();
            long limit = TextWire.this.bytes.readLimit();
            long position = TextWire.this.bytes.readPosition();
            try {
                long newLimit = position - 1L + len;
                TextWire.this.bytes.readLimit(newLimit);
                TextWire.this.bytes.readSkip(1L);
                TextWire.this.consumePadding();
                T t = marshallableReader.apply(TextWire.this);
                return t;
            }
            finally {
                TextWire.this.bytes.readLimit(limit);
                TextWire.this.consumePadding(1);
                code = TextWire.this.readCode();
                this.popState();
                if (code != 125) {
                    throw new IORuntimeException("Unterminated { while reading marshallable bytes=" + Bytes.toString((Bytes)TextWire.this.bytes));
                }
            }
        }

        @Override
        @NotNull
        public <T> ValueIn typePrefix(T t, @NotNull BiConsumer<T, CharSequence> ts) {
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            StringBuilder sb = TextWire.this.acquireStringBuilder();
            sb.setLength(0);
            if (code == -1) {
                sb.append("java.lang.Object");
            } else if (code == 33) {
                TextWire.this.readCode();
                TextWire.this.parseUntil(sb, TextStopCharTesters.END_OF_TYPE);
            }
            return this;
        }

        @Override
        public Class typePrefix() {
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            if (code == 33) {
                TextWire.this.readCode();
                StringBuilder sb = TextWire.this.acquireStringBuilder();
                sb.setLength(0);
                TextWire.this.parseUntil(sb, TextStopCharTesters.END_OF_TYPE);
                try {
                    return TextWire.this.classLookup().forName((CharSequence)sb);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public boolean isTyped() {
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            return code == 33;
        }

        @NotNull
        String stringForCode(int code) {
            return code < 0 ? "Unexpected end of input" : "'" + (char)code + "'";
        }

        @Override
        @NotNull
        public <T> WireIn typeLiteralAsText(T t, @NotNull BiConsumer<T, CharSequence> classNameConsumer) throws IORuntimeException, BufferUnderflowException {
            TextWire.this.consumePadding();
            int code = TextWire.this.readCode();
            if (!TextWire.this.peekStringIgnoreCase("type ")) {
                throw new UnsupportedOperationException(this.stringForCode(code));
            }
            TextWire.this.bytes.readSkip((long)"type ".length());
            StringBuilder sb = TextWire.this.acquireStringBuilder();
            TextWire.this.parseUntil(sb, TextStopCharTesters.END_OF_TYPE);
            classNameConsumer.accept(t, sb);
            return TextWire.this;
        }

        @Override
        public <T> Class<T> typeLiteral() throws IORuntimeException, BufferUnderflowException {
            TextWire.this.consumePadding();
            int code = TextWire.this.readCode();
            if (!TextWire.this.peekStringIgnoreCase("type ")) {
                throw new UnsupportedOperationException(this.stringForCode(code));
            }
            TextWire.this.bytes.readSkip((long)"type ".length());
            StringBuilder sb = TextWire.this.acquireStringBuilder();
            TextWire.this.parseUntil(sb, TextStopCharTesters.END_OF_TYPE);
            try {
                return TextWire.this.classLookup().forName((CharSequence)sb);
            }
            catch (ClassNotFoundException e) {
                throw new IORuntimeException((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean marshallable(@NotNull Object object, SerializationStrategy strategy) throws BufferUnderflowException, IORuntimeException {
            if (this.isNull()) {
                return false;
            }
            if (TextWire.this.indentation() == 0) {
                strategy.readUsing(object, this);
                return true;
            }
            this.pushState();
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            if (code == 33) {
                this.typePrefix(null, (o, x) -> {});
            } else if (code != 123) {
                throw new IORuntimeException("Unsupported type " + this.stringForCode(code));
            }
            long len = this.readLengthMarshallable();
            long limit = TextWire.this.bytes.readLimit();
            long position = TextWire.this.bytes.readPosition();
            long newLimit = position - 1L + len;
            try {
                TextWire.this.bytes.readLimit(newLimit);
                TextWire.this.bytes.readSkip(1L);
                TextWire.this.consumePadding();
                strategy.readUsing(object, this);
            }
            finally {
                TextWire.this.bytes.readLimit(limit);
                TextWire.this.bytes.readPosition(newLimit);
                this.popState();
            }
            TextWire.this.consumePadding(1);
            code = TextWire.this.readCode();
            if (code != 125) {
                throw new IORuntimeException("Unterminated { while reading marshallable " + object + ",code='" + (char)code + "', bytes=" + Bytes.toString((Bytes)TextWire.this.bytes, (long)1024L));
            }
            TextWire.this.consumePadding(1);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Demarshallable demarshallable(@NotNull Class clazz) {
            Object object;
            this.pushState();
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            if (code == 33) {
                this.typePrefix(null, (o, x) -> {});
            } else if (code != 123) {
                throw new IORuntimeException("Unsupported type " + this.stringForCode(code));
            }
            long len = this.readLengthMarshallable();
            long limit = TextWire.this.bytes.readLimit();
            long position = TextWire.this.bytes.readPosition();
            long newLimit = position - 1L + len;
            try {
                TextWire.this.bytes.readLimit(newLimit);
                TextWire.this.bytes.readSkip(1L);
                TextWire.this.consumePadding();
                object = Demarshallable.newInstance(clazz, TextWire.this);
            }
            finally {
                TextWire.this.bytes.readLimit(limit);
                TextWire.this.bytes.readPosition(newLimit);
                this.popState();
            }
            TextWire.this.consumePadding(1);
            code = TextWire.this.readCode();
            if (code != 125) {
                throw new IORuntimeException("Unterminated { while reading marshallable " + object + ",code='" + (char)code + "', bytes=" + Bytes.toString((Bytes)TextWire.this.bytes, (long)1024L));
            }
            return object;
        }

        @Override
        @Nullable
        public <T> T typedMarshallable() {
            return (T)this.objectWithInferredType(null, SerializationStrategies.ANY_NESTED, null);
        }

        @Override
        @Nullable
        public <K, V> Map<K, V> map(@NotNull Class<K> kClass, @NotNull Class<V> vClass, Map<K, V> usingMap) {
            TextWire.this.consumePadding();
            if (usingMap == null) {
                usingMap = new LinkedHashMap();
            } else {
                usingMap.clear();
            }
            StringBuilder sb = TextWire.this.acquireStringBuilder();
            int code = TextWire.this.peekCode();
            switch (code) {
                case 33: {
                    return this.typedMap(kClass, vClass, usingMap, sb);
                }
                case 123: {
                    return this.marshallableAsMap(kClass, vClass, usingMap);
                }
                case 63: {
                    return TextWire.this.readAllAsMap(kClass, vClass, usingMap);
                }
            }
            return usingMap;
        }

        @Nullable
        private <K, V> Map<K, V> typedMap(@NotNull Class<K> kClazz, @NotNull Class<V> vClass, @NotNull Map<K, V> usingMap, StringBuilder sb) {
            TextWire.this.parseUntil(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
            String str = WireInternal.INTERNER.intern((CharSequence)sb);
            if ("!!null".contentEquals(sb)) {
                this.text();
                return null;
            }
            if ("!!seqmap".contentEquals(sb)) {
                TextWire.this.consumePadding();
                int start = TextWire.this.readCode();
                if (start != 91) {
                    throw new IORuntimeException("Unsupported start of sequence : " + (char)start);
                }
                do {
                    this.marshallable((WireIn r) -> {
                        Object k = r.read(() -> "key").object(kClazz);
                        Object v = r.read(() -> "value").object(vClass);
                        usingMap.put(k, v);
                    });
                } while (this.hasNextSequenceItem());
                return usingMap;
            }
            throw new IORuntimeException("Unsupported type :" + str);
        }

        @Override
        public <K extends ReadMarshallable, V extends ReadMarshallable> void typedMap(@NotNull Map<K, V> usingMap) {
            TextWire.this.consumePadding();
            usingMap.clear();
            StringBuilder sb = TextWire.this.acquireStringBuilder();
            if (TextWire.this.peekCode() == 33) {
                TextWire.this.parseUntil(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                String str = WireInternal.INTERNER.intern((CharSequence)sb);
                if (TextWire.SEQ_MAP.contentEquals(sb)) {
                    while (this.hasNext()) {
                        this.sequence(this, (T o, ValueIn s) -> s.marshallable((WireIn r) -> {
                            try {
                                ReadMarshallable k = (ReadMarshallable)r.read(() -> "key").typedMarshallable();
                                ReadMarshallable v = (ReadMarshallable)r.read(() -> "value").typedMarshallable();
                                usingMap.put(k, v);
                            }
                            catch (Exception e) {
                                Jvm.warn().on(this.getClass(), (Throwable)e);
                            }
                        }));
                    }
                } else {
                    throw new IORuntimeException("Unsupported type " + str);
                }
            }
        }

        @Override
        public boolean bool() {
            TextWire.this.consumePadding();
            StringBuilder sb = TextWire.this.acquireStringBuilder();
            if (this.textTo(sb) == null) {
                throw new NullPointerException("value is null");
            }
            return StringUtils.equalsCaseIgnore((CharSequence)sb, (CharSequence)"true");
        }

        @Override
        public byte int8() {
            long l = this.int64();
            if (l > 127L || l < -128L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Byte.MAX_VALUE/MIN_VALUE");
            }
            return (byte)l;
        }

        @Override
        public short int16() {
            long l = this.int64();
            if (l > 32767L || l < -32768L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Short.MAX_VALUE/MIN_VALUE");
            }
            return (short)l;
        }

        @Override
        public int int32() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer.MAX_VALUE/MIN_VALUE");
            }
            return (int)l;
        }

        @Override
        public int uint16() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < 0L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer" + ".MAX_VALUE/ZERO");
            }
            return (int)l;
        }

        @Override
        public long int64() {
            TextWire.this.consumePadding();
            TextWire.this.valueIn.skipType();
            long l = this.getALong();
            this.checkRewind();
            return l;
        }

        public void checkRewind() {
            int ch = TextWire.this.bytes.readUnsignedByte(TextWire.this.bytes.readPosition() - 1L);
            if (ch == 58 || ch == 125 || ch == 93) {
                TextWire.this.bytes.readSkip(-1L);
            }
        }

        @Override
        public double float64() {
            TextWire.this.consumePadding();
            TextWire.this.valueIn.skipType();
            double v = TextWire.this.bytes.parseDouble();
            this.checkRewind();
            return v;
        }

        private void skipType() {
            long peek = TextWire.this.bytes.peekUnsignedByte();
            if (peek == 33L) {
                StringBuilder sb = TextWire.this.acquireStringBuilder();
                TextWire.this.parseUntil(sb, TextStopCharTesters.END_OF_TYPE);
                TextWire.this.consumePadding();
            }
        }

        @Override
        public float float32() {
            double d = this.float64();
            if ((double)((float)d) != d) {
                throw new IllegalStateException("value=" + d + " can not be represented as a float");
            }
            return (float)d;
        }

        @Override
        public boolean isNull() {
            TextWire.this.consumePadding();
            if (TextWire.this.peekStringIgnoreCase("!!null \"\"")) {
                TextWire.this.bytes.readSkip((long)"!!null \"\"".length());
                return true;
            }
            return false;
        }

        @Override
        public Object objectWithInferredType(Object using, @NotNull SerializationStrategy strategy, Class type) {
            TextWire.this.consumePadding();
            int code = TextWire.this.peekCode();
            switch (code) {
                case 63: {
                    return this.map(Object.class, Object.class, (Map)using);
                }
                case 33: {
                    return this.object(using, type);
                }
                case 45: {
                    if (TextWire.this.bytes.readByte(TextWire.this.bytes.readPosition() + 1L) == 32) {
                        return TextWire.this.readList(TextWire.this.indentation(), null);
                    }
                    return TextWire.this.valueIn.readNumber();
                }
                case 91: {
                    return this.readSequence(strategy.type());
                }
                case 123: {
                    return TextWire.this.valueIn.marshallableAsMap(Object.class, Object.class);
                }
                case 43: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return TextWire.this.valueIn.readNumber();
                }
            }
            String text = TextWire.this.valueIn.text();
            if (Enum.class.isAssignableFrom(strategy.type())) {
                return text;
            }
            switch (text) {
                case "true": {
                    return Boolean.TRUE;
                }
                case "false": {
                    return Boolean.FALSE;
                }
            }
            return text;
        }

        protected Object readNumber() {
            String s;
            String ss = s = this.text();
            if (s == null || s.length() > 40) {
                return s;
            }
            if (s.contains("_")) {
                ss = s.replace("_", "");
            }
            try {
                return Long.decode(ss);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return Double.parseDouble(ss);
                }
                catch (NumberFormatException numberFormatException2) {
                    try {
                        if (s.length() == 7 && s.charAt(1) == ':') {
                            return LocalTime.parse("0" + s);
                        }
                        if (s.length() == 8 && s.charAt(2) == ':') {
                            return LocalTime.parse(s);
                        }
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        // empty catch block
                    }
                    try {
                        if (s.length() == 10) {
                            return LocalDate.parse(s);
                        }
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        // empty catch block
                    }
                    try {
                        if (s.length() >= 22) {
                            return ZonedDateTime.parse(s);
                        }
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        // empty catch block
                    }
                    return s;
                }
            }
        }

        @NotNull
        private Object readSequence(@NotNull Class clazz) {
            if (clazz == Object[].class || clazz == Object.class) {
                Object[] list = new ArrayList();
                this.sequence(list, (T l, ValueIn v) -> {
                    while (v.hasNextSequenceItem()) {
                        l.add(v.object(Object.class));
                    }
                });
                return clazz == Object[].class ? list.toArray() : list;
            }
            if (clazz == String[].class) {
                ArrayList list = new ArrayList();
                this.sequence(list, (T l, ValueIn v) -> {
                    while (v.hasNextSequenceItem()) {
                        l.add(v.text());
                    }
                });
                return list.toArray(new String[0]);
            }
            if (clazz == List.class) {
                ArrayList list = new ArrayList();
                this.sequence(list, (T l, ValueIn v) -> {
                    while (v.hasNextSequenceItem()) {
                        l.add(v.text());
                    }
                });
                return list;
            }
            if (clazz == Set.class) {
                HashSet list = new HashSet();
                this.sequence(list, (T l, ValueIn v) -> {
                    while (v.hasNextSequenceItem()) {
                        l.add(v.text());
                    }
                });
                return list;
            }
            throw new UnsupportedOperationException("Arrays of type " + clazz + " not supported.");
        }

        private Object typedObject() {
            Class clazz2;
            TextWire.this.readCode();
            StringBuilder sb = TextWire.this.acquireStringBuilder();
            TextWire.this.parseUntil(sb, TextStopCharTesters.END_OF_TYPE);
            if (StringUtils.isEqual((CharSequence)sb, (CharSequence)"!null")) {
                this.text();
                return null;
            }
            try {
                clazz2 = TextWire.this.classLookup().forName((CharSequence)sb);
            }
            catch (ClassNotFoundException e) {
                throw new IORuntimeException((Throwable)e);
            }
            return this.object(null, clazz2);
        }

        public String toString() {
            return TextWire.this.toString();
        }
    }

    class TextValueOut
    implements ValueOut {
        protected int indentation = 0;
        protected List<BytesStore> seps = new ArrayList<BytesStore>(4);
        @NotNull
        protected BytesStore sep = BytesStore.empty();
        protected boolean leaf = false;

        TextValueOut() {
        }

        @Override
        public void resetState() {
            this.indentation = 0;
            this.seps.clear();
            this.sep = BytesStore.empty();
            this.leaf = false;
        }

        void prependSeparator() {
            TextWire.this.append((CharSequence)this.sep);
            if (this.sep.endsWith('\n') || this.sep == EMPTY_AFTER_COMMENT) {
                this.indent();
            }
            this.sep = BytesStore.empty();
        }

        @Override
        @NotNull
        public ValueOut leaf() {
            this.leaf = true;
            return this;
        }

        @Override
        public ValueOut leaf(boolean leaf) {
            this.leaf = leaf;
            return this;
        }

        @Override
        @NotNull
        public WireOut wireOut() {
            return TextWire.this;
        }

        private void indent() {
            for (int i = 0; i < this.indentation; ++i) {
                TextWire.this.bytes.writeUnsignedShort(8224);
            }
        }

        public void elementSeparator() {
            if (this.indentation == 0) {
                if (this.leaf) {
                    this.sep = COMMA_SPACE;
                } else {
                    this.sep = BytesStore.empty();
                    TextWire.this.bytes.writeUnsignedByte(10);
                }
            } else {
                this.sep = this.leaf ? COMMA_SPACE : COMMA_NEW_LINE;
            }
        }

        @Override
        @NotNull
        public WireOut bool(@Nullable Boolean flag) {
            this.prependSeparator();
            TextWire.this.append(flag == null ? this.nullOut() : (flag != false ? "true" : "false"));
            this.elementSeparator();
            return this.wireOut();
        }

        @NotNull
        public String nullOut() {
            return "!!null \"\"";
        }

        @Override
        @NotNull
        public WireOut text(@Nullable CharSequence s) {
            this.prependSeparator();
            if (s == null) {
                TextWire.this.append(this.nullOut());
            } else {
                TextWire.this.escape(s);
            }
            this.elementSeparator();
            return this.wireOut();
        }

        @Override
        @NotNull
        public WireOut int8(byte i8) {
            this.prependSeparator();
            TextWire.this.bytes.append((long)i8);
            this.elementSeparator();
            return this.wireOut();
        }

        @Override
        @NotNull
        public WireOut bytes(@Nullable BytesStore fromBytes) {
            if (this.isText(fromBytes)) {
                return this.text(fromBytes);
            }
            int length = Maths.toInt32((long)fromBytes.readRemaining());
            byte[] byteArray = new byte[length];
            fromBytes.copyTo(byteArray);
            return this.bytes(byteArray);
        }

        @Override
        @NotNull
        public WireOut rawBytes(@NotNull byte[] value) {
            this.prependSeparator();
            TextWire.this.bytes.write(value);
            this.elementSeparator();
            return this.wireOut();
        }

        private boolean isText(@Nullable BytesStore fromBytes) {
            if (fromBytes == null) {
                return true;
            }
            for (long i = fromBytes.readPosition(); i < fromBytes.readLimit(); ++i) {
                int ch = fromBytes.readUnsignedByte(i);
                if ((ch >= 32 || ch == 9) && ch < 127) continue;
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public ValueOut writeLength(long remaining) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireOut bytes(byte[] byteArray) {
            return this.bytes("!binary", byteArray);
        }

        @Override
        @NotNull
        public WireOut bytes(String type, byte[] byteArray) {
            this.prependSeparator();
            this.typePrefix(type);
            TextWire.this.append(Base64.getEncoder().encodeToString(byteArray));
            TextWire.this.append((CharSequence)(this.leaf ? SPACE : END_FIELD));
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(String type, BytesStore bytesStore) {
            this.prependSeparator();
            this.typePrefix(type);
            TextWire.this.append(Base64.getEncoder().encodeToString(bytesStore.toByteArray()));
            TextWire.this.append((CharSequence)END_FIELD);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut uint8checked(int u8) {
            this.prependSeparator();
            TextWire.this.bytes.append((long)u8);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut int16(short i16) {
            this.prependSeparator();
            TextWire.this.bytes.append((long)i16);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut uint16checked(int u16) {
            this.prependSeparator();
            TextWire.this.bytes.append((long)u16);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut utf8(int codepoint) {
            this.prependSeparator();
            StringBuilder sb = TextWire.this.acquireStringBuilder();
            sb.appendCodePoint(codepoint);
            this.text(sb);
            this.sep = BytesStore.empty();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut int32(int i32) {
            this.prependSeparator();
            TextWire.this.bytes.append((long)i32);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut uint32checked(long u32) {
            this.prependSeparator();
            TextWire.this.bytes.append(u32);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut int64(long i64) {
            this.prependSeparator();
            TextWire.this.bytes.append(i64);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut int64_0x(long i64) {
            this.prependSeparator();
            ((Bytes)((Bytes)TextWire.this.bytes.writeUnsignedByte(48)).writeUnsignedByte(120)).appendBase(i64, 16);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity) {
            TextLongArrayReference.write((Bytes)TextWire.this.bytes, (long)capacity);
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity, @NotNull LongArrayValues values) {
            long pos = TextWire.this.bytes.writePosition();
            TextLongArrayReference.write((Bytes)TextWire.this.bytes, (long)capacity);
            ((Byteable)values).bytesStore((BytesStore)TextWire.this.bytes, pos, TextWire.this.bytes.writePosition() - pos);
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut float32(float f) {
            this.prependSeparator();
            TextWire.this.bytes.append(f);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut float64(double d) {
            this.prependSeparator();
            TextWire.this.bytes.append(d);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut time(@NotNull LocalTime localTime) {
            return this.asText(localTime);
        }

        @Override
        @NotNull
        public WireOut zonedDateTime(@NotNull ZonedDateTime zonedDateTime) {
            String s = zonedDateTime.toString();
            return s.endsWith("]") ? this.text(s) : this.asText(s);
        }

        @Override
        @NotNull
        public WireOut date(@NotNull LocalDate localDate) {
            return this.asText(localDate);
        }

        @Override
        @NotNull
        public WireOut dateTime(LocalDateTime localDateTime) {
            return this.asText(localDateTime);
        }

        @NotNull
        private WireOut asText(Object stringable) {
            if (stringable == null) {
                this.nu11();
            } else {
                this.prependSeparator();
                TextWire.this.append(stringable.toString());
                this.elementSeparator();
            }
            return TextWire.this;
        }

        @Override
        public ValueOut optionalTyped(Class aClass) {
            return this.typePrefix(aClass);
        }

        @Override
        @NotNull
        public ValueOut typePrefix(@NotNull CharSequence typeName) {
            this.prependSeparator();
            TextWire.this.bytes.writeUnsignedByte(33);
            TextWire.this.append(typeName);
            TextWire.this.bytes.writeUnsignedByte(32);
            this.sep = BytesStore.empty();
            return this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull BiConsumer<Class, Bytes> typeTranslator, Class type) {
            this.prependSeparator();
            TextWire.this.append((CharSequence)TYPE);
            typeTranslator.accept(type, TextWire.this.bytes);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull CharSequence type) {
            this.prependSeparator();
            TextWire.this.append((CharSequence)TYPE);
            TextWire.this.escape(type);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut uuid(@NotNull UUID uuid) {
            return this.asText(uuid);
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value) {
            this.prependSeparator();
            TextIntReference.write((Bytes)TextWire.this.bytes, (int)value);
            this.elementSeparator();
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value, IntValue intValue) {
            if (!TextIntReference.class.isInstance(intValue)) {
                throw new IllegalArgumentException();
            }
            this.prependSeparator();
            long offset = TextWire.this.bytes.writePosition();
            TextIntReference.write((Bytes)TextWire.this.bytes, (int)value);
            long length = TextWire.this.bytes.writePosition() - offset;
            ((Byteable)intValue).bytesStore((BytesStore)TextWire.this.bytes, offset, length);
            this.elementSeparator();
            return this.wireOut();
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value) {
            this.prependSeparator();
            TextLongReference.write((Bytes)TextWire.this.bytes, (long)value);
            this.elementSeparator();
            return this.wireOut();
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value, LongValue longValue) {
            if (!TextLongReference.class.isInstance(longValue)) {
                throw new IllegalArgumentException();
            }
            this.prependSeparator();
            long offset = TextWire.this.bytes.writePosition();
            TextLongReference.write((Bytes)TextWire.this.bytes, (long)value);
            long length = TextWire.this.bytes.writePosition() - offset;
            ((Byteable)longValue).bytesStore((BytesStore)TextWire.this.bytes, offset, length);
            this.elementSeparator();
            return this.wireOut();
        }

        @Override
        @NotNull
        public <T> WireOut sequence(T t, BiConsumer<T, ValueOut> writer) {
            boolean leaf = this.leaf;
            this.pushState();
            TextWire.this.bytes.writeUnsignedByte(91);
            if (!leaf) {
                this.newLine();
            }
            long pos = TextWire.this.bytes.readPosition();
            writer.accept(t, this);
            if (!leaf) {
                this.addNewLine(pos);
            }
            this.popState();
            if (!leaf) {
                this.indent();
            }
            TextWire.this.bytes.writeUnsignedByte(93);
            this.endField();
            return this.wireOut();
        }

        @Override
        @NotNull
        public <T, K> WireOut sequence(T t, K kls, TriConsumer<T, K, ValueOut> writer) {
            this.pushState();
            TextWire.this.bytes.writeUnsignedByte(91);
            this.newLine();
            long pos = TextWire.this.bytes.readPosition();
            writer.accept(t, kls, this);
            this.addNewLine(pos);
            this.popState();
            this.indent();
            TextWire.this.bytes.writeUnsignedByte(93);
            this.endField();
            return this.wireOut();
        }

        protected void addNewLine(long pos) {
            if (TextWire.this.bytes.writePosition() > pos + 1L) {
                TextWire.this.bytes.writeUnsignedByte(10);
            }
        }

        protected void newLine() {
            this.sep = NEW_LINE;
        }

        protected void popState() {
            this.sep = this.seps.remove(this.seps.size() - 1);
            --this.indentation;
            this.leaf = false;
        }

        protected void pushState() {
            ++this.indentation;
            this.seps.add(this.sep);
            this.sep = EMPTY;
        }

        @Override
        @NotNull
        public WireOut marshallable(@NotNull WriteMarshallable object) {
            if (TextWire.this.bytes.writePosition() == 0L) {
                object.writeMarshallable(TextWire.this);
                return TextWire.this;
            }
            boolean wasLeaf = this.leaf;
            if (!wasLeaf) {
                this.pushState();
            }
            this.prependSeparator();
            TextWire.this.bytes.writeUnsignedByte(123);
            if (wasLeaf) {
                this.afterOpen();
            } else {
                this.newLine();
            }
            object.writeMarshallable(TextWire.this);
            BytesStore popSep = null;
            if (wasLeaf) {
                this.leaf = false;
            } else if (this.seps.size() > 0) {
                popSep = this.seps.get(this.seps.size() - 1);
                this.popState();
                this.sep = NEW_LINE;
            }
            if (this.sep.startsWith(',')) {
                TextWire.this.append((CharSequence)this.sep, 1, this.sep.length() - 1);
                if (!wasLeaf) {
                    this.indent();
                }
            } else {
                this.prependSeparator();
            }
            TextWire.this.bytes.writeUnsignedByte(125);
            if (popSep != null) {
                this.sep = popSep;
            }
            if (this.indentation == 0) {
                this.afterClose();
            } else {
                this.elementSeparator();
            }
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireOut marshallable(@NotNull Serializable object) {
            if (TextWire.this.bytes.writePosition() == 0L) {
                this.writeSerializable(object);
                return TextWire.this;
            }
            boolean wasLeaf = this.leaf;
            if (!wasLeaf) {
                this.pushState();
            }
            this.prependSeparator();
            TextWire.this.bytes.writeUnsignedByte(object instanceof Externalizable ? 91 : 123);
            if (wasLeaf) {
                this.afterOpen();
            } else {
                this.newLine();
            }
            this.writeSerializable(object);
            BytesStore popSep = null;
            if (wasLeaf) {
                this.leaf = false;
            } else if (this.seps.size() > 0) {
                popSep = this.seps.get(this.seps.size() - 1);
                this.popState();
                this.sep = NEW_LINE;
            }
            if (this.sep.startsWith(',')) {
                TextWire.this.append((CharSequence)this.sep, 1, this.sep.length() - 1);
                if (!wasLeaf) {
                    this.indent();
                }
            } else {
                this.prependSeparator();
            }
            TextWire.this.bytes.writeUnsignedByte(object instanceof Externalizable ? 93 : 125);
            if (popSep != null) {
                this.sep = popSep;
            }
            if (this.indentation == 0) {
                this.afterClose();
            } else {
                this.elementSeparator();
            }
            return TextWire.this;
        }

        private void writeSerializable(@NotNull Serializable object) {
            try {
                if (object instanceof Externalizable) {
                    ((Externalizable)object).writeExternal(TextWire.this.objectOutput());
                } else {
                    Wires.writeMarshallable(object, TextWire.this);
                }
            }
            catch (IOException e) {
                throw new IORuntimeException((Throwable)e);
            }
        }

        protected void afterClose() {
            this.newLine();
            TextWire.this.append((CharSequence)this.sep);
            this.sep = EMPTY;
        }

        protected void afterOpen() {
            this.sep = SPACE;
        }

        @Override
        @NotNull
        public WireOut map(@NotNull Map map) {
            this.marshallable(map, Object.class, Object.class, false);
            return TextWire.this;
        }

        protected void endField() {
            this.sep = END_FIELD;
        }

        private void object2(Object v) {
            if (v instanceof CharSequence) {
                this.text((CharSequence)v);
            } else if (v instanceof WriteMarshallable) {
                this.typedMarshallable((WriteMarshallable)v);
            } else if (v == null) {
                TextWire.this.append(this.nullOut());
            } else {
                this.text(String.valueOf(v));
            }
        }

        @Override
        @NotNull
        public WireOut typedMap(@NotNull Map<? extends WriteMarshallable, ? extends Marshallable> map) {
            this.typePrefix(TextWire.SEQ_MAP);
            map.forEach((k, v) -> this.sequence((ValueOut w) -> w.marshallable((WireOut m) -> m.write(() -> "key").typedMarshallable((WriteMarshallable)k).write(() -> "value").typedMarshallable((WriteMarshallable)v))));
            return this.wireOut();
        }

        protected void fieldValueSeperator() {
            TextWire.this.writeTwo(':', ' ');
        }

        @NotNull
        public ValueOut write() {
            TextWire.this.append((CharSequence)this.sep);
            TextWire.this.writeTwo('\"', '\"');
            this.endEvent();
            return this;
        }

        @NotNull
        public ValueOut write(@NotNull WireKey key) {
            return this.write(key.name());
        }

        @NotNull
        public ValueOut write(@NotNull CharSequence name) {
            this.prependSeparator();
            TextWire.this.escape(name);
            this.fieldValueSeperator();
            return this;
        }

        public ValueOut write(Class expectedType, @NotNull Object objectKey) {
            this.prependSeparator();
            TextWire.this.startEvent();
            this.object(expectedType, objectKey);
            this.endEvent();
            return this;
        }

        public void endEvent() {
            if (TextWire.this.bytes.readByte(TextWire.this.bytes.writePosition() - 1L) <= 32) {
                TextWire.this.bytes.writeSkip(-1L);
            }
            this.fieldValueSeperator();
            this.sep = BytesStore.empty();
        }

        public void writeComment(@NotNull CharSequence s) {
            this.prependSeparator();
            TextWire.this.append((CharSequence)this.sep);
            TextWire.this.writeTwo('#', ' ');
            TextWire.this.append(s);
            TextWire.this.bytes.writeUnsignedByte(10);
            this.sep = EMPTY_AFTER_COMMENT;
        }
    }

    static enum NoObject {
        NO_OBJECT;

    }
}

