/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.nio.BufferUnderflowException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.BooleanConsumer;
import net.openhft.chronicle.core.util.ObjBooleanConsumer;
import net.openhft.chronicle.core.util.ObjByteConsumer;
import net.openhft.chronicle.core.util.ObjFloatConsumer;
import net.openhft.chronicle.core.util.ObjShortConsumer;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefaultValueIn
implements ValueIn {
    private final WireIn wireIn;
    WireKey wireKey;

    DefaultValueIn(WireIn wireIn) {
        this.wireIn = wireIn;
    }

    @Override
    @Nullable
    public String text() {
        Object o = this.wireKey.defaultValue();
        return o == null ? null : o.toString();
    }

    @Override
    @Nullable
    public StringBuilder textTo(@NotNull StringBuilder sb) {
        Object o = this.wireKey.defaultValue();
        if (o == null) {
            return null;
        }
        sb.append(o);
        return sb;
    }

    @Override
    @Nullable
    public Bytes textTo(@NotNull Bytes bytes) {
        Object o = this.wireKey.defaultValue();
        if (o == null) {
            return null;
        }
        bytes.write((BytesStore)o);
        return bytes;
    }

    @Override
    @NotNull
    public WireIn bytes(@NotNull Bytes<?> toBytes) {
        Object o = this.wireKey.defaultValue();
        if (o == null) {
            return this.wireIn();
        }
        BytesStore bytes = (BytesStore)o;
        toBytes.write(bytes);
        return this.wireIn();
    }

    @Override
    @Nullable
    public WireIn bytesSet(@NotNull PointerBytesStore toBytes) {
        Object o = this.wireKey.defaultValue();
        if (o == null) {
            toBytes.set(NoBytesStore.NO_PAGE, 0L);
            return this.wireIn();
        }
        BytesStore bytes = (BytesStore)o;
        toBytes.set(bytes.address(0L), bytes.realCapacity());
        return this.wireIn();
    }

    @Override
    @NotNull
    public WireIn bytesMatch(@NotNull BytesStore compareBytes, BooleanConsumer consumer) {
        Object o = this.wireKey.defaultValue();
        BytesStore bytes = (BytesStore)o;
        consumer.accept(Boolean.valueOf(compareBytes.contentEquals(bytes)));
        return this.wireIn();
    }

    @Override
    @NotNull
    public WireIn bytes(@NotNull ReadBytesMarshallable wireInConsumer) {
        Object o = this.wireKey.defaultValue();
        if (o == null) {
            wireInConsumer.readMarshallable(Wires.NO_BYTES);
            return this.wireIn();
        }
        BytesStore bytes = (BytesStore)o;
        wireInConsumer.readMarshallable(bytes.bytesForRead());
        return this.wireIn();
    }

    @Override
    @Nullable
    public byte[] bytes() {
        return (byte[])this.wireKey.defaultValue();
    }

    @Override
    @NotNull
    public WireIn wireIn() {
        return this.wireIn;
    }

    @Override
    public long readLength() {
        return 0L;
    }

    @Override
    @NotNull
    public <T> WireIn bool(T t, @NotNull ObjBooleanConsumer<T> tFlag) {
        Boolean o = (Boolean)this.wireKey.defaultValue();
        tFlag.accept(t, o);
        return this.wireIn();
    }

    @Override
    @NotNull
    public <T> WireIn int8(@NotNull T t, @NotNull ObjByteConsumer<T> tb) {
        Number o = (Number)this.wireKey.defaultValue();
        if (o == null) {
            o = 0;
        }
        tb.accept(t, o.byteValue());
        return this.wireIn();
    }

    @Override
    @NotNull
    public <T> WireIn uint8(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
        Number o = (Number)this.wireKey.defaultValue();
        if (o == null) {
            o = 0;
        }
        ti.accept(t, o.shortValue());
        return this.wireIn();
    }

    @Override
    @NotNull
    public <T> WireIn int16(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
        Number o = (Number)this.wireKey.defaultValue();
        if (o == null) {
            o = 0;
        }
        ti.accept(t, o.shortValue());
        return this.wireIn();
    }

    @Override
    @NotNull
    public <T> WireIn uint16(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
        Number o = (Number)this.wireKey.defaultValue();
        if (o == null) {
            o = 0;
        }
        ti.accept(t, o.intValue());
        return this.wireIn();
    }

    @Override
    @NotNull
    public <T> WireIn int32(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
        Number o = (Number)this.wireKey.defaultValue();
        if (o == null) {
            o = 0;
        }
        ti.accept(t, o.intValue());
        return this.wireIn();
    }

    @Override
    @NotNull
    public <T> WireIn uint32(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
        Number o = (Number)this.wireKey.defaultValue();
        if (o == null) {
            o = 0;
        }
        tl.accept(t, o.longValue());
        return this.wireIn();
    }

    @Override
    @NotNull
    public <T> WireIn int64(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
        Number o = (Number)this.wireKey.defaultValue();
        if (o == null) {
            o = 0;
        }
        tl.accept(t, o.longValue());
        return this.wireIn();
    }

    @Override
    @NotNull
    public <T> WireIn float32(@NotNull T t, @NotNull ObjFloatConsumer<T> tf) {
        Number o = (Number)this.wireKey.defaultValue();
        if (o == null) {
            o = 0;
        }
        tf.accept(t, o.floatValue());
        return this.wireIn();
    }

    @Override
    @NotNull
    public <T> WireIn float64(@NotNull T t, @NotNull ObjDoubleConsumer<T> td) {
        Number o = (Number)this.wireKey.defaultValue();
        if (o == null) {
            o = 0;
        }
        td.accept(t, o.doubleValue());
        return this.wireIn();
    }

    @Override
    @NotNull
    public <T> WireIn time(@NotNull T t, @NotNull BiConsumer<T, LocalTime> setLocalTime) {
        LocalTime o = (LocalTime)this.wireKey.defaultValue();
        setLocalTime.accept(t, o);
        return this.wireIn();
    }

    @Override
    @NotNull
    public <T> WireIn zonedDateTime(@NotNull T t, @NotNull BiConsumer<T, ZonedDateTime> tZonedDateTime) {
        ZonedDateTime o = (ZonedDateTime)this.wireKey.defaultValue();
        tZonedDateTime.accept(t, o);
        return this.wireIn();
    }

    @Override
    @NotNull
    public <T> WireIn date(@NotNull T t, @NotNull BiConsumer<T, LocalDate> tLocalDate) {
        LocalDate o = (LocalDate)this.wireKey.defaultValue();
        tLocalDate.accept(t, o);
        return this.wireIn();
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public boolean hasNextSequenceItem() {
        return false;
    }

    @Override
    @NotNull
    public <T> WireIn uuid(@NotNull T t, @NotNull BiConsumer<T, UUID> tuuid) {
        UUID o = (UUID)this.wireKey.defaultValue();
        tuuid.accept(t, o);
        return this.wireIn();
    }

    @Override
    @NotNull
    public <T> WireIn int64array(@Nullable LongArrayValues values, T t, @NotNull BiConsumer<T, LongArrayValues> setter) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    @NotNull
    public WireIn int64(@NotNull LongValue value) {
        Number o = (Number)this.wireKey.defaultValue();
        if (o == null) {
            o = 0;
        }
        value.setValue(o.longValue());
        return this.wireIn();
    }

    @Override
    @NotNull
    public <T> WireIn int64(@Nullable LongValue value, T t, @NotNull BiConsumer<T, LongValue> setter) {
        Number o = (Number)this.wireKey.defaultValue();
        if (o == null) {
            o = 0;
        }
        value.setValue(o.longValue());
        setter.accept(t, value);
        return this.wireIn();
    }

    @Override
    @NotNull
    public <T> WireIn int32(@Nullable IntValue value, T t, @NotNull BiConsumer<T, IntValue> setter) {
        Number o = (Number)this.wireKey.defaultValue();
        if (o == null) {
            o = 0;
        }
        value.setValue(o.intValue());
        setter.accept(t, value);
        return this.wireIn();
    }

    @Override
    @NotNull
    public <T> WireIn sequence(@NotNull T t, @NotNull BiConsumer<T, ValueIn> tReader) {
        assert (this.wireKey.defaultValue() == null);
        tReader.accept(t, this);
        return this.wireIn();
    }

    @Override
    public <T> T applyToMarshallable(Function<WireIn, T> marshallableReader) {
        return (T)this.wireKey.defaultValue();
    }

    @Override
    @Nullable
    public <T> T typedMarshallable() throws IORuntimeException {
        return (T)this.wireKey.defaultValue();
    }

    @Override
    @NotNull
    public <T> ValueIn typePrefix(T t, @NotNull BiConsumer<T, CharSequence> ts) {
        ts.accept(t, null);
        return this;
    }

    @Override
    @NotNull
    public <T> WireIn typeLiteralAsText(T t, @NotNull BiConsumer<T, CharSequence> ts) throws IORuntimeException, BufferUnderflowException {
        ts.accept(t, null);
        return this.wireIn();
    }

    @Override
    @NotNull
    public WireIn marshallable(@NotNull ReadMarshallable object) throws BufferUnderflowException, IORuntimeException {
        assert (this.wireKey.defaultValue() == null);
        object.readMarshallable(Wires.EMPTY);
        return this.wireIn();
    }

    @Override
    public <K extends ReadMarshallable, V extends ReadMarshallable> void typedMap(@NotNull Map<K, V> usingMap) {
        assert (this.wireKey.defaultValue() == null);
        usingMap.clear();
    }

    @Override
    @Nullable
    public <K, V> Map<K, V> map(@NotNull Class<K> kClazz, @NotNull Class<V> vClass, @NotNull Map<K, V> usingMap) {
        assert (this.wireKey.defaultValue() == null);
        usingMap.clear();
        return usingMap;
    }

    @Override
    public boolean bool() throws IORuntimeException {
        return this.wireKey.defaultValue() == Boolean.TRUE;
    }

    @Override
    public byte int8() {
        Number o = (Number)this.wireKey.defaultValue();
        if (o == null) {
            o = 0;
        }
        return o.byteValue();
    }

    @Override
    public short int16() {
        Number o = (Number)this.wireKey.defaultValue();
        if (o == null) {
            o = 0;
        }
        return o.shortValue();
    }

    @Override
    public int uint16() {
        Number o = (Number)this.wireKey.defaultValue();
        if (o == null) {
            o = 0;
        }
        return o.intValue();
    }

    @Override
    public int int32() {
        Number o = (Number)this.wireKey.defaultValue();
        if (o == null) {
            o = 0;
        }
        return o.intValue();
    }

    @Override
    public long int64() {
        Number o = (Number)this.wireKey.defaultValue();
        if (o == null) {
            o = 0;
        }
        return o.longValue();
    }

    @Override
    public double float64() {
        Number o = (Number)this.wireKey.defaultValue();
        if (o == null) {
            o = 0;
        }
        return o.doubleValue();
    }

    @Override
    public float float32() {
        Number o = (Number)this.wireKey.defaultValue();
        if (o == null) {
            o = 0;
        }
        return o.floatValue();
    }

    @Override
    public <T> Class<T> typeLiteral() throws IORuntimeException, BufferUnderflowException {
        return (Class)this.wireKey.defaultValue();
    }

    @Override
    @Nullable
    public <E> E object(@Nullable E using, @NotNull Class<E> clazz) {
        return (E)this.wireKey.defaultValue();
    }

    @Override
    @Nullable
    public <T, E> WireIn object(@NotNull Class<E> clazz, T t, BiConsumer<T, E> e) {
        e.accept(t, this.wireKey.defaultValue());
        return this.wireIn();
    }

    @Override
    public boolean isTyped() {
        return false;
    }

    @Override
    public Class typePrefix() {
        Object o = this.wireKey.defaultValue();
        if (o == null) {
            return Void.TYPE;
        }
        return o.getClass();
    }

    @Override
    public void resetState() {
    }
}

