/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.EOFException;
import java.io.StreamCorruptedException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireCommon;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public interface WireOut
extends WireCommon {
    @NotNull
    public ValueOut write();

    @NotNull
    default public ValueOut writeEventName(WireKey key) {
        return this.write(key);
    }

    @NotNull
    public ValueOut write(WireKey var1);

    @NotNull
    public ValueOut getValueOut();

    @NotNull
    public WireOut writeComment(CharSequence var1);

    @NotNull
    public WireOut addPadding(int var1);

    @NotNull
    default public WireOut writeAlignTo(int alignment) {
        long mod = this.bytes().writePosition() % (long)alignment;
        if (mod != 0L) {
            this.addPadding((int)((long)alignment - mod));
        }
        return this;
    }

    default public void writeDocument(boolean metaData, @NotNull WriteMarshallable writer) {
        WireInternal.writeData(this, metaData, false, writer);
    }

    public DocumentContext writingDocument(boolean var1);

    default public void writeNotReadyDocument(boolean metaData, @NotNull WriteMarshallable writer) {
        WireInternal.writeData(this, metaData, true, writer);
    }

    default public long writeHeader(long timeout, TimeUnit timeUnit) throws TimeoutException, EOFException {
        return this.writeHeader(0, timeout, timeUnit);
    }

    default public void updateHeader(long position, boolean metaData) throws StreamCorruptedException {
        this.updateHeader(0, position, metaData);
    }

    public long writeHeader(int var1, long var2, TimeUnit var4) throws TimeoutException, EOFException;

    public void updateHeader(int var1, long var2, boolean var4) throws StreamCorruptedException;

    public boolean writeFirstHeader();

    public void updateFirstHeader();

    public void writeEndOfWire(long var1, TimeUnit var3) throws TimeoutException;
}

