/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.EOFException;
import java.io.StreamCorruptedException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.util.UTF8StringInterner;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.threads.BusyPauser;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWire
implements Wire {
    protected static final UTF8StringInterner UTF8_INTERNER = new UTF8StringInterner(512);
    protected static final boolean ASSERTIONS;
    protected final Bytes<?> bytes;
    protected final boolean use8bit;
    protected Pauser pauser = BusyPauser.INSTANCE;
    protected ClassLookup classLookup = ClassAliasPool.CLASS_ALIASES;

    public AbstractWire(Bytes bytes, boolean use8bit) {
        this.bytes = bytes;
        this.use8bit = use8bit;
    }

    private static long throwNotEnoughSpace(int maxlen, Bytes<?> bytes) {
        throw new IllegalStateException("not enough space to write " + maxlen + " was " + bytes.writeRemaining());
    }

    private static void throwHeaderOverwritten(long position, int expectedHeader, Bytes<?> bytes) throws StreamCorruptedException {
        throw new StreamCorruptedException("Data at " + position + " overwritten? Expected: " + Integer.toHexString(expectedHeader) + " was " + Integer.toHexString(bytes.readVolatileInt(position)));
    }

    private static void throwLengthMismatch(int length, int actualLength) throws StreamCorruptedException {
        throw new StreamCorruptedException("Wrote " + actualLength + " when " + length + " was set initially.");
    }

    @Override
    public Pauser pauser() {
        return this.pauser;
    }

    @Override
    public void pauser(Pauser pauser) {
        this.pauser = pauser;
    }

    @Override
    public void clear() {
        this.bytes.clear();
    }

    @Override
    public void classLookup(ClassLookup classLookup) {
        this.classLookup = classLookup;
    }

    @Override
    public ClassLookup classLookup() {
        return this.classLookup;
    }

    @Override
    @NotNull
    public Bytes<?> bytes() {
        return this.bytes;
    }

    @Override
    public boolean hasMore() {
        this.consumePadding();
        return this.bytes.readRemaining() > 0L;
    }

    @Override
    public boolean readDataHeader() throws EOFException {
        int header;
        this.bytes.readLimit(this.bytes.capacity());
        while (Wires.isReady(header = this.bytes.readVolatileInt(this.bytes.readPosition()))) {
            if (header == 0) {
                return false;
            }
            if (Wires.isReadyData(header)) {
                return true;
            }
            this.bytes.readSkip((long)(Wires.lengthOf(header) + 4));
        }
        if (header == -1073741824) {
            throw new EOFException();
        }
        return false;
    }

    @Override
    public void readAndSetLength(long position) {
        int header = this.bytes.readVolatileInt(this.bytes.readPosition());
        if (Wires.isReady(header)) {
            if (header == 0) {
                throw new IllegalStateException();
            }
            long start = position + 4L;
            this.bytes.readPositionRemaining(start, (long)Wires.lengthOf(header));
            return;
        }
        throw new IllegalStateException();
    }

    @Override
    public void readMetaDataHeader() {
        int header = this.bytes.readVolatileInt(this.bytes.readPosition());
        if (Wires.isReady(header)) {
            if (header == 0) {
                throw new IllegalStateException("Meta data not initialised");
            }
            if (Wires.isReadyMetaData(header)) {
                this.setLimitPosition(header);
                return;
            }
        }
        throw new IllegalStateException("Meta data not ready " + Integer.toHexString(header));
    }

    private void setLimitPosition(int header) {
        ((Bytes)this.bytes.readLimit(this.bytes.readPosition() + (long)Wires.lengthOf(header) + 4L)).readSkip(4L);
    }

    @Override
    public void readFirstHeader(long timeout, TimeUnit timeUnit) throws TimeoutException, StreamCorruptedException {
        int header;
        while (!Wires.isReady(header = this.bytes.readVolatileInt(0L))) {
            this.pauser.pause(timeout, timeUnit);
        }
        this.pauser.reset();
        int len = Wires.lengthOf(header);
        if (!Wires.isReadyMetaData(header) || len > 65536) {
            throw new StreamCorruptedException("Unexpected magic number " + Integer.toHexString(header));
        }
        this.bytes.readPositionRemaining(4L, (long)len);
    }

    @Override
    public long writeHeader(int length, long timeout, TimeUnit timeUnit) throws TimeoutException, EOFException {
        if (length < 0 || length > 0x3FFFFFFF) {
            throw new IllegalArgumentException();
        }
        long pos = this.bytes.writePosition();
        if (this.bytes.compareAndSwapInt(pos, 0, Integer.MIN_VALUE | length)) {
            int maxlen;
            int n = maxlen = length == 0 ? 0x3FFFFFFF : length;
            if ((long)maxlen > this.bytes.writeRemaining()) {
                return AbstractWire.throwNotEnoughSpace(maxlen, this.bytes);
            }
            this.bytes.writePositionRemaining(pos + 4L, (long)maxlen);
            return pos;
        }
        return this.writeHeader0(length, timeout, timeUnit);
    }

    private long writeHeader0(int length, long timeout, TimeUnit timeUnit) throws TimeoutException, EOFException {
        if (length < 0 || length > 0x3FFFFFFF) {
            throw new IllegalArgumentException();
        }
        long pos = this.bytes.writePosition();
        try {
            while (true) {
                if (this.bytes.compareAndSwapInt(pos, 0, Integer.MIN_VALUE | length)) {
                    int maxlen;
                    this.bytes.writePosition(pos + 4L);
                    int n = maxlen = length == 0 ? 0x3FFFFFFF : length;
                    if ((long)maxlen > this.bytes.writeRemaining()) {
                        AbstractWire.throwNotEnoughSpace(maxlen, this.bytes);
                    }
                    this.bytes.writeLimit(this.bytes.writePosition() + (long)maxlen);
                    long l = pos;
                    return l;
                }
                this.pauser.pause(timeout, timeUnit);
                int header = this.bytes.readVolatileInt(pos);
                if (header == -1073741824) {
                    throw new EOFException();
                }
                if (header == Integer.MIN_VALUE) continue;
                int len = Wires.lengthOf(header);
                pos += (long)(len + 4);
            }
        }
        finally {
            this.pauser.reset();
        }
    }

    @Override
    public void updateHeader(int length, long position, boolean metaData) throws StreamCorruptedException {
        long pos = this.bytes.writePosition();
        int actualLength = Maths.toUInt31((long)(pos - position - 4L));
        int expectedHeader = Integer.MIN_VALUE | length;
        if (length == 0) {
            length = actualLength;
        } else if (length < actualLength) {
            AbstractWire.throwLengthMismatch(length, actualLength);
        }
        int header = length;
        if (metaData) {
            header |= 0x40000000;
        }
        if (ASSERTIONS) {
            if (!this.bytes.compareAndSwapInt(position, expectedHeader, header)) {
                AbstractWire.throwHeaderOverwritten(position, expectedHeader, this.bytes);
            }
        } else {
            this.bytes.writeOrderedInt(position, header);
        }
        this.bytes.writeLimit(this.bytes.capacity());
    }

    @Override
    public boolean writeFirstHeader() {
        boolean cas = this.bytes.compareAndSwapInt(0L, 0, Integer.MIN_VALUE);
        if (cas) {
            this.bytes.writeSkip(4L);
        }
        return cas;
    }

    @Override
    public void updateFirstHeader() {
        long pos = this.bytes.writePosition();
        long actualLength = pos - 4L;
        if (actualLength >= 0x40000000L) {
            throw new IllegalStateException("Header too large was " + actualLength);
        }
        int header = (int)(0x40000000L | actualLength);
        if (!this.bytes.compareAndSwapInt(0L, Integer.MIN_VALUE, header)) {
            throw new IllegalStateException("Data at 0 overwritten? Expected: " + Integer.toHexString(Integer.MIN_VALUE) + " was " + Integer.toHexString(this.bytes.readVolatileInt(0L)));
        }
    }

    @Override
    public void writeEndOfWire(long timeout, TimeUnit timeUnit) throws TimeoutException {
        long pos = this.bytes.writePosition();
        try {
            while (true) {
                if (this.bytes.compareAndSwapInt(pos, 0, -1073741824)) {
                    this.bytes.writePosition(pos + 4L);
                    return;
                }
                this.pauser.pause(timeout, timeUnit);
                int header = this.bytes.readVolatileInt(pos);
                if (header == -1073741824) {
                    return;
                }
                if (header == Integer.MIN_VALUE) continue;
                int len = Wires.lengthOf(header);
                pos += (long)(len + 4);
            }
        }
        finally {
            this.pauser.reset();
        }
    }

    static {
        boolean assertions = false;
        if (!$assertionsDisabled) {
            assertions = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        ASSERTIONS = assertions;
    }
}

