/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAnyWire
extends AbstractWire
implements Wire {
    protected final WireAcquisition wireAcquisition;

    public AbstractAnyWire(Bytes bytes, @NotNull WireAcquisition wa) {
        super(bytes, false);
        this.wireAcquisition = wa;
    }

    public Wire underlyingWire() {
        return this.wireAcquisition.acquireWire();
    }

    public Supplier<WireType> underlyingType() {
        return this.wireAcquisition.underlyingType();
    }

    @Override
    public void copyTo(@NotNull WireOut wire) {
        this.wireAcquisition.acquireWire().copyTo(wire);
    }

    @Override
    @NotNull
    public ValueIn read() {
        return this.wireAcquisition.acquireWire().read();
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        return this.wireAcquisition.acquireWire().read(key);
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        return this.wireAcquisition.acquireWire().read(name);
    }

    @Override
    @NotNull
    public ValueIn getValueIn() {
        return this.wireAcquisition.acquireWire().getValueIn();
    }

    @Override
    @NotNull
    public Wire readComment(@NotNull StringBuilder sb) {
        return this.wireAcquisition.acquireWire().readComment(sb);
    }

    @Override
    @NotNull
    public IntValue newIntReference() {
        return this.wireAcquisition.acquireWire().newIntReference();
    }

    @Override
    @NotNull
    public LongValue newLongReference() {
        return this.wireAcquisition.acquireWire().newLongReference();
    }

    @Override
    @NotNull
    public LongArrayValues newLongArrayReference() {
        return this.wireAcquisition.acquireWire().newLongArrayReference();
    }

    void checkWire() {
        this.wireAcquisition.acquireWire();
    }

    @Override
    public boolean hasMore() {
        return this.wireAcquisition.acquireWire().hasMore();
    }

    @Override
    public DocumentContext readingDocument() {
        return this.wireAcquisition.acquireWire().readingDocument();
    }

    @Override
    public DocumentContext readingDocument(long readLocation) {
        return this.wireAcquisition.acquireWire().readingDocument(readLocation);
    }

    @Override
    public void consumePadding() {
        this.wireAcquisition.acquireWire().consumePadding();
    }

    @Override
    @NotNull
    public ValueOut write() {
        return this.wireAcquisition.acquireWire().write();
    }

    @Override
    @NotNull
    public ValueOut write(WireKey key) {
        return this.wireAcquisition.acquireWire().write(key);
    }

    @Override
    @NotNull
    public ValueOut getValueOut() {
        return this.wireAcquisition.acquireWire().getValueOut();
    }

    @Override
    @NotNull
    public WireOut writeComment(CharSequence s) {
        return this.wireAcquisition.acquireWire().writeComment(s);
    }

    @Override
    @NotNull
    public WireOut addPadding(int paddingToAdd) {
        return this.wireAcquisition.acquireWire().addPadding(paddingToAdd);
    }

    @Override
    public DocumentContext writingDocument(boolean metaData) {
        return this.wireAcquisition.acquireWire().writingDocument(metaData);
    }

    static interface WireAcquisition {
        public Supplier<WireType> underlyingType();

        public Wire acquireWire();

        public void classLookup(ClassLookup var1);

        public ClassLookup classLookup();
    }
}

