/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.InternalWire;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.Wires;

public class WriteDocumentContext
implements DocumentContext {
    final InternalWire wire;
    long position;
    private int metaDataBit;

    public WriteDocumentContext(InternalWire wire) {
        this.wire = wire;
    }

    @Override
    public long index() {
        throw new UnsupportedOperationException("todo");
    }

    public void start(boolean metaData) {
        Bytes<?> bytes = this.wire.bytes();
        this.position = bytes.writePosition();
        this.metaDataBit = metaData ? 0x40000000 : 0;
        bytes.writeOrderedInt(this.metaDataBit | Integer.MIN_VALUE | 0);
    }

    @Override
    public boolean isMetaData() {
        return this.metaDataBit != 0;
    }

    public void close() {
        Bytes<?> bytes = this.wire.bytes();
        long position1 = bytes.writePosition();
        if (position1 < this.position) {
            System.out.println("Message truncated from " + this.position + " to " + position1);
        }
        int length = this.metaDataBit | Wires.toIntU30(position1 - this.position - 4L, "Document length %,d out of 30-bit int range.");
        bytes.writeOrderedInt(this.position, length);
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    @Override
    public boolean isData() {
        return this.metaDataBit == 0;
    }

    @Override
    public Wire wire() {
        return this.wire;
    }
}

