/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.InternalWire;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.Wires;

public class ReadDocumentContext
implements DocumentContext {
    private final InternalWire wire;
    private boolean data;
    private boolean present;
    private long readPosition;
    private long readLimit;
    private long index;

    public ReadDocumentContext(Wire wire) {
        this.wire = (InternalWire)wire;
    }

    @Override
    public boolean isMetaData() {
        return !this.data && this.present;
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    public void closeReadPosition(long readPosition) {
        this.readPosition = readPosition;
    }

    public void closeReadLimit(long readLimit) {
        this.readLimit = readLimit;
    }

    @Override
    public boolean isData() {
        return this.data && this.present;
    }

    @Override
    public Wire wire() {
        return this.wire;
    }

    public void close() {
        if (this.readLimit > 0L) {
            Bytes<?> bytes = this.wire.bytes();
            bytes.readPosition(this.readPosition);
            bytes.readLimit(this.readLimit);
        }
    }

    @Override
    public long index() {
        return this.index;
    }

    public void start() {
        this.start(true, this.wire.bytes().readPosition());
    }

    public void start(boolean next, long index) {
        this.index = index;
        Bytes<?> bytes = this.wire.bytes();
        if (!next || bytes.readRemaining() < 4L) {
            this.present = false;
            this.readLimit = -1L;
            this.readPosition = -1L;
            return;
        }
        long position = bytes.readPosition();
        int header = bytes.readVolatileInt(position);
        if (!Wires.isKnownLength(header) || !Wires.isReady(header)) {
            this.present = false;
            return;
        }
        bytes.readSkip(4L);
        boolean ready = Wires.isReady(header);
        int len = Wires.lengthOf(header);
        assert (len > 0) : "len=" + len;
        this.data = Wires.isData(header);
        this.wire.setReady(ready);
        if ((long)len > bytes.readRemaining()) {
            throw new BufferUnderflowException();
        }
        this.readLimit = bytes.readLimit();
        this.readPosition = bytes.readPosition() + (long)len;
        bytes.readLimit(this.readPosition);
        this.present = true;
    }
}

