/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.BinaryWireCode;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.InternalWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;

public class ReadAnyWire
implements Wire,
InternalWire {
    private WireAcquisition wa;

    public Class<Wire> underlyingType() {
        return this.wa.acquireWire().getClass();
    }

    public ReadAnyWire(Bytes bytes) {
        this.wa = new WireAcquisition(bytes);
    }

    @Override
    public void setReady(boolean ready) {
        this.wa.acquireWire().setReady(ready);
    }

    @Override
    public boolean isReady() {
        return this.wa.acquireWire().isReady();
    }

    @Override
    public void copyTo(@NotNull WireOut wire) {
        this.wa.acquireWire().copyTo(wire);
    }

    @Override
    @NotNull
    public ValueIn read() {
        return this.wa.acquireWire().read();
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        return this.wa.acquireWire().read(key);
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        return this.wa.acquireWire().read(name);
    }

    @Override
    @NotNull
    public ValueIn getValueIn() {
        return this.wa.acquireWire().getValueIn();
    }

    @Override
    @NotNull
    public Wire readComment(@NotNull StringBuilder sb) {
        return this.wa.acquireWire().readComment(sb);
    }

    @Override
    @NotNull
    public Bytes<?> bytes() {
        this.wa.acquireWire();
        return this.wa.bytes();
    }

    @Override
    @NotNull
    public IntValue newIntReference() {
        return this.wa.acquireWire().newIntReference();
    }

    @Override
    @NotNull
    public LongValue newLongReference() {
        return this.wa.acquireWire().newLongReference();
    }

    @Override
    @NotNull
    public LongArrayValues newLongArrayReference() {
        return this.wa.acquireWire().newLongArrayReference();
    }

    @Override
    public void clear() {
        this.wa.acquireWire();
        this.wa.bytes().clear();
    }

    @Override
    public boolean hasMore() {
        return this.wa.acquireWire().hasMore();
    }

    @Override
    public DocumentContext readingDocument() {
        return this.wa.acquireWire().readingDocument();
    }

    @Override
    public DocumentContext readingDocument(long readLocation) {
        return this.wa.acquireWire().readingDocument(readLocation);
    }

    @Override
    public void consumePadding() {
        this.wa.acquireWire().consumePadding();
    }

    @Override
    @NotNull
    public ValueOut write() {
        return this.wa.acquireWire().write();
    }

    @Override
    @NotNull
    public ValueOut write(WireKey key) {
        return this.wa.acquireWire().write(key);
    }

    @Override
    @NotNull
    public ValueOut getValueOut() {
        return this.wa.acquireWire().getValueOut();
    }

    @Override
    @NotNull
    public WireOut writeComment(CharSequence s) {
        return this.wa.acquireWire().writeComment(s);
    }

    @Override
    @NotNull
    public WireOut addPadding(int paddingToAdd) {
        return this.wa.acquireWire().addPadding(paddingToAdd);
    }

    @Override
    public DocumentContext writingDocument(boolean metaData) {
        return this.wa.acquireWire().writingDocument(metaData);
    }

    private static class WireAcquisition {
        private final Bytes bytes;
        InternalWire wire = null;

        public WireAcquisition(Bytes bytes) {
            this.bytes = bytes;
        }

        private InternalWire acquireWire() {
            if (this.wire != null) {
                return this.wire;
            }
            if (this.bytes.readRemaining() > 0L) {
                byte code = this.bytes.readByte(0L);
                if (code >= 32 && code < 127) {
                    this.wire = (InternalWire)WireType.TEXT.apply(this.bytes);
                    return this.wire;
                }
                if (BinaryWireCode.isFieldCode(code)) {
                    this.wire = (InternalWire)WireType.FIELDLESS_BINARY.apply(this.bytes);
                    return this.wire;
                }
                this.wire = (InternalWire)WireType.BINARY.apply(this.bytes);
                return this.wire;
            }
            return null;
        }

        public Bytes bytes() {
            return this.bytes;
        }
    }
}

