/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.nio.BufferUnderflowException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.ref.BinaryIntReference;
import net.openhft.chronicle.bytes.ref.BinaryLongArrayReference;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.bytes.util.Compression;
import net.openhft.chronicle.bytes.util.UTF8StringInterner;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.util.BooleanConsumer;
import net.openhft.chronicle.core.util.ObjBooleanConsumer;
import net.openhft.chronicle.core.util.ObjByteConsumer;
import net.openhft.chronicle.core.util.ObjFloatConsumer;
import net.openhft.chronicle.core.util.ObjShortConsumer;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.ReadResolvable;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.BinaryWireCode;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.InternalWire;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ReadDocumentContext;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteDocumentContext;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.WriteValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryWire
implements Wire,
InternalWire {
    private static final int END_OF_BYTES = -1;
    private static final UTF8StringInterner UTF8_INTERNER = new UTF8StringInterner(512);
    private final Bytes<?> bytes;
    private final ValueOut fixedValueOut = new FixedBinaryValueOut();
    @NotNull
    private final ValueOut valueOut;
    private final BinaryValueIn valueIn = new BinaryValueIn();
    private final boolean numericFields;
    private final boolean fieldLess;
    private final int compressedSize;
    private final WriteDocumentContext writeContext = new WriteDocumentContext(this);
    private final ReadDocumentContext readContext = new ReadDocumentContext(this);
    private boolean ready;
    private String compression;

    public BinaryWire(Bytes bytes) {
        this(bytes, false, false, false, Integer.MAX_VALUE, "binary");
    }

    public BinaryWire(Bytes bytes, boolean fixed, boolean numericFields, boolean fieldLess, int compressedSize, String compression) {
        this.numericFields = numericFields;
        this.fieldLess = fieldLess;
        this.bytes = bytes;
        this.compressedSize = compressedSize;
        this.valueOut = fixed ? this.fixedValueOut : new BinaryValueOut();
        this.compression = compression;
    }

    @Override
    public DocumentContext writingDocument(boolean metaData) {
        this.writeContext.start(metaData);
        return this.writeContext;
    }

    @Override
    public DocumentContext readingDocument() {
        this.readContext.start();
        return this.readContext;
    }

    @Override
    public DocumentContext readingDocument(long readLocation) {
        long readPosition = this.bytes().readPosition();
        long readLimit = this.bytes().readLimit();
        this.bytes().readPosition(readLocation);
        this.readContext.start();
        this.readContext.closeReadLimit(readLimit);
        this.readContext.closeReadPosition(readPosition);
        return this.readContext;
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }

    @Override
    public void setReady(boolean ready) {
        this.ready = ready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyTo(@NotNull WireOut wire) {
        block22: while (this.bytes.readRemaining() > 0L) {
            int peekCode = this.peekCode();
            block3 : switch (peekCode >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.bytes.readSkip(1L);
                    wire.getValueOut().uint8checked(peekCode);
                    break;
                }
                case 8: {
                    switch (peekCode) {
                        case 143: {
                            this.bytes.readSkip(1L);
                            break block3;
                        }
                        case 142: {
                            this.bytes.readSkip(1L);
                            this.bytes.readSkip(this.bytes.readUnsignedInt());
                            break block3;
                        }
                        case 130: {
                            this.bytes.readSkip(1L);
                            int len = this.bytes.readInt();
                            long lim = this.bytes.readLimit();
                            try {
                                this.bytes.readLimit(this.bytes.readPosition() + (long)len);
                                if (this.isFieldNext()) {
                                    wire.getValueOut().marshallable(w -> this.copyTo(w));
                                    continue block22;
                                }
                                wire.getValueOut().sequence(v -> this.copyTo(v.wireOut()));
                                continue block22;
                            }
                            finally {
                                this.bytes.readLimit(lim);
                                continue block22;
                            }
                        }
                        case 138: {
                            this.bytes.readSkip(1L);
                            wire.getValueOut().bytes((BytesStore)this.bytes);
                            this.bytes.readPosition(this.bytes.readLimit());
                            break block3;
                        }
                    }
                    this.unknownCode(wire);
                    break;
                }
                case 9: {
                    this.bytes.readSkip(1L);
                    try {
                        Double d = this.readFloat0(peekCode);
                        wire.getValueOut().object(d);
                    }
                    catch (Exception e) {
                        this.unknownCode(wire);
                    }
                    break;
                }
                case 10: {
                    this.bytes.readSkip(1L);
                    try {
                        Number l = this.readInt0object(peekCode);
                        wire.getValueOut().object(l);
                    }
                    catch (Exception e) {
                        this.unknownCode(wire);
                    }
                    break;
                }
                case 11: {
                    this.copySpecial(wire, peekCode);
                    break;
                }
                case 12: 
                case 13: {
                    StringBuilder fsb = this.readField(peekCode, AnyCodeMatch.ANY_CODE_MATCH, WireInternal.acquireStringBuilder(), false);
                    wire.write(() -> fsb);
                    break;
                }
                case 14: 
                case 15: {
                    this.bytes.readSkip(1L);
                    StringBuilder sb = this.readText(peekCode, WireInternal.acquireStringBuilder());
                    wire.getValueOut().text(sb);
                }
            }
        }
    }

    private void unknownCode(@NotNull WireOut wire) {
        wire.writeComment("# " + BinaryWireCode.stringForCode(this.bytes.readUnsignedByte()));
    }

    private boolean isFieldNext() {
        int peekCode = this.peekCode();
        return peekCode == 183 || peekCode >= 192 && peekCode <= 223;
    }

    @Override
    @NotNull
    public ValueIn read() {
        this.readField(WireInternal.acquireStringBuilder(), AnyCodeMatch.ANY_CODE_MATCH);
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        long position = this.bytes.readPosition();
        StringBuilder sb = this.readField(WireInternal.acquireStringBuilder(), key);
        if (this.fieldLess || sb != null && (sb.length() == 0 || StringUtils.isEqual((CharSequence)sb, (CharSequence)key.name()))) {
            return this.valueIn;
        }
        return this.unorderedField(key, position, sb);
    }

    @NotNull
    private ValueIn unorderedField(@NotNull WireKey key, long position, @Nullable StringBuilder sb) {
        this.bytes.readPosition(position);
        if (sb == null) {
            sb = WireInternal.acquireStringBuilder();
        }
        this.readEventName(sb);
        throw new UnsupportedOperationException("Unordered fields not supported yet, Expected=" + key.name() + " was: '" + sb + "'");
    }

    @Override
    @NotNull
    public ValueIn readEventName(@NotNull StringBuilder name) {
        this.readField(name, AnyCodeMatch.ANY_CODE_MATCH);
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        this.readField(name, AnyCodeMatch.ANY_CODE_MATCH);
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn getValueIn() {
        return this.valueIn;
    }

    @Override
    @NotNull
    public Wire readComment(@NotNull StringBuilder s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.bytes.clear();
    }

    @Override
    @NotNull
    public Bytes<?> bytes() {
        return this.bytes;
    }

    @Override
    public boolean hasMore() {
        this.consumeSpecial();
        return this.bytes.readRemaining() > 0L;
    }

    @Nullable
    private StringBuilder readField(@NotNull StringBuilder name, WireKey key) {
        this.consumeSpecial();
        int peekCode = this.peekCode();
        return this.readField(peekCode, key, name, true);
    }

    void consumeSpecial() {
        this.consumeSpecial(false);
    }

    void consumeSpecial(boolean consumeType) {
        block6: while (true) {
            int code = this.peekCode();
            switch (code) {
                case 143: {
                    this.bytes.readSkip(1L);
                    continue block6;
                }
                case 142: {
                    this.bytes.readSkip(1L);
                    this.bytes.readSkip(this.bytes.readUnsignedInt());
                    continue block6;
                }
                case 182: {
                    if (!consumeType) {
                        return;
                    }
                }
                case 190: 
                case 191: {
                    this.bytes.readSkip(1L);
                    StringBuilder sb = WireInternal.acquireStringBuilder();
                    this.bytes.readUtf8((Appendable)sb);
                    continue block6;
                }
            }
            break;
        }
    }

    private int peekCode() {
        if (this.bytes.readRemaining() < 1L) {
            return -1;
        }
        long pos = this.bytes.readPosition();
        return this.bytes.readUnsignedByte(pos);
    }

    private StringBuilder readField(int peekCode, WireKey key, @NotNull StringBuilder sb, boolean missingOk) {
        sb.setLength(0);
        switch (peekCode >> 4) {
            case -1: {
                break;
            }
            case 11: {
                return this.readSpecialField(peekCode, key, sb);
            }
            case 12: 
            case 13: {
                this.bytes.readSkip(1L);
                if (this.bytes.bytesStore() instanceof NativeBytesStore) {
                    AppendableUtil.parse8bit_SB1(this.bytes, (StringBuilder)sb, (int)(peekCode & 0x1F));
                } else {
                    AppendableUtil.parse8bit(this.bytes, (Appendable)sb, (int)(peekCode & 0x1F));
                }
                return sb;
            }
            default: {
                if (missingOk) break;
                throw new UnsupportedOperationException("Unknown code " + BinaryWireCode.stringForCode(peekCode));
            }
        }
        if (this.fieldLess) {
            return sb;
        }
        return null;
    }

    @Nullable
    private StringBuilder readSpecialField(int peekCode, WireKey key, @NotNull StringBuilder sb) {
        if (peekCode == 186) {
            this.bytes.readSkip(1L);
            long fieldId = this.bytes.readStopBit();
            int codeMatch = key.code();
            if (codeMatch >= 0 && fieldId != (long)codeMatch) {
                throw new UnsupportedOperationException("Field was: " + fieldId + " expected " + codeMatch);
            }
            if (codeMatch < 0) {
                sb.append(fieldId);
            }
            return sb;
        }
        if (peekCode == 183 || peekCode == 185) {
            this.bytes.readSkip(1L);
            this.bytes.readUtf8((Appendable)sb);
            return sb;
        }
        return null;
    }

    @NotNull
    private <ACS extends Appendable & CharSequence> ACS getStringBuilder(int code, @NotNull ACS sb) {
        this.bytes.parseUtf8(sb, code & 0x1F);
        return sb;
    }

    private void copySpecial(@NotNull WireOut wire, int peekCode) {
        switch (peekCode) {
            case 190: {
                this.bytes.readSkip(1L);
                StringBuilder sb = WireInternal.acquireStringBuilder();
                this.bytes.readUtf8((Appendable)sb);
                wire.writeComment(sb);
                break;
            }
            case 191: {
                this.bytes.readSkip(1L);
                StringBuilder sb = WireInternal.acquireStringBuilder();
                this.bytes.readUtf8((Appendable)sb);
                break;
            }
            case 178: 
            case 180: 
            case 181: {
                throw new UnsupportedOperationException();
            }
            case 182: {
                long readPosition = this.bytes.readPosition();
                this.bytes.readSkip(1L);
                StringBuilder sb = WireInternal.acquireStringBuilder();
                this.bytes.readUtf8((Appendable)sb);
                if (StringUtils.isEqual((CharSequence)"snappy", (CharSequence)sb) || StringUtils.isEqual((CharSequence)"gzip", (CharSequence)sb) || StringUtils.isEqual((CharSequence)"lzw", (CharSequence)sb)) {
                    this.bytes.readPosition(readPosition);
                    wire.writeComment(sb);
                    wire.getValueOut().text(this.valueIn.text());
                    break;
                }
                wire.getValueOut().typePrefix(sb);
                break;
            }
            case 188: {
                this.bytes.readSkip(1L);
                StringBuilder sb = WireInternal.acquireStringBuilder();
                this.bytes.readUtf8((Appendable)sb);
                wire.getValueOut().typeLiteral(sb);
                break;
            }
            case 183: 
            case 185: {
                StringBuilder fsb = this.readField(peekCode, AnyCodeMatch.ANY_CODE_MATCH, WireInternal.acquireStringBuilder(), false);
                wire.write(() -> fsb);
                break;
            }
            case 184: {
                this.bytes.readSkip(1L);
                StringBuilder sb1 = WireInternal.acquireStringBuilder();
                this.bytes.readUtf8((Appendable)sb1);
                wire.getValueOut().text(sb1);
                break;
            }
            case 186: {
                this.bytes.readSkip(1L);
                final long code2 = this.bytes.readStopBit();
                wire.write(new WireKey(){

                    @Override
                    @NotNull
                    public String name() {
                        return Integer.toString(this.code());
                    }

                    @Override
                    public int code() {
                        return (int)code2;
                    }
                });
                break;
            }
            case 187: {
                this.bytes.readSkip(1L);
                wire.getValueOut().bool(null);
                break;
            }
            case 176: {
                this.bytes.readSkip(1L);
                wire.getValueOut().bool(false);
                break;
            }
            case 177: {
                this.bytes.readSkip(1L);
                wire.getValueOut().bool(true);
                break;
            }
            default: {
                this.unknownCode(wire);
            }
        }
    }

    private long readInt(int code) {
        if (code < 128) {
            return code;
        }
        switch (code >> 4) {
            case 11: {
                switch (code) {
                    case 176: {
                        return 0L;
                    }
                    case 177: {
                        return 1L;
                    }
                }
                break;
            }
            case 9: {
                double d = this.readFloat0(code);
                return (long)d;
            }
            case 10: {
                return this.readInt0(code);
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    private double readFloat0(int code) {
        if (code < 128 && code >= 0) {
            return code;
        }
        switch (code) {
            case 144: {
                return this.bytes.readFloat();
            }
            case 145: {
                return this.bytes.readDouble();
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    private Number readFloat0object(int code) {
        if (code < 128 && code >= 0) {
            return code;
        }
        switch (code) {
            case 144: {
                return Float.valueOf(this.bytes.readFloat());
            }
            case 145: {
                return this.bytes.readDouble();
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    private long readInt0(int code) {
        if (this.isSmallInt(code)) {
            return code;
        }
        switch (code) {
            case 164: {
                return this.bytes.readByte();
            }
            case 161: {
                return this.bytes.readUnsignedByte();
            }
            case 165: {
                return this.bytes.readShort();
            }
            case 162: {
                return this.bytes.readUnsignedShort();
            }
            case 166: {
                return this.bytes.readInt();
            }
            case 163: {
                return this.bytes.readUnsignedInt();
            }
            case 167: {
                return this.bytes.readLong();
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    private Number readInt0object(int code) {
        if (this.isSmallInt(code)) {
            return code;
        }
        switch (code) {
            case 164: {
                return this.bytes.readByte();
            }
            case 161: {
                return this.bytes.readUnsignedByte();
            }
            case 165: {
                return this.bytes.readShort();
            }
            case 162: {
                return this.bytes.readUnsignedShort();
            }
            case 166: {
                return this.bytes.readInt();
            }
            case 163: {
                return this.bytes.readUnsignedInt();
            }
            case 167: {
                return this.bytes.readLong();
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    private boolean isSmallInt(int code) {
        return (code & 0x80) == 0;
    }

    private double readFloat(int code) {
        if (code < 128) {
            return code;
        }
        switch (code >> 4) {
            case 9: {
                return this.readFloat0(code);
            }
            case 10: {
                return this.readInt0(code);
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    @Override
    @NotNull
    public ValueOut write() {
        if (!this.fieldLess) {
            this.writeField("");
        }
        return this.valueOut;
    }

    @Override
    @NotNull
    public ValueOut writeEventName(@NotNull WireKey key) {
        this.writeCode(185).writeUtf8(key.name());
        return this.valueOut;
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull WireKey key) {
        if (!this.fieldLess) {
            if (this.numericFields) {
                this.writeField(key.code());
            } else {
                this.writeField(key.name());
            }
        }
        return this.valueOut;
    }

    @Override
    @NotNull
    public ValueOut getValueOut() {
        return this.valueOut;
    }

    @Override
    @NotNull
    public Wire writeComment(CharSequence s) {
        this.writeCode(190);
        this.bytes.writeUtf8(s);
        return this;
    }

    @Override
    @NotNull
    public WireOut addPadding(int paddingToAdd) {
        if (paddingToAdd < 0) {
            throw new IllegalStateException("Cannot add " + paddingToAdd + " bytes of padding");
        }
        if (paddingToAdd >= 5) {
            this.writeCode(142).writeUnsignedInt((long)(paddingToAdd - 5)).writeSkip((long)(paddingToAdd - 5));
        } else {
            for (int i = 0; i < paddingToAdd; ++i) {
                this.writeCode(143);
            }
        }
        return this;
    }

    private void writeField(@NotNull CharSequence name) {
        int len = name.length();
        if (len < 32) {
            if (len > 0 && Character.isDigit(name.charAt(0))) {
                try {
                    this.writeField(Integer.parseInt(name.toString()));
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ((Bytes)this.bytes.writeByte((byte)(192 + len))).write(name);
        } else {
            this.writeCode(183).write8bit(name);
        }
    }

    private void writeField(int code) {
        this.writeCode(186);
        this.bytes.writeStopBit((long)code);
    }

    private Bytes writeCode(int code) {
        return (Bytes)this.bytes.writeByte((byte)code);
    }

    @Nullable
    <ACS extends Appendable & CharSequence> ACS readText(int code, @NotNull ACS sb) {
        if (code <= 127) {
            AppendableUtil.append(sb, (long)code);
            return sb;
        }
        switch (code >> 4) {
            case 8: {
                switch (code) {
                    case 130: {
                        if (!(sb instanceof StringBuilder)) {
                            throw new AssertionError();
                        }
                        this.bytes.readSkip(-1L);
                        this.valueIn.bytesStore((StringBuilder)sb);
                        return sb;
                    }
                }
            }
            case 11: {
                switch (code) {
                    case 187: {
                        AppendableUtil.append(sb, (String)"null");
                        return sb;
                    }
                    case 177: {
                        AppendableUtil.append(sb, (String)"true");
                        return sb;
                    }
                    case 176: {
                        AppendableUtil.append(sb, (String)"false");
                        return sb;
                    }
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: 
                    case 184: 
                    case 188: {
                        if (this.bytes.readUtf8(sb)) {
                            return sb;
                        }
                        return null;
                    }
                }
                return null;
            }
            case 9: {
                AppendableUtil.append(sb, (double)this.readFloat(code));
                return sb;
            }
            case 10: {
                AppendableUtil.append(sb, (long)this.readInt(code));
                return sb;
            }
            case 14: 
            case 15: {
                return this.getStringBuilder(code, sb);
            }
        }
        throw new UnsupportedOperationException("code=0x" + String.format("%02X ", code).trim());
    }

    private int readCode() {
        if (this.bytes.readRemaining() < 1L) {
            return -1;
        }
        return this.bytes.readUnsignedByte();
    }

    @NotNull
    public String toString() {
        return this.bytes.readRemaining() > 1024L ? this.bytes.toDebugString(1024L) + "..." : this.bytes.toDebugString();
    }

    @Override
    @NotNull
    public LongValue newLongReference() {
        return new BinaryLongReference();
    }

    @Override
    @NotNull
    public IntValue newIntReference() {
        return new BinaryIntReference();
    }

    @NotNull
    public BinaryLongArrayReference newLongArrayReference() {
        return new BinaryLongArrayReference();
    }

    class BinaryValueIn
    implements ValueIn {
        BinaryValueIn() {
        }

        @NotNull
        WireIn text(@NotNull Consumer<String> s) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            switch (code) {
                case 187: {
                    s.accept(null);
                    break;
                }
                case 184: {
                    s.accept(BinaryWire.this.bytes.readUtf8());
                    break;
                }
                default: {
                    if (code >= 224 && code <= 255) {
                        StringBuilder sb = WireInternal.acquireStringBuilder();
                        BinaryWire.this.bytes.parseUtf8((Appendable)sb, code & 0x1F);
                        s.accept(WireInternal.INTERNER.intern((CharSequence)sb));
                        break;
                    }
                    this.cantRead(code);
                }
            }
            return BinaryWire.this;
        }

        private boolean isText(int code) {
            return code == 184 || code >= 224 && code <= 255;
        }

        @Override
        @Nullable
        public StringBuilder textTo(@NotNull StringBuilder sb) {
            boolean wasNull;
            int code = BinaryWire.this.readCode();
            boolean bl = wasNull = code == 187;
            if (wasNull) {
                sb.setLength(0);
                return null;
            }
            StringBuilder text = BinaryWire.this.readText(code, sb);
            if (text == null) {
                this.cantRead(code);
            }
            return sb;
        }

        @Override
        @Nullable
        public Bytes textTo(@NotNull Bytes bytes) {
            boolean wasNull;
            int code = BinaryWire.this.readCode();
            boolean bl = wasNull = code == 187;
            if (wasNull) {
                bytes.readPosition(0L);
                return null;
            }
            Bytes text = BinaryWire.this.readText(code, bytes);
            if (text == null) {
                this.cantRead(code);
            }
            return bytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public String text() {
            int code = BinaryWire.this.readCode();
            switch (code) {
                case 187: {
                    return null;
                }
                case 184: {
                    long len0 = BinaryWire.this.bytes.readStopBit();
                    if (len0 == -1L) {
                        return null;
                    }
                    int len = Maths.toUInt31((long)len0);
                    long limit = BinaryWire.this.bytes.readLimit();
                    try {
                        BinaryWire.this.bytes.readLimit(BinaryWire.this.bytes.readPosition() + (long)len);
                        String string = UTF8_INTERNER.intern(BinaryWire.this.bytes);
                        return string;
                    }
                    finally {
                        BinaryWire.this.bytes.readPosition(BinaryWire.this.bytes.readLimit());
                        BinaryWire.this.bytes.readLimit(limit);
                    }
                }
                case 182: {
                    byte[] bytes;
                    StringBuilder sb = WireInternal.acquireStringBuilder();
                    if (BinaryWire.this.bytes.readUtf8((Appendable)sb) && (bytes = Compression.uncompress((CharSequence)sb, (Object)this, ValueIn::bytes)) != null) {
                        return new String(bytes, StandardCharsets.UTF_8);
                    }
                    StringBuilder text = BinaryWire.this.readText(code, sb);
                    return WireInternal.INTERNER.intern((CharSequence)text);
                }
            }
            StringBuilder text = BinaryWire.this.readText(code, WireInternal.acquireStringBuilder());
            if (text == null) {
                this.cantRead(code);
            }
            return WireInternal.INTERNER.intern((CharSequence)text);
        }

        @NotNull
        public WireIn bytes(@NotNull Bytes toBytes) {
            long length = this.readLength();
            int code = BinaryWire.this.readCode();
            if (code == 187) {
                toBytes.isPresent(false);
                return BinaryWire.this;
            }
            if (code == 182) {
                StringBuilder sb = WireInternal.acquireStringBuilder();
                if (BinaryWire.this.bytes.readUtf8((Appendable)sb)) {
                    long length2 = this.readLength();
                    int code2 = BinaryWire.this.readCode();
                    if (code2 != 138) {
                        this.cantRead(code);
                    }
                    toBytes.clear();
                    BinaryWire.this.bytes.readWithLength(length2 - 1L, b -> Compression.uncompress((CharSequence)sb, (Bytes)b, (Bytes)toBytes));
                    return this.wireIn();
                }
                throw new AssertionError();
            }
            if (code != 138) {
                this.cantRead(code);
            }
            toBytes.clear();
            BinaryWire.this.bytes.readWithLength(length - 1L, arg_0 -> ((Bytes)toBytes).write(arg_0));
            return this.wireIn();
        }

        @Override
        @Nullable
        public WireIn bytesSet(@NotNull PointerBytesStore toBytes) {
            long length = this.readLength();
            int code = BinaryWire.this.readCode();
            if (code == 187) {
                toBytes.isPresent(false);
                return BinaryWire.this;
            }
            if (code != 138) {
                this.cantRead(code);
            }
            long startAddr = BinaryWire.this.bytes.address(BinaryWire.this.bytes.readPosition());
            toBytes.set(startAddr, length - 1L);
            BinaryWire.this.bytes.readSkip(length - 1L);
            return this.wireIn();
        }

        @Override
        @NotNull
        public WireIn bytesMatch(@NotNull BytesStore compareBytes, @NotNull BooleanConsumer consumer) {
            long length = this.readLength();
            int code = BinaryWire.this.readCode();
            if (code != 138) {
                this.cantRead(code);
            }
            if (compareBytes.readRemaining() == --length) {
                consumer.accept(Boolean.valueOf(BinaryWire.this.bytes.equalBytes(compareBytes, length)));
            } else {
                consumer.accept(Boolean.valueOf(false));
            }
            BinaryWire.this.bytes.readSkip(length);
            return this.wireIn();
        }

        @Override
        @Nullable
        public BytesStore bytesStore() {
            long length = this.readLength() - 1L;
            int code = BinaryWire.this.readCode();
            switch (code) {
                case 138: {
                    NativeBytesStore toBytes = NativeBytesStore.lazyNativeBytesStoreWithFixedCapacity((long)length);
                    toBytes.write(0L, (RandomDataInput)BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
                    BinaryWire.this.bytes.readSkip(length);
                    return toBytes;
                }
                case 182: {
                    StringBuilder sb = WireInternal.acquireStringBuilder();
                    BinaryWire.this.bytes.readUtf8((Appendable)sb);
                    byte[] bytes = Compression.uncompress((CharSequence)sb, (Object)this, ValueIn::bytes);
                    if (bytes != null) {
                        return BytesStore.wrap((byte[])bytes);
                    }
                    throw new UnsupportedOperationException("Unsupported type " + sb);
                }
                case 187: {
                    return null;
                }
            }
            this.cantRead(code);
            throw new AssertionError();
        }

        public void bytesStore(@NotNull StringBuilder sb) {
            sb.setLength(0);
            long length = this.readLength() - 1L;
            int code = BinaryWire.this.readCode();
            if (code != 138) {
                this.cantRead(code);
            }
            for (long i = 0L; i < length; ++i) {
                sb.append((char)BinaryWire.this.bytes.readUnsignedByte());
            }
        }

        public void bytesStore(@NotNull Bytes toBytes) {
            toBytes.clear();
            long length = this.readLength() - 1L;
            int code = BinaryWire.this.readCode();
            if (code == 187) {
                toBytes.isPresent(false);
                return;
            }
            if (code != 138) {
                this.cantRead(code);
            }
            toBytes.write(0L, (RandomDataInput)BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
            toBytes.readLimit(length);
            BinaryWire.this.bytes.readSkip(length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public WireIn bytes(@NotNull ReadMarshallable bytesConsumer) {
            long length = this.readLength() - 1L;
            int code = BinaryWire.this.readCode();
            if (code != 138) {
                this.cantRead(code);
            }
            if (length > BinaryWire.this.bytes.readRemaining()) {
                throw new BufferUnderflowException();
            }
            long limit0 = BinaryWire.this.bytes.readLimit();
            long limit = BinaryWire.this.bytes.readPosition() + length;
            try {
                BinaryWire.this.bytes.readLimit(limit);
                bytesConsumer.readMarshallable(this.wireIn());
            }
            finally {
                BinaryWire.this.bytes.readLimit(limit0);
                BinaryWire.this.bytes.readPosition(limit);
            }
            return this.wireIn();
        }

        @Override
        @NotNull
        public byte[] bytes() {
            long length = this.readLength();
            int code = BinaryWire.this.readCode();
            if (code == 187) {
                return null;
            }
            if (code != 138) {
                this.cantRead(code);
            }
            byte[] bytes2 = new byte[Maths.toUInt31((long)(length - 1L))];
            BinaryWire.this.bytes.readWithLength(length - 1L, b -> b.read(bytes2));
            return bytes2;
        }

        @Override
        @NotNull
        public WireIn wireIn() {
            return BinaryWire.this;
        }

        @Override
        public long readLength() {
            int code = BinaryWire.this.peekCode();
            switch (code) {
                case 130: {
                    BinaryWire.this.bytes.readSkip(1L);
                    return BinaryWire.this.bytes.readUnsignedInt();
                }
            }
            return AnyCodeMatch.ANY_CODE_MATCH.code();
        }

        @Override
        @NotNull
        public <T> WireIn bool(T t, @NotNull ObjBooleanConsumer<T> tFlag) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            switch (code) {
                case 187: {
                    tFlag.accept(t, null);
                    break;
                }
                case 176: {
                    tFlag.accept(t, Boolean.valueOf(false));
                    break;
                }
                case 177: {
                    tFlag.accept(t, Boolean.valueOf(true));
                    break;
                }
                default: {
                    throw this.cantRead(code);
                }
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int8(@NotNull T t, @NotNull ObjByteConsumer<T> tb) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.bytes.readUnsignedByte();
            if (this.isText(code)) {
                tb.accept(t, Byte.parseByte(this.text()));
            } else {
                tb.accept(t, (byte)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint8(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                ti.accept(t, Short.parseShort(this.text()));
            } else {
                ti.accept(t, (short)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int16(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                ti.accept(t, Short.parseShort(this.text()));
            } else {
                ti.accept(t, (short)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint16(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                ti.accept(t, Integer.parseInt(this.text()));
            } else {
                ti.accept(t, (int)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int32(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                ti.accept(t, Integer.parseInt(this.text()));
            } else {
                ti.accept(t, (int)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint32(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                tl.accept(t, Long.parseLong(this.text()));
            } else {
                tl.accept(t, BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                tl.accept(t, Long.parseLong(this.text()));
            } else {
                tl.accept(t, BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn float32(@NotNull T t, @NotNull ObjFloatConsumer<T> tf) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                tf.accept(t, Float.parseFloat(this.text()));
            } else {
                tf.accept(t, (float)BinaryWire.this.readFloat(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn float64(@NotNull T t, @NotNull ObjDoubleConsumer<T> td) {
            int code = BinaryWire.this.readCode();
            td.accept(t, BinaryWire.this.readFloat(code));
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn time(@NotNull T t, @NotNull BiConsumer<T, LocalTime> setLocalTime) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code == 178) {
                setLocalTime.accept(t, this.readLocalTime());
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        private LocalTime readLocalTime() {
            StringBuilder sb = WireInternal.acquireStringBuilder();
            BinaryWire.this.bytes.readUtf8((Appendable)sb);
            return LocalTime.parse(sb);
        }

        @Override
        @NotNull
        public <T> WireIn zonedDateTime(@NotNull T t, @NotNull BiConsumer<T, ZonedDateTime> tZonedDateTime) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code == 181) {
                StringBuilder sb = WireInternal.acquireStringBuilder();
                BinaryWire.this.bytes.readUtf8((Appendable)sb);
                tZonedDateTime.accept(t, ZonedDateTime.parse(sb));
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn date(@NotNull T t, @NotNull BiConsumer<T, LocalDate> tLocalDate) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code == 180) {
                StringBuilder sb = WireInternal.acquireStringBuilder();
                BinaryWire.this.bytes.readUtf8((Appendable)sb);
                tLocalDate.accept(t, LocalDate.parse(sb));
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        public boolean hasNext() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public boolean hasNextSequenceItem() {
            return BinaryWire.this.bytes.readRemaining() > 0L;
        }

        @Override
        @NotNull
        public <T> WireIn uuid(@NotNull T t, @NotNull BiConsumer<T, UUID> tuuid) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code == 160) {
                tuuid.accept(t, new UUID(BinaryWire.this.bytes.readLong(), BinaryWire.this.bytes.readLong()));
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64array(@Nullable LongArrayValues values, T t, @NotNull BiConsumer<T, LongArrayValues> setter) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code == 141) {
                if (!(values instanceof BinaryLongArrayReference)) {
                    values = new BinaryLongArrayReference();
                    setter.accept(t, values);
                }
                Byteable b = (Byteable)values;
                long length = BinaryLongArrayReference.peakLength((BytesStore)BinaryWire.this.bytes, (long)BinaryWire.this.bytes.readPosition());
                b.bytesStore((BytesStore)BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
                BinaryWire.this.bytes.readSkip(length);
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn int64(LongValue value) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code != 167) {
                this.cantRead(code);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
            BinaryWire.this.bytes.readSkip(length);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64(@Nullable LongValue value, T t, @NotNull BiConsumer<T, LongValue> setter) {
            if (!(value instanceof BinaryLongReference)) {
                value = new BinaryLongReference();
                setter.accept(t, value);
            }
            return this.int64(value);
        }

        @Override
        @NotNull
        public <T> WireIn int32(@Nullable IntValue value, T t, @NotNull BiConsumer<T, IntValue> setter) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code != 166) {
                this.cantRead(code);
            }
            if (!(value instanceof Byteable) || ((Byteable)value).maxSize() != 4L) {
                value = new BinaryIntReference();
                setter.accept(t, value);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
            BinaryWire.this.bytes.readSkip(length);
            return BinaryWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public <T> WireIn sequence(@NotNull T t, @NotNull BiConsumer<T, ValueIn> tReader) {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code != 130) {
                this.cantRead(code);
            }
            int length = BinaryWire.this.bytes.readInt();
            long limit = BinaryWire.this.bytes.readLimit();
            long limit2 = BinaryWire.this.bytes.readPosition() + (long)length;
            BinaryWire.this.bytes.readLimit(limit2);
            try {
                tReader.accept(t, this);
            }
            finally {
                BinaryWire.this.bytes.readLimit(limit);
                BinaryWire.this.bytes.readPosition(limit2);
            }
            return BinaryWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T applyToMarshallable(@NotNull Function<WireIn, T> marshallableReader) {
            BinaryWire.this.consumeSpecial();
            long length = this.readLength();
            if (length >= 0L) {
                long limit = BinaryWire.this.bytes.readLimit();
                long limit2 = BinaryWire.this.bytes.readPosition() + length;
                BinaryWire.this.bytes.readLimit(limit2);
                try {
                    T t = marshallableReader.apply(BinaryWire.this);
                    return t;
                }
                finally {
                    BinaryWire.this.bytes.readLimit(limit);
                    BinaryWire.this.bytes.readPosition(limit2);
                }
            }
            return marshallableReader.apply(BinaryWire.this);
        }

        @Override
        public boolean isTyped() {
            int code = BinaryWire.this.peekCode();
            return code == 182;
        }

        @Override
        @Nullable
        public <T extends ReadMarshallable> T typedMarshallable() throws IORuntimeException {
            StringBuilder sb = WireInternal.acquireStringBuilder();
            int code = BinaryWire.this.readCode();
            switch (code) {
                case 182: {
                    Class clazz;
                    BinaryWire.this.bytes.readUtf8((Appendable)sb);
                    try {
                        clazz = ClassAliasPool.CLASS_ALIASES.forName((CharSequence)sb);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IORuntimeException((Throwable)e);
                    }
                    if (!Marshallable.class.isAssignableFrom(clazz)) {
                        throw new IllegalStateException("its not possible to Marshallable and object that is not of type Marshallable, type=" + sb);
                    }
                    ReadMarshallable m = (ReadMarshallable)ObjectUtils.newInstance((Class)clazz);
                    this.marshallable(m);
                    return (T)((ReadMarshallable)ReadResolvable.readResolve((Object)m));
                }
                case 187: {
                    return null;
                }
            }
            this.cantRead(code);
            return null;
        }

        @Override
        public Class typePrefix() {
            StringBuilder sb = WireInternal.acquireStringBuilder();
            int code = BinaryWire.this.readCode();
            if (code == 182) {
                BinaryWire.this.bytes.readUtf8((Appendable)sb);
            } else if (code == 187) {
                sb.setLength(0);
                sb.append("!null");
            } else {
                this.cantRead(code);
            }
            try {
                return ClassAliasPool.CLASS_ALIASES.forName((CharSequence)sb);
            }
            catch (ClassNotFoundException e) {
                throw new IORuntimeException((Throwable)e);
            }
        }

        @Override
        @NotNull
        public <T> ValueIn typePrefix(T t, @NotNull BiConsumer<T, CharSequence> ts) {
            StringBuilder sb = WireInternal.acquireStringBuilder();
            int code = BinaryWire.this.readCode();
            if (code == 182) {
                BinaryWire.this.bytes.readUtf8((Appendable)sb);
            } else if (code == 187) {
                sb.setLength(0);
                sb.append("!null");
            } else {
                this.cantRead(code);
            }
            ts.accept(t, sb);
            return this;
        }

        @Override
        @NotNull
        public <T> WireIn typeLiteralAsText(T t, @NotNull BiConsumer<T, CharSequence> classNameConsumer) {
            int code = BinaryWire.this.readCode();
            if (code == 188) {
                StringBuilder sb = WireInternal.acquireStringBuilder();
                BinaryWire.this.bytes.readUtf8((Appendable)sb);
                classNameConsumer.accept(t, sb);
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        public <T> Class<T> typeLiteral() {
            StringBuilder sb = WireInternal.acquireStringBuilder();
            int code = BinaryWire.this.readCode();
            if (code == 188) {
                BinaryWire.this.bytes.readUtf8((Appendable)sb);
                try {
                    return ClassAliasPool.CLASS_ALIASES.forName((CharSequence)sb);
                }
                catch (ClassNotFoundException e) {
                    throw new IORuntimeException((Throwable)e);
                }
            }
            if (code == 187) {
                return null;
            }
            throw this.cantRead(code);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public WireIn marshallable(@NotNull ReadMarshallable object) throws BufferUnderflowException, IORuntimeException {
            BinaryWire.this.consumeSpecial(true);
            long length = this.readLength();
            if (length >= 0L) {
                long limit = BinaryWire.this.bytes.readLimit();
                long limit2 = BinaryWire.this.bytes.readPosition() + length;
                BinaryWire.this.bytes.readLimit(limit2);
                try {
                    object.readMarshallable(BinaryWire.this);
                }
                finally {
                    BinaryWire.this.bytes.readLimit(limit);
                    BinaryWire.this.bytes.readPosition(limit2);
                }
            } else {
                object.readMarshallable(BinaryWire.this);
            }
            return BinaryWire.this;
        }

        @Override
        public <K extends ReadMarshallable, V extends ReadMarshallable> void typedMap(@NotNull Map<K, V> usingMap) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public <K, V> Map<K, V> map(@NotNull Class<K> kClazz, @NotNull Class<V> vClass, @NotNull Map<K, V> usingMap) {
            throw new UnsupportedOperationException("todo");
        }

        private long readTextAsLong() throws IORuntimeException, BufferUnderflowException {
            BinaryWire.this.bytes.readSkip(-1L);
            String text = this.text();
            if (text == null) {
                throw new NullPointerException();
            }
            try {
                return Long.parseLong(text);
            }
            catch (NumberFormatException e) {
                return Math.round(Double.parseDouble(text));
            }
        }

        private double readTextAsDouble() throws IORuntimeException, BufferUnderflowException {
            BinaryWire.this.bytes.readSkip(-1L);
            String text = this.text();
            if (text == null || text.length() == 0) {
                return Double.NaN;
            }
            return Double.parseDouble(text);
        }

        @Override
        public boolean bool() throws IORuntimeException {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                return Boolean.valueOf(this.text());
            }
            switch (code) {
                case 177: {
                    return true;
                }
                case 176: {
                    return false;
                }
            }
            throw new IORuntimeException(BinaryWireCode.stringForCode(code));
        }

        @Override
        public byte int8() {
            long value;
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            long l = value = this.isText(code) ? this.readTextAsLong() : BinaryWire.this.readInt0(code);
            if (value > 127L || value < -128L) {
                throw new IllegalStateException();
            }
            return (byte)value;
        }

        @Override
        public short int16() {
            long value;
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            long l = value = this.isText(code) ? this.readTextAsLong() : BinaryWire.this.readInt0(code);
            if (value > 32767L || value < -32768L) {
                throw new IllegalStateException();
            }
            return (short)value;
        }

        @Override
        public int uint16() {
            long value;
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            long l = value = this.isText(code) ? this.readTextAsLong() : BinaryWire.this.readInt0(code);
            if (value > 0x100000000L || value < 0L) {
                throw new IllegalStateException();
            }
            return (int)value;
        }

        @Override
        public int int32() {
            long value;
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            long l = value = this.isText(code) ? this.readTextAsLong() : BinaryWire.this.readInt0(code);
            if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
                throw new IllegalStateException();
            }
            return (int)value;
        }

        @Override
        public long int64() {
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            if (code >> 4 == 9) {
                return (long)BinaryWire.this.readFloat0(code);
            }
            return this.isText(code) ? this.readTextAsLong() : BinaryWire.this.readInt0(code);
        }

        @Override
        public double float64() {
            int code = BinaryWire.this.readCode();
            if (code >> 4 == 9) {
                return BinaryWire.this.readFloat0(code);
            }
            return this.isText(code) ? this.readTextAsDouble() : (double)BinaryWire.this.readInt0(code);
        }

        @Override
        public float float32() {
            double value;
            BinaryWire.this.consumeSpecial();
            int code = BinaryWire.this.readCode();
            double d = value = this.isText(code) ? this.readTextAsDouble() : BinaryWire.this.readFloat0(code);
            if (Double.isFinite(value) && (value > 3.4028234663852886E38 || value < (double)1.4E-45f)) {
                throw new IllegalStateException("Cannot convert " + value + " to float");
            }
            return (float)value;
        }

        @NotNull
        private RuntimeException cantRead(int code) {
            throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
        }

        @Override
        @Nullable
        public <E> E object(@Nullable E using, @NotNull Class<E> clazz) {
            return (E)ObjectUtils.convertTo(clazz, (Object)this.object0(using, clazz));
        }

        @Override
        @Nullable
        public <T, E> WireIn object(@NotNull Class<E> clazz, T t, BiConsumer<T, E> e) {
            Object o = this.object0(null, clazz);
            Object u = ObjectUtils.convertTo(clazz, (Object)o);
            e.accept(t, u);
            return BinaryWire.this;
        }

        @Nullable
        Object object0(@Nullable Object using, @NotNull Class clazz) {
            int code = BinaryWire.this.peekCode();
            if (code == 187) {
                BinaryWire.this.readCode();
                return null;
            }
            if (ReadMarshallable.class.isAssignableFrom(clazz)) {
                Object v = using == null ? ObjectUtils.newInstance((Class)clazz) : using;
                this.marshallable((ReadMarshallable)v);
                return ReadResolvable.readResolve((Object)v);
            }
            if (CharSequence.class.isAssignableFrom(clazz)) {
                if (StringBuilder.class.isAssignableFrom(clazz)) {
                    StringBuilder builder = using == null ? WireInternal.acquireStringBuilder() : (StringBuilder)using;
                    this.textTo(builder);
                    return builder;
                }
                return this.text();
            }
            if (Map.class.isAssignableFrom(clazz)) {
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
                this.map(result);
                return result;
            }
            if (byte[].class.isAssignableFrom(clazz)) {
                return this.bytes();
            }
            return this.object(using);
        }

        @Nullable
        private Object object(@Nullable Object using) {
            int code = BinaryWire.this.peekCode();
            if ((code & 0x80) == 0) {
                BinaryWire.this.bytes.readSkip(1L);
                return code;
            }
            switch (code >> 4) {
                case 8: {
                    switch (code) {
                        case 130: {
                            if (using instanceof StringBuilder) {
                                this.bytesStore((StringBuilder)using);
                                return using;
                            }
                            if (using instanceof Bytes) {
                                this.bytesStore((Bytes)using);
                                return using;
                            }
                            return this.bytesStore();
                        }
                    }
                    break;
                }
                case 11: {
                    switch (code) {
                        case 176: {
                            BinaryWire.this.bytes.readSkip(1L);
                            return Boolean.FALSE;
                        }
                        case 177: {
                            BinaryWire.this.bytes.readSkip(1L);
                            return Boolean.TRUE;
                        }
                        case 187: {
                            BinaryWire.this.bytes.readSkip(1L);
                            return null;
                        }
                        case 184: {
                            return this.text();
                        }
                        case 182: {
                            Class clazz2;
                            BinaryWire.this.readCode();
                            StringBuilder sb = WireInternal.acquireStringBuilder();
                            BinaryWire.this.bytes.readUtf8((Appendable)sb);
                            try {
                                clazz2 = ClassAliasPool.CLASS_ALIASES.forName((CharSequence)sb);
                            }
                            catch (ClassNotFoundException e) {
                                throw new IORuntimeException((Throwable)e);
                            }
                            return this.object(null, clazz2);
                        }
                    }
                    break;
                }
                case 9: {
                    return BinaryWire.this.readFloat0object(code);
                }
                case 10: {
                    return BinaryWire.this.readInt0object(code);
                }
            }
            return this.text();
        }
    }

    class BinaryValueOut
    extends FixedBinaryValueOut {
        BinaryValueOut() {
        }

        @Override
        @NotNull
        public WireOut int8(byte i8) {
            this.writeNumber(i8);
            return BinaryWire.this;
        }

        void writeNumber(long l) {
            if (l >= 0L && l <= 127L) {
                BinaryWire.this.bytes.writeUnsignedByte((int)l);
                return;
            }
            if (l >= 0L) {
                if (l <= 255L) {
                    super.uint8checked((short)l);
                    return;
                }
                if (l <= 65535L) {
                    super.uint16checked((int)l);
                    return;
                }
                if (l <= 0xFFFFFFFFL) {
                    super.uint32checked(l);
                    return;
                }
                if ((long)((float)l) == l) {
                    super.float32(l);
                    return;
                }
                super.int64(l);
                return;
            }
            if (l >= -128L && l <= 127L) {
                super.int8((byte)l);
                return;
            }
            if (l >= -32768L && l <= 32767L) {
                super.int16((short)l);
                return;
            }
            if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                super.int32((int)l);
                return;
            }
            if ((long)((float)l) == l) {
                super.float32(l);
                return;
            }
            super.int64(l);
        }

        void writeNumber(double l) {
            boolean canOnlyBeRepresentedAsFloatingPoint;
            boolean bl = canOnlyBeRepresentedAsFloatingPoint = (double)((long)l) != l;
            if (l >= 0.0 && l <= 127.0 && !canOnlyBeRepresentedAsFloatingPoint) {
                BinaryWire.this.bytes.writeUnsignedByte((int)l);
                return;
            }
            if (l >= 0.0) {
                if (l <= 255.0 && !canOnlyBeRepresentedAsFloatingPoint) {
                    super.uint8checked((short)l);
                    return;
                }
                if (l <= 65535.0 && !canOnlyBeRepresentedAsFloatingPoint) {
                    super.uint16checked((int)l);
                    return;
                }
                if ((double)((float)l) == l) {
                    super.float32((float)l);
                    return;
                }
                if (l <= 4.294967295E9 && !canOnlyBeRepresentedAsFloatingPoint) {
                    super.uint32checked((int)l);
                    return;
                }
                super.float64(l);
                return;
            }
            if (l >= -128.0 && l <= 127.0 && !canOnlyBeRepresentedAsFloatingPoint) {
                super.int8((byte)l);
                return;
            }
            if (l >= -32768.0 && l <= 32767.0 && !canOnlyBeRepresentedAsFloatingPoint) {
                super.int16((short)l);
                return;
            }
            if ((double)((float)l) == l) {
                super.float32((float)l);
                return;
            }
            if (l >= -2.147483648E9 && l <= 2.147483647E9 && !canOnlyBeRepresentedAsFloatingPoint) {
                super.int32((int)l);
                return;
            }
            super.float64(l);
        }

        @Override
        @NotNull
        public WireOut uint8checked(int u8) {
            this.writeNumber(u8);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int16(short i16) {
            this.writeNumber(i16);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint16checked(int u16) {
            this.writeNumber(u16);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int32(int i32) {
            this.writeNumber(i32);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint32checked(long u32) {
            this.writeNumber(u32);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64(long i64) {
            this.writeNumber(i64);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut float32(float f) {
            this.writeNumber(f);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut float64(double d) {
            this.writeNumber(d);
            return BinaryWire.this;
        }
    }

    class FixedBinaryValueOut
    implements ValueOut {
        FixedBinaryValueOut() {
        }

        @Override
        @NotNull
        public ValueOut leaf() {
            return this;
        }

        @Override
        @NotNull
        public WireOut bool(@Nullable Boolean flag) {
            BinaryWire.this.bytes.writeUnsignedByte(flag == null ? 187 : (flag != false ? 177 : 176));
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut text(@Nullable CharSequence s) {
            if (s == null) {
                BinaryWire.this.writeCode(187);
            } else {
                int len = s.length();
                if (len < 32) {
                    ((Bytes)BinaryWire.this.bytes.writeUnsignedByte(224 + len)).appendUtf8(s);
                } else {
                    BinaryWire.this.writeCode(184).writeUtf8(s);
                }
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut text(@Nullable BytesStore s) {
            if (s == null) {
                BinaryWire.this.writeCode(187);
            } else {
                int len = s.length();
                if (len < 32) {
                    ((Bytes)BinaryWire.this.bytes.writeUnsignedByte(224 + len)).appendUtf8((CharSequence)s);
                } else {
                    BinaryWire.this.writeCode(184).writeUtf8((CharSequence)s);
                }
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(@Nullable BytesStore fromBytes) {
            if (fromBytes == null) {
                return this.text((BytesStore)null);
            }
            long remaining = fromBytes.readRemaining();
            if (remaining >= (long)this.compressedSize()) {
                this.compress(BinaryWire.this.compression, fromBytes.bytesForRead());
            } else {
                this.bytes0(fromBytes, remaining);
            }
            return BinaryWire.this;
        }

        @Override
        public int compressedSize() {
            return BinaryWire.this.compressedSize;
        }

        public void bytes0(@Nullable BytesStore fromBytes, long remaining) {
            this.writeLength(Maths.toInt32((long)(remaining + 1L)));
            BinaryWire.this.writeCode(138);
            if (remaining > 0L) {
                BinaryWire.this.bytes.write(fromBytes);
            }
        }

        @Override
        @NotNull
        public WireOut rawBytes(byte[] value) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public ValueOut writeLength(long length) {
            if (length < 0L) {
                throw new IllegalArgumentException("Invalid length " + length);
            }
            BinaryWire.this.writeCode(130);
            BinaryWire.this.bytes.writeUnsignedInt(length);
            return this;
        }

        @Override
        @NotNull
        public WireOut bytes(@NotNull byte[] fromBytes) {
            this.writeLength(Maths.toInt32((long)(fromBytes.length + 1)));
            BinaryWire.this.writeCode(138);
            BinaryWire.this.bytes.write(fromBytes);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(String type, @Nullable BytesStore fromBytes) {
            this.typePrefix(type);
            this.bytes0(fromBytes, fromBytes.readRemaining());
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(String type, byte[] fromBytes) {
            this.typePrefix(type);
            return this.bytes(fromBytes);
        }

        @Override
        @NotNull
        public WireOut int8(byte i8) {
            BinaryWire.this.writeCode(164).writeByte(i8);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint8checked(int u8) {
            BinaryWire.this.writeCode(161).writeUnsignedByte(u8);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int16(short i16) {
            BinaryWire.this.writeCode(165).writeShort(i16);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint16checked(int u16) {
            BinaryWire.this.writeCode(162).writeUnsignedShort(u16);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut utf8(int codepoint) {
            BinaryWire.this.writeCode(162);
            BinaryWire.this.bytes.appendUtf8(codepoint);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int32(int i32) {
            return this.fixedInt32(i32);
        }

        @NotNull
        public WireOut fixedInt32(int i32) {
            BinaryWire.this.writeCode(166).writeInt(i32);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint32checked(long u32) {
            BinaryWire.this.writeCode(163).writeUnsignedInt(u32);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64(long i64) {
            return this.fixedInt64(i64);
        }

        @NotNull
        private WireOut fixedInt64(long i64) {
            BinaryWire.this.writeCode(167).writeLong(i64);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity) {
            BinaryWire.this.writeCode(141);
            BinaryLongArrayReference.lazyWrite((Bytes)BinaryWire.this.bytes, (long)capacity);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity, @NotNull LongArrayValues values) {
            BinaryWire.this.writeCode(141);
            long pos = BinaryWire.this.bytes.writePosition();
            BinaryLongArrayReference.lazyWrite((Bytes)BinaryWire.this.bytes, (long)capacity);
            ((Byteable)values).bytesStore((BytesStore)BinaryWire.this.bytes, pos, BinaryWire.this.bytes.writePosition() - pos);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut float32(float f) {
            BinaryWire.this.writeCode(144).writeFloat(f);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut float64(double d) {
            BinaryWire.this.writeCode(145).writeDouble(d);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut time(@NotNull LocalTime localTime) {
            BinaryWire.this.writeCode(178).writeUtf8((CharSequence)localTime.toString());
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut zonedDateTime(@NotNull ZonedDateTime zonedDateTime) {
            BinaryWire.this.writeCode(181).writeUtf8((CharSequence)zonedDateTime.toString());
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut date(@NotNull LocalDate localDate) {
            BinaryWire.this.writeCode(180).writeUtf8((CharSequence)localDate.toString());
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public ValueOut typePrefix(CharSequence typeName) {
            BinaryWire.this.writeCode(182).writeUtf8(typeName);
            return this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull CharSequence type) {
            BinaryWire.this.writeCode(188).writeUtf8(type);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull Class type) {
            BinaryWire.this.writeCode(188).writeUtf8((CharSequence)ClassAliasPool.CLASS_ALIASES.nameFor(type));
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull BiConsumer<Class, Bytes> typeTranslator, @NotNull Class type) {
            BinaryWire.this.writeCode(188);
            typeTranslator.accept(type, BinaryWire.this.bytes);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uuid(@NotNull UUID uuid) {
            BinaryWire.this.writeCode(160).writeLong(uuid.getMostSignificantBits()).writeLong(uuid.getLeastSignificantBits());
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value) {
            int fromEndOfCacheLine = (int)(-BinaryWire.this.bytes.readPosition() - 1L & 0x3FL);
            if (fromEndOfCacheLine < 4) {
                BinaryWire.this.addPadding(fromEndOfCacheLine - 1);
            }
            this.fixedInt32(value);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value) {
            int fromEndOfCacheLine = (int)(-BinaryWire.this.bytes.readPosition() - 1L & 0x3FL);
            if (fromEndOfCacheLine < 8) {
                BinaryWire.this.addPadding(fromEndOfCacheLine);
            }
            this.fixedInt64(value);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value, @NotNull IntValue intValue) {
            this.int32forBinding(value);
            ((BinaryIntReference)intValue).bytesStore((BytesStore)BinaryWire.this.bytes, BinaryWire.this.bytes.writePosition() - 4L, 4L);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value, @NotNull LongValue longValue) {
            this.int64forBinding(value);
            ((BinaryLongReference)longValue).bytesStore((BytesStore)BinaryWire.this.bytes, BinaryWire.this.bytes.writePosition() - 8L, 8L);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut sequence(@NotNull WriteValue writer) {
            BinaryWire.this.writeCode(130);
            long position = BinaryWire.this.bytes.writePosition();
            BinaryWire.this.bytes.writeInt(0);
            writer.writeValue(this);
            BinaryWire.this.bytes.writeOrderedInt(position, Maths.toInt32((long)(BinaryWire.this.bytes.writePosition() - position - 4L), (String)"Document length %,d out of 32-bit int range."));
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut marshallable(@NotNull WriteMarshallable object) {
            BinaryWire.this.writeCode(130);
            long position = BinaryWire.this.bytes.writePosition();
            BinaryWire.this.bytes.writeInt(0);
            object.writeMarshallable(BinaryWire.this);
            BinaryWire.this.bytes.writeOrderedInt(position, Maths.toInt32((long)(BinaryWire.this.bytes.writePosition() - position - 4L), (String)"Document length %,d out of 32-bit int range."));
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut map(Map map) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireOut typedMap(@NotNull Map<? extends WriteMarshallable, ? extends Marshallable> map) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireOut wireOut() {
            return BinaryWire.this;
        }
    }

    static enum AnyCodeMatch implements WireKey
    {
        ANY_CODE_MATCH;


        @Override
        public int code() {
            return Integer.MIN_VALUE;
        }
    }
}

