/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.BinaryLongArrayReference;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.TextLongArrayReference;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueryWire
extends TextWire {
    final QueryValueOut valueOut = new QueryValueOut();
    final ValueIn valueIn = new QueryValueIn();

    public QueryWire(Bytes bytes) {
        super(bytes);
    }

    @Override
    @NotNull
    protected QueryValueOut createValueOut() {
        return new QueryValueOut();
    }

    @Override
    @NotNull
    protected TextWire.TextValueIn createValueIn() {
        return new QueryValueIn();
    }

    @Override
    @NotNull
    protected StringBuilder readField(@NotNull StringBuilder sb) {
        this.consumeWhiteSpace();
        this.bytes.parseUTF((Appendable)sb, (StopCharTester)QueryStopCharTesters.QUERY_FIELD_NAME);
        if (this.rewindAndRead() == 38) {
            this.bytes.readSkip(-1L);
        }
        return sb;
    }

    @Override
    @ForceInline
    void consumeWhiteSpace() {
        int codePoint = this.peekCode();
        while (Character.isWhitespace(codePoint)) {
            this.bytes.readSkip(1L);
            codePoint = this.peekCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean peekStringIgnoreCase(@NotNull String source) {
        if (source.isEmpty()) {
            return true;
        }
        if (this.bytes.readRemaining() < 1L) {
            return false;
        }
        long pos = this.bytes.readPosition();
        try {
            for (int i = 0; i < source.length(); ++i) {
                if (Character.toLowerCase(source.charAt(i)) == Character.toLowerCase(this.bytes.readByte())) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.bytes.readPosition(pos);
        }
        return true;
    }

    private int readCode() {
        if (this.bytes.readRemaining() < 1L) {
            return -1;
        }
        return this.bytes.readUnsignedByte();
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        long position = this.bytes.readPosition();
        StringBuilder sb = this.readField(WireInternal.acquireStringBuilder());
        if (sb.length() == 0 || StringUtils.isEqual((CharSequence)sb, (CharSequence)key.name())) {
            return this.valueIn;
        }
        this.bytes.readPosition(position);
        throw new UnsupportedOperationException("Unordered fields not supported yet. key=" + key.name() + ", was=" + sb + ", data='" + sb + "'");
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        this.consumeWhiteSpace();
        this.readField(name);
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn getValueIn() {
        return this.valueIn;
    }

    @Override
    public boolean hasMore() {
        return this.bytes.readRemaining() > 0L;
    }

    @Override
    @NotNull
    public ValueOut write() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull WireKey key) {
        return this.valueOut.write(key);
    }

    @Override
    @NotNull
    public ValueOut getValueOut() {
        return this.valueOut;
    }

    @Override
    @NotNull
    public Wire writeComment(CharSequence s) {
        return this;
    }

    @Override
    @NotNull
    public WireOut addPadding(int paddingToAdd) {
        return this;
    }

    int rewindAndRead() {
        return this.bytes.readUnsignedByte(this.bytes.readPosition() - 1L);
    }

    @Override
    @NotNull
    public LongValue newLongReference() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public IntValue newIntReference() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public BinaryLongArrayReference newLongArrayReference() {
        throw new UnsupportedOperationException();
    }

    class QueryValueIn
    extends TextWire.TextValueIn {
        QueryValueIn() {
            super(QueryWire.this);
        }

        @Override
        public String text() {
            return StringUtils.toString((Object)this.textTo(WireInternal.acquireStringBuilder()));
        }

        @Override
        @Nullable
        public StringBuilder textTo(@NotNull StringBuilder a) {
            QueryWire.this.consumeWhiteSpace();
            QueryWire.this.bytes.parseUTF((Appendable)a, (StopCharTester)QueryStopCharTesters.QUERY_VALUE);
            return a;
        }

        @Override
        @Nullable
        public Bytes textTo(@NotNull Bytes a) {
            QueryWire.this.consumeWhiteSpace();
            QueryWire.this.bytes.parseUTF((Appendable)a, (StopCharTester)QueryStopCharTesters.QUERY_VALUE);
            return a;
        }

        @Override
        public <T> WireIn typeLiteralAsText(T t, @NotNull BiConsumer<T, CharSequence> classNameConsumer) {
            StringBuilder sb = WireInternal.acquireStringBuilder();
            this.textTo(sb);
            classNameConsumer.accept(t, sb);
            return this.wireIn();
        }

        @Override
        public <T> Class<T> typeLiteral() {
            StringBuilder sb = WireInternal.acquireStringBuilder();
            this.textTo(sb);
            try {
                return ClassAliasPool.CLASS_ALIASES.forName((CharSequence)sb);
            }
            catch (ClassNotFoundException e) {
                throw new IORuntimeException((Throwable)e);
            }
        }

        @Override
        @NotNull
        public WireIn bytes(@NotNull Bytes toBytes) {
            return this.bytes((WireIn wi) -> toBytes.write(wi.bytes()));
        }

        @Override
        public boolean hasNextSequenceItem() {
            QueryWire.this.consumeWhiteSpace();
            int ch = QueryWire.this.peekCode();
            if (ch == 44) {
                QueryWire.this.bytes.readSkip(1L);
                return true;
            }
            return ch != 93;
        }
    }

    class QueryValueOut
    extends TextWire.TextValueOut {
        @NotNull
        String sep;
        @Nullable
        CharSequence fieldName;

        QueryValueOut() {
            super(QueryWire.this);
            this.sep = "";
            this.fieldName = null;
        }

        @Override
        void prependSeparator() {
            QueryWire.this.bytes.appendUtf8((CharSequence)this.sep);
            this.sep = "";
            if (this.fieldName != null) {
                ((Bytes)QueryWire.this.bytes.appendUtf8(this.fieldName)).appendUtf8(61);
                this.fieldName = null;
            }
        }

        @Override
        @NotNull
        public ValueOut leaf() {
            return this;
        }

        @Override
        public void elementSeparator() {
            this.sep = "&";
        }

        @Override
        @NotNull
        public WireOut bool(@Nullable Boolean flag) {
            if (flag != null) {
                this.prependSeparator();
                QueryWire.this.bytes.appendUtf8((CharSequence)(flag != false ? "true" : "false"));
                this.elementSeparator();
            }
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut text(@Nullable CharSequence s) {
            if (s != null) {
                this.prependSeparator();
                QueryWire.this.bytes.appendUtf8(s);
                this.elementSeparator();
            }
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut int8(byte i8) {
            this.prependSeparator();
            QueryWire.this.bytes.appendUtf8((int)i8);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(@Nullable BytesStore fromBytes) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireOut rawBytes(@Nullable byte[] value) {
            if (value != null) {
                this.prependSeparator();
                QueryWire.this.bytes.write(value);
                this.elementSeparator();
            }
            return QueryWire.this;
        }

        private boolean isText(@NotNull Bytes fromBytes) {
            for (long i = fromBytes.readPosition(); i < fromBytes.readLimit(); ++i) {
                int ch = fromBytes.readUnsignedByte(i);
                if ((ch >= 32 || ch == 9) && ch != 38 && ch < 127) continue;
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public WireOut bytes(byte[] byteArray) {
            this.prependSeparator();
            QueryWire.this.bytes.appendUtf8((CharSequence)Base64.getEncoder().encodeToString(byteArray));
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint8checked(int u8) {
            this.prependSeparator();
            QueryWire.this.bytes.appendUtf8(u8);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut int16(short i16) {
            this.prependSeparator();
            QueryWire.this.bytes.appendUtf8((int)i16);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint16checked(int u16) {
            this.prependSeparator();
            QueryWire.this.bytes.appendUtf8(u16);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut utf8(int codepoint) {
            this.prependSeparator();
            StringBuilder sb = WireInternal.acquireStringBuilder();
            sb.appendCodePoint(codepoint);
            this.text(sb);
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut int32(int i32) {
            this.prependSeparator();
            QueryWire.this.bytes.appendUtf8(i32);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint32checked(long u32) {
            this.prependSeparator();
            QueryWire.this.bytes.append(u32);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64(long i64) {
            this.prependSeparator();
            QueryWire.this.bytes.append(i64);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity) {
            TextLongArrayReference.write(QueryWire.this.bytes, capacity);
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity, LongArrayValues values) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireOut float32(float f) {
            this.prependSeparator();
            QueryWire.this.bytes.append(f);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut float64(double d) {
            this.prependSeparator();
            QueryWire.this.bytes.append(d);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut time(@NotNull LocalTime localTime) {
            this.prependSeparator();
            QueryWire.this.bytes.appendUtf8((CharSequence)localTime.toString());
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut zonedDateTime(@NotNull ZonedDateTime zonedDateTime) {
            this.prependSeparator();
            QueryWire.this.bytes.appendUtf8((CharSequence)zonedDateTime.toString());
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut date(@NotNull LocalDate localDate) {
            this.prependSeparator();
            QueryWire.this.bytes.appendUtf8((CharSequence)localDate.toString());
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public ValueOut typePrefix(@NotNull CharSequence typeName) {
            this.prependSeparator();
            QueryWire.this.bytes.appendUtf8(typeName);
            this.sep = " ";
            return this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull CharSequence type) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull BiConsumer<Class, Bytes> typeTranslator, @NotNull Class type) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireOut uuid(@NotNull UUID uuid) {
            this.prependSeparator();
            ((Bytes)QueryWire.this.bytes.appendUtf8((CharSequence)this.sep)).appendUtf8((CharSequence)uuid.toString());
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value, IntValue intValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value, LongValue longValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireOut sequence(@NotNull Consumer<ValueOut> writer) {
            this.prependSeparator();
            this.pushState();
            QueryWire.this.bytes.appendUtf8((CharSequence)"[");
            this.sep = ",";
            long pos = QueryWire.this.bytes.writePosition();
            writer.accept(this);
            if (pos != QueryWire.this.bytes.writePosition()) {
                QueryWire.this.bytes.appendUtf8((CharSequence)",");
            }
            this.popState();
            QueryWire.this.bytes.appendUtf8((CharSequence)"]");
            this.elementSeparator();
            return QueryWire.this;
        }

        private void popState() {
        }

        private void pushState() {
        }

        @Override
        @NotNull
        public WireOut marshallable(@NotNull WriteMarshallable object) {
            this.pushState();
            this.prependSeparator();
            QueryWire.this.bytes.appendUtf8((CharSequence)"{");
            this.sep = ",";
            object.writeMarshallable(QueryWire.this);
            this.popState();
            QueryWire.this.bytes.appendUtf8(125);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public WireOut map(@NotNull Map map) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public WireOut typedMap(@NotNull Map<? extends WriteMarshallable, ? extends Marshallable> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public ValueOut write() {
            ((Bytes)QueryWire.this.bytes.appendUtf8((CharSequence)this.sep)).appendUtf8((CharSequence)"\"\": ");
            this.sep = "";
            return this;
        }

        @Override
        @NotNull
        public ValueOut write(@NotNull WireKey key) {
            this.fieldName = key.name();
            return this;
        }
    }

    static enum QueryStopCharTesters implements StopCharTester
    {
        QUERY_FIELD_NAME{

            public boolean isStopChar(int ch) throws IllegalStateException {
                return ch == 38 || ch == 61 || ch < 0;
            }
        }
        ,
        QUERY_VALUE{

            public boolean isStopChar(int ch) throws IllegalStateException {
                return ch == 38 || ch < 0;
            }
        };

    }
}

