/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.nio.BufferUnderflowException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.util.BooleanConsumer;
import net.openhft.chronicle.core.util.ObjBooleanConsumer;
import net.openhft.chronicle.core.util.ObjByteConsumer;
import net.openhft.chronicle.core.util.ObjFloatConsumer;
import net.openhft.chronicle.core.util.ObjShortConsumer;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.BinaryIntReference;
import net.openhft.chronicle.wire.BinaryLongArrayReference;
import net.openhft.chronicle.wire.BinaryLongReference;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.InternalWire;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ReadDocumentContext;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteDocumentContext;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.WriteValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RawWire
implements Wire,
InternalWire {
    private final Bytes bytes;
    private final RawValueOut valueOut = new RawValueOut();
    private final RawValueIn valueIn = new RawValueIn();
    private final WriteDocumentContext writeContext = new WriteDocumentContext(this);
    private final ReadDocumentContext readContext = new ReadDocumentContext(this);
    boolean use8bit;
    @Nullable
    private StringBuilder lastSB;
    private boolean ready;

    public RawWire(Bytes bytes) {
        this(bytes, true);
    }

    public RawWire(Bytes bytes, boolean use8bit) {
        this.bytes = bytes;
        this.use8bit = use8bit;
    }

    @Override
    public DocumentContext writingDocument(boolean metaData) {
        this.writeContext.start(metaData);
        return this.writeContext;
    }

    @Override
    public DocumentContext readingDocument() {
        this.readContext.start();
        return this.readContext;
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }

    @Override
    public void setReady(boolean ready) {
        this.ready = ready;
    }

    @Override
    public void copyTo(@NotNull WireOut wire) {
        if (!(wire instanceof RawWire)) {
            throw new UnsupportedOperationException("Can only copy Raw Wire format to the same format.");
        }
        wire.bytes().write((BytesStore)this.bytes);
    }

    @Override
    @NotNull
    public ValueIn read() {
        this.lastSB = null;
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        this.lastSB = null;
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn readEventName(@NotNull StringBuilder name) {
        if (this.use8bit) {
            this.bytes.read8bit(name);
        } else {
            this.bytes.readUtf8((Appendable)name);
        }
        this.lastSB = null;
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        this.lastSB = name;
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn getValueIn() {
        return this.valueIn;
    }

    @Override
    @NotNull
    public Wire readComment(@NotNull StringBuilder sb) {
        return this;
    }

    @Override
    public void clear() {
        this.bytes.clear();
    }

    @NotNull
    public Bytes bytes() {
        return this.bytes;
    }

    @Override
    public boolean hasMore() {
        return this.bytes.readRemaining() > 0L;
    }

    @Override
    @NotNull
    public WireIn readAlignTo(int alignment) {
        long mod = this.bytes.readPosition() % (long)alignment;
        this.bytes.readSkip(mod);
        return this;
    }

    public String toString() {
        return this.bytes.toString();
    }

    @Override
    @NotNull
    public ValueOut write() {
        return this.valueOut;
    }

    @Override
    @NotNull
    public ValueOut writeEventName(@NotNull WireKey key) {
        if (this.use8bit) {
            this.bytes.write8bit(key.name());
        } else {
            this.bytes.writeUtf8(key.name());
        }
        return this.valueOut;
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull WireKey key) {
        return this.valueOut;
    }

    @Override
    @NotNull
    public ValueOut getValueOut() {
        return this.valueOut;
    }

    @Override
    @NotNull
    public Wire writeComment(CharSequence s) {
        return this;
    }

    @Override
    @NotNull
    public WireOut addPadding(int paddingToAdd) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public LongValue newLongReference() {
        return new BinaryLongReference();
    }

    @Override
    @NotNull
    public IntValue newIntReference() {
        return new BinaryIntReference();
    }

    @Override
    @NotNull
    public BinaryLongArrayReference newLongArrayReference() {
        return new BinaryLongArrayReference();
    }

    class RawValueIn
    implements ValueIn {
        RawValueIn() {
        }

        @Override
        @NotNull
        public <T> WireIn bool(T t, @NotNull ObjBooleanConsumer<T> flag) {
            int b = RawWire.this.bytes.readUnsignedByte();
            if (b == 187) {
                flag.accept(t, null);
            } else if (b == 0 || b == 176) {
                flag.accept(t, Boolean.valueOf(false));
            } else {
                flag.accept(t, Boolean.valueOf(true));
            }
            return RawWire.this;
        }

        @Override
        public boolean isTyped() {
            return false;
        }

        @Override
        public Class typePrefix() {
            return Object.class;
        }

        @Override
        @Nullable
        public String text() {
            return RawWire.this.use8bit ? RawWire.this.bytes.readUtf8() : RawWire.this.bytes.read8bit();
        }

        @Override
        @Nullable
        public StringBuilder textTo(@NotNull StringBuilder s) {
            if (RawWire.this.use8bit) {
                return RawWire.this.bytes.read8bit(s) ? s : null;
            }
            return RawWire.this.bytes.readUtf8((Appendable)s) ? s : null;
        }

        @Override
        @Nullable
        public Bytes textTo(@NotNull Bytes s) {
            if (RawWire.this.use8bit) {
                return RawWire.this.bytes.read8bit(s) ? s : null;
            }
            return RawWire.this.bytes.readUtf8((Appendable)s) ? s : null;
        }

        @NotNull
        public WireIn bytes(@NotNull Bytes toBytes) {
            toBytes.clear();
            long length = this.readLength();
            Bytes<?> bytes = this.wireIn().bytes();
            toBytes.write(bytes, bytes.readPosition(), length);
            bytes.readSkip(length);
            return this.wireIn();
        }

        @Override
        @NotNull
        public WireIn bytesMatch(@NotNull BytesStore compareBytes, @NotNull BooleanConsumer consumer) {
            long length = this.readLength();
            Bytes<?> bytes = this.wireIn().bytes();
            if (length == compareBytes.readRemaining()) {
                consumer.accept(Boolean.valueOf(bytes.equalBytes(compareBytes, length)));
            } else {
                consumer.accept(Boolean.valueOf(false));
            }
            bytes.readSkip(length);
            return this.wireIn();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public WireIn bytes(@NotNull ReadMarshallable bytesConsumer) {
            long length = this.readLength();
            if (length > RawWire.this.bytes.readRemaining()) {
                throw new BufferUnderflowException();
            }
            long limit0 = RawWire.this.bytes.readLimit();
            long limit = RawWire.this.bytes.readPosition() + length;
            try {
                RawWire.this.bytes.readLimit(limit);
                bytesConsumer.readMarshallable(this.wireIn());
            }
            finally {
                RawWire.this.bytes.readLimit(limit0);
                RawWire.this.bytes.readPosition(limit);
            }
            return this.wireIn();
        }

        @Override
        @NotNull
        public byte[] bytes() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireIn wireIn() {
            return RawWire.this;
        }

        @Override
        public long readLength() {
            return RawWire.this.bytes.readStopBit();
        }

        @Override
        @NotNull
        public <T> WireIn int8(@NotNull T t, @NotNull ObjByteConsumer<T> tb) {
            tb.accept(t, RawWire.this.bytes.readByte());
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint8(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            ti.accept(t, (short)RawWire.this.bytes.readUnsignedByte());
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int16(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            ti.accept(t, RawWire.this.bytes.readShort());
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint16(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            ti.accept(t, RawWire.this.bytes.readUnsignedShort());
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int32(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            ti.accept(t, RawWire.this.bytes.readInt());
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint32(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            tl.accept(t, RawWire.this.bytes.readUnsignedInt());
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            tl.accept(t, RawWire.this.bytes.readLong());
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn float32(@NotNull T t, @NotNull ObjFloatConsumer<T> tf) {
            tf.accept(t, RawWire.this.bytes.readFloat());
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn float64(@NotNull T t, @NotNull ObjDoubleConsumer<T> td) {
            td.accept(t, RawWire.this.bytes.readDouble());
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn time(@NotNull T t, @NotNull BiConsumer<T, LocalTime> setLocalTime) {
            setLocalTime.accept(t, LocalTime.ofNanoOfDay(RawWire.this.bytes.readLong()));
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn zonedDateTime(@NotNull T t, @NotNull BiConsumer<T, ZonedDateTime> tZonedDateTime) {
            tZonedDateTime.accept(t, ZonedDateTime.parse(RawWire.this.bytes.readUtf8()));
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn date(@NotNull T t, @NotNull BiConsumer<T, LocalDate> tLocalDate) {
            tLocalDate.accept(t, LocalDate.ofEpochDay(RawWire.this.bytes.readStopBit()));
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uuid(@NotNull T t, @NotNull BiConsumer<T, UUID> tuuid) {
            tuuid.accept(t, new UUID(RawWire.this.bytes.readLong(), RawWire.this.bytes.readLong()));
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64array(@Nullable LongArrayValues values, T t, @NotNull BiConsumer<T, LongArrayValues> setter) {
            if (!(values instanceof Byteable)) {
                values = new BinaryLongArrayReference();
            }
            Byteable b = (Byteable)values;
            long length = b.maxSize();
            b.bytesStore((BytesStore)RawWire.this.bytes, RawWire.this.bytes.readPosition(), length);
            RawWire.this.bytes.readSkip(length);
            setter.accept(t, values);
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64(@Nullable LongValue value, T t, @NotNull BiConsumer<T, LongValue> setter) {
            if (!(value instanceof Byteable) || ((Byteable)value).maxSize() != 8L) {
                value = new BinaryLongReference();
                setter.accept(t, value);
            }
            return this.int64(value);
        }

        @Override
        @NotNull
        public WireIn int64(@Nullable LongValue value) {
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)RawWire.this.bytes, RawWire.this.bytes.readPosition(), length);
            RawWire.this.bytes.readSkip(length);
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int32(@Nullable IntValue value, T t, @NotNull BiConsumer<T, IntValue> setter) {
            if (!(value instanceof Byteable) || ((Byteable)value).maxSize() != 8L) {
                value = new BinaryIntReference();
                setter.accept(t, value);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)RawWire.this.bytes, RawWire.this.bytes.readPosition(), length);
            RawWire.this.bytes.readSkip(length);
            return RawWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn sequence(@NotNull T t, @NotNull BiConsumer<T, ValueIn> tReader) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public <T> ValueIn typePrefix(T t, @NotNull BiConsumer<T, CharSequence> ts) {
            StringBuilder sb = WireInternal.acquireStringBuilder();
            RawWire.this.bytes.readUtf8((Appendable)sb);
            ts.accept(t, sb);
            return this;
        }

        @Override
        @NotNull
        public <T> WireIn typeLiteralAsText(T t, @NotNull BiConsumer<T, CharSequence> classNameConsumer) {
            StringBuilder sb = WireInternal.acquireStringBuilder();
            RawWire.this.bytes.readUtf8((Appendable)sb);
            classNameConsumer.accept(t, sb);
            return RawWire.this;
        }

        @Override
        public <T> Class<T> typeLiteral() {
            StringBuilder sb = WireInternal.acquireStringBuilder();
            RawWire.this.bytes.readUtf8((Appendable)sb);
            try {
                return ClassAliasPool.CLASS_ALIASES.forName((CharSequence)sb);
            }
            catch (ClassNotFoundException e) {
                throw new IORuntimeException((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T applyToMarshallable(@NotNull Function<WireIn, T> marshallableReader) {
            this.textTo(RawWire.this.lastSB);
            long length = RawWire.this.bytes.readUnsignedInt();
            if (length >= 0L) {
                long limit = RawWire.this.bytes.readLimit();
                long limit2 = RawWire.this.bytes.readPosition() + length;
                RawWire.this.bytes.readLimit(limit2);
                try {
                    T t = marshallableReader.apply(RawWire.this);
                    return t;
                }
                finally {
                    RawWire.this.bytes.readLimit(limit);
                    RawWire.this.bytes.readPosition(limit2);
                }
            }
            return marshallableReader.apply(RawWire.this);
        }

        @Override
        @Nullable
        public <T extends ReadMarshallable> T typedMarshallable() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public boolean hasNext() {
            return RawWire.this.bytes.readRemaining() > 0L;
        }

        @Override
        public boolean hasNextSequenceItem() {
            throw new UnsupportedOperationException("todo");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public WireIn marshallable(@NotNull ReadMarshallable object) {
            long length = RawWire.this.bytes.readUnsignedInt();
            if (length > RawWire.this.bytes.readRemaining()) {
                throw new IllegalStateException("Length was " + length + " greater than remaining " + RawWire.this.bytes.readRemaining());
            }
            if (length >= 0L) {
                long limit = RawWire.this.bytes.readLimit();
                long limit2 = RawWire.this.bytes.readPosition() + length;
                RawWire.this.bytes.readLimit(limit2);
                try {
                    object.readMarshallable(RawWire.this);
                }
                finally {
                    RawWire.this.bytes.readLimit(limit);
                    RawWire.this.bytes.readPosition(limit2);
                }
            } else {
                object.readMarshallable(RawWire.this);
            }
            return RawWire.this;
        }

        @Override
        public <K extends ReadMarshallable, V extends ReadMarshallable> void typedMap(@NotNull Map<K, V> usingMap) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public <K, V> Map<K, V> map(@NotNull Class<K> kClazz, @NotNull Class<V> vClass, @NotNull Map<K, V> usingMap) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public boolean bool() {
            return RawWire.this.bytes.readBoolean();
        }

        @Override
        public byte int8() {
            return RawWire.this.bytes.readByte();
        }

        @Override
        public short int16() {
            return RawWire.this.bytes.readShort();
        }

        @Override
        public int uint16() {
            return RawWire.this.bytes.readUnsignedShort();
        }

        @Override
        public int int32() {
            return RawWire.this.bytes.readInt();
        }

        @Override
        public long int64() {
            return RawWire.this.bytes.readLong();
        }

        @Override
        public double float64() {
            return RawWire.this.bytes.readDouble();
        }

        @Override
        public float float32() {
            return RawWire.this.bytes.readFloat();
        }

        @Override
        @Nullable
        public <E> E object(@Nullable E using, @NotNull Class<E> clazz) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @Nullable
        public <T, E> WireIn object(@NotNull Class<E> clazz, T t, BiConsumer<T, E> e) {
            throw new UnsupportedOperationException("todo");
        }
    }

    class RawValueOut
    implements ValueOut {
        RawValueOut() {
        }

        @Override
        @NotNull
        public ValueOut leaf() {
            return this;
        }

        @Override
        @NotNull
        public WireOut bool(@Nullable Boolean flag) {
            if (flag == null) {
                RawWire.this.bytes.writeUnsignedByte(187);
            } else {
                RawWire.this.bytes.writeUnsignedByte(flag != false ? 177 : 0);
            }
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut text(@Nullable CharSequence s) {
            if (RawWire.this.use8bit) {
                RawWire.this.bytes.write8bit(s);
            } else {
                RawWire.this.bytes.writeUtf8(s);
            }
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut text(@Nullable BytesStore s) {
            if (RawWire.this.use8bit) {
                RawWire.this.bytes.write8bit(s);
            } else {
                RawWire.this.bytes.writeUtf8((CharSequence)s);
            }
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut int8(byte i8) {
            RawWire.this.bytes.writeByte(i8);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(@Nullable BytesStore bytesStore) {
            if (bytesStore == null) {
                this.writeLength(-1L);
            } else {
                this.writeLength(bytesStore.readRemaining());
                RawWire.this.bytes.write(bytesStore);
            }
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(String type, byte[] bytesArr) {
            this.typePrefix(type);
            return this.bytes(bytesArr);
        }

        @Override
        @NotNull
        public WireOut bytes(String type, @Nullable BytesStore fromBytes) {
            this.typePrefix(type);
            return this.bytes(fromBytes);
        }

        @Override
        @NotNull
        public WireOut rawBytes(byte[] value) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public ValueOut writeLength(long length) {
            RawWire.this.bytes.writeStopBit(length);
            return this;
        }

        @Override
        @NotNull
        public WireOut bytes(@NotNull byte[] fromBytes) {
            this.writeLength(fromBytes.length);
            RawWire.this.bytes.write(fromBytes);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut uint8checked(int u8) {
            RawWire.this.bytes.writeUnsignedByte(u8);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut int16(short i16) {
            RawWire.this.bytes.writeShort(i16);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut uint16checked(int u16) {
            RawWire.this.bytes.writeUnsignedShort(u16);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut utf8(int codepoint) {
            RawWire.this.bytes.appendUtf8(codepoint);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut int32(int i32) {
            RawWire.this.bytes.writeInt(i32);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut uint32checked(long u32) {
            RawWire.this.bytes.writeUnsignedInt(u32);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut int64(long i64) {
            RawWire.this.bytes.writeLong(i64);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity) {
            BinaryLongArrayReference.lazyWrite(RawWire.this.bytes, capacity);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity, @NotNull LongArrayValues values) {
            long pos = RawWire.this.bytes.writePosition();
            BinaryLongArrayReference.lazyWrite(RawWire.this.bytes, capacity);
            ((Byteable)values).bytesStore((BytesStore)RawWire.this.bytes, pos, RawWire.this.bytes.writePosition() - pos);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut float32(float f) {
            RawWire.this.bytes.writeFloat(f);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut float64(double d) {
            RawWire.this.bytes.writeDouble(d);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut time(@NotNull LocalTime localTime) {
            long t = localTime.toNanoOfDay();
            RawWire.this.bytes.writeLong(t);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut zonedDateTime(@NotNull ZonedDateTime zonedDateTime) {
            if (RawWire.this.use8bit) {
                RawWire.this.bytes.write8bit(zonedDateTime.toString());
            } else {
                RawWire.this.bytes.writeUtf8((CharSequence)zonedDateTime.toString());
            }
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut date(@NotNull LocalDate localDate) {
            RawWire.this.bytes.writeStopBit(localDate.toEpochDay());
            return RawWire.this;
        }

        @Override
        @NotNull
        public ValueOut typePrefix(CharSequence typeName) {
            RawWire.this.bytes.writeUtf8(typeName);
            return this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull CharSequence type) {
            RawWire.this.bytes.writeUtf8(type);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull BiConsumer<Class, Bytes> typeTranslator, @NotNull Class type) {
            long position = RawWire.this.bytes.writePosition();
            RawWire.this.bytes.writeSkip(1L);
            typeTranslator.accept(type, RawWire.this.bytes);
            RawWire.this.bytes.writeUnsignedByte(position, (int)Maths.toInt8((long)(RawWire.this.bytes.writePosition() - position - 1L)));
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut uuid(@NotNull UUID uuid) {
            RawWire.this.bytes.writeLong(uuid.getMostSignificantBits());
            RawWire.this.bytes.writeLong(uuid.getLeastSignificantBits());
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value) {
            RawWire.this.bytes.writeInt(value);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value) {
            RawWire.this.bytes.writeLong(value);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value, @NotNull IntValue intValue) {
            this.int32forBinding(value);
            ((BinaryIntReference)intValue).bytesStore((BytesStore)RawWire.this.bytes, RawWire.this.bytes.writePosition() - 4L, 4L);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value, @NotNull LongValue longValue) {
            this.int64forBinding(value);
            ((BinaryLongReference)longValue).bytesStore((BytesStore)RawWire.this.bytes, RawWire.this.bytes.writePosition() - 8L, 8L);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut sequence(@NotNull WriteValue writer) {
            long position = RawWire.this.bytes.writePosition();
            RawWire.this.bytes.writeInt(0);
            writer.writeValue(this);
            RawWire.this.bytes.writeOrderedInt(position, Maths.toInt32((long)(RawWire.this.bytes.writePosition() - position - 4L), (String)"Document length %,d out of 32-bit int range."));
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut marshallable(@NotNull WriteMarshallable object) {
            long position = RawWire.this.bytes.writePosition();
            RawWire.this.bytes.writeInt(0);
            object.writeMarshallable(RawWire.this);
            int length = Maths.toInt32((long)(RawWire.this.bytes.writePosition() - position - 4L), (String)"Document length %,d out of 32-bit int range.");
            RawWire.this.bytes.writeOrderedInt(position, length);
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut map(Map map) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireOut typedMap(@NotNull Map<? extends WriteMarshallable, ? extends Marshallable> map) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireOut object(@Nullable Object o) {
            RawWire.this.bytes.writeUtf8((CharSequence)(o == null ? null : o.toString()));
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireOut wireOut() {
            return RawWire.this;
        }
    }
}

