/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.nio.BufferUnderflowException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.BinaryLongArrayReference;
import net.openhft.chronicle.wire.BinaryLongReference;
import net.openhft.chronicle.wire.IntBinaryReference;
import net.openhft.chronicle.wire.InternalWireIn;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.util.BooleanConsumer;
import net.openhft.chronicle.wire.util.ByteConsumer;
import net.openhft.chronicle.wire.util.FloatConsumer;
import net.openhft.chronicle.wire.util.ShortConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RawWire
implements Wire,
InternalWireIn {
    final Bytes bytes;
    final RawValueOut valueOut = new RawValueOut();
    final RawValueIn valueIn = new RawValueIn();
    String lastField = "";
    StringBuilder lastSB;
    boolean ready;

    public RawWire(Bytes bytes) {
        this.bytes = bytes;
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }

    @Override
    public void setReady(boolean ready) {
        this.ready = ready;
    }

    @Override
    public void copyTo(@NotNull WireOut wire) {
        if (!(wire instanceof RawWire)) {
            throw new UnsupportedOperationException("Can only copy Raw Wire format to the same format.");
        }
        wire.bytes().write(this.bytes);
    }

    @Override
    public ValueIn read() {
        this.lastSB = null;
        return this.valueIn;
    }

    @Override
    public ValueIn read(@NotNull WireKey key) {
        this.lastSB = null;
        return this.valueIn;
    }

    @Override
    public ValueIn readEventName(@NotNull StringBuilder name) {
        this.bytes.readUTF\u0394((Appendable)name);
        this.lastSB = null;
        return this.valueIn;
    }

    @Override
    public ValueIn read(@NotNull StringBuilder name) {
        this.lastSB = name;
        return this.valueIn;
    }

    @Override
    public ValueIn getValueIn() {
        return this.valueIn;
    }

    @Override
    public Wire readComment(@NotNull StringBuilder sb) {
        return this;
    }

    @Override
    public void flip() {
        this.bytes.flip();
    }

    @Override
    public void clear() {
        this.bytes.clear();
    }

    @Override
    public Bytes bytes() {
        return this.bytes;
    }

    public String toString() {
        return this.bytes.toString();
    }

    @Override
    public ValueOut write() {
        this.lastField = "";
        return this.valueOut;
    }

    @Override
    public ValueOut writeEventName(WireKey key) {
        this.lastField = "";
        this.bytes.writeUTF\u0394(key.name());
        return this.valueOut;
    }

    @Override
    public ValueOut write(WireKey key) {
        this.lastField = key.name().toString();
        return this.valueOut;
    }

    @Override
    public ValueOut writeValue() {
        this.lastField = "";
        return this.valueOut;
    }

    @Override
    public ValueOut getValueOut() {
        return this.valueOut;
    }

    @Override
    public Wire writeComment(CharSequence s) {
        return this;
    }

    @Override
    public boolean hasDocument() {
        return false;
    }

    @Override
    public WireOut addPadding(int paddingToAdd) {
        throw new UnsupportedOperationException();
    }

    class RawValueIn
    implements ValueIn {
        RawValueIn() {
        }

        @Override
        @NotNull
        public Wire bool(@NotNull BooleanConsumer flag) {
            int b = RawWire.this.bytes.readUnsignedByte();
            if (b == 187) {
                flag.accept(null);
            } else if (b == 0 || b == 176) {
                flag.accept(false);
            } else {
                flag.accept(true);
            }
            return RawWire.this;
        }

        @Override
        @NotNull
        public WireIn text(@NotNull Consumer<String> s) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public <ACS extends Appendable & CharSequence> WireIn text(@NotNull ACS s) {
            RawWire.this.bytes.readUTF\u0394(s);
            return RawWire.this;
        }

        @Override
        @NotNull
        public Wire int8(@NotNull ByteConsumer i) {
            i.accept(RawWire.this.bytes.readByte());
            return RawWire.this;
        }

        @NotNull
        public WireIn bytes(@NotNull Bytes toBytes) {
            this.wireIn().bytes().withLength(this.readLength(), arg_0 -> ((Bytes)toBytes).write(arg_0));
            return this.wireIn();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public WireIn bytes(@NotNull Consumer<WireIn> bytesConsumer) {
            long length = this.readLength();
            if (length > RawWire.this.bytes.remaining()) {
                throw new BufferUnderflowException();
            }
            long limit0 = RawWire.this.bytes.limit();
            long limit = RawWire.this.bytes.position() + length;
            try {
                RawWire.this.bytes.limit(limit);
                bytesConsumer.accept(this.wireIn());
            }
            finally {
                RawWire.this.bytes.limit(limit0);
                RawWire.this.bytes.position(limit);
            }
            return this.wireIn();
        }

        @Override
        public byte[] bytes() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public WireIn wireIn() {
            return RawWire.this;
        }

        @Override
        public long readLength() {
            return RawWire.this.bytes.readStopBit();
        }

        @Override
        @NotNull
        public Wire uint8(@NotNull ShortConsumer i) {
            i.accept((short)RawWire.this.bytes.readUnsignedByte());
            return RawWire.this;
        }

        @Override
        @NotNull
        public Wire int16(@NotNull ShortConsumer i) {
            i.accept(RawWire.this.bytes.readShort());
            return RawWire.this;
        }

        @Override
        @NotNull
        public Wire uint16(@NotNull IntConsumer i) {
            i.accept(RawWire.this.bytes.readUnsignedShort());
            return RawWire.this;
        }

        @Override
        @NotNull
        public Wire int32(@NotNull IntConsumer i) {
            i.accept(RawWire.this.bytes.readInt());
            return RawWire.this;
        }

        @Override
        @NotNull
        public Wire uint32(@NotNull LongConsumer i) {
            i.accept(RawWire.this.bytes.readUnsignedInt());
            return RawWire.this;
        }

        @Override
        @NotNull
        public Wire int64(@NotNull LongConsumer i) {
            i.accept(RawWire.this.bytes.readLong());
            return RawWire.this;
        }

        @Override
        @NotNull
        public Wire float32(@NotNull FloatConsumer v) {
            v.accept(RawWire.this.bytes.readFloat());
            return RawWire.this;
        }

        @Override
        @NotNull
        public Wire float64(@NotNull DoubleConsumer v) {
            v.accept(RawWire.this.bytes.readDouble());
            return RawWire.this;
        }

        @Override
        @NotNull
        public Wire time(@NotNull Consumer<LocalTime> localTime) {
            localTime.accept(LocalTime.ofNanoOfDay(RawWire.this.bytes.readLong()));
            return RawWire.this;
        }

        @Override
        @NotNull
        public Wire zonedDateTime(@NotNull Consumer<ZonedDateTime> zonedDateTime) {
            zonedDateTime.accept(ZonedDateTime.parse(RawWire.this.bytes.readUTF\u0394()));
            return RawWire.this;
        }

        @Override
        @NotNull
        public Wire date(@NotNull Consumer<LocalDate> localDate) {
            localDate.accept(LocalDate.ofEpochDay(RawWire.this.bytes.readStopBit()));
            return RawWire.this;
        }

        @Override
        public boolean hasNext() {
            return RawWire.this.bytes.remaining() > 0L;
        }

        @Override
        public boolean hasNextSequenceItem() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public WireIn uuid(@NotNull Consumer<UUID> uuid) {
            uuid.accept(new UUID(RawWire.this.bytes.readLong(), RawWire.this.bytes.readLong()));
            return RawWire.this;
        }

        @Override
        public WireIn int64array(@Nullable LongArrayValues values, @NotNull Consumer<LongArrayValues> setter) {
            if (!(values instanceof Byteable)) {
                values = new BinaryLongArrayReference();
                setter.accept(values);
            }
            Byteable b = (Byteable)values;
            long length = b.maxSize();
            b.bytesStore((BytesStore)RawWire.this.bytes, RawWire.this.bytes.position(), length);
            RawWire.this.bytes.skip(length);
            return RawWire.this;
        }

        @Override
        public WireIn int64(LongValue value, @NotNull Consumer<LongValue> setter) {
            if (!(value instanceof Byteable) || ((Byteable)value).maxSize() != 8L) {
                value = new BinaryLongReference();
                setter.accept(value);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)RawWire.this.bytes, RawWire.this.bytes.position(), length);
            RawWire.this.bytes.skip(length);
            return RawWire.this;
        }

        @Override
        public WireIn int32(IntValue value, @NotNull Consumer<IntValue> setter) {
            if (!(value instanceof Byteable) || ((Byteable)value).maxSize() != 8L) {
                value = new IntBinaryReference();
                setter.accept(value);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore((BytesStore)RawWire.this.bytes, RawWire.this.bytes.position(), length);
            RawWire.this.bytes.skip(length);
            return RawWire.this;
        }

        @Override
        public WireIn sequence(@NotNull Consumer<ValueIn> reader) {
            this.text(RawWire.this.lastSB);
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T applyToMarshallable(Function<WireIn, T> marshallableReader) {
            this.text(RawWire.this.lastSB);
            long length = RawWire.this.bytes.readUnsignedInt();
            if (length >= 0L) {
                long limit = RawWire.this.bytes.readLimit();
                long limit2 = RawWire.this.bytes.position() + length;
                RawWire.this.bytes.limit(limit2);
                try {
                    T t = marshallableReader.apply(RawWire.this);
                    return t;
                }
                finally {
                    RawWire.this.bytes.limit(limit);
                    RawWire.this.bytes.position(limit2);
                }
            }
            return marshallableReader.apply(RawWire.this);
        }

        @Override
        @NotNull
        public Wire type(@NotNull StringBuilder s) {
            RawWire.this.bytes.readUTF\u0394((Appendable)s);
            return RawWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public WireIn marshallable(@NotNull ReadMarshallable object) {
            this.text(RawWire.this.lastSB);
            long length = RawWire.this.bytes.readUnsignedInt();
            if (length >= 0L) {
                long limit = RawWire.this.bytes.readLimit();
                long limit2 = RawWire.this.bytes.position() + length;
                RawWire.this.bytes.limit(limit2);
                try {
                    object.readMarshallable(RawWire.this);
                }
                finally {
                    RawWire.this.bytes.limit(limit);
                    RawWire.this.bytes.position(limit2);
                }
            } else {
                object.readMarshallable(RawWire.this);
            }
            return RawWire.this;
        }

        @Override
        public <K extends ReadMarshallable, V extends ReadMarshallable> void typedMap(@NotNull Map<K, V> usingMap) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public <K, V> Map<K, V> map(@NotNull Class<K> kClazz, @NotNull Class<V> vClass, @NotNull Map<K, V> usingMap) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public boolean bool() {
            return RawWire.this.bytes.readBoolean();
        }

        @Override
        public byte int8() {
            return RawWire.this.bytes.readByte();
        }

        @Override
        public short int16() {
            return RawWire.this.bytes.readShort();
        }

        @Override
        public int uint16() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public int int32() {
            return RawWire.this.bytes.readInt();
        }

        @Override
        public long int64() {
            return RawWire.this.bytes.readLong();
        }

        @Override
        public double float64() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public float float32() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public boolean isNull() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public <E> E object(@Nullable E using, @NotNull Class<E> clazz) {
            throw new UnsupportedOperationException("todo");
        }
    }

    class RawValueOut
    implements ValueOut {
        RawValueOut() {
        }

        @Override
        public ValueOut leaf() {
            return this;
        }

        @Override
        public Wire bool(Boolean flag) {
            if (flag == null) {
                RawWire.this.bytes.writeUnsignedByte(187);
            } else {
                RawWire.this.bytes.writeUnsignedByte(flag != false ? 177 : 0);
            }
            return RawWire.this;
        }

        @Override
        public Wire text(CharSequence s) {
            RawWire.this.bytes.writeUTF\u0394(s);
            return RawWire.this;
        }

        @Override
        public Wire int8(byte i8) {
            RawWire.this.bytes.writeByte(i8);
            return RawWire.this;
        }

        @Override
        public WireOut bytes(Bytes fromBytes) {
            this.writeLength(fromBytes.remaining());
            RawWire.this.bytes.write(fromBytes);
            return RawWire.this;
        }

        @Override
        public WireOut rawBytes(byte[] value) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public ValueOut writeLength(long length) {
            RawWire.this.bytes.writeStopBit(length);
            return this;
        }

        @Override
        public WireOut bytes(byte[] fromBytes) {
            this.writeLength(fromBytes.length);
            RawWire.this.bytes.write(fromBytes);
            return RawWire.this;
        }

        @Override
        public Wire uint8checked(int u8) {
            RawWire.this.bytes.writeUnsignedByte(u8);
            return RawWire.this;
        }

        @Override
        public Wire int16(short i16) {
            RawWire.this.bytes.writeShort(i16);
            return RawWire.this;
        }

        @Override
        public Wire uint16checked(int u16) {
            RawWire.this.bytes.writeUnsignedShort(u16);
            return RawWire.this;
        }

        @Override
        public Wire utf8(int codepoint) {
            BytesUtil.appendUTF((StreamingDataOutput)RawWire.this.bytes, (int)codepoint);
            return RawWire.this;
        }

        @Override
        public Wire int32(int i32) {
            RawWire.this.bytes.writeInt(i32);
            return RawWire.this;
        }

        @Override
        public Wire uint32checked(long u32) {
            RawWire.this.bytes.writeUnsignedInt(u32);
            return RawWire.this;
        }

        @Override
        public Wire int64(long i64) {
            RawWire.this.bytes.writeLong(i64);
            return RawWire.this;
        }

        @Override
        public WireOut int64array(long capacity) {
            BinaryLongArrayReference.lazyWrite(RawWire.this.bytes, capacity);
            return RawWire.this;
        }

        @Override
        public Wire float32(float f) {
            RawWire.this.bytes.writeFloat(f);
            return RawWire.this;
        }

        @Override
        public Wire float64(double d) {
            RawWire.this.bytes.writeDouble(d);
            return RawWire.this;
        }

        @Override
        public Wire time(LocalTime localTime) {
            long t = localTime.toNanoOfDay();
            RawWire.this.bytes.writeLong(t);
            return RawWire.this;
        }

        @Override
        public Wire zonedDateTime(ZonedDateTime zonedDateTime) {
            RawWire.this.bytes.writeUTF\u0394((CharSequence)zonedDateTime.toString());
            return RawWire.this;
        }

        @Override
        public Wire date(LocalDate localDate) {
            RawWire.this.bytes.writeStopBit(localDate.toEpochDay());
            return RawWire.this;
        }

        @Override
        public Wire type(CharSequence typeName) {
            RawWire.this.bytes.writeUTF\u0394(typeName);
            return RawWire.this;
        }

        @Override
        public WireOut uuid(UUID uuid) {
            RawWire.this.bytes.writeLong(uuid.getMostSignificantBits());
            RawWire.this.bytes.writeLong(uuid.getLeastSignificantBits());
            return RawWire.this;
        }

        @Override
        public WireOut int32forBinding(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public WireOut int64forBinding(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public WireOut sequence(Consumer<ValueOut> writer) {
            this.text(RawWire.this.lastField);
            long position = RawWire.this.bytes.position();
            RawWire.this.bytes.writeInt(0);
            writer.accept(this);
            RawWire.this.bytes.writeOrderedInt(position, Maths.toInt32((long)(RawWire.this.bytes.position() - position - 4L), (String)"Document length %,d out of 32-bit int range."));
            return RawWire.this;
        }

        @Override
        public WireOut marshallable(WriteMarshallable object) {
            this.text(RawWire.this.lastField);
            long position = RawWire.this.bytes.position();
            RawWire.this.bytes.writeInt(0);
            object.writeMarshallable(RawWire.this);
            RawWire.this.bytes.writeOrderedInt(position, Maths.toInt32((long)(RawWire.this.bytes.position() - position - 4L), (String)"Document length %,d out of 32-bit int range."));
            return RawWire.this;
        }

        @Override
        public WireOut map(Map map) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public WireOut typedMap(@NotNull Map<? extends WriteMarshallable, ? extends Marshallable> map) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public WireOut object(Object o) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public WireOut wireOut() {
            return RawWire.this;
        }
    }
}

