/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionMarshaller
implements Marshallable {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionMarshaller.class);
    private final Exception exception;

    public ExceptionMarshaller(Exception throwable) {
        this.exception = throwable;
    }

    public ExceptionMarshaller() {
        this.exception = null;
    }

    @Override
    public void readMarshallable(WireIn wireIn) throws IllegalStateException {
        Throwable exception;
        Class<?> aClass;
        StringBuilder type = Wires.acquireStringBuilder();
        wireIn.getValueIn().type(type);
        try {
            aClass = Class.forName(type.toString());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("unable to load an class of class=" + type.toString());
        }
        try {
            exception = (Throwable)UnsafeMemory.MEMORY.allocateInstance(aClass);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("unable to allocated a class=" + aClass);
        }
        wireIn.getValueIn().marshallable(m -> {
            String message = m.read(() -> "message").text();
            if (message != null) {
                Field messageField = null;
                try {
                    messageField = Exception.class.getDeclaredField("detailMessage");
                    messageField.set(exception, message);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    LOG.error("", (Throwable)e);
                }
            }
        });
        try {
            ValueIn stackTrace = wireIn.getValueIn();
            ArrayList<StackTraceElement> stes = new ArrayList<StackTraceElement>();
            while (stackTrace.hasNextSequenceItem()) {
                stackTrace.sequence(c -> c.marshallable(r -> {
                    String declaringClass = r.read(() -> "class").text();
                    String methodName = r.read(() -> "method").text();
                    String fileName = r.read(() -> "file").text();
                    int lineNumber = r.read(() -> "lineNumber").int32();
                    stes.add(new StackTraceElement(declaringClass, methodName, fileName, lineNumber));
                }));
            }
            stes.add(new StackTraceElement("~ remote", "tcp ~", "", 0));
            StackTraceElement[] stackTrace2 = Thread.currentThread().getStackTrace();
            for (int i = 4; i < stackTrace2.length; ++i) {
                stes.add(stackTrace2[i]);
            }
            Field stackTraceField = Throwable.class.getDeclaredField("stackTrace");
            stackTraceField.setAccessible(true);
            stackTraceField.set(exception, stes.toArray(new StackTraceElement[stes.size()]));
            Jvm.rethrow((Throwable)exception);
        }
        catch (Exception e) {
            Jvm.rethrow((Throwable)e);
        }
    }

    @Override
    public void writeMarshallable(WireOut wireOut) {
        ValueOut valueOut0 = wireOut.getValueOut();
        valueOut0.type(this.exception.getClass().getName());
        valueOut0.marshallable(w -> w.write(() -> "message").text(this.exception.getMessage()));
        try {
            this.writeStackTraceElement(this.exception, valueOut0);
        }
        catch (Exception ignore) {
            LOG.error("", (Throwable)ignore);
        }
    }

    private void writeStackTraceElement(Exception e, ValueOut target) throws NoSuchFieldException, IllegalAccessException {
        LOG.info("", (Throwable)e);
        Field stackTrace = Throwable.class.getDeclaredField("stackTrace");
        stackTrace.setAccessible(true);
        ArrayList<StackTraceElement> stes = new ArrayList<StackTraceElement>(Arrays.asList((StackTraceElement[])stackTrace.get(e)));
        for (int i = stes.size() - 1; i > 0 && ((StackTraceElement)stes.get(i)).getClassName().startsWith("Thread"); --i) {
            stes.remove(i);
        }
        for (StackTraceElement element : stes) {
            target.sequence(s -> s.marshallable(se -> {
                for (String[] f : new String[][]{{"declaringClass", "class"}, {"methodName", "method"}, {"fileName", "file"}}) {
                    try {
                        Field field = StackTraceElement.class.getDeclaredField(f[0]);
                        field.setAccessible(true);
                        se.write(() -> f[1]).text((String)field.get(element));
                    }
                    catch (Exception e1) {
                        LOG.error("", (Throwable)e1);
                    }
                }
                try {
                    Field field = StackTraceElement.class.getDeclaredField("lineNumber");
                    field.setAccessible(true);
                    se.write(() -> "lineNumber").int32(field.getInt(element));
                }
                catch (Exception e2) {
                    LOG.error("", (Throwable)e2);
                }
            }));
        }
    }
}

