/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.map;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.wire.CoreFields;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireHandlers;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.map.MapWireHandler;
import net.openhft.chronicle.wire.util.ExceptionMarshaller;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapWireHandlerProcessor<K, V>
implements MapWireHandler<K, V>,
Consumer<WireHandlers> {
    public static boolean IS_DEBUG = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");
    private CharSequence csp;
    private BiConsumer<ValueOut, V> vToWire;
    private Function<ValueIn, K> wireToK;
    private Function<ValueIn, V> wireToV;
    private static final Logger LOG = LoggerFactory.getLogger(MapWireHandlerProcessor.class);
    public static final int SIZE_OF_SIZE = 2;
    private final Map<Long, String> cidToCsp;
    @NotNull
    private final Map<String, Long> cspToCid = new HashMap<String, Long>();
    private Wire inWire = null;
    private Wire outWire = null;
    private final Consumer<WireIn> metaDataConsumer = new Consumer<WireIn>(){

        @Override
        public void accept(WireIn wireIn) {
            ValueIn read;
            StringBuilder sb = Wires.acquireStringBuilder();
            do {
                read = MapWireHandlerProcessor.this.inWire.read(sb);
            } while (!CoreFields.tid.contentEquals(sb));
            MapWireHandlerProcessor.this.tid = read.int64();
        }
    };
    private Map<K, V> map;
    public long tid;
    private final AtomicLong cid = new AtomicLong();
    final StringBuilder eventName = new StringBuilder();
    private final Consumer<WireIn> dataConsumer = new Consumer<WireIn>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(WireIn wireIn) {
            Bytes<?> outBytes = MapWireHandlerProcessor.this.outWire.bytes();
            try {
                ValueIn valueIn = MapWireHandlerProcessor.this.inWire.readEventName(MapWireHandlerProcessor.this.eventName);
                MapWireHandlerProcessor.this.outWire.writeDocument(true, wire -> MapWireHandlerProcessor.this.outWire.write(CoreFields.tid).int64(MapWireHandlerProcessor.this.tid));
                MapWireHandlerProcessor.this.writeData(out -> {
                    if (EventId.clear.contentEquals(MapWireHandlerProcessor.this.eventName)) {
                        MapWireHandlerProcessor.this.map.clear();
                        return;
                    }
                    if (EventId.putAll.contentEquals(MapWireHandlerProcessor.this.eventName)) {
                        HashMap data = new HashMap();
                        while (valueIn.hasNext()) {
                            valueIn.sequence(v -> valueIn.marshallable(wire -> data.put(MapWireHandlerProcessor.this.wireToK.apply(wire.read(EventId.put.params()[0])), MapWireHandlerProcessor.this.wireToV.apply(wire.read(EventId.put.params()[1])))));
                        }
                        MapWireHandlerProcessor.this.map.putAll(data);
                        return;
                    }
                    if (EventId.putIfAbsent.contentEquals(MapWireHandlerProcessor.this.eventName)) {
                        valueIn.marshallable(wire -> {
                            Params[] params = (Params[])EventId.putIfAbsent.params();
                            Object key = MapWireHandlerProcessor.this.wireToK.apply(wire.read(params[0]));
                            Object newValue = MapWireHandlerProcessor.this.wireToV.apply(wire.read(params[1]));
                            Object result = MapWireHandlerProcessor.this.map.putIfAbsent(key, newValue);
                            MapWireHandlerProcessor.this.nullCheck(key);
                            MapWireHandlerProcessor.this.nullCheck(newValue);
                            MapWireHandlerProcessor.this.vToWire.accept(MapWireHandlerProcessor.this.outWire.writeEventName(CoreFields.reply), result);
                        });
                        return;
                    }
                    if (EventId.size.contentEquals(MapWireHandlerProcessor.this.eventName)) {
                        MapWireHandlerProcessor.this.outWire.writeEventName(CoreFields.reply).int64(MapWireHandlerProcessor.this.map.size());
                        return;
                    }
                    if (EventId.keySet.contentEquals(MapWireHandlerProcessor.this.eventName) || EventId.values.contentEquals(MapWireHandlerProcessor.this.eventName) || EventId.entrySet.contentEquals(MapWireHandlerProcessor.this.eventName)) {
                        MapWireHandlerProcessor.this.createProxy(MapWireHandlerProcessor.this.eventName.toString());
                        return;
                    }
                    if (EventId.size.contentEquals(MapWireHandlerProcessor.this.eventName)) {
                        MapWireHandlerProcessor.this.outWire.writeEventName(CoreFields.reply).int64(MapWireHandlerProcessor.this.map.size());
                        return;
                    }
                    if (EventId.containsKey.contentEquals(MapWireHandlerProcessor.this.eventName)) {
                        Object key = MapWireHandlerProcessor.this.wireToK.apply(valueIn);
                        MapWireHandlerProcessor.this.nullCheck(key);
                        MapWireHandlerProcessor.this.outWire.writeEventName(CoreFields.reply).bool(MapWireHandlerProcessor.this.map.containsKey(key));
                        return;
                    }
                    if (EventId.containsValue.contentEquals(MapWireHandlerProcessor.this.eventName)) {
                        Object value = MapWireHandlerProcessor.this.wireToV.apply(valueIn);
                        MapWireHandlerProcessor.this.nullCheck(value);
                        MapWireHandlerProcessor.this.outWire.writeEventName(CoreFields.reply).bool(MapWireHandlerProcessor.this.map.containsValue(value));
                        return;
                    }
                    if (EventId.get.contentEquals(MapWireHandlerProcessor.this.eventName)) {
                        Object key = MapWireHandlerProcessor.this.wireToK.apply(valueIn);
                        MapWireHandlerProcessor.this.nullCheck(key);
                        MapWireHandlerProcessor.this.vToWire.accept(MapWireHandlerProcessor.this.outWire.writeEventName(CoreFields.reply), MapWireHandlerProcessor.this.map.get(key));
                        return;
                    }
                    if (EventId.getAndPut.contentEquals(MapWireHandlerProcessor.this.eventName)) {
                        valueIn.marshallable(wire -> {
                            Params[] params = (Params[])EventId.getAndPut.params();
                            Object key = MapWireHandlerProcessor.this.wireToK.apply(wire.read(params[0]));
                            Object value = MapWireHandlerProcessor.this.wireToV.apply(wire.read(params[1]));
                            MapWireHandlerProcessor.this.nullCheck(key);
                            MapWireHandlerProcessor.this.nullCheck(value);
                            MapWireHandlerProcessor.this.vToWire.accept(MapWireHandlerProcessor.this.outWire.writeEventName(CoreFields.reply), MapWireHandlerProcessor.this.map.put(key, value));
                        });
                        return;
                    }
                    if (EventId.remove.contentEquals(MapWireHandlerProcessor.this.eventName)) {
                        Object key = MapWireHandlerProcessor.this.wireToK.apply(valueIn);
                        MapWireHandlerProcessor.this.nullCheck(key);
                        MapWireHandlerProcessor.this.vToWire.accept(MapWireHandlerProcessor.this.outWire.writeEventName(CoreFields.reply), MapWireHandlerProcessor.this.map.remove(key));
                        return;
                    }
                    if (EventId.replace.contentEquals(MapWireHandlerProcessor.this.eventName)) {
                        valueIn.marshallable(wire -> {
                            Params[] params = (Params[])EventId.replace.params();
                            Object key = MapWireHandlerProcessor.this.wireToK.apply(wire.read(params[0]));
                            Object value = MapWireHandlerProcessor.this.wireToV.apply(wire.read(params[1]));
                            MapWireHandlerProcessor.this.nullCheck(key);
                            MapWireHandlerProcessor.this.nullCheck(value);
                            MapWireHandlerProcessor.this.vToWire.accept(MapWireHandlerProcessor.this.outWire.writeEventName(CoreFields.reply), MapWireHandlerProcessor.this.map.replace(key, value));
                        });
                        return;
                    }
                    if (EventId.replaceWithOldAndNewValue.contentEquals(MapWireHandlerProcessor.this.eventName)) {
                        valueIn.marshallable(wire -> {
                            Params[] params = (Params[])EventId.replaceWithOldAndNewValue.params();
                            Object key = MapWireHandlerProcessor.this.wireToK.apply(wire.read(params[0]));
                            Object oldValue = MapWireHandlerProcessor.this.wireToV.apply(wire.read(params[1]));
                            Object newValue = MapWireHandlerProcessor.this.wireToV.apply(wire.read(params[2]));
                            MapWireHandlerProcessor.this.nullCheck(key);
                            MapWireHandlerProcessor.this.nullCheck(oldValue);
                            MapWireHandlerProcessor.this.nullCheck(newValue);
                            MapWireHandlerProcessor.this.outWire.writeEventName(CoreFields.reply).bool(MapWireHandlerProcessor.this.map.replace(key, oldValue, newValue));
                        });
                        return;
                    }
                    if (EventId.putIfAbsent.contentEquals(MapWireHandlerProcessor.this.eventName)) {
                        valueIn.marshallable(wire -> {
                            Params[] params = (Params[])EventId.putIfAbsent.params();
                            Object key = MapWireHandlerProcessor.this.wireToK.apply(wire.read(params[0]));
                            Object value = MapWireHandlerProcessor.this.wireToV.apply(wire.read(params[1]));
                            MapWireHandlerProcessor.this.nullCheck(key);
                            MapWireHandlerProcessor.this.nullCheck(value);
                            MapWireHandlerProcessor.this.vToWire.accept(MapWireHandlerProcessor.this.outWire.writeEventName(CoreFields.reply), MapWireHandlerProcessor.this.map.putIfAbsent(key, value));
                        });
                        return;
                    }
                    if (EventId.removeWithValue.contentEquals(MapWireHandlerProcessor.this.eventName)) {
                        valueIn.marshallable(wire -> {
                            Params[] params = (Params[])EventId.removeWithValue.params();
                            Object key = MapWireHandlerProcessor.this.wireToK.apply(wire.read(params[0]));
                            Object value = MapWireHandlerProcessor.this.wireToV.apply(wire.read(params[1]));
                            MapWireHandlerProcessor.this.nullCheck(key);
                            MapWireHandlerProcessor.this.nullCheck(value);
                            MapWireHandlerProcessor.this.outWire.writeEventName(CoreFields.reply).bool(MapWireHandlerProcessor.this.map.remove(key, value));
                        });
                    }
                    if (EventId.hashCode.contentEquals(MapWireHandlerProcessor.this.eventName)) {
                        MapWireHandlerProcessor.this.outWire.writeEventName(CoreFields.reply).int32(MapWireHandlerProcessor.this.map.hashCode());
                        return;
                    }
                    throw new IllegalStateException("unsupported event=" + MapWireHandlerProcessor.this.eventName);
                });
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            finally {
                if (IS_DEBUG) {
                    // empty if block
                }
            }
        }
    };

    @Override
    public void process(@NotNull Wire in, @NotNull Wire out, Map<K, V> map, @NotNull CharSequence csp, BiConsumer<ValueOut, V> vToWire, @NotNull Function<ValueIn, K> kFromWire, @NotNull Function<ValueIn, V> vFromWire) throws StreamCorruptedException {
        this.vToWire = vToWire;
        this.wireToK = kFromWire;
        this.wireToV = vFromWire;
        try {
            this.inWire = in;
            this.outWire = out;
            this.map = map;
            this.csp = csp;
            this.inWire.readDocument(this.metaDataConsumer, this.dataConsumer);
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
        }
    }

    public MapWireHandlerProcessor(@NotNull Map<Long, String> cidToCsp) throws IOException {
        this.cidToCsp = cidToCsp;
    }

    @Override
    public void accept(@NotNull WireHandlers wireHandlers) {
    }

    private long createCid(CharSequence csp) {
        long newCid = this.cid.incrementAndGet();
        String cspStr = csp.toString();
        Long aLong = this.cspToCid.putIfAbsent(cspStr, newCid);
        if (aLong != null) {
            return aLong;
        }
        this.cidToCsp.put(newCid, cspStr);
        return newCid;
    }

    private void nullCheck(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
    }

    private void createProxy(String type) {
        this.outWire.writeEventName(CoreFields.reply).type("set-proxy").writeValue().marshallable(w -> {
            CharSequence root = this.csp.subSequence(0, this.csp.length() - "#map".length());
            StringBuilder csp = Wires.acquireStringBuilder().append(root).append("#").append(type);
            w.write(CoreFields.csp).text(csp);
            w.write(CoreFields.cid).int64(this.createCid(csp));
        });
    }

    private void writeData(@NotNull Consumer<WireOut> c) {
        this.outWire.writeDocument(false, out -> {
            long position = this.outWire.bytes().position();
            try {
                c.accept(this.outWire);
            }
            catch (Exception exception) {
                this.outWire.bytes().position(position);
                this.outWire.writeEventName(() -> "exception");
                ExceptionMarshaller exceptionMarshaller = new ExceptionMarshaller(exception);
                exceptionMarshaller.writeMarshallable(this.outWire);
            }
            if (position == this.outWire.bytes().position()) {
                this.outWire.writeEventName(CoreFields.reply).marshallable(WireOut.EMPTY);
            }
        });
    }

    public static enum EventId implements ParameterizeWireKey
    {
        longSize(new WireKey[0]),
        size(new WireKey[0]),
        containsKey((WireKey[])new Params[]{Params.key}),
        containsValue((WireKey[])new Params[]{Params.value}),
        get((WireKey[])new Params[]{Params.key}),
        getAndPut((WireKey[])new Params[]{Params.key, Params.value}),
        put((WireKey[])new Params[]{Params.key, Params.value}),
        remove((WireKey[])new Params[]{Params.key}),
        removeWithoutAcc((WireKey[])new Params[]{Params.key}),
        clear(new WireKey[0]),
        keySet(new WireKey[0]),
        values(new WireKey[0]),
        entrySet(new WireKey[0]),
        entrySetRestricted(new WireKey[0]),
        replace((WireKey[])new Params[]{Params.key, Params.value}),
        replaceWithOldAndNewValue((WireKey[])new Params[]{Params.key, Params.oldValue, Params.newValue}),
        putIfAbsent((WireKey[])new Params[]{Params.key, Params.value}),
        removeWithValue((WireKey[])new Params[]{Params.key, Params.value}),
        toString(new WireKey[0]),
        getApplicationVersion(new WireKey[0]),
        persistedDataVersion(new WireKey[0]),
        putAll(new WireKey[0]),
        putAllWithoutAcc(new WireKey[0]),
        hashCode(new WireKey[0]),
        mapForKey(new WireKey[0]),
        putMapped(new WireKey[0]),
        keyBuilder(new WireKey[0]),
        valueBuilder(new WireKey[0]),
        createChannel(new WireKey[0]),
        remoteIdentifier(new WireKey[0]);

        private final WireKey[] params;

        private <P extends WireKey> EventId(P ... params) {
            this.params = params;
        }

        @Override
        public <P extends WireKey> P[] params() {
            return this.params;
        }
    }

    static enum Params implements WireKey
    {
        key,
        value,
        oldValue,
        newValue;

    }
}

