/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.collection;

import java.io.StreamCorruptedException;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.wire.CoreFields;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireHandlers;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.collection.CollectionWireHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionWireHandlerProcessor<U, C extends Collection<U>>
implements CollectionWireHandler<U, C>,
Consumer<WireHandlers> {
    private Function<ValueIn, U> fromWire;
    private BiConsumer<ValueOut, U> toWire;
    private static final Logger LOG = LoggerFactory.getLogger(CollectionWireHandlerProcessor.class);
    public static final int SIZE_OF_SIZE = 2;
    private Wire inWire = null;
    private Wire outWire = null;
    private C underlyingCollection;
    public long tid;
    private Supplier<C> factory;
    private final Consumer<WireIn> metaDataConsumer = new Consumer<WireIn>(){

        @Override
        public void accept(WireIn wireIn) {
            ValueIn read;
            StringBuilder sb = Wires.acquireStringBuilder();
            do {
                read = CollectionWireHandlerProcessor.this.inWire.read(sb);
            } while (!CoreFields.tid.contentEquals(sb));
            CollectionWireHandlerProcessor.this.tid = read.int64();
        }
    };
    private final Consumer<WireIn> dataConsumer = new Consumer<WireIn>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(WireIn wireIn) {
            Bytes<?> outBytes = CollectionWireHandlerProcessor.this.outWire.bytes();
            try {
                StringBuilder eventName = Wires.acquireStringBuilder();
                ValueIn valueIn = CollectionWireHandlerProcessor.this.inWire.readEventName(eventName);
                CollectionWireHandlerProcessor.this.outWire.writeDocument(true, wire -> CollectionWireHandlerProcessor.this.outWire.write(CoreFields.tid).int64(CollectionWireHandlerProcessor.this.tid));
                CollectionWireHandlerProcessor.this.outWire.writeDocument(false, out -> {
                    if (CollectionWireHandler.SetEventId.remove.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.outWire.write(CoreFields.reply).bool(CollectionWireHandlerProcessor.this.underlyingCollection.remove(CollectionWireHandlerProcessor.this.fromWire.apply(valueIn)));
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.iterator.contentEquals(eventName)) {
                        ValueOut valueOut = CollectionWireHandlerProcessor.this.outWire.writeEventName(CoreFields.reply);
                        CollectionWireHandlerProcessor.this.underlyingCollection.forEach(e -> valueOut.sequence(v -> CollectionWireHandlerProcessor.this.toWire.accept(v, e)));
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.numberOfSegments.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.outWire.write(CoreFields.reply).int32(1);
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.isEmpty.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.outWire.write(CoreFields.reply).bool(CollectionWireHandlerProcessor.this.underlyingCollection.isEmpty());
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.size.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.outWire.write(CoreFields.reply).int32(CollectionWireHandlerProcessor.this.underlyingCollection.size());
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.clear.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.underlyingCollection.clear();
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.contains.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.outWire.write(CoreFields.reply).bool(CollectionWireHandlerProcessor.this.underlyingCollection.contains(CollectionWireHandlerProcessor.this.fromWire.apply(valueIn)));
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.add.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.outWire.write(CoreFields.reply).bool(CollectionWireHandlerProcessor.this.underlyingCollection.add(CollectionWireHandlerProcessor.this.fromWire.apply(valueIn)));
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.remove.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.outWire.write(CoreFields.reply).bool(CollectionWireHandlerProcessor.this.underlyingCollection.remove(CollectionWireHandlerProcessor.this.fromWire.apply(valueIn)));
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.containsAll.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.outWire.write(CoreFields.reply).bool(CollectionWireHandlerProcessor.this.underlyingCollection.remove(CollectionWireHandlerProcessor.this.collectionFromWire()));
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.addAll.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.outWire.write(CoreFields.reply).bool(CollectionWireHandlerProcessor.this.underlyingCollection.addAll(CollectionWireHandlerProcessor.this.collectionFromWire()));
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.removeAll.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.outWire.write(CoreFields.reply).bool(CollectionWireHandlerProcessor.this.underlyingCollection.removeAll(CollectionWireHandlerProcessor.this.collectionFromWire()));
                        return;
                    }
                    if (CollectionWireHandler.SetEventId.retainAll.contentEquals(eventName)) {
                        CollectionWireHandlerProcessor.this.outWire.write(CoreFields.reply).bool(CollectionWireHandlerProcessor.this.underlyingCollection.retainAll(CollectionWireHandlerProcessor.this.collectionFromWire()));
                        return;
                    }
                    throw new IllegalStateException("unsupported event=" + eventName);
                });
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            finally {
                long len = outBytes.position() - 2L;
                if (len == 0L) {
                    System.out.println("--------------------------------------------\nserver writes:\n\n<EMPTY>");
                } else {
                    System.out.println("--------------------------------------------\nserver writes:\n\n" + Wires.fromSizePrefixedBlobs(outBytes, 2L, len));
                }
            }
        }
    };

    private C collectionFromWire() {
        Collection c = (Collection)this.factory.get();
        ValueIn valueIn = this.outWire.getValueIn();
        while (valueIn.hasNextSequenceItem()) {
            c.add(this.fromWire.apply(valueIn));
        }
        return (C)c;
    }

    @Override
    public void process(Wire in, Wire out, C collection, CharSequence csp, BiConsumer<ValueOut, U> toWire, Function<ValueIn, U> fromWire, Supplier<C> factory) throws StreamCorruptedException {
        this.fromWire = fromWire;
        this.toWire = toWire;
        this.underlyingCollection = collection;
        this.factory = factory;
        try {
            this.inWire = in;
            this.outWire = out;
            this.inWire.readDocument(this.metaDataConsumer, this.dataConsumer);
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public void accept(@NotNull WireHandlers wireHandlers) {
    }
}

