/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.nio.BufferUnderflowException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.EscapingStopCharTester;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharTesters;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.pool.StringInterner;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.IntTextReference;
import net.openhft.chronicle.wire.InternalWireIn;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.TextLongArrayReference;
import net.openhft.chronicle.wire.TextLongReference;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.util.BooleanConsumer;
import net.openhft.chronicle.wire.util.ByteConsumer;
import net.openhft.chronicle.wire.util.FloatConsumer;
import net.openhft.chronicle.wire.util.ShortConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextWire
implements Wire,
InternalWireIn {
    private static final Logger LOG = LoggerFactory.getLogger(TextWire.class);
    public static final String FIELD_SEP = "";
    private static final String END_FIELD = "\n";
    public static final String SEQUENCE_L1 = "- ";
    public static final String MAP = "!!map";
    final Bytes<?> bytes;
    final ValueOut valueOut = new TextValueOut();
    final ValueIn valueIn = new TextValueIn();
    String sep = "";
    boolean ready;

    public TextWire(Bytes<?> bytes) {
        this.bytes = bytes;
    }

    public static String asText(Wire wire) {
        TextWire tw = new TextWire((Bytes<?>)NativeBytes.nativeBytes());
        wire.copyTo(tw);
        tw.flip();
        wire.flip();
        return tw.toString();
    }

    public String toString() {
        return this.bytes.toString();
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }

    @Override
    public void setReady(boolean ready) {
        this.ready = ready;
    }

    @Override
    public void copyTo(@NotNull WireOut wire) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ValueIn read() {
        this.readField(Wires.acquireStringBuilder());
        return this.valueIn;
    }

    private StringBuilder readField(StringBuilder sb) {
        this.consumeWhiteSpace();
        try {
            int ch = this.peekCode();
            if (ch == 34) {
                this.bytes.skip(1L);
                this.bytes.parseUTF(sb, EscapingStopCharTester.escaping(c -> c == 34));
                this.consumeWhiteSpace();
                ch = this.readCode();
                if (ch != 58) {
                    throw new UnsupportedOperationException("Expected a : at " + this.bytes.toDebugString());
                }
            } else {
                if (ch < 0) {
                    sb.setLength(0);
                    return sb;
                }
                this.bytes.parseUTF(sb, EscapingStopCharTester.escaping(c -> c < 32 || c == 58));
            }
            this.unescape(sb);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        return sb;
    }

    private void consumeWhiteSpace() {
        int byteValue;
        while (this.bytes.remaining() > 0L && (Character.isWhitespace(byteValue = this.bytes.readUnsignedByte(this.bytes.position())) || byteValue == 44)) {
            this.bytes.skip(1L);
        }
    }

    private int peekCode() {
        if (this.bytes.remaining() < 1L) {
            return -1;
        }
        long pos = this.bytes.position();
        return this.bytes.readUnsignedByte(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean peekStringIgnoreCase(@NotNull String source) {
        if (source.isEmpty()) {
            return true;
        }
        if (this.bytes.remaining() < 1L) {
            return false;
        }
        long pos = this.bytes.position();
        try {
            for (int i = 0; i < source.length(); ++i) {
                if (Character.toLowerCase(source.charAt(i)) == Character.toLowerCase(this.bytes.readByte())) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.bytes.position(pos);
        }
        return true;
    }

    private int readCode() {
        if (this.bytes.remaining() < 1L) {
            return -1;
        }
        return this.bytes.readUnsignedByte();
    }

    private void unescape(StringBuilder sb) {
        for (int i = 0; i < sb.length(); ++i) {
            char ch2 = sb.charAt(i);
            if (ch2 != '\\') continue;
            sb.deleteCharAt(i);
            char ch3 = sb.charAt(i);
            switch (ch3) {
                case 'n': {
                    sb.setCharAt(i, '\n');
                }
            }
        }
    }

    @Override
    public ValueIn read(@NotNull WireKey key) {
        long position = this.bytes.position();
        StringBuilder sb = this.readField(Wires.acquireStringBuilder());
        if (sb.length() == 0 || StringInterner.isEqual((CharSequence)sb, (CharSequence)key.name())) {
            return this.valueIn;
        }
        this.bytes.position(position);
        throw new UnsupportedOperationException("Unordered fields not supported yet. key=" + key.name() + ", data='" + sb + "'");
    }

    @Override
    public ValueIn read(@NotNull StringBuilder name) {
        this.consumeWhiteSpace();
        this.readField(name);
        return this.valueIn;
    }

    @Override
    public ValueIn getValueIn() {
        return this.valueIn;
    }

    @Override
    public Wire readComment(@NotNull StringBuilder s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flip() {
        this.bytes.flip();
    }

    @Override
    public void clear() {
        this.bytes.clear();
    }

    @Override
    public Bytes<?> bytes() {
        return this.bytes;
    }

    @Override
    public ValueOut write() {
        ((Bytes)this.bytes.append((CharSequence)this.sep)).append((CharSequence)"\"\": ");
        this.sep = FIELD_SEP;
        return this.valueOut;
    }

    @Override
    public ValueOut write(WireKey key) {
        CharSequence name = key.name();
        if (name == null) {
            name = Integer.toString(key.code());
        }
        ((Bytes)((Bytes)this.bytes.append((CharSequence)this.sep)).append(this.quotes(name))).append((CharSequence)":");
        this.sep = " ";
        return this.valueOut;
    }

    @Override
    public ValueOut writeValue() {
        return this.valueOut;
    }

    @Override
    public ValueOut getValueOut() {
        return this.valueOut;
    }

    @Override
    public Wire writeComment(CharSequence s) {
        ((Bytes)((Bytes)((Bytes)this.bytes.append((CharSequence)this.sep)).append((CharSequence)"# ")).append(s)).append((CharSequence)END_FIELD);
        this.sep = FIELD_SEP;
        return this;
    }

    @Override
    public boolean hasDocument() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WireOut addPadding(int paddingToAdd) {
        for (int i = 0; i < paddingToAdd; ++i) {
            this.bytes.append((this.bytes.position() & 0x3FL) == 0L ? (char)'\n' : ' ');
        }
        return this;
    }

    CharSequence quotes(CharSequence s) {
        if (!this.needsQuotes(s)) {
            return s;
        }
        StringBuilder sb2 = Wires.acquireAnotherStringBuilder(s);
        sb2.append('\"');
        block4: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': 
                case '\\': {
                    sb2.append('\\').append(ch);
                    continue block4;
                }
                case '\n': {
                    sb2.append("\\n");
                    continue block4;
                }
                default: {
                    sb2.append(ch);
                }
            }
        }
        sb2.append('\"');
        return sb2;
    }

    boolean needsQuotes(CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            if ("\" ,\n\\".indexOf(s.charAt(i)) < 0) continue;
            return true;
        }
        return s.length() == 0;
    }

    class TextValueIn
    implements ValueIn {
        TextValueIn() {
        }

        @Override
        @NotNull
        public Wire bool(@NotNull BooleanConsumer flag) {
            TextWire.this.consumeWhiteSpace();
            if (this.isNull()) {
                flag.accept(null);
                return TextWire.this;
            }
            StringBuilder sb = Wires.acquireStringBuilder();
            TextWire.this.bytes.parseUTF(sb, (StopCharTester)StopCharTesters.COMMA_STOP);
            if (StringInterner.isEqual((CharSequence)sb, (CharSequence)"true")) {
                flag.accept(true);
            } else if (StringInterner.isEqual((CharSequence)sb, (CharSequence)"false")) {
                flag.accept(false);
            } else {
                throw new UnsupportedOperationException();
            }
            return TextWire.this;
        }

        @Override
        @NotNull
        public WireIn text(@NotNull Consumer<String> s) {
            StringBuilder sb = Wires.acquireStringBuilder();
            this.text(sb);
            s.accept(sb.toString());
            return TextWire.this;
        }

        @Override
        public String text() {
            if (this.isNull()) {
                return null;
            }
            StringBuilder sb = Wires.acquireStringBuilder();
            this.text(sb);
            return sb.toString();
        }

        @Override
        @NotNull
        public Wire text(@NotNull StringBuilder s) {
            TextWire.this.consumeWhiteSpace();
            int ch = TextWire.this.peekCode();
            StringBuilder sb = s;
            if (ch == 123) {
                long len = this.readLength();
                sb.append(Bytes.toDebugString(TextWire.this.bytes, (long)TextWire.this.bytes.position(), (long)len));
                TextWire.this.bytes.skip(len);
                TextWire.this.bytes.skipTo((StopCharTester)StopCharTesters.COMMA_STOP);
                return TextWire.this;
            }
            if (ch == 34) {
                TextWire.this.bytes.skip(1L);
                TextWire.this.bytes.parseUTF(sb, EscapingStopCharTester.escaping(c -> c == 34));
                TextWire.this.consumeWhiteSpace();
            } else {
                TextWire.this.bytes.parseUTF(sb, EscapingStopCharTester.escaping((StopCharTester)StopCharTesters.COMMA_STOP));
            }
            TextWire.this.unescape(sb);
            return TextWire.this;
        }

        @Override
        @NotNull
        public Wire int8(@NotNull ByteConsumer i) {
            TextWire.this.consumeWhiteSpace();
            i.accept((byte)TextWire.this.bytes.parseLong());
            return TextWire.this;
        }

        @NotNull
        public WireIn bytes(@NotNull Bytes toBytes) {
            return this.bytes((WireIn wi) -> toBytes.write(wi.bytes()));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public WireIn bytes(@NotNull Consumer<WireIn> bytesConsumer) {
            TextWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            if (TextWire.this.peekCode() == 33) {
                TextWire.this.bytes.parseUTF(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                String str = sb.toString();
                if (!str.equals("!!binary")) throw new IORuntimeException("Unsupported type " + str);
                sb.setLength(0);
                TextWire.this.bytes.parseUTF(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                byte[] decode = Base64.getDecoder().decode(sb.toString());
                bytesConsumer.accept(new TextWire(Bytes.wrap((byte[])decode)));
                return TextWire.this;
            } else {
                this.text(sb);
                bytesConsumer.accept(new TextWire(Bytes.wrap((byte[])sb.toString().getBytes())));
            }
            return TextWire.this;
        }

        @Override
        public byte[] bytes() {
            TextWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            if (TextWire.this.peekCode() == 33) {
                TextWire.this.bytes.parseUTF(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                String str = sb.toString();
                if (str.equals("!!binary")) {
                    sb.setLength(0);
                    TextWire.this.bytes.parseUTF(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                    byte[] decode = Base64.getDecoder().decode(sb.toString());
                    return decode;
                }
                if (str.equals(TextWire.MAP)) {
                    sb.append(TextWire.this.bytes.toString());
                    return sb.toString().getBytes();
                }
                throw new IllegalStateException("unsupported type");
            }
            this.text(sb);
            return sb.toString().getBytes();
        }

        @Override
        @NotNull
        public WireIn wireIn() {
            return TextWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long readLength() {
            TextWire.this.consumeWhiteSpace();
            long start = TextWire.this.bytes.position();
            try {
                TextWire.this.consumeWhiteSpace();
                int code = TextWire.this.readCode();
                switch (code) {
                    case 123: {
                        int count = 1;
                        while (true) {
                            byte b;
                            if ((b = TextWire.this.bytes.readByte()) == 123) {
                                ++count;
                                continue;
                            }
                            if (b != 125 || --count != 0) continue;
                            long l = TextWire.this.bytes.position() - start;
                            return l;
                        }
                    }
                    case 45: {
                        while (true) {
                            byte b;
                            if ((b = TextWire.this.bytes.readByte()) == 10) {
                                long l = TextWire.this.bytes.position() - start + 1L;
                                return l;
                            }
                            if (TextWire.this.bytes.remaining() != 0L) continue;
                            long l = TextWire.this.bytes.limit() - start;
                            return l;
                        }
                    }
                }
                this.bytes();
                long l = TextWire.this.bytes.position() - start;
                return l;
            }
            finally {
                TextWire.this.bytes.position(start);
            }
        }

        private long readSequenceLength() {
            long start = TextWire.this.bytes.position();
            try {
                while (true) {
                    byte b;
                    if ((b = TextWire.this.bytes.readByte()) == 10) {
                        long l = TextWire.this.bytes.position() - start - 1L;
                        return l;
                    }
                    if (TextWire.this.bytes.remaining() != 0L) continue;
                    long l = TextWire.this.bytes.limit() - start;
                    return l;
                }
            }
            finally {
                TextWire.this.bytes.position(start);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long readLengthMarshable() {
            long start = TextWire.this.bytes.position();
            try {
                TextWire.this.consumeWhiteSpace();
                int code = TextWire.this.readCode();
                switch (code) {
                    case 123: {
                        int count = 1;
                        while (true) {
                            byte b;
                            if ((b = TextWire.this.bytes.readByte()) == 123) {
                                ++count;
                                continue;
                            }
                            if (b != 125 || --count != 0) continue;
                            long l = TextWire.this.bytes.position() - start;
                            return l;
                        }
                    }
                }
                this.bytes();
                long l = TextWire.this.bytes.position() - start;
                return l;
            }
            finally {
                TextWire.this.bytes.position(start);
            }
        }

        @Override
        @NotNull
        public Wire uint8(@NotNull ShortConsumer i) {
            TextWire.this.consumeWhiteSpace();
            i.accept((short)TextWire.this.bytes.parseLong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public Wire int16(@NotNull ShortConsumer i) {
            TextWire.this.consumeWhiteSpace();
            i.accept((short)TextWire.this.bytes.parseLong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public Wire uint16(@NotNull IntConsumer i) {
            TextWire.this.consumeWhiteSpace();
            i.accept((int)TextWire.this.bytes.parseLong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public Wire int32(@NotNull IntConsumer i) {
            TextWire.this.consumeWhiteSpace();
            i.accept((int)TextWire.this.bytes.parseLong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public Wire uint32(@NotNull LongConsumer i) {
            TextWire.this.consumeWhiteSpace();
            i.accept(TextWire.this.bytes.parseLong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public Wire int64(@NotNull LongConsumer i) {
            TextWire.this.consumeWhiteSpace();
            i.accept(TextWire.this.bytes.parseLong());
            return TextWire.this;
        }

        @Override
        @NotNull
        public Wire float32(@NotNull FloatConsumer v) {
            TextWire.this.consumeWhiteSpace();
            v.accept((float)TextWire.this.bytes.parseDouble());
            return TextWire.this;
        }

        @Override
        @NotNull
        public Wire float64(@NotNull DoubleConsumer v) {
            TextWire.this.consumeWhiteSpace();
            v.accept(TextWire.this.bytes.parseDouble());
            return TextWire.this;
        }

        @Override
        @NotNull
        public Wire time(@NotNull Consumer<LocalTime> localTime) {
            TextWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            this.text(sb);
            localTime.accept(LocalTime.parse(sb.toString()));
            return TextWire.this;
        }

        @Override
        @NotNull
        public Wire zonedDateTime(@NotNull Consumer<ZonedDateTime> zonedDateTime) {
            TextWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            this.text(sb);
            zonedDateTime.accept(ZonedDateTime.parse(sb.toString()));
            return TextWire.this;
        }

        @Override
        @NotNull
        public Wire date(@NotNull Consumer<LocalDate> localDate) {
            TextWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            this.text(sb);
            localDate.accept(LocalDate.parse(sb.toString()));
            return TextWire.this;
        }

        @Override
        public boolean hasNext() {
            return TextWire.this.bytes.remaining() > 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNextSequenceItem() {
            long pos = TextWire.this.bytes.position();
            try {
                if (TextWire.this.peekStringIgnoreCase(TextWire.SEQUENCE_L1)) {
                    boolean bl = true;
                    return bl;
                }
                TextWire.this.bytes.skipTo((StopCharTester)StopCharTesters.NEW_LINE_STOP);
                boolean bl = TextWire.this.peekStringIgnoreCase(TextWire.SEQUENCE_L1);
                return bl;
            }
            finally {
                TextWire.this.bytes.position(pos);
            }
        }

        @Override
        public WireIn uuid(@NotNull Consumer<UUID> uuid) {
            TextWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            this.text(sb);
            uuid.accept(UUID.fromString(sb.toString()));
            return TextWire.this;
        }

        @Override
        public WireIn int64array(@Nullable LongArrayValues values, @NotNull Consumer<LongArrayValues> setter) {
            TextWire.this.consumeWhiteSpace();
            if (!(values instanceof TextLongArrayReference)) {
                values = new TextLongArrayReference();
                setter.accept(values);
            }
            Byteable b = (Byteable)values;
            long length = TextLongArrayReference.peakLength(TextWire.this.bytes, TextWire.this.bytes.position());
            b.bytesStore(TextWire.this.bytes, TextWire.this.bytes.position(), length);
            TextWire.this.bytes.skip(length);
            return TextWire.this;
        }

        @Override
        public WireIn int64(LongValue value, @NotNull Consumer<LongValue> setter) {
            TextWire.this.consumeWhiteSpace();
            if (!(value instanceof TextLongReference)) {
                value = new TextLongReference();
                setter.accept(value);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore(TextWire.this.bytes, TextWire.this.bytes.position(), length);
            TextWire.this.bytes.skip(length);
            return TextWire.this;
        }

        @Override
        public WireIn int32(IntValue value, @NotNull Consumer<IntValue> setter) {
            if (!(value instanceof IntTextReference)) {
                value = new IntTextReference();
                setter.accept(value);
            }
            Byteable b = (Byteable)value;
            long length = b.maxSize();
            b.bytesStore(TextWire.this.bytes, TextWire.this.bytes.position(), length);
            TextWire.this.bytes.skip(length);
            return TextWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WireIn sequence(@NotNull Consumer<ValueIn> reader) {
            TextWire.this.consumeWhiteSpace();
            int code = TextWire.this.peekCode();
            if (code != 45) {
                throw new IORuntimeException("Unsupported type " + (char)code + "(" + code + ")");
            }
            TextWire.this.bytes.skip(1L);
            TextWire.this.consumeWhiteSpace();
            long len = this.readSequenceLength();
            long limit = TextWire.this.bytes.limit();
            long position = TextWire.this.bytes.position();
            try {
                long newLimit = position + len;
                TextWire.this.bytes.limit(newLimit);
                reader.accept(TextWire.this.valueIn);
            }
            finally {
                TextWire.this.bytes.limit(limit);
            }
            TextWire.this.bytes.skipTo((StopCharTester)StopCharTesters.NEW_LINE_STOP);
            return TextWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T applyToMarshallable(Function<WireIn, T> marshallableReader) {
            TextWire.this.consumeWhiteSpace();
            int code = TextWire.this.peekCode();
            if (code != 123) {
                throw new IORuntimeException("Unsupported type " + (char)code);
            }
            long len = this.readLengthMarshable() - 1L;
            long limit = TextWire.this.bytes.limit();
            long position = TextWire.this.bytes.position();
            try {
                long newLimit = position - 1L + len;
                TextWire.this.bytes.limit(newLimit);
                TextWire.this.bytes.skip(1L);
                TextWire.this.consumeWhiteSpace();
                T t = marshallableReader.apply(TextWire.this);
                return t;
            }
            finally {
                TextWire.this.bytes.limit(limit);
                TextWire.this.consumeWhiteSpace();
                code = TextWire.this.readCode();
                if (code != 125) {
                    throw new IORuntimeException("Unterminated { while reading marshallable bytes=" + Bytes.toDebugString(TextWire.this.bytes));
                }
            }
        }

        @Override
        @NotNull
        public Wire type(@NotNull StringBuilder s) {
            TextWire.this.consumeWhiteSpace();
            int code = TextWire.this.readCode();
            if (code != 33) {
                throw new UnsupportedOperationException(WireType.stringForCode(code));
            }
            TextWire.this.bytes.parseUTF(s, (StopCharTester)StopCharTesters.SPACE_STOP);
            return TextWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public WireIn marshallable(@NotNull ReadMarshallable object) {
            TextWire.this.consumeWhiteSpace();
            int code = TextWire.this.peekCode();
            if (code != 123) {
                throw new IORuntimeException("Unsupported type " + (char)code);
            }
            long len = this.readLengthMarshable() - 1L;
            long limit = TextWire.this.bytes.limit();
            long position = TextWire.this.bytes.position();
            long newLimit = position - 1L + len;
            try {
                TextWire.this.bytes.limit(newLimit);
                TextWire.this.bytes.skip(1L);
                TextWire.this.consumeWhiteSpace();
                object.readMarshallable(TextWire.this);
            }
            finally {
                TextWire.this.bytes.limit(limit);
                TextWire.this.bytes.position(newLimit);
            }
            TextWire.this.consumeWhiteSpace();
            code = TextWire.this.readCode();
            if (code != 125) {
                throw new IORuntimeException("Unterminated { while reading marshallable " + object + ",code='" + (char)code + "', bytes=" + Bytes.toDebugString(TextWire.this.bytes));
            }
            return TextWire.this;
        }

        @Override
        public <K, V> Map<K, V> map(@NotNull Class<K> kClazz, @NotNull Class<V> vClass, @NotNull Map<K, V> usingMap) {
            TextWire.this.consumeWhiteSpace();
            usingMap.clear();
            StringBuilder sb = Wires.acquireStringBuilder();
            if (TextWire.this.peekCode() == 33) {
                TextWire.this.bytes.parseUTF(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                String str = sb.toString();
                if ("!!null".contentEquals(sb)) {
                    return null;
                }
                if (TextWire.MAP.contentEquals(sb)) {
                    while (this.hasNextSequenceItem()) {
                        this.sequence(s -> s.marshallable(r -> {
                            try {
                                Object k = r.read(() -> "key").object(kClazz);
                                Object v = r.read(() -> "value").object(vClass);
                                usingMap.put(k, v);
                            }
                            catch (Exception e) {
                                LOG.error(TextWire.FIELD_SEP, (Throwable)e);
                            }
                        }));
                    }
                    return usingMap;
                }
                throw new IORuntimeException("Unsupported type :" + str);
            }
            return usingMap;
        }

        @Override
        public void typedMap(@NotNull Map<Marshallable, Marshallable> usingMap) {
            TextWire.this.consumeWhiteSpace();
            usingMap.clear();
            StringBuilder sb = Wires.acquireStringBuilder();
            if (TextWire.this.peekCode() == 33) {
                TextWire.this.bytes.parseUTF(sb, (StopCharTester)StopCharTesters.SPACE_STOP);
                String str = sb.toString();
                if (TextWire.MAP.contentEquals(sb)) {
                    while (this.hasNext()) {
                        this.sequence(s -> s.marshallable(r -> {
                            try {
                                Marshallable k = r.read(() -> "key").typedMarshallable();
                                Marshallable v = r.read(() -> "value").typedMarshallable();
                                usingMap.put(k, v);
                            }
                            catch (Exception e) {
                                LOG.error(TextWire.FIELD_SEP, (Throwable)e);
                            }
                        }));
                    }
                } else {
                    throw new IORuntimeException("Unsupported type " + str);
                }
            }
        }

        @Override
        public boolean bool() {
            TextWire.this.consumeWhiteSpace();
            StringBuilder sb = Wires.acquireStringBuilder();
            TextWire.this.bytes.parseUTF(sb, (StopCharTester)StopCharTesters.COMMA_STOP);
            if (StringInterner.isEqual((CharSequence)sb, (CharSequence)"true")) {
                return true;
            }
            if (StringInterner.isEqual((CharSequence)sb, (CharSequence)"false")) {
                return false;
            }
            if (this.isNull()) {
                throw new NullPointerException("value is null");
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public byte int8() {
            long l = this.int64();
            if (l > 127L || l < -128L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Byte.MAX_VALUE/MIN_VALUE");
            }
            return (byte)l;
        }

        @Override
        public short int16() {
            long l = this.int64();
            if (l > 32767L || l < -32768L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Short.MAX_VALUE/MIN_VALUE");
            }
            return (short)l;
        }

        @Override
        public int int32() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer.MAX_VALUE/MIN_VALUE");
            }
            return (int)l;
        }

        @Override
        public int uint16() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < 0L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer" + ".MAX_VALUE/ZERO");
            }
            return (int)l;
        }

        @Override
        public long int64() {
            TextWire.this.consumeWhiteSpace();
            return TextWire.this.bytes.parseLong();
        }

        @Override
        public double float64() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public float float32() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public boolean isNull() {
            TextWire.this.consumeWhiteSpace();
            if (TextWire.this.peekStringIgnoreCase("!!null")) {
                TextWire.this.bytes.skip((long)"!!null".length());
                if (TextWire.this.bytes.remaining() > 0L && TextWire.this.bytes.readByte(TextWire.this.bytes.position()) == 10) {
                    TextWire.this.bytes.skip(1L);
                }
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public <E> E object(@Nullable E using, @NotNull Class<E> clazz) {
            TextWire.this.consumeWhiteSpace();
            if (this.isNull()) {
                return null;
            }
            if (byte[].class.isAssignableFrom(clazz)) {
                return (E)this.bytes();
            }
            if (Marshallable.class.isAssignableFrom(clazz)) {
                Object v;
                if (using == null) {
                    try {
                        v = UnsafeMemory.MEMORY.allocateInstance(clazz);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    v = using;
                }
                TextWire.this.valueIn.marshallable((Marshallable)v);
                return v;
            }
            if (StringBuilder.class.isAssignableFrom(clazz)) {
                StringBuilder builder = using == null ? Wires.acquireStringBuilder() : (StringBuilder)using;
                TextWire.this.valueIn.text(builder);
                return using;
            }
            if (CharSequence.class.isAssignableFrom(clazz)) {
                return (E)TextWire.this.valueIn.text();
            }
            if (Long.class.isAssignableFrom(clazz)) {
                return (E)Long.valueOf(TextWire.this.valueIn.int64());
            }
            if (Double.class.isAssignableFrom(clazz)) {
                return (E)Double.valueOf(TextWire.this.valueIn.float64());
            }
            if (Integer.class.isAssignableFrom(clazz)) {
                return (E)Integer.valueOf(TextWire.this.valueIn.int32());
            }
            if (Float.class.isAssignableFrom(clazz)) {
                return (E)Float.valueOf(TextWire.this.valueIn.float32());
            }
            if (Short.class.isAssignableFrom(clazz)) {
                return (E)Short.valueOf(TextWire.this.valueIn.int16());
            }
            if (Character.class.isAssignableFrom(clazz)) {
                String text = TextWire.this.valueIn.text();
                if (text == null || text.length() == 0) {
                    return null;
                }
                return (E)Character.valueOf(text.charAt(0));
            }
            if (Byte.class.isAssignableFrom(clazz)) {
                return (E)Byte.valueOf(TextWire.this.valueIn.int8());
            }
            if (Map.class.isAssignableFrom(clazz)) {
                HashMap<String, String> result = new HashMap<String, String>();
                TextWire.this.valueIn.map(result);
                return (E)result;
            }
            throw new IllegalStateException("unsupported type=" + clazz);
        }
    }

    class TextValueOut
    implements ValueOut {
        boolean nested = false;
        private boolean sequence;

        TextValueOut() {
        }

        public void separator() {
            if (this.isNested()) {
                TextWire.this.sep = ", ";
            } else {
                if (!this.sequence) {
                    TextWire.this.bytes.append((CharSequence)TextWire.END_FIELD);
                }
                TextWire.this.sep = TextWire.FIELD_SEP;
            }
        }

        @Override
        public Wire bool(Boolean flag) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append((CharSequence)(flag == null ? "!!null" : (flag != false ? "true" : "false")));
            this.separator();
            return TextWire.this;
        }

        @Override
        public Wire text(CharSequence s) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append(s == null ? "!!null" : TextWire.this.quotes(s));
            this.separator();
            return TextWire.this;
        }

        @Override
        public Wire int8(byte i8) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append((long)i8);
            this.separator();
            return TextWire.this;
        }

        @Override
        public WireOut bytes(Bytes fromBytes) {
            if (this.isText(fromBytes)) {
                return this.text((CharSequence)fromBytes);
            }
            int length = Maths.toInt32((long)fromBytes.remaining());
            byte[] byteArray = new byte[length];
            fromBytes.read(byteArray);
            return this.bytes(byteArray);
        }

        @Override
        public WireOut rawBytes(byte[] value) {
            TextWire.this.bytes.append((CharSequence)TextWire.this.sep);
            TextWire.this.bytes.write(value);
            this.separator();
            return TextWire.this;
        }

        private boolean isText(Bytes fromBytes) {
            for (long i = fromBytes.position(); i < fromBytes.readLimit(); ++i) {
                int ch = fromBytes.readUnsignedByte(i);
                if ((ch >= 32 || ch == 9) && ch < 127) continue;
                return false;
            }
            return true;
        }

        private boolean startsWith(CharSequence s, String starts) {
            if (s.length() < starts.length()) {
                return false;
            }
            for (int i = 0; i < starts.length(); ++i) {
                if (s.charAt(i) == starts.charAt(i)) continue;
                return false;
            }
            return true;
        }

        @Override
        public ValueOut writeLength(long remaining) {
            throw new UnsupportedOperationException();
        }

        @Override
        public WireOut bytes(byte[] byteArray) {
            ((Bytes)((Bytes)((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append((CharSequence)"!!binary ")).append((CharSequence)Base64.getEncoder().encodeToString(byteArray))).append((CharSequence)TextWire.END_FIELD);
            TextWire.this.sep = TextWire.FIELD_SEP;
            return TextWire.this;
        }

        @Override
        public Wire uint8checked(int u8) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append((long)u8);
            this.separator();
            return TextWire.this;
        }

        @Override
        public Wire int16(short i16) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append((long)i16);
            this.separator();
            return TextWire.this;
        }

        @Override
        public Wire uint16checked(int u16) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append((long)u16);
            this.separator();
            return TextWire.this;
        }

        @Override
        public Wire utf8(int codepoint) {
            StringBuilder sb = Wires.acquireStringBuilder();
            sb.appendCodePoint(codepoint);
            this.text(sb);
            TextWire.this.sep = TextWire.FIELD_SEP;
            return TextWire.this;
        }

        @Override
        public Wire int32(int i32) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append((long)i32);
            this.separator();
            return TextWire.this;
        }

        @Override
        public Wire uint32checked(long u32) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append(u32);
            this.separator();
            return TextWire.this;
        }

        @Override
        public Wire int64(long i64) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append(i64);
            this.separator();
            return TextWire.this;
        }

        @Override
        public WireOut int64array(long capacity) {
            TextLongArrayReference.write(TextWire.this.bytes, capacity);
            return TextWire.this;
        }

        @Override
        public Wire float32(float f) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append(f);
            this.separator();
            return TextWire.this;
        }

        @Override
        public Wire float64(double d) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append(d);
            this.separator();
            return TextWire.this;
        }

        @Override
        public Wire time(LocalTime localTime) {
            TextWire.this.bytes.append((CharSequence)localTime.toString());
            this.separator();
            return TextWire.this;
        }

        @Override
        public Wire zonedDateTime(ZonedDateTime zonedDateTime) {
            TextWire.this.bytes.append((CharSequence)zonedDateTime.toString());
            this.separator();
            return TextWire.this;
        }

        @Override
        public Wire date(LocalDate localDate) {
            TextWire.this.bytes.append((CharSequence)localDate.toString());
            this.separator();
            return TextWire.this;
        }

        @Override
        public Wire type(CharSequence typeName) {
            ((Bytes)((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append('!')).append(typeName);
            TextWire.this.sep = " ";
            return TextWire.this;
        }

        @Override
        public WireOut uuid(UUID uuid) {
            ((Bytes)TextWire.this.bytes.append((CharSequence)TextWire.this.sep)).append((CharSequence)uuid.toString());
            this.separator();
            return TextWire.this;
        }

        @Override
        public WireOut int32forBinding(int value) {
            TextWire.this.bytes.append((CharSequence)TextWire.this.sep);
            IntTextReference.write(TextWire.this.bytes, value);
            this.separator();
            return TextWire.this;
        }

        @Override
        public WireOut int64forBinding(long value) {
            TextWire.this.bytes.append((CharSequence)TextWire.this.sep);
            TextLongReference.write(TextWire.this.bytes, value);
            this.separator();
            return TextWire.this;
        }

        @Override
        public WireOut sequence(Consumer<ValueOut> writer) {
            TextWire.this.bytes.append((CharSequence)"\n- ");
            TextWire.this.sep = TextWire.FIELD_SEP;
            boolean nested = this.isNested();
            try {
                this.nested(false);
                this.sequence(true);
                writer.accept(this);
            }
            finally {
                this.nested(nested);
                this.sequence(false);
            }
            return TextWire.this;
        }

        @Override
        public WireOut marshallable(WriteMarshallable object) {
            TextWire.this.bytes.append((CharSequence)TextWire.this.sep);
            TextWire.this.bytes.append((CharSequence)"{ ");
            TextWire.this.sep = TextWire.FIELD_SEP;
            boolean nested = this.isNested();
            try {
                this.nested(true);
                object.writeMarshallable(TextWire.this);
            }
            finally {
                this.nested(nested);
            }
            TextWire.this.bytes.append(' ');
            TextWire.this.bytes.append('}');
            TextWire.this.sep = nested ? ", " : (this.isSequence() ? TextWire.FIELD_SEP : TextWire.END_FIELD);
            return TextWire.this;
        }

        @Override
        public WireOut map(@NotNull Map map) {
            this.type("!map ");
            this.nested = true;
            map.forEach((k, v) -> this.sequence(w -> w.marshallable(m -> m.write(() -> "key").object(k).write(() -> "value").object(v))));
            return TextWire.this;
        }

        @Override
        public WireOut typedMap(@NotNull Map<Marshallable, Marshallable> map) {
            this.nested = true;
            this.type("!map");
            map.forEach((k, v) -> this.sequence(w -> w.marshallable(m -> m.write(() -> "key").typedMarshallable((Marshallable)k).write(() -> "value").typedMarshallable((Marshallable)v))));
            return TextWire.this;
        }

        @Override
        public boolean isNested() {
            return this.nested;
        }

        @Override
        public boolean isSequence() {
            return this.sequence;
        }

        @Override
        public WireOut nested(boolean nested) {
            this.nested = nested;
            return TextWire.this;
        }

        @Override
        public WireOut sequence(boolean sequence) {
            this.sequence = sequence;
            return TextWire.this;
        }
    }
}

