/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireSerializedLambda;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xerial.snappy.Snappy;

public interface ValueOut {
    @NotNull
    public WireOut bool(Boolean var1);

    @NotNull
    public WireOut text(@Nullable CharSequence var1);

    @NotNull
    default public WireOut int8(long x) {
        return this.int8(Maths.toInt8((long)x));
    }

    @NotNull
    public WireOut int8(byte var1);

    @NotNull
    public WireOut bytes(@Nullable BytesStore var1);

    @NotNull
    public WireOut rawBytes(byte[] var1);

    @NotNull
    public ValueOut writeLength(long var1);

    @NotNull
    public WireOut bytes(byte[] var1);

    @NotNull
    default public WireOut uint8(int x) {
        return this.uint8checked(Maths.toUInt8((long)x));
    }

    @NotNull
    public WireOut uint8checked(int var1);

    @NotNull
    default public WireOut int16(long x) {
        return this.int16(Maths.toInt16((long)x));
    }

    @NotNull
    public WireOut int16(short var1);

    @NotNull
    default public WireOut uint16(long x) {
        return this.uint16checked((int)x);
    }

    @NotNull
    public WireOut uint16checked(int var1);

    @NotNull
    public WireOut utf8(int var1);

    @NotNull
    default public WireOut int32(long x) {
        return this.int32(Maths.toInt32((long)x));
    }

    @NotNull
    public WireOut int32(int var1);

    @NotNull
    default public WireOut uint32(long x) {
        return this.uint32checked(x);
    }

    @NotNull
    public WireOut uint32checked(long var1);

    @NotNull
    public WireOut int64(long var1);

    @NotNull
    public WireOut int64array(long var1);

    @NotNull
    public WireOut int64array(long var1, LongArrayValues var3);

    @NotNull
    public WireOut float32(float var1);

    @NotNull
    public WireOut float64(double var1);

    @NotNull
    public WireOut time(LocalTime var1);

    @NotNull
    public WireOut zonedDateTime(ZonedDateTime var1);

    @NotNull
    public WireOut date(LocalDate var1);

    @NotNull
    public ValueOut type(CharSequence var1);

    @NotNull
    default public WireOut typeLiteral(@NotNull Class type) {
        return this.typeLiteral((t, b) -> b.append((CharSequence)ClassAliasPool.CLASS_ALIASES.nameFor(t)), type);
    }

    @NotNull
    public WireOut typeLiteral(@NotNull CharSequence var1);

    @NotNull
    public WireOut typeLiteral(@NotNull BiConsumer<Class, Bytes> var1, @NotNull Class var2);

    @NotNull
    public WireOut uuid(UUID var1);

    @NotNull
    public WireOut int32forBinding(int var1);

    @NotNull
    public WireOut int32forBinding(int var1, IntValue var2);

    @NotNull
    public WireOut int64forBinding(long var1);

    @NotNull
    public WireOut int64forBinding(long var1, LongValue var3);

    @NotNull
    public WireOut sequence(Consumer<ValueOut> var1);

    @NotNull
    default public WireOut array(Consumer<ValueOut> writer, Class arrayType) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public WireOut marshallable(WriteMarshallable var1);

    @NotNull
    public WireOut map(Map var1);

    @NotNull
    public WireOut typedMap(@NotNull Map<? extends WriteMarshallable, ? extends Marshallable> var1);

    @NotNull
    public ValueOut leaf();

    @NotNull
    default public WireOut typedMarshallable(@Nullable WriteMarshallable object) {
        if (object == null) {
            return this.text(null);
        }
        this.type(ClassAliasPool.CLASS_ALIASES.nameFor(object.getClass()));
        return this.marshallable(object);
    }

    @NotNull
    default public WireOut typedMarshallable(CharSequence typeName, WriteMarshallable object) {
        this.type(typeName);
        return this.marshallable(object);
    }

    default public <E extends Enum<E>> WireOut asEnum(E e) {
        return this.text(e == null ? null : e.name());
    }

    @NotNull
    default public WireOut object(Object value) {
        if (value instanceof byte[]) {
            return this.rawBytes((byte[])value);
        }
        if (value == null) {
            return this.text(null);
        }
        if (value instanceof Map) {
            return this.map((Map)value);
        }
        if (value instanceof Byte) {
            return this.int8((Byte)value);
        }
        if (value instanceof Boolean) {
            return this.bool((Boolean)value);
        }
        if (value instanceof Character) {
            return this.text(value.toString());
        }
        if (value instanceof Short) {
            return this.int16((Short)value);
        }
        if (value instanceof Integer) {
            return this.int32((Integer)value);
        }
        if (value instanceof Long) {
            return this.int64((Long)value);
        }
        if (value instanceof Double) {
            return this.float64((Double)value);
        }
        if (value instanceof Float) {
            return this.float32(((Float)value).floatValue());
        }
        if (value instanceof Marshallable) {
            return this.typedMarshallable((Marshallable)value);
        }
        if (value instanceof Throwable) {
            return this.throwable((Throwable)value);
        }
        if (value instanceof BytesStore) {
            return this.bytes((BytesStore)value);
        }
        if (value instanceof CharSequence) {
            return this.text((CharSequence)value);
        }
        if (value instanceof Enum) {
            return this.typedScalar(value);
        }
        if (value instanceof String[]) {
            return this.array(v -> Stream.of((String[])value).forEach(v::text), String[].class);
        }
        if (value instanceof Collection) {
            if (((Collection)value).size() == 0) {
                return this.sequence(v -> {});
            }
            Class<?> listType = ((Collection)value).iterator().next().getClass();
            if (listType == String.class) {
                return this.sequence(v -> ((Collection)value).stream().forEach(v::text));
            }
            throw new UnsupportedOperationException("Collection of type " + listType + " not supported");
        }
        if (WireSerializedLambda.isSerializableLambda(value.getClass())) {
            WireSerializedLambda.write(value, this);
            return this.wireOut();
        }
        if (Object[].class.isAssignableFrom(value.getClass())) {
            return this.array(v -> Stream.of((Object[])value).forEach(v::object), Object[].class);
        }
        throw new IllegalStateException("type=" + value.getClass() + " is unsupported, it must either be of type Marshallable, String or " + "AutoBoxed primitive Object");
    }

    @NotNull
    default public WireOut typedScalar(@NotNull Object value) {
        this.type(ClassAliasPool.CLASS_ALIASES.nameFor(value.getClass()));
        this.text(value.toString());
        return this.wireOut();
    }

    @NotNull
    default public WireOut throwable(@NotNull Throwable t) {
        this.typedMarshallable(t.getClass().getName(), w -> w.write(() -> "message").text(t.getMessage()).write(() -> "stackTrace").sequence(w3 -> {
            StackTraceElement[] stes = t.getStackTrace();
            int last = Jvm.trimLast((int)0, (StackTraceElement[])stes);
            for (int i = 0; i < last; ++i) {
                StackTraceElement ste = stes[i];
                w3.leaf().marshallable(w4 -> w4.write(() -> "class").text(ste.getClassName()).write(() -> "method").text(ste.getMethodName()).write(() -> "file").text(ste.getFileName()).write(() -> "line").int32(ste.getLineNumber()));
            }
        }));
        return this.wireOut();
    }

    @NotNull
    public WireOut wireOut();

    default public WireOut snappy(byte[] compressedBytes) {
        throw new UnsupportedOperationException();
    }

    default public WireOut compressWithSnappy(String str) {
        try {
            return this.snappy(Snappy.compress((String)str));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

