/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.io.ThreadingIllegalStateException;
import net.openhft.chronicle.values.Align;
import net.openhft.chronicle.values.Array;
import net.openhft.chronicle.values.ArrayFieldModel;
import net.openhft.chronicle.values.CharSequences;
import net.openhft.chronicle.values.Copyable;
import net.openhft.chronicle.values.Enums;
import net.openhft.chronicle.values.FieldModel;
import net.openhft.chronicle.values.Group;
import net.openhft.chronicle.values.MaxUtf8Length;
import net.openhft.chronicle.values.NotNull;
import net.openhft.chronicle.values.Range;
import net.openhft.chronicle.values.SimpleURIClassObject;
import net.openhft.chronicle.values.ValueModel;
import net.openhft.chronicle.values.Values;

public class MyJavaFileManager
extends net.openhft.compiler.MyJavaFileManager {
    private static final Map<String, Set<JavaFileObject>> dependencyFileObjects = new HashMap<String, Set<JavaFileObject>>();
    private final Map<String, Set<JavaFileObject>> fileObjects = new HashMap<String, Set<JavaFileObject>>(dependencyFileObjects);

    public MyJavaFileManager(Class<?> valueType, StandardJavaFileManager fileManager) {
        super(fileManager);
        this.fileObjects.replaceAll((p, objects) -> new HashSet(objects));
        MyJavaFileManager.addFileObjects(this.fileObjects, valueType);
    }

    private static void addFileObjects(Map<String, Set<JavaFileObject>> fileObjects, Class<?> c) {
        Type[] interfaces;
        fileObjects.compute(c.getPackage().getName(), (p, objects) -> {
            if (objects == null) {
                objects = new HashSet<JavaFileObject>();
            }
            objects.add(MyJavaFileManager.classFileObject(c));
            return objects;
        });
        for (Type superInterface : interfaces = c.getGenericInterfaces()) {
            Class rawInterface = ValueModel.rawInterface(superInterface);
            MyJavaFileManager.addFileObjects(fileObjects, rawInterface);
        }
    }

    private static JavaFileObject classFileObject(Class<?> c) {
        try {
            String className = c.getName();
            int lastDotIndex = className.lastIndexOf(46);
            URI uri = c.getResource(className.substring(lastDotIndex + 1) + ".class").toURI();
            return new SimpleURIClassObject(uri, c);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable delegateFileObjects = super.list(location, packageName, kinds, recurse);
        ArrayList<JavaFileObject> packageFileObjects = (ArrayList<JavaFileObject>)((Object)this.fileObjects.get(packageName));
        if (packageFileObjects != null) {
            packageFileObjects = new ArrayList<JavaFileObject>(packageFileObjects);
            delegateFileObjects.forEach(packageFileObjects::add);
            return packageFileObjects;
        }
        return delegateFileObjects;
    }

    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof SimpleURIClassObject) {
            return ((SimpleURIClassObject)file).c.getName();
        }
        return super.inferBinaryName(location, file);
    }

    static {
        Arrays.asList(Enums.class, CharSequences.class, ValueModel.class, Values.class, FieldModel.class, ArrayFieldModel.class, Copyable.class, Align.class, Array.class, Group.class, MaxUtf8Length.class, NotNull.class, Range.class, Bytes.class, BytesStore.class, BytesUtil.class, Byteable.class, BytesMarshallable.class, IORuntimeException.class, InvalidMarshallableException.class, ClosedIllegalStateException.class, ThreadingIllegalStateException.class).forEach(c -> MyJavaFileManager.addFileObjects(dependencyFileObjects, c));
    }
}

