/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

final class Primitives {
    private Primitives() {
    }

    static boolean isPrimitiveIntegerType(Class type) {
        return type == Byte.TYPE || type == Short.TYPE || type == Character.TYPE || type == Integer.TYPE || type == Long.TYPE;
    }

    static boolean isPrimitiveFloatingType(Class type) {
        return type == Float.TYPE || type == Double.TYPE;
    }

    static int widthInBits(Class type) {
        if (type == Boolean.TYPE) {
            return 1;
        }
        if (type == Byte.TYPE) {
            return 8;
        }
        if (type == Character.TYPE || type == Short.TYPE) {
            return 16;
        }
        if (type == Integer.TYPE || type == Float.TYPE) {
            return 32;
        }
        if (type == Long.TYPE || type == Double.TYPE) {
            return 64;
        }
        throw new AssertionError((Object)(type + " is not a primitive type"));
    }

    static Class boxed(Class type) {
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        throw new AssertionError((Object)("Expected primitive type: " + type));
    }
}

