/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import com.squareup.javapoet.MethodSpec;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.function.Function;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.values.ArrayFieldModel;
import net.openhft.chronicle.values.FieldModel;
import net.openhft.chronicle.values.IntegerBackedNativeMemberGenerator;
import net.openhft.chronicle.values.MemberGenerator;
import net.openhft.chronicle.values.MethodTemplate;
import net.openhft.chronicle.values.NumberHeapMemberGenerator;
import net.openhft.chronicle.values.PrimitiveFieldModel;
import net.openhft.chronicle.values.Primitives;
import net.openhft.chronicle.values.Range;
import net.openhft.chronicle.values.RangeImpl;
import net.openhft.chronicle.values.Utils;
import net.openhft.chronicle.values.ValueBuilder;
import org.jetbrains.annotations.NotNull;

class IntegerFieldModel
extends PrimitiveFieldModel {
    static final Function<String, String> VOLATILE_ACCESS_TYPE = s -> "Volatile" + s;
    static final Function<String, String> ORDERED_ACCESS_TYPE = s -> "Ordered" + s;
    static final Function<String, String> NORMAL_ACCESS_TYPE = Function.identity();
    final FieldModel outerModel;
    Range range;
    final MemberGenerator nativeGenerator = new IntegerBackedNativeMemberGenerator(this, this){

        @Override
        void generateArrayElementFields(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder) {
        }

        @Override
        void finishGet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, String value) {
            methodBuilder.addStatement("return $N", new Object[]{value});
        }

        @Override
        String startSet(MethodSpec.Builder methodBuilder) {
            Range range;
            String value = IntegerFieldModel.this.varName();
            String checkCondition = this.checkCondition(value, range = IntegerFieldModel.this.range());
            if (!checkCondition.isEmpty()) {
                methodBuilder.beginControlFlow(String.format("if (%s)", checkCondition), new Object[0]);
                methodBuilder.addStatement("throw new $T($S + $N + $S)", new Object[]{IllegalArgumentException.class, value + String.format(" should be in [%d, %d] range, ", range.min(), range.max()), value, " is given"});
                methodBuilder.endControlFlow();
            }
            return value;
        }

        @NotNull
        private String checkCondition(String value, Range range) {
            Range defaultRange = IntegerFieldModel.this.defaultRange();
            String cond = " || ";
            if (range.min() != defaultRange.min()) {
                cond = cond + value + " < " + Utils.formatIntOrLong(range.min());
            }
            if (range.max() != defaultRange.max()) {
                cond = cond + " || " + value + " > " + Utils.formatIntOrLong(range.max());
            }
            return cond.substring(4);
        }

        @Override
        public void generateAdd(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            String value = IntegerFieldModel.this.genGet(valueBuilder, NORMAL_ACCESS_TYPE);
            methodBuilder.addStatement("$T $N = $N", new Object[]{IntegerFieldModel.this.type, IntegerFieldModel.this.oldName(), value});
            if (IntegerFieldModel.this.type != Byte.TYPE && IntegerFieldModel.this.type != Short.TYPE && IntegerFieldModel.this.type != Character.TYPE) {
                methodBuilder.addStatement("$T $N = $N + $N", new Object[]{IntegerFieldModel.this.type, IntegerFieldModel.this.newName(), IntegerFieldModel.this.oldName(), "addition"});
            } else {
                methodBuilder.addStatement("$T $N = ($T) ($N + $N)", new Object[]{IntegerFieldModel.this.type, IntegerFieldModel.this.newName(), IntegerFieldModel.this.type, IntegerFieldModel.this.oldName(), "addition"});
            }
            Range range = IntegerFieldModel.this.range();
            String checkCondition = this.checkCondition(IntegerFieldModel.this.newName(), range);
            if (!checkCondition.isEmpty()) {
                methodBuilder.beginControlFlow(String.format("if (%s)", checkCondition), new Object[0]);
                methodBuilder.addStatement("throw new $T($S + $N + $S + $N + $S + $N + $S)", new Object[]{IllegalStateException.class, value + String.format(" should be in [%d, %d] range, the value was ", range.min(), range.max()), IntegerFieldModel.this.oldName(), ", + ", "addition", " = ", IntegerFieldModel.this.newName(), " out of the range"});
                methodBuilder.endControlFlow();
            }
            IntegerFieldModel.this.genSet(valueBuilder, methodBuilder, NORMAL_ACCESS_TYPE, IntegerFieldModel.this.newName());
            methodBuilder.addStatement("return $N", new Object[]{IntegerFieldModel.this.newName()});
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void generateAddAtomic(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            int bitOffset = valueBuilder.model.fieldBitOffset(IntegerFieldModel.this.outerModel);
            if (bitOffset % 8 != 0) throw new UnsupportedOperationException("not implemented yet");
            Range range = IntegerFieldModel.this.range();
            int byteOffset = bitOffset / 8;
            if (RangeImpl.DEFAULT_INT_RANGE.equals(range) && IntegerFieldModel.this.type == Integer.TYPE) {
                methodBuilder.addStatement("return bs.addAndGetInt(offset + $L, addition)", new Object[]{byteOffset});
                return;
            } else {
                if (!RangeImpl.DEFAULT_LONG_RANGE.equals(range)) throw new UnsupportedOperationException("not implemented yet");
                methodBuilder.addStatement("return bs.addAndGetLong(offset + $L, addition)", new Object[]{byteOffset});
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void generateCompareAndSwap(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            int bitOffset = valueBuilder.model.fieldBitOffset(IntegerFieldModel.this.outerModel);
            if (bitOffset % 8 != 0) throw new UnsupportedOperationException("not implemented yet");
            Range range = IntegerFieldModel.this.range();
            int byteOffset = bitOffset / 8;
            if (RangeImpl.DEFAULT_INT_RANGE.equals(range) && IntegerFieldModel.this.type == Integer.TYPE) {
                methodBuilder.addStatement("return bs.compareAndSwapInt(offset + $L, $N, $N)", new Object[]{byteOffset, IntegerFieldModel.this.oldName(), IntegerFieldModel.this.newName()});
                return;
            } else {
                if (!RangeImpl.DEFAULT_LONG_RANGE.equals(range)) throw new UnsupportedOperationException("not implemented yet");
                methodBuilder.addStatement("return bs.compareAndSwapLong(offset + $L, $N, $N)", new Object[]{byteOffset, IntegerFieldModel.this.oldName(), IntegerFieldModel.this.newName()});
            }
        }

        @Override
        void generateEquals(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addCode("if ($N() != other.$N()) return false;\n", new Object[]{IntegerFieldModel.this.getOrGetVolatile().getName(), IntegerFieldModel.this.getOrGetVolatile().getName()});
        }

        @Override
        void generateArrayElementEquals(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            String get = arrayFieldModel.getOrGetVolatile().getName();
            methodBuilder.addCode("if ($N(index) != other.$N(index)) return false;\n", new Object[]{get, get});
        }

        @Override
        String generateHashCode(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            return String.format("%s.hashCode(%s())", Primitives.boxed(IntegerFieldModel.this.type).getName(), IntegerFieldModel.this.getOrGetVolatile().getName());
        }

        @Override
        String generateArrayElementHashCode(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            return String.format("%s.hashCode(%s(index))", Primitives.boxed(IntegerFieldModel.this.type).getName(), arrayFieldModel.getOrGetVolatile().getName());
        }
    };

    IntegerFieldModel() {
        this.outerModel = this;
    }

    IntegerFieldModel(FieldModel outerModel) {
        this.outerModel = outerModel;
    }

    private static int coverBits(long options) {
        assert (options > 0L);
        if (options == 1L) {
            return 1;
        }
        return Maths.intLog2((long)(options - 1L)) + 1;
    }

    private static String read(String offset, int bitsToRead, Function<String, String> accessType) {
        return String.format("bs.read%s(%s)", accessType.apply(IntegerFieldModel.integerBytesMethodSuffix(bitsToRead)), offset);
    }

    private static String integerBytesMethodSuffix(int bitsToRead) {
        return Utils.capitalize(IntegerFieldModel.integerBytesIoType(bitsToRead).getSimpleName());
    }

    private static Class integerBytesIoType(int bits) {
        switch (bits) {
            case 8: {
                return Byte.TYPE;
            }
            case 16: {
                return Short.TYPE;
            }
            case 32: {
                return Integer.TYPE;
            }
            case 64: {
                return Long.TYPE;
            }
        }
        throw new AssertionError((Object)("cannot read/write " + bits + " bits"));
    }

    private static String repeat(char c, int n) {
        char[] chars = new char[n];
        Arrays.fill(chars, c);
        return new String(chars);
    }

    @Override
    void addTypeInfo(Method m, MethodTemplate template) {
        super.addTypeInfo(m, template);
        Parameter annotatedParameter = template.annotatedParameter.apply(m);
        if (annotatedParameter == null) {
            return;
        }
        Range paramRange = annotatedParameter.getAnnotation(Range.class);
        if (paramRange != null) {
            long max;
            if (this.range != null) {
                throw new IllegalStateException("@Range should be specified only once for " + this.name + " field. Specified " + this.range + " and " + paramRange);
            }
            long min = paramRange.min();
            if (min >= (max = paramRange.max())) {
                throw new IllegalStateException(paramRange + ": min should be less than max, field " + this.name);
            }
            if (min < this.defaultRange().min() || max > this.defaultRange().max()) {
                throw new IllegalStateException(this.range + " out of extent of " + this.type + " type of the field " + this.name);
            }
            this.range = paramRange;
        }
    }

    private Range defaultRange() {
        if (this.type == Byte.TYPE) {
            return RangeImpl.DEFAULT_BYTE_RANGE;
        }
        if (this.type == Character.TYPE) {
            return RangeImpl.DEFAULT_CHAR_RANGE;
        }
        if (this.type == Short.TYPE) {
            return RangeImpl.DEFAULT_SHORT_RANGE;
        }
        if (this.type == Integer.TYPE) {
            return RangeImpl.DEFAULT_INT_RANGE;
        }
        if (this.type == Long.TYPE) {
            return RangeImpl.DEFAULT_LONG_RANGE;
        }
        throw new AssertionError((Object)("not an integer type: " + this.type));
    }

    private Range range() {
        return this.range != null ? this.range : this.defaultRange();
    }

    @Override
    int sizeInBits() {
        Range range = this.range();
        long options = range.max() - range.min() + 1L;
        int coverBits = options <= 0L ? 64 : IntegerFieldModel.coverBits(options);
        if (coverBits > Primitives.widthInBits(this.type)) {
            throw new IllegalStateException(range + " too wide for " + this.type + " type");
        }
        return this.sizeInBitsConsideringVolatileOrOrderedPuts(coverBits);
    }

    String genGet(ValueBuilder valueBuilder, Function<String, String> accessType) {
        int bitOffset = valueBuilder.model.fieldBitOffset(this.outerModel);
        int byteOffset = bitOffset / 8;
        int bitExtent = valueBuilder.model.fieldBitExtent(this.outerModel);
        String readOffset = "offset + " + byteOffset;
        int lowMaskBits = bitOffset - byteOffset * 8;
        return this.genGet(lowMaskBits, bitExtent, readOffset, accessType);
    }

    private String genGet(int lowMaskBits, int bitExtent, String readOffset, Function<String, String> accessType) {
        String add;
        Range range;
        int leastBitsToRead = lowMaskBits + this.sizeInBits();
        int bitsToRead = Maths.nextPower2((int)leastBitsToRead, (int)8);
        int highMaskBits = Math.max(bitsToRead - bitExtent - lowMaskBits, 0);
        int fieldBits = bitsToRead - lowMaskBits - highMaskBits;
        String read = IntegerFieldModel.read(readOffset, bitsToRead, accessType);
        long readMin = -1L << fieldBits - 1;
        long readMax = -(readMin + 1L);
        if (lowMaskBits > 0 || highMaskBits > 0) {
            if (lowMaskBits > 0) {
                read = String.format("%s >> %d", read, lowMaskBits);
            }
            if (highMaskBits > 0) {
                String l = bitsToRead == 64 ? "L" : "";
                read = String.format("(%s) & ((1%s << %d) - 1)", read, l, fieldBits);
                readMin = 0L;
                readMax = (1L << fieldBits) - 1L;
            }
        }
        if (readMin <= (range = this.range()).min() && readMax >= range.max()) {
            return read;
        }
        long readRange = readMax - readMin;
        if (range.min() == 0L && (readRange < 0L || range.max() <= readRange)) {
            String mask = fieldBits % 4 == 0 ? "0x" + IntegerFieldModel.repeat('F', fieldBits / 4) : "0b" + IntegerFieldModel.repeat('1', fieldBits);
            if (this.type == Long.TYPE) {
                mask = mask + "L";
            }
            return this.cast(String.format("(%s) & %s", read, mask));
        }
        if (this.type != Long.TYPE) {
            assert (bitsToRead <= 32) : "long read of int value is possible only if the value spans 5 bytes, therefore must be masked";
            add = (int)range.min() - (int)readMin + "";
        } else {
            add = range.min() - readMin + "L";
        }
        return this.cast(String.format("(%s) + %s", read, add));
    }

    private String cast(String value) {
        if (this.type == Byte.TYPE || this.type == Character.TYPE || this.type == Short.TYPE) {
            value = String.format("((%s) (%s))", this.type.getSimpleName(), value);
        }
        return value;
    }

    String genArrayElementGet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, Function<String, String> accessType) {
        int arrayBitOffset = valueBuilder.model.fieldBitOffset(arrayFieldModel);
        if (arrayBitOffset % 8 != 0) {
            throw new UnsupportedOperationException("not implemented yet");
        }
        int arrayByteOffset = arrayBitOffset / 8;
        int elemBitExtent = arrayFieldModel.elemBitExtent();
        if (elemBitExtent % 8 == 0) {
            IntegerFieldModel.genVerifiedElementOffset(arrayFieldModel, methodBuilder);
            String readOffset = String.format("offset + %d + elementOffset", arrayByteOffset);
            return this.genGet(0, elemBitExtent, readOffset, accessType);
        }
        throw new UnsupportedOperationException("not implemented yet");
    }

    void genSet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, Function<String, String> accessType, String valueToWrite) {
        int bitOffset = valueBuilder.model.fieldBitOffset(this.outerModel);
        int byteOffset = bitOffset / 8;
        String ioOffset = "offset + " + byteOffset;
        int lowMaskBits = bitOffset - byteOffset * 8;
        int bitExtent = valueBuilder.model.fieldBitExtent(this.outerModel);
        this.genSet(methodBuilder, lowMaskBits, bitExtent, ioOffset, accessType, valueToWrite);
    }

    private void genSet(MethodSpec.Builder methodBuilder, int lowMaskBits, int bitExtent, String ioOffset, Function<String, String> accessType, String valueToWrite) {
        Class ioType;
        long readMax;
        long readMin;
        int leastBitsToWrite = lowMaskBits + this.sizeInBits();
        int bitsToWrite = Maths.nextPower2((int)leastBitsToWrite, (int)8);
        int highMaskBits = Math.max(bitsToWrite - bitExtent - lowMaskBits, 0);
        int fieldBits = bitsToWrite - lowMaskBits - highMaskBits;
        if (highMaskBits == 0) {
            readMin = -1L << fieldBits - 1;
            readMax = -(readMin + 1L);
        } else {
            readMin = 0L;
            readMax = (1L << fieldBits) - 1L;
        }
        long readRange = readMax - readMin;
        Range range = this.range();
        if ((readMin > range.min() || readMax < range.max()) && (range.min() != 0L || readRange >= 0L && range.max() > readRange)) {
            String sub;
            if (this.type != Long.TYPE) {
                assert (bitsToWrite <= 32) : "long read of int value is possible only if the value spans 5 bytes, therefore must be masked";
                sub = (int)range.min() - (int)readMin + "";
            } else {
                sub = range.min() - readMin + "L";
            }
            valueToWrite = String.format("((%s) - %s)", valueToWrite, sub);
        }
        if (lowMaskBits > 0 || highMaskBits > 0) {
            assert (accessType == NORMAL_ACCESS_TYPE) : "volatile/ordered fields shouldn't have masking";
            String mask = lowMaskBits % 4 == 0 && fieldBits % 4 == 0 && highMaskBits % 4 == 0 ? "0x" + IntegerFieldModel.repeat('F', highMaskBits / 4) + IntegerFieldModel.repeat('0', fieldBits / 4) + IntegerFieldModel.repeat('F', lowMaskBits / 4) : "0b" + IntegerFieldModel.repeat('1', highMaskBits) + IntegerFieldModel.repeat('0', fieldBits) + IntegerFieldModel.repeat('1', lowMaskBits);
            if (bitsToWrite == 64) {
                mask = mask + "L";
            }
            String read = IntegerFieldModel.read(ioOffset, bitsToWrite, NORMAL_ACCESS_TYPE);
            if (lowMaskBits > 0) {
                valueToWrite = String.format("((%s) << %s)", valueToWrite, lowMaskBits);
            }
            valueToWrite = String.format("((%s) & %s) | (%s)", read, mask, valueToWrite);
        }
        if ((ioType = IntegerFieldModel.integerBytesIoType(bitsToWrite)) != this.type) {
            valueToWrite = String.format("(%s) (%s)", ioType.getSimpleName(), valueToWrite);
        }
        String writeMethod = "write" + accessType.apply(this.type != Character.TYPE ? IntegerFieldModel.integerBytesMethodSuffix(bitsToWrite) : "UnsignedShort");
        String write = String.format("bs.%s(%s, %s)", writeMethod, ioOffset, valueToWrite);
        methodBuilder.addStatement(write, new Object[0]);
    }

    void genArrayElementSet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, Function<String, String> accessType, String valueToWrite) {
        int arrayBitOffset = valueBuilder.model.fieldBitOffset(arrayFieldModel);
        if (arrayBitOffset % 8 != 0) {
            throw new UnsupportedOperationException("not implemented yet");
        }
        int arrayByteOffset = arrayBitOffset / 8;
        int elemBitExtent = arrayFieldModel.elemBitExtent();
        if (elemBitExtent % 8 != 0) {
            throw new UnsupportedOperationException("not implemented yet");
        }
        IntegerFieldModel.genVerifiedElementOffset(arrayFieldModel, methodBuilder);
        String ioOffset = String.format("offset + %d + elementOffset", arrayByteOffset);
        this.genSet(methodBuilder, 0, elemBitExtent, ioOffset, accessType, valueToWrite);
    }

    @Override
    MemberGenerator nativeGenerator() {
        return this.nativeGenerator;
    }

    @Override
    MemberGenerator createHeapGenerator() {
        return new NumberHeapMemberGenerator(this);
    }
}

