/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.values.CompilerUtils;
import net.openhft.chronicle.values.JavaSourceFromString;
import net.openhft.chronicle.values.MyJavaFileManager;
import org.jetbrains.annotations.NotNull;

class CachedCompiler {
    private static final Map<ClassLoader, Map<String, Class>> loadedClassesMap = new WeakHashMap<ClassLoader, Map<String, Class>>();
    private static final List<String> java8Options = Arrays.asList("-XDenableSunApiLintControl", "-Xlint:-sunapi");
    private static final List<String> java9PlusOptions = null;
    private final Map<String, JavaFileObject> javaFileObjects = new HashMap<String, JavaFileObject>();
    private boolean errors;

    CachedCompiler() {
    }

    @NotNull
    Map<String, byte[]> compileFromJava(Class valueType, @NotNull String className, @NotNull String javaCode) {
        this.javaFileObjects.put(className, new JavaSourceFromString(className, javaCode));
        Collection<JavaFileObject> compilationUnits = this.javaFileObjects.values();
        MyJavaFileManager fileManager = new MyJavaFileManager(valueType, CompilerUtils.s_standardJavaFileManager);
        this.errors = false;
        List<String> compilerOptions = Jvm.isJava9Plus() ? java9PlusOptions : java8Options;
        CompilerUtils.s_compiler.getTask(null, fileManager, diagnostic -> {
            if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                this.errors = true;
                System.err.println(diagnostic);
            }
        }, compilerOptions, null, compilationUnits).call();
        Map<String, byte[]> result = fileManager.getAllBuffers();
        if (this.errors) {
            this.javaFileObjects.remove(className);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadFromJava(Class valueType, @NotNull ClassLoader classLoader, @NotNull String className, @NotNull String javaCode) throws ClassNotFoundException {
        Map<String, Class> loadedClasses;
        Class<?> clazz = null;
        Map<ClassLoader, Map<String, Class>> map = loadedClassesMap;
        synchronized (map) {
            loadedClasses = loadedClassesMap.get(classLoader);
            if (loadedClasses == null) {
                loadedClasses = new LinkedHashMap<String, Class>();
                loadedClassesMap.put(classLoader, loadedClasses);
            } else {
                clazz = loadedClasses.get(className);
            }
        }
        if (clazz != null) {
            return clazz;
        }
        for (Map.Entry entry : this.compileFromJava(valueType, className, javaCode).entrySet()) {
            String className2 = (String)entry.getKey();
            Map<ClassLoader, Map<String, Class>> map2 = loadedClassesMap;
            synchronized (map2) {
                if (loadedClasses.containsKey(className2)) {
                    continue;
                }
            }
            byte[] bytes = (byte[])entry.getValue();
            Class clazz2 = CompilerUtils.defineClass(classLoader, className2, bytes);
            Map<ClassLoader, Map<String, Class>> map3 = loadedClassesMap;
            synchronized (map3) {
                loadedClasses.put(className2, clazz2);
            }
        }
        map = loadedClassesMap;
        synchronized (map) {
            clazz = classLoader.loadClass(className);
            loadedClasses.put(className, clazz);
        }
        return clazz;
    }
}

