/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.lang.model.element.Modifier;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.values.Copyable;
import net.openhft.chronicle.values.FieldModel;
import net.openhft.chronicle.values.HeapByteable;
import net.openhft.chronicle.values.MemberGenerator;
import net.openhft.chronicle.values.ValueBuilder;
import net.openhft.chronicle.values.ValueModel;

final class Generators {
    private static final boolean DUMP_CODE = Boolean.getBoolean("chronicle.values.dumpCode");

    static String generateNativeClass(ValueModel model, String nativeClassName) {
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)nativeClassName);
        typeBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        ValueBuilder valueBuilder = new ValueBuilder(model, nativeClassName, typeBuilder);
        model.fields().forEach(f -> f.generateNativeMembers(valueBuilder));
        Generators.generateNativeCommons(valueBuilder);
        valueBuilder.closeConstructorsAndInitializationBlocks();
        TypeSpec nativeType = typeBuilder.build();
        String result = JavaFile.builder((String)model.valueType.getPackage().getName(), (TypeSpec)nativeType).build().toString();
        if (DUMP_CODE) {
            System.out.println(result);
        }
        return result;
    }

    private static void generateNativeCommons(ValueBuilder valueBuilder) {
        Generators.generateValueCommons(valueBuilder, FieldModel::nativeGenerator);
        ValueModel model = valueBuilder.model;
        valueBuilder.typeBuilder.addSuperinterface(Byteable.class).addField(BytesStore.class, "bs", new Modifier[]{Modifier.PRIVATE}).addField(Long.TYPE, "offset", new Modifier[]{Modifier.PRIVATE}).addMethod(Generators.bytesStoreMethod(model)).addMethod(Generators.bytesStoreGetterMethod()).addMethod(Generators.offsetMethod()).addMethod(Generators.maxSizeMethod(model));
    }

    private static MethodSpec bytesStoreMethod(ValueModel model) {
        try {
            Method bytesStoreReflectMethod = Byteable.class.getMethod("bytesStore", BytesStore.class, Long.TYPE, Long.TYPE);
            return Generators.methodBuilder(bytesStoreReflectMethod, Arrays.asList("bytesStore", "offset", "length")).beginControlFlow("if (length != maxSize())", new Object[0]).addStatement("throw new $T($S + length)", new Object[]{IllegalArgumentException.class, String.format("Constant size is %d, given length is ", model.sizeInBytes())}).endControlFlow().addStatement("this.bs = bytesStore", new Object[0]).addStatement("this.offset = offset", new Object[0]).build();
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static MethodSpec bytesStoreGetterMethod() {
        try {
            Method bytesStoreReflectMethod = Byteable.class.getMethod("bytesStore", new Class[0]);
            return Generators.methodBuilder(bytesStoreReflectMethod, Collections.emptyList()).addStatement("return bs", new Object[0]).build();
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static MethodSpec offsetMethod() {
        try {
            return Generators.methodBuilder(Byteable.class.getMethod("offset", new Class[0]), Collections.emptyList()).addStatement("return offset", new Object[0]).build();
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static MethodSpec maxSizeMethod(ValueModel model) {
        try {
            return Generators.methodBuilder(Byteable.class.getMethod("maxSize", new Class[0]), Collections.emptyList()).addStatement("return $L", new Object[]{model.sizeInBytes()}).build();
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void generateValueCommons(ValueBuilder valueBuilder, Function<FieldModel, MemberGenerator> generator) {
        Class<?> valueType = valueBuilder.model.valueType;
        valueBuilder.typeBuilder.addSuperinterface(valueType).addSuperinterface((TypeName)ParameterizedTypeName.get(Copyable.class, (Type[])new Type[]{valueType})).addSuperinterface(BytesMarshallable.class);
        valueBuilder.typeBuilder.addMethod(Generators.copyFromMethod(valueBuilder, generator)).addMethod(Generators.writeMarshallableMethod(valueBuilder, generator)).addMethod(Generators.readMarshallableMethod(valueBuilder, generator)).addMethod(Generators.equalsMethod(valueBuilder, generator)).addMethod(Generators.hashCodeMethod(valueBuilder, generator)).addMethod(Generators.toStringMethod(valueBuilder, generator));
    }

    private static MethodSpec copyFromMethod(ValueBuilder valueBuilder, Function<FieldModel, MemberGenerator> generator) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"copyFrom").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(valueBuilder.model.valueType, "from", new Modifier[0]);
        valueBuilder.model.fields().forEach(f -> ((MemberGenerator)generator.apply((FieldModel)f)).generateCopyFrom(valueBuilder, methodBuilder));
        return methodBuilder.build();
    }

    private static MethodSpec readMarshallableMethod(ValueBuilder valueBuilder, Function<FieldModel, MemberGenerator> generator) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"readMarshallable").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Bytes.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)}), "bytes", new Modifier[0]);
        valueBuilder.model.fields().forEach(f -> ((MemberGenerator)generator.apply((FieldModel)f)).generateReadMarshallable(valueBuilder, methodBuilder));
        return methodBuilder.build();
    }

    private static MethodSpec writeMarshallableMethod(ValueBuilder valueBuilder, Function<FieldModel, MemberGenerator> generator) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"writeMarshallable").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Bytes.class, "bytes", new Modifier[0]);
        valueBuilder.model.fields().forEach(f -> ((MemberGenerator)generator.apply((FieldModel)f)).generateWriteMarshallable(valueBuilder, methodBuilder));
        return methodBuilder.build();
    }

    private static MethodSpec equalsMethod(ValueBuilder valueBuilder, Function<FieldModel, MemberGenerator> generator) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"equals").addParameter(Object.class, "obj", new Modifier[0]).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE);
        Class<?> valueType = valueBuilder.model.valueType;
        methodBuilder.addCode("if (!(obj instanceof $T)) return false;\n", new Object[]{valueType});
        methodBuilder.addStatement("$T other = ($T) obj", new Object[]{valueType, valueType});
        valueBuilder.model.fields().forEach(f -> ((MemberGenerator)generator.apply((FieldModel)f)).generateEquals(valueBuilder, methodBuilder));
        methodBuilder.addStatement("return true", new Object[0]);
        return methodBuilder.build();
    }

    private static MethodSpec hashCodeMethod(ValueBuilder valueBuilder, Function<FieldModel, MemberGenerator> generator) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"hashCode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE);
        methodBuilder.addStatement("int hashCode = 1", new Object[0]);
        valueBuilder.model.fields().forEach(f -> {
            methodBuilder.addStatement("hashCode *= 1000003", new Object[0]);
            String fieldHashCode = ((MemberGenerator)generator.apply((FieldModel)f)).generateHashCode(valueBuilder, methodBuilder);
            methodBuilder.addStatement("hashCode ^= $N", new Object[]{fieldHashCode});
        });
        methodBuilder.addStatement("return hashCode", new Object[0]);
        return methodBuilder.build();
    }

    private static MethodSpec toStringMethod(ValueBuilder valueBuilder, Function<FieldModel, MemberGenerator> generator) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class);
        methodBuilder.addStatement("$T sb = new $T()", new Object[]{StringBuilder.class, StringBuilder.class});
        String modelName = valueBuilder.model.simpleName();
        methodBuilder.addStatement("sb.append($S)", new Object[]{modelName});
        valueBuilder.model.fields().forEach(f -> ((MemberGenerator)generator.apply((FieldModel)f)).generateToString(valueBuilder, methodBuilder));
        methodBuilder.addStatement("sb.setCharAt($L, '{')", new Object[]{modelName.length()});
        methodBuilder.addStatement("sb.append(' ').append('}')", new Object[0]);
        methodBuilder.addStatement("return sb.toString()", new Object[0]);
        return methodBuilder.build();
    }

    static String generateHeapClass(ValueModel model, String heapClassName) {
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)heapClassName);
        typeBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        ValueBuilder valueBuilder = new ValueBuilder(model, heapClassName, typeBuilder);
        model.fields().forEach(f -> f.generateHeapMembers(valueBuilder));
        Generators.generateValueCommons(valueBuilder, FieldModel::heapGenerator);
        if (Byteable.class.isAssignableFrom(model.valueType)) {
            typeBuilder.addSuperinterface(HeapByteable.class);
        }
        valueBuilder.closeConstructorsAndInitializationBlocks();
        TypeSpec heapType = typeBuilder.build();
        String result = JavaFile.builder((String)model.valueType.getPackage().getName(), (TypeSpec)heapType).build().toString();
        if (DUMP_CODE) {
            System.out.println(result);
        }
        return result;
    }

    static MethodSpec.Builder methodBuilder(Method m, List<String> paramNames) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)m.getName()).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.returns(m.getReturnType());
        Parameter[] parameters = m.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter p = parameters[i];
            builder.addParameter(ParameterSpec.builder(p.getType(), (String)paramNames.get(i), (Modifier[])new Modifier[0]).build());
        }
        return builder;
    }

    private Generators() {
    }
}

