/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import com.squareup.javapoet.MethodSpec;
import java.lang.reflect.Method;
import java.util.Date;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.values.Array;
import net.openhft.chronicle.values.BooleanFieldModel;
import net.openhft.chronicle.values.CharSequenceFieldModel;
import net.openhft.chronicle.values.DateFieldModel;
import net.openhft.chronicle.values.EnumFieldModel;
import net.openhft.chronicle.values.FieldModel;
import net.openhft.chronicle.values.FloatingFieldModel;
import net.openhft.chronicle.values.IntegerFieldModel;
import net.openhft.chronicle.values.MemberGenerator;
import net.openhft.chronicle.values.MethodTemplate;
import net.openhft.chronicle.values.Primitives;
import net.openhft.chronicle.values.ScalarFieldModel;
import net.openhft.chronicle.values.Utils;
import net.openhft.chronicle.values.ValueBuilder;
import net.openhft.chronicle.values.ValueFieldModel;
import org.jetbrains.annotations.NotNull;

public class ArrayFieldModel
extends FieldModel {
    ScalarFieldModel elemModel;
    Array array;
    private MemberGenerator nativeGenerator;

    @Override
    void addLayoutInfo(Method m, MethodTemplate template) {
        super.addLayoutInfo(m, template);
        Array array = m.getAnnotation(Array.class);
        if (array != null) {
            if (this.array != null) {
                throw new IllegalStateException("@Array should be specified only once for " + this.name + " field. Specified " + this.array + " and " + array);
            }
            if (array.length() <= 1) {
                throw new IllegalStateException(array + ": length should be > 1, field " + this.name);
            }
            this.array = array;
            int elementOffsetAlignment = array.elementOffsetAlignment();
            if (elementOffsetAlignment == -1 && !(this.elemModel instanceof ValueFieldModel)) {
                elementOffsetAlignment = 0;
            }
            this.elemModel.setOffsetAlignmentExplicitly(elementOffsetAlignment);
            this.elemModel.dontCrossAlignment = array.elementDontCrossAlignment();
        }
    }

    @Override
    void addTypeInfo(Method m, MethodTemplate template) {
        super.addTypeInfo(m, template);
        if (this.elemModel == null) {
            this.elemModel = this.createScalarModel(this.type);
            this.elemModel.name = this.name;
        }
        this.elemModel.addTypeInfo(m, template);
    }

    ScalarFieldModel createScalarModel(Class type) {
        return ArrayFieldModel.createScalarFieldModel(type, this.name);
    }

    @NotNull
    static ScalarFieldModel createScalarFieldModel(Class type, String fieldName) {
        if (Primitives.isPrimitiveIntegerType(type)) {
            return new IntegerFieldModel();
        }
        if (type == Float.TYPE || type == Double.TYPE) {
            return new FloatingFieldModel();
        }
        if (type == Boolean.TYPE) {
            return new BooleanFieldModel();
        }
        if (Enum.class.isAssignableFrom(type)) {
            return new EnumFieldModel();
        }
        if (type == Date.class) {
            return new DateFieldModel();
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return new CharSequenceFieldModel();
        }
        if (type.isInterface()) {
            return new ValueFieldModel();
        }
        throw new IllegalStateException(fieldName + " field type " + type + " is not supported: " + "not a primitive, enum, CharSequence or another value interface");
    }

    @Override
    int sizeInBits() {
        int elemDontCrossBits;
        int elemSizeInBits = this.elemModel.sizeInBits();
        int elemBitExtent = this.elemBitExtent();
        if (elemBitExtent <= (elemDontCrossBits = this.elemModel.dontCrossAlignmentInBits())) {
            int elemsInOneAlignment = 1 << Maths.intLog2((long)(elemDontCrossBits / elemBitExtent));
            return this.array.length() / elemsInOneAlignment * elemDontCrossBits + (this.array.length() % elemsInOneAlignment - 1) * elemBitExtent + elemSizeInBits;
        }
        assert (elemDontCrossBits == 0) : "" + elemDontCrossBits;
        return elemBitExtent * (this.array.length() - 1) + elemSizeInBits;
    }

    int elemBitExtent() {
        return Utils.roundUp(this.elemModel.sizeInBits(), this.elemModel.offsetAlignmentInBits());
    }

    @Override
    int offsetAlignmentInBytes() {
        int elementAlignment = this.elemModel.maxAlignmentInBytes();
        if (this.offsetAlignment == -1) {
            return elementAlignment;
        }
        if (this.offsetAlignment == 0 && elementAlignment == 1) {
            return 1;
        }
        if (this.offsetAlignment < elementAlignment || elementAlignment > 0 && this.offsetAlignment % elementAlignment != 0) {
            throw new IllegalStateException("Alignment of the array field " + this.name + " " + this.offsetAlignment + " must be a multiple of it's element alignment " + elementAlignment + " (offset alignment is " + this.elemModel.offsetAlignmentInBytes() + ", dontCross alignment is " + this.elemModel.dontCrossAlignmentInBytes());
        }
        return this.offsetAlignment;
    }

    @Override
    void postProcess() {
        super.postProcess();
        this.elemModel.postProcess();
    }

    @Override
    void checkState() {
        super.checkState();
        this.elemModel.checkState();
    }

    @NotNull
    private ArrayFieldModel self() {
        return this;
    }

    @Override
    MemberGenerator nativeGenerator() {
        if (this.nativeGenerator == null) {
            this.nativeGenerator = new ArrayMemberGenerator(this, this.elemModel.nativeGenerator());
        }
        return this.nativeGenerator;
    }

    @Override
    MemberGenerator createHeapGenerator() {
        return new ArrayMemberGenerator(this, this.elemModel.heapGenerator());
    }

    void checkBounds(MethodSpec.Builder methodBuilder) {
        methodBuilder.beginControlFlow("if (index < 0 || index >= $L)", new Object[]{this.array.length()});
        methodBuilder.addStatement("throw new $T(index + $S)", new Object[]{ArrayIndexOutOfBoundsException.class, " is out of bounds, array length " + this.array.length()});
        methodBuilder.endControlFlow();
    }

    public Array array() {
        return this.array;
    }

    private class ArrayMemberGenerator
    extends MemberGenerator {
        private final MemberGenerator elemGenerator;

        private ArrayMemberGenerator(FieldModel fieldModel, MemberGenerator elemGenerator) {
            super(fieldModel);
            this.elemGenerator = elemGenerator;
        }

        @Override
        public void generateFields(ValueBuilder valueBuilder) {
            this.elemGenerator.generateArrayElementFields(ArrayFieldModel.this.self(), valueBuilder);
        }

        @Override
        public void generateGet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.elemGenerator.generateArrayElementGet(ArrayFieldModel.this.self(), valueBuilder, methodBuilder);
        }

        @Override
        public void generateGetVolatile(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.elemGenerator.generateArrayElementGetVolatile(ArrayFieldModel.this.self(), valueBuilder, methodBuilder);
        }

        @Override
        public void generateGetUsing(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.elemGenerator.generateArrayElementGetUsing(ArrayFieldModel.this.self(), valueBuilder, methodBuilder);
        }

        @Override
        public void generateSet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.elemGenerator.generateArrayElementSet(ArrayFieldModel.this.self(), valueBuilder, methodBuilder);
        }

        @Override
        public void generateSetVolatile(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.elemGenerator.generateArrayElementSetVolatile(ArrayFieldModel.this.self(), valueBuilder, methodBuilder);
        }

        @Override
        public void generateSetOrdered(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.elemGenerator.generateArrayElementSetOrdered(ArrayFieldModel.this.self(), valueBuilder, methodBuilder);
        }

        @Override
        public void generateAdd(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.elemGenerator.generateArrayElementAdd(ArrayFieldModel.this.self(), valueBuilder, methodBuilder);
        }

        @Override
        public void generateAddAtomic(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.elemGenerator.generateArrayElementAddAtomic(ArrayFieldModel.this.self(), valueBuilder, methodBuilder);
        }

        @Override
        public void generateCompareAndSwap(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.elemGenerator.generateArrayElementCompareAndSwap(ArrayFieldModel.this.self(), valueBuilder, methodBuilder);
        }

        @Override
        public void generateCopyFrom(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.beginLoop(methodBuilder);
            this.elemGenerator.generateArrayElementCopyFrom(ArrayFieldModel.this.self(), valueBuilder, methodBuilder);
            methodBuilder.endControlFlow();
        }

        private void beginLoop(MethodSpec.Builder methodBuilder) {
            methodBuilder.beginControlFlow("for (int index = 0; index < $L; index++)", new Object[]{ArrayFieldModel.this.array.length()});
        }

        @Override
        void generateWriteMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.beginLoop(methodBuilder);
            this.elemGenerator.generateArrayElementWriteMarshallable(ArrayFieldModel.this.self(), valueBuilder, methodBuilder);
            methodBuilder.endControlFlow();
        }

        @Override
        void generateArrayElementWriteMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            throw new UnsupportedOperationException();
        }

        @Override
        void generateReadMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.beginLoop(methodBuilder);
            this.elemGenerator.generateArrayElementReadMarshallable(ArrayFieldModel.this.self(), valueBuilder, methodBuilder);
            methodBuilder.endControlFlow();
        }

        @Override
        void generateEquals(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.beginLoop(methodBuilder);
            this.elemGenerator.generateArrayElementEquals(ArrayFieldModel.this.self(), valueBuilder, methodBuilder);
            methodBuilder.endControlFlow();
        }

        @Override
        String generateHashCode(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            String hashCodeVarName = ArrayFieldModel.this.varName() + "HashCode";
            methodBuilder.addStatement("int $N = 1", new Object[]{hashCodeVarName});
            this.beginLoop(methodBuilder);
            methodBuilder.addStatement("$N *= 1000003", new Object[]{hashCodeVarName});
            String elemHashCode = this.elemGenerator.generateArrayElementHashCode(ArrayFieldModel.this.self(), valueBuilder, methodBuilder);
            methodBuilder.addStatement("$N ^= $N", new Object[]{hashCodeVarName, elemHashCode});
            methodBuilder.endControlFlow();
            return hashCodeVarName;
        }

        @Override
        void generateToString(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("sb.append($S)", new Object[]{", " + this.fieldModel.name + "=["});
            this.beginLoop(methodBuilder);
            this.elemGenerator.generateArrayElementToString(ArrayFieldModel.this.self(), valueBuilder, methodBuilder);
            methodBuilder.endControlFlow();
            methodBuilder.addStatement("sb.setCharAt(sb.length() - 2, ']')", new Object[0]);
            methodBuilder.addStatement("sb.setLength(sb.length() - 1)", new Object[0]);
        }

        @Override
        void generateArrayElementToString(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            throw new UnsupportedOperationException();
        }
    }
}

