/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import javax.lang.model.element.Modifier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.values.ArrayFieldModel;
import net.openhft.chronicle.values.FieldModel;
import net.openhft.chronicle.values.MemberGenerator;
import net.openhft.chronicle.values.ValueBuilder;
import sun.misc.Unsafe;

abstract class HeapMemberGenerator
extends MemberGenerator {
    FieldSpec field;
    private FieldSpec fieldOffset;

    HeapMemberGenerator(FieldModel fieldModel) {
        super(fieldModel);
    }

    abstract String putVolatile();

    abstract String putOrdered();

    abstract String compareAndSwap();

    abstract String arrayBase();

    abstract String arrayScale();

    FieldSpec fieldOffset(ValueBuilder valueBuilder) {
        if (this.fieldOffset == null) {
            this.fieldOffset = FieldSpec.builder(Long.TYPE, (String)(this.fieldModel.name + "Offset"), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).build();
            valueBuilder.staticBlockBuilder().addStatement("$N = $N.objectFieldOffset($T.getField($N.class, $S))", new Object[]{this.fieldOffset, valueBuilder.unsafe(), Jvm.class, valueBuilder.className, this.field.name});
            valueBuilder.typeBuilder.addField(this.fieldOffset);
        }
        return this.fieldOffset;
    }

    Class fieldType() {
        return this.fieldModel.type;
    }

    abstract String wrap(String var1);

    abstract String unwrap(String var1);

    @Override
    void generateFields(ValueBuilder valueBuilder) {
        this.field = FieldSpec.builder((Type)this.fieldType(), (String)this.fieldModel.fieldName(), (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        valueBuilder.typeBuilder.addField(this.field);
    }

    @Override
    void generateArrayElementFields(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder) {
        this.field = FieldSpec.builder((TypeName)ArrayTypeName.of((Type)this.fieldType()), (String)this.fieldModel.fieldName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).initializer("new $T[$L]", new Object[]{this.fieldType(), arrayFieldModel.array.length()}).build();
        valueBuilder.typeBuilder.addField(this.field);
    }

    @Override
    public void generateGet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        methodBuilder.addStatement("return " + this.wrap("$N"), new Object[]{this.field});
    }

    @Override
    public void generateArrayElementGet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        methodBuilder.addStatement("return " + this.wrap("$N[index]"), new Object[]{this.field});
    }

    @Override
    public void generateSet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        methodBuilder.addStatement("this.$N = " + this.unwrap("$N"), new Object[]{this.field, this.fieldModel.varName()});
    }

    @Override
    public void generateArrayElementSet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        methodBuilder.addStatement("this.$N[index] = " + this.unwrap("$N"), new Object[]{this.field, this.fieldModel.varName()});
    }

    @Override
    public void generateSetVolatile(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        methodBuilder.addStatement(String.format("$N.$N(this, $N, %s)", this.unwrap("$N")), new Object[]{valueBuilder.unsafe(), this.putVolatile(), this.fieldOffset(valueBuilder), this.fieldModel.varName()});
    }

    @Override
    public void generateArrayElementSetVolatile(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        arrayFieldModel.checkBounds(methodBuilder);
        methodBuilder.addStatement(String.format("$N.$N($N, (long) $T.$N + (index * (long) $T.$N), %s)", this.unwrap("$N")), new Object[]{valueBuilder.unsafe(), this.putVolatile(), this.field, Unsafe.class, this.arrayBase(), Unsafe.class, this.arrayScale(), this.fieldModel.varName()});
    }

    @Override
    public void generateSetOrdered(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        methodBuilder.addStatement(String.format("$N.$N(this, $N, %s)", this.unwrap("$N")), new Object[]{valueBuilder.unsafe(), this.putOrdered(), this.fieldOffset(valueBuilder), this.fieldModel.varName()});
    }

    @Override
    public void generateArrayElementSetOrdered(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        arrayFieldModel.checkBounds(methodBuilder);
        methodBuilder.addStatement(String.format("$N.$N($N, (long) $T.$N + (index * (long) $T.$N), %s)", this.unwrap("$N")), new Object[]{valueBuilder.unsafe(), this.putOrdered(), this.field, Unsafe.class, this.arrayBase(), Unsafe.class, this.arrayScale(), this.fieldModel.varName()});
    }

    @Override
    public void generateCompareAndSwap(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        methodBuilder.addStatement(String.format("return $N.$N(this, $N, %s, %s)", this.unwrap("$N"), this.unwrap("$N")), new Object[]{valueBuilder.unsafe(), this.compareAndSwap(), this.fieldOffset(valueBuilder), this.fieldModel.oldName(), this.fieldModel.newName()});
    }

    @Override
    public void generateArrayElementCompareAndSwap(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        arrayFieldModel.checkBounds(methodBuilder);
        methodBuilder.addStatement(String.format("return $N.$N($N, (long) $T.$N + (index * (long) $T.$N), %s, %s)", this.unwrap("$N"), this.unwrap("$N")), new Object[]{valueBuilder.unsafe(), this.compareAndSwap(), this.field, Unsafe.class, this.arrayBase(), Unsafe.class, this.arrayScale(), this.fieldModel.oldName(), this.fieldModel.newName()});
    }

    @Override
    public void generateCopyFrom(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        methodBuilder.addStatement(String.format("this.$N = %s", this.unwrap("from.$N()")), new Object[]{this.field, this.fieldModel.getOrGetVolatile().getName()});
    }

    @Override
    public void generateArrayElementCopyFrom(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        methodBuilder.addStatement(String.format("this.$N[index] = %s", this.unwrap("from.$N(index)")), new Object[]{this.field, arrayFieldModel.getOrGetVolatile().getName()});
    }

    @Override
    void generateToString(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        this.genToString(methodBuilder, this.wrap(this.field.name));
    }

    @Override
    void generateArrayElementToString(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        this.genArrayElementToString(methodBuilder, this.wrap(this.field.name + "[index]"));
    }
}

