/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import com.squareup.javapoet.MethodSpec;
import net.openhft.chronicle.values.ArrayFieldModel;
import net.openhft.chronicle.values.FieldModel;
import net.openhft.chronicle.values.HeapMemberGenerator;
import net.openhft.chronicle.values.PrimitiveFieldModel;
import net.openhft.chronicle.values.Primitives;
import net.openhft.chronicle.values.Utils;
import net.openhft.chronicle.values.ValueBuilder;
import sun.misc.Unsafe;

class PrimitiveHeapMemberGenerator
extends HeapMemberGenerator {
    final String capType;
    private final String upperType;

    PrimitiveHeapMemberGenerator(FieldModel fieldModel) {
        super(fieldModel);
        assert (this.fieldType().isPrimitive());
        this.capType = Utils.capitalize(this.fieldType().getName());
        this.upperType = this.fieldType().getName().toUpperCase();
    }

    @Override
    Class fieldType() {
        Class modelType = super.fieldType();
        if (modelType == Long.TYPE || modelType == Integer.TYPE) {
            return modelType;
        }
        PrimitiveFieldModel fieldModel = (PrimitiveFieldModel)this.fieldModel;
        if (fieldModel.setOrdered != null || fieldModel.compareAndSwap != null || fieldModel.addAtomic != null) {
            if (modelType == Double.TYPE) {
                return Long.TYPE;
            }
            return Integer.TYPE;
        }
        return modelType;
    }

    String getVolatile() {
        return "get" + this.capType + "Volatile";
    }

    @Override
    String putVolatile() {
        return "put" + this.capType + "Volatile";
    }

    @Override
    String putOrdered() {
        return "putOrdered" + this.capType;
    }

    @Override
    String compareAndSwap() {
        return "compareAndSwap" + this.capType;
    }

    @Override
    String arrayBase() {
        return "ARRAY_" + this.upperType + "_BASE_OFFSET";
    }

    @Override
    String arrayScale() {
        return "ARRAY_" + this.upperType + "_INDEX_SCALE";
    }

    @Override
    String wrap(String rawStoredValue) {
        if (this.fieldType() == this.fieldModel.type) {
            return rawStoredValue;
        }
        if (this.fieldModel.type == Float.TYPE) {
            return "java.lang.Float.intBitsToFloat(" + rawStoredValue + ")";
        }
        if (this.fieldModel.type == Double.TYPE) {
            return "java.lang.Double.longBitsToDouble(" + rawStoredValue + ")";
        }
        if (this.fieldModel.type == Boolean.TYPE) {
            return "(" + rawStoredValue + " != 0)";
        }
        assert (this.fieldModel.type == Byte.TYPE || this.fieldModel.type == Short.TYPE || this.fieldModel.type == Character.TYPE);
        return "((" + this.fieldModel.type.getSimpleName() + ") " + rawStoredValue + ")";
    }

    @Override
    String unwrap(String inputValue) {
        if (this.fieldType() == this.fieldModel.type) {
            return inputValue;
        }
        if (this.fieldModel.type == Float.TYPE) {
            return "java.lang.Float.floatToRawIntBits(" + inputValue + ")";
        }
        if (this.fieldModel.type == Double.TYPE) {
            return "java.lang.Double.doubleToRawLongBits(" + inputValue + ")";
        }
        if (this.fieldModel.type == Boolean.TYPE) {
            return "(" + inputValue + " ? 1 : 0)";
        }
        assert (this.fieldModel.type == Byte.TYPE || this.fieldModel.type == Short.TYPE || this.fieldModel.type == Character.TYPE);
        return inputValue;
    }

    @Override
    public void generateGetVolatile(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        methodBuilder.addStatement("return " + this.wrap("$N.$N(this, $N)"), new Object[]{valueBuilder.unsafe(), this.getVolatile(), this.fieldOffset(valueBuilder)});
    }

    @Override
    public void generateArrayElementGetVolatile(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        arrayFieldModel.checkBounds(methodBuilder);
        methodBuilder.addStatement("return " + this.wrap("$N.$N($N, (long) $T.$N + (index * (long) $T.$N))"), new Object[]{valueBuilder.unsafe(), this.getVolatile(), this.field, Unsafe.class, this.arrayBase(), Unsafe.class, this.arrayScale()});
    }

    String getCast() {
        return this.fieldType() == this.fieldModel.type ? "" : String.format("(%s) ", this.fieldModel.type.getName());
    }

    @Override
    void generateReadMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        if (this.fieldModel.type != Character.TYPE || this.fieldType() != this.fieldModel.type) {
            methodBuilder.addStatement("$N = " + this.unwrap("bytes.$N()"), new Object[]{this.field, this.fieldModel.readMethod()});
        } else {
            methodBuilder.addStatement("$N = (char) bytes.readUnsignedShort()", new Object[]{this.field});
        }
    }

    @Override
    void generateArrayElementReadMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        if (this.fieldModel.type != Character.TYPE || this.fieldType() != this.fieldModel.type) {
            methodBuilder.addStatement("$N[index] = " + this.unwrap("bytes.$N()"), new Object[]{this.field, this.fieldModel.readMethod()});
        } else {
            methodBuilder.addStatement("$N[index] = (char) bytes.readUnsignedShort()", new Object[]{this.field});
        }
    }

    @Override
    void generateEquals(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        methodBuilder.addCode("if ($N() != other.$N()) return false;\n", new Object[]{this.fieldModel.getOrGetVolatile().getName(), this.fieldModel.getOrGetVolatile().getName()});
    }

    @Override
    void generateArrayElementEquals(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        String get = arrayFieldModel.getOrGetVolatile().getName();
        methodBuilder.addCode("if ($N(index) != other.$N(index)) return false;\n", new Object[]{get, get});
    }

    @Override
    String generateHashCode(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        return String.format("%s.hashCode(%s())", Primitives.boxed(this.fieldModel.type).getName(), this.fieldModel.getOrGetVolatile().getName());
    }

    @Override
    String generateArrayElementHashCode(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        return String.format("%s.hashCode(%s(index))", Primitives.boxed(this.fieldModel.type).getName(), arrayFieldModel.getOrGetVolatile().getName());
    }
}

