/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import com.squareup.javapoet.MethodSpec;
import java.util.Date;
import net.openhft.chronicle.values.ArrayFieldModel;
import net.openhft.chronicle.values.IntegerBackedFieldModel;
import net.openhft.chronicle.values.IntegerBackedMemberGenerator;
import net.openhft.chronicle.values.IntegerFieldModel;
import net.openhft.chronicle.values.MemberGenerator;
import net.openhft.chronicle.values.ObjectHeapMemberGenerator;
import net.openhft.chronicle.values.RangeImpl;
import net.openhft.chronicle.values.ValueBuilder;

class DateFieldModel
extends IntegerBackedFieldModel {
    final MemberGenerator nativeGenerator;

    DateFieldModel() {
        this.nativeGenerator = new IntegerBackedMemberGenerator(this, this.backend){

            @Override
            void generateArrayElementFields(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder) {
            }

            @Override
            protected void finishGet(MethodSpec.Builder methodBuilder, String value) {
                methodBuilder.addStatement(String.format("return new $T(%s)", value), new Object[]{Date.class});
            }

            @Override
            protected String startSet(MethodSpec.Builder methodBuilder) {
                return DateFieldModel.this.varName() + ".getTime()";
            }

            @Override
            void generateEquals(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                String time = this.backingFieldModel.genGet(valueBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE);
                methodBuilder.addStatement("if ($N != other.$N().getTime()) return false;\n", new Object[]{time, DateFieldModel.this.getOrGetVolatile().getName()});
            }

            @Override
            void generateArrayElementEquals(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                String time = this.backingFieldModel.genArrayElementGet(arrayFieldModel, valueBuilder, methodBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE);
                methodBuilder.addStatement("if ($N != other.$N(index).getTime()) return false;\n", new Object[]{time, arrayFieldModel.getOrGetVolatile().getName()});
            }

            @Override
            String generateHashCode(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                String time = this.backingFieldModel.genGet(valueBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE);
                return String.format("java.lang.Long.hashCode(%s)", time);
            }

            @Override
            String generateArrayElementHashCode(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                String time = this.backingFieldModel.genArrayElementGet(arrayFieldModel, valueBuilder, methodBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE);
                return String.format("java.lang.Long.hashCode(%s)", time);
            }
        };
    }

    @Override
    void postProcess() {
        super.postProcess();
        this.backend.type = Long.TYPE;
        this.backend.range = RangeImpl.DEFAULT_LONG_RANGE;
    }

    @Override
    MemberGenerator nativeGenerator() {
        return this.nativeGenerator;
    }

    @Override
    MemberGenerator createHeapGenerator() {
        return new ObjectHeapMemberGenerator(this){

            @Override
            void generateWriteMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("bytes.writeLong($N.getTime())", new Object[]{DateFieldModel.this.fieldName()});
            }

            @Override
            void generateArrayElementWriteMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("bytes.writeLong($N[index].getTime())", new Object[]{DateFieldModel.this.fieldName()});
            }

            @Override
            void generateReadMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("$N = new Date(bytes.readLong())", new Object[]{DateFieldModel.this.fieldName()});
            }

            @Override
            void generateArrayElementReadMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addStatement("$N[index] = new Date(bytes.readLong())", new Object[]{DateFieldModel.this.fieldName()});
            }
        };
    }
}

