/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.threads.TimingPauser;
import org.jetbrains.annotations.NotNull;

public class YieldingPauser
implements TimingPauser {
    final int minBusy;
    int count = 0;
    private long timePaused = 0L;
    private long countPaused = 0L;
    private long yieldStart = 0L;
    private long timeOutStart = Long.MAX_VALUE;

    public YieldingPauser(int minBusy) {
        this.minBusy = minBusy;
    }

    @Override
    public void reset() {
        this.checkYieldTime();
        this.count = 0;
        this.timeOutStart = Long.MAX_VALUE;
    }

    @Override
    public void pause() {
        ++this.count;
        if (this.count < this.minBusy) {
            ++this.countPaused;
            Jvm.safepoint();
            return;
        }
        this.yield0();
        this.checkYieldTime();
    }

    @Override
    public void pause(long timeout, @NotNull TimeUnit timeUnit) throws TimeoutException {
        if (this.timeOutStart == Long.MAX_VALUE) {
            this.timeOutStart = System.nanoTime();
        }
        ++this.count;
        if (this.count < this.minBusy) {
            return;
        }
        this.yield0();
        if (System.nanoTime() - this.timeOutStart > timeUnit.toNanos(timeout)) {
            throw new TimeoutException();
        }
        this.checkYieldTime();
    }

    void checkYieldTime() {
        if (this.yieldStart > 0L) {
            long time = System.nanoTime() - this.yieldStart;
            this.timePaused += time;
            ++this.countPaused;
            this.yieldStart = 0L;
        }
    }

    void yield0() {
        if (this.yieldStart == 0L) {
            this.yieldStart = System.nanoTime();
        }
        Thread.yield();
    }

    @Override
    public void unpause() {
    }

    @Override
    public long timePaused() {
        return this.timePaused / 1000000L;
    }

    @Override
    public long countPaused() {
        return this.countPaused;
    }

    public String toString() {
        if (this.minBusy == 2) {
            return "PauserMode.yielding";
        }
        return "YieldingPauser{minBusy=" + this.minBusy + '}';
    }
}

