/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import net.openhft.chronicle.threads.Pauser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MilliPauser
implements Pauser {
    private final AtomicBoolean pausing = new AtomicBoolean();
    private long pauseTimeMS;
    private long timePaused = 0L;
    private long countPaused = 0L;
    private long pauseUntilMS = 0L;
    @Nullable
    private volatile transient Thread thread = null;

    public MilliPauser(long pauseTimeMS) {
        this.pauseTimeMS = pauseTimeMS;
    }

    public MilliPauser pauseTimeMS(long pauseTimeMS) {
        this.pauseTimeMS = pauseTimeMS;
        return this;
    }

    public MilliPauser minPauseTimeMS(long pauseTimeMS) {
        this.pauseTimeMS = Math.min(this.pauseTimeMS, pauseTimeMS);
        if (this.pauseTimeMS < 1L) {
            this.pauseTimeMS = 1L;
        }
        return this;
    }

    public long pauseTimeMS() {
        return this.pauseTimeMS;
    }

    @Override
    public void reset() {
        this.pauseUntilMS = 0L;
    }

    @Override
    public void pause() {
        this.doPauseMS(this.pauseTimeMS);
    }

    @Override
    public void asyncPause() {
        this.pauseUntilMS = System.currentTimeMillis() + this.pauseTimeMS;
    }

    @Override
    public boolean asyncPausing() {
        return this.pauseUntilMS > System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void pause(long timeout, @NotNull TimeUnit timeUnit) throws TimeoutException {
        void timeUnit2;
        if (timeUnit == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'timeUnit') of net/openhft/chronicle/threads/MilliPauser.pause must not be null");
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'timeUnit') of net/openhft/chronicle/threads/MilliPauser.pause must not be null");
        }
        this.doPauseMS(timeUnit2.toMillis(timeout));
    }

    void doPauseMS(long delayMS) {
        long start = System.nanoTime();
        this.thread = Thread.currentThread();
        this.pausing.set(true);
        if (!this.thread.isInterrupted()) {
            LockSupport.parkNanos(delayMS * 1000000L);
        }
        this.pausing.set(false);
        long time = System.nanoTime() - start;
        this.timePaused += time;
        ++this.countPaused;
    }

    @Override
    public void unpause() {
        Thread threadSnapshot = this.thread;
        if (threadSnapshot != null && this.pausing.get()) {
            LockSupport.unpark(threadSnapshot);
        }
    }

    @Override
    public long timePaused() {
        return this.timePaused / 1000000L;
    }

    @Override
    public long countPaused() {
        return this.countPaused;
    }
}

