/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.threads.BusyPauser;
import net.openhft.chronicle.threads.BusyTimedPauser;
import net.openhft.chronicle.threads.LongPauser;
import net.openhft.chronicle.threads.MilliPauser;
import net.openhft.chronicle.threads.TimingPauser;
import net.openhft.chronicle.threads.YieldingPauser;
import org.jetbrains.annotations.NotNull;

public interface Pauser {
    public static final int MIN_PROCESSORS = Integer.getInteger("pauser.minProcessors", 8);
    public static final boolean SLEEPY = Pauser.getSleepy();

    public void reset();

    public void pause();

    default public void pause(long timeout, TimeUnit timeUnit) throws TimeoutException {
        throw new UnsupportedOperationException(this + " is not stateful, use a TimingPauser");
    }

    public void unpause();

    public long timePaused();

    public long countPaused();

    public static boolean getSleepy() {
        int procs = Runtime.getRuntime().availableProcessors();
        return procs < MIN_PROCESSORS;
    }

    public static Pauser yielding(int minBusy) {
        SleepyWarning.warnSleepy();
        return SLEEPY ? Pauser.sleepy() : new YieldingPauser(minBusy);
    }

    public static TimingPauser sleepy() {
        return new LongPauser(0, 100, 500L, 20000L, TimeUnit.MICROSECONDS);
    }

    public static Pauser balanced() {
        return Pauser.balancedUpToMillis(20);
    }

    public static Pauser balancedUpToMillis(int millis) {
        return SLEEPY ? Pauser.sleepy() : new LongPauser(20000, 250, 50L, (Jvm.isDebug() ? 200000 : 0) + millis * 1000, TimeUnit.MICROSECONDS);
    }

    public static MilliPauser millis(int millis) {
        return new MilliPauser(millis);
    }

    public static Pauser millis(int minMillis, int maxMillis) {
        return new LongPauser(0, 0, minMillis, maxMillis, TimeUnit.MILLISECONDS);
    }

    public static Pauser yielding() {
        return Pauser.yielding(2);
    }

    @NotNull
    public static Pauser busy() {
        SleepyWarning.warnSleepy();
        return SLEEPY ? Pauser.sleepy() : BusyPauser.INSTANCE;
    }

    @NotNull
    public static TimingPauser timedBusy() {
        return SLEEPY ? Pauser.sleepy() : new BusyTimedPauser();
    }

    public static enum SleepyWarning {


        static void warnSleepy() {
        }

        static {
            if (SLEEPY) {
                int procs = Runtime.getRuntime().availableProcessors();
                Jvm.warn().on(Pauser.class, "Using Pauser.sleepy() as not enough processors, have " + procs + ", needs " + MIN_PROCESSORS + "+");
            }
        }
    }
}

