/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Threads;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingEventLoop
implements EventLoop {
    private static final Logger LOG = LoggerFactory.getLogger(BlockingEventLoop.class);
    @NotNull
    private final EventLoop parent;
    @NotNull
    private final ExecutorService service;
    @NotNull
    private final String name;
    private volatile boolean closed;
    private volatile boolean started;
    private List<EventHandler> handlers = new ArrayList<EventHandler>();

    public BlockingEventLoop(@NotNull EventLoop parent, @NotNull String name) {
        this.name = name;
        this.parent = parent;
        this.service = Executors.newCachedThreadPool(new NamedThreadFactory(name, true));
    }

    public BlockingEventLoop(@NotNull String name) {
        this.name = name;
        this.parent = this;
        this.service = Executors.newCachedThreadPool(new NamedThreadFactory(name, true));
    }

    public void awaitTermination() {
        try {
            this.service.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void addHandler(@NotNull EventHandler handler) {
        if (this.isClosed()) {
            throw new IllegalStateException("Event Group has been closed");
        }
        this.handlers.add(handler);
        if (this.started) {
            this.startHandler(handler);
        }
    }

    private String asString(Object handler) {
        return Integer.toHexString(System.identityHashCode(handler));
    }

    public void start() {
        this.started = true;
        this.handlers.forEach(this::startHandler);
    }

    @NotNull
    private void startHandler(EventHandler handler) {
        try {
            this.service.submit(new Runner(handler));
        }
        catch (RejectedExecutionException e) {
            Jvm.warn().on(this.getClass(), (Throwable)e);
        }
    }

    public void unpause() {
    }

    public void stop() {
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isAlive() {
        return !this.service.isShutdown();
    }

    public void close() {
        this.closed = true;
        Threads.shutdown(this.service);
        if (!this.started) {
            this.handlers.forEach(EventHandler::loopFinished);
        }
        Closeable.closeQuietly(this.handlers);
    }

    public String toString() {
        return "BlockingEventLoop{name=" + this.name + '}';
    }

    private class Runner
    implements Runnable {
        private final EventHandler handler;

        public Runner(EventHandler handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            this.handler.eventLoop(BlockingEventLoop.this.parent);
            try {
                while (!BlockingEventLoop.this.closed) {
                    this.handler.action();
                }
            }
            catch (InvalidEventHandlerException invalidEventHandlerException) {
            }
            catch (Throwable t) {
                if (!BlockingEventLoop.this.closed) {
                    Jvm.warn().on(this.handler.getClass(), BlockingEventLoop.this.asString(this.handler) + " threw", t);
                }
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    Jvm.debug().on(this.handler.getClass(), "handler " + BlockingEventLoop.this.asString(this.handler) + " done.");
                }
                this.handler.loopFinished();
            }
        }
    }
}

