/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.HandlerPriority;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ThreadMonitorEventHandler
implements EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadMonitorEventHandler.class);
    private static final int TIMING_ERROR = OS.isWindows() ? 20000000 : 12000000;
    private final String description;
    private final long timeLimit;
    private final LongSupplier timeSupplier;
    private final Supplier<Thread> threadSupplier;
    private final BooleanSupplier logEnabled;
    private final Consumer<String> logConsumer;
    private long lastTime = 0L;
    private long lastActionCall = Long.MAX_VALUE;

    ThreadMonitorEventHandler(String description, long timeLimit, LongSupplier timeSupplier, Supplier<Thread> threadSupplier) {
        this(description, timeLimit, timeSupplier, threadSupplier, () -> ((Logger)LOG).isInfoEnabled(), arg_0 -> ((Logger)LOG).info(arg_0));
    }

    ThreadMonitorEventHandler(String description, long timeLimit, LongSupplier timeSupplier, Supplier<Thread> threadSupplier, BooleanSupplier logEnabled, Consumer<String> logConsumer) {
        this.description = description;
        this.timeLimit = timeLimit;
        this.timeSupplier = timeSupplier;
        this.threadSupplier = threadSupplier;
        this.logEnabled = logEnabled;
        this.logConsumer = logConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean action() {
        long time = this.timeSupplier.getAsLong();
        long now = System.nanoTime();
        try {
            if (time == Long.MIN_VALUE || time == Long.MAX_VALUE) {
                boolean bl = false;
                return bl;
            }
            if (now - this.lastActionCall > this.timeLimit + (long)TIMING_ERROR) {
                Thread thread = this.threadSupplier.get();
                if (thread != null && thread.isAlive()) {
                    this.logConsumer.accept("Monitor thread for " + thread.getName() + " was delayed by " + (double)((now - this.lastActionCall) / 100000L) / 10.0 + " ms");
                }
                boolean bl = true;
                return bl;
            }
            long latency = now - time;
            if (latency <= this.timeLimit) {
                boolean bl = false;
                return bl;
            }
            Thread thread = this.threadSupplier.get();
            if (thread != null && thread.isAlive() && this.logEnabled.getAsBoolean()) {
                String type = time == this.lastTime ? "re-reporting" : "new report";
                StringBuilder out = new StringBuilder().append("THIS IS NOT AN ERROR, but a profile of the thread, ").append(this.description).append(" thread ").append(thread.getName()).append(" interrupted ").append(thread.isInterrupted()).append(" blocked for ").append(TimeUnit.NANOSECONDS.toMillis(latency)).append(" ms. ").append(type);
                Jvm.trimStackTrace((StringBuilder)out, (StackTraceElement[])thread.getStackTrace());
                this.logConsumer.accept(out.toString());
                this.lastTime = time;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lastActionCall = now;
        }
    }

    @NotNull
    public HandlerPriority priority() {
        return HandlerPriority.MONITOR;
    }
}

