/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;

public abstract class TimedEventHandler
implements EventHandler {
    private long nextRunNS = 0L;

    public boolean action() throws InvalidEventHandlerException, InterruptedException {
        long now = System.nanoTime();
        if (this.nextRunNS <= now) {
            long delayUS = this.timedAction();
            if (delayUS < 0L) {
                return true;
            }
            this.nextRunNS = now + delayUS * 1000L;
        }
        return false;
    }

    protected abstract long timedAction();

    public HandlerPriority priority() {
        return HandlerPriority.TIMER;
    }
}

