/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.threads.NamedThreadFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingEventLoop
implements EventLoop {
    private static final Logger LOG = LoggerFactory.getLogger(BlockingEventLoop.class);
    private final EventLoop parent;
    private final Consumer<Throwable> onThrowable;
    @NotNull
    private final ExecutorService service;
    @Nullable
    private Thread thread = null;
    private volatile boolean closed;
    private EventHandler handler;

    public BlockingEventLoop(@NotNull EventLoop parent, @NotNull String name, @NotNull Consumer<Throwable> onThrowable) {
        this.parent = parent;
        this.onThrowable = onThrowable;
        this.service = Executors.newCachedThreadPool(new NamedThreadFactory(name, true));
    }

    public void addHandler(boolean dontAttemptToRunImmediatelyInCurrentThread, @NotNull EventHandler handler) {
        this.addHandler(handler);
    }

    public void addHandler(@NotNull EventHandler handler) {
        block2: {
            this.handler = handler;
            try {
                this.service.submit(() -> {
                    this.thread = Thread.currentThread();
                    handler.eventLoop(this.parent);
                    try {
                        while (!this.closed) {
                            handler.action();
                        }
                    }
                    catch (InvalidEventHandlerException invalidEventHandlerException) {
                    }
                    catch (Throwable t) {
                        this.onThrowable.accept(t);
                    }
                    finally {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("handler " + handler + " done.");
                        }
                        if (this.closed) {
                            Closeable.closeQuietly((Object)this.handler);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                if (this.closed) break block2;
                LOG.error("", (Throwable)e);
            }
        }
    }

    public void start() {
    }

    public void unpause() {
    }

    public void stop() {
    }

    public boolean isClosed() {
        return this.service.isShutdown();
    }

    public boolean isAlive() {
        return !this.service.isShutdown();
    }

    public void close() {
        this.closed = true;
        Closeable.closeQuietly((Object)this.handler);
        this.service.shutdown();
        try {
            if (!this.service.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                this.service.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.service.shutdownNow();
        }
        try {
            if (this.thread != null) {
                this.thread.join(100L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this.thread != null && this.thread.isAlive()) {
            StackTraceElement[] stackTrace = this.thread.getStackTrace();
            StringBuilder sb = new StringBuilder(this.thread + " still running ");
            Jvm.trimStackTrace((StringBuilder)sb, (StackTraceElement[])stackTrace);
            LOG.info(sb.toString());
        }
    }
}

