/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.lang.reflect.Field;
import java.util.concurrent.Callable;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.ForceInline;
import org.jetbrains.annotations.NotNull;

public enum Threads {

    static final Field GROUP = Jvm.getField(Thread.class, (String)"group");

    @ForceInline
    public static <R> R withThreadGroup(ThreadGroup tg, @NotNull Callable<R> callable) {
        Thread thread = Thread.currentThread();
        ThreadGroup tg0 = thread.getThreadGroup();
        Threads.setThreadGroup(thread, tg);
        try {
            R r = callable.call();
            return r;
        }
        catch (Exception e) {
            throw Jvm.rethrow((Throwable)e);
        }
        finally {
            Threads.setThreadGroup(thread, tg0);
        }
    }

    @ForceInline
    public static void setThreadGroup(Thread thread, ThreadGroup tg) {
        try {
            GROUP.set(thread, tg);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public static String threadGroupPrefix() {
        String threadGroupName = Thread.currentThread().getThreadGroup().getName();
        if (!threadGroupName.endsWith("/")) {
            threadGroupName = threadGroupName + "/";
        }
        return threadGroupName;
    }
}

