/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.xml.ws.WebServiceException;
import net.openhft.chronicle.core.annotation.HotMethod;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.api.EventHandler;
import net.openhft.chronicle.threads.api.EventLoop;
import net.openhft.chronicle.threads.api.InvalidEventHandlerException;
import org.jetbrains.annotations.NotNull;

public class MonitorEventLoop
implements EventLoop,
Runnable,
Closeable {
    final ExecutorService service = Executors.newSingleThreadExecutor(new NamedThreadFactory("event-loop-monitor", true));
    private final EventLoop parent;
    private final List<EventHandler> handlers = new ArrayList<EventHandler>();
    private final Pauser pauser;
    private volatile boolean running = true;

    public MonitorEventLoop(EventLoop parent, Pauser pauser) {
        this.parent = parent;
        this.pauser = pauser;
    }

    @Override
    public void start() {
        this.running = true;
        this.service.submit(this);
    }

    @Override
    public void unpause() {
        this.pauser.unpause();
    }

    @Override
    public void stop() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHandler(@NotNull EventHandler handler) {
        List<EventHandler> list = this.handlers;
        synchronized (list) {
            this.handlers.add(handler);
            handler.eventLoop(this.parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @HotMethod
    public void run() {
        try {
            while (this.running) {
                boolean busy;
                List<EventHandler> list = this.handlers;
                synchronized (list) {
                    busy = this.runHandlers();
                }
                if (busy) {
                    this.pauser.reset();
                    continue;
                }
                this.pauser.pause();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @HotMethod
    private boolean runHandlers() {
        boolean busy = false;
        for (int i = 0; i < this.handlers.size(); ++i) {
            EventHandler handler = this.handlers.get(i);
            if (handler == null) continue;
            try {
                busy |= handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                this.handlers.remove(i--);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return busy;
    }

    @Override
    public void close() throws WebServiceException {
        this.service.shutdown();
        try {
            if (!this.service.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                this.service.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.service.shutdownNow();
        }
    }
}

