/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.threads.Pauser;

public class LightPauser
implements Pauser {
    public static final long NO_BUSY_PERIOD = -1L;
    public static final long NO_PAUSE_PERIOD = -1L;
    private final AtomicBoolean pausing = new AtomicBoolean();
    private final long busyPeriodNS;
    private final long parkPeriodNS;
    private int count;
    private long pauseStart = 0L;
    private volatile Thread thread;

    public LightPauser(long busyPeriodNS, long parkPeriodNS) {
        this.busyPeriodNS = busyPeriodNS;
        this.parkPeriodNS = parkPeriodNS;
    }

    @Override
    @ForceInline
    public void reset() {
        this.count = 0;
        this.pauseStart = 0;
    }

    @Override
    public void pause() {
        this.pause(this.parkPeriodNS);
    }

    @Override
    public void pause(long maxPauseNS) {
        if (this.busyPeriodNS > 0L) {
            if (this.count++ < 1000) {
                return;
            }
            if (this.pauseStart == 0L) {
                this.pauseStart = System.nanoTime();
                return;
            }
            if (System.nanoTime() < this.pauseStart + this.busyPeriodNS) {
                return;
            }
        }
        if (maxPauseNS < 10000L) {
            return;
        }
        this.thread = Thread.currentThread();
        this.pausing.set(true);
        this.doPause(maxPauseNS);
        this.pausing.set(false);
    }

    protected void doPause(long maxPauseNS) {
        LockSupport.parkNanos(Math.max(maxPauseNS, this.parkPeriodNS));
    }

    @Override
    @ForceInline
    public void unpause() {
        if (this.pausing.get()) {
            LockSupport.unpark(this.thread);
        }
    }
}

