/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.salt;

import javax.xml.bind.DatatypeConverter;
import jnr.ffi.LibraryLoader;
import jnr.ffi.Platform;
import jnr.ffi.annotations.In;
import jnr.ffi.annotations.Out;
import jnr.ffi.byref.LongLongByReference;
import jnr.ffi.types.u_int64_t;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;

public interface Sodium {
    public static final String STANDARD_GROUP_ELEMENT = "0900000000000000000000000000000000000000000000000000000000000000";
    public static final BytesStore<?, ?> SGE_BYTES = Init.fromHex(0, "0900000000000000000000000000000000000000000000000000000000000000");
    public static final int ED25519_PUBLICKEY_BYTES = 32;
    public static final int ED25519_PRIVATEKEY_BYTES = 32;
    public static final int ED25519_SECRETKEY_BYTES = 64;
    public static final Sodium SODIUM = Init.init();

    public static void checkValid(int status, String description) {
        if (status != 0) {
            throw new IllegalStateException(description + ", status: " + status);
        }
    }

    public int sodium_init();

    public String sodium_version_string();

    public void randombytes(@In long var1, @In @u_int64_t int var3);

    public int crypto_box_curve25519xsalsa20poly1305_keypair(@In long var1, @In long var3);

    public int crypto_sign_ed25519_seed_keypair(@In long var1, @In long var3, @In long var5);

    public int crypto_sign_ed25519(@In long var1, @Out LongLongByReference var3, @In long var4, @In @u_int64_t int var6, @In long var7);

    public int crypto_sign_ed25519_open(@In long var1, @Out LongLongByReference var3, @In long var4, @In @u_int64_t int var6, @In long var7);

    public int crypto_scalarmult_curve25519(@In long var1, @In long var3, @In long var5);

    public int crypto_hash_sha256(@In long var1, @In long var3, @In @u_int64_t int var5);

    public int crypto_hash_sha512(@In long var1, @In long var3, @In @u_int64_t int var5);

    public static enum Init {


        static Sodium init() {
            String libraryName = "sodium";
            if (Platform.getNativePlatform().getOS() == Platform.OS.WINDOWS) {
                libraryName = "libsodium";
            }
            Sodium sodium = null;
            try {
                sodium = (Sodium)LibraryLoader.create(Sodium.class).search("lib").search("/usr/local/lib").search("/opt/local/lib").load(libraryName);
            }
            catch (Error e) {
                if (Platform.getNativePlatform().getOS() == Platform.OS.WINDOWS) {
                    System.err.println("Unable to load libsodium, make sure the Visual C++ Downloadable is installed\nhttps://support.microsoft.com/en-gb/help/2977003/the-latest-supported-visual-c-downloads");
                }
                throw e;
            }
            Sodium.checkValid(sodium.sodium_init(), "sodium_init()");
            return sodium;
        }

        static Bytes<?> fromHex(int padding, String s) {
            byte[] byteArr = DatatypeConverter.parseHexBinary((String)s);
            VanillaBytes bytes = Bytes.allocateDirect((long)(padding + byteArr.length));
            if (padding > 0) {
                bytes.zeroOut(0L, (long)padding);
                bytes.writePosition((long)padding);
            }
            bytes.write(byteArr);
            return bytes;
        }
    }
}

