/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.salt;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.salt.Sodium;

public enum SHA2 {

    static final int HASH_SHA256_BYTES = 32;
    static final int HASH_SHA512_BYTES = 64;

    public static void sha256(Bytes<?> hash256, BytesStore<?, ?> message) {
        long wp = hash256.writePosition();
        hash256.ensureCapacity(wp + 32L);
        Sodium.SODIUM.crypto_hash_sha256(hash256.addressForWrite(wp), message.addressForRead(message.readPosition()), Maths.toUInt31((long)message.readRemaining()));
        hash256.writeSkip(32L);
    }

    public static void sha512(Bytes<?> hash512, BytesStore<?, ?> message) {
        long wp = hash512.writePosition();
        hash512.ensureCapacity(wp + 64L);
        Sodium.SODIUM.crypto_hash_sha512(hash512.addressForWrite(wp), message.addressForRead(message.readPosition()), Maths.toUInt31((long)message.readRemaining()));
        hash512.writeSkip(64L);
    }
}

