/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.salt;

import jnr.ffi.byref.LongLongByReference;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.salt.Sodium;

public final class Ed25519
extends Enum<Ed25519> {
    public static final int PRIVATE_KEY_LENGTH = 32;
    public static final int PUBLIC_KEY_LENGTH = 32;
    public static final int SECRET_KEY_LENGTH = 64;
    public static final int SIGNATURE_LENGTH = 64;
    private static final ThreadLocal<LocalEd25519> CACHED_CRYPTO;
    private static final /* synthetic */ Ed25519[] $VALUES;

    public static Ed25519[] values() {
        return (Ed25519[])$VALUES.clone();
    }

    public static Ed25519 valueOf(String name) {
        return Enum.valueOf(Ed25519.class, name);
    }

    public static Bytes<Void> allocatePublicKey() {
        return Bytes.allocateDirect((long)32L);
    }

    public static Bytes<Void> allocatePrivateKey() {
        return Bytes.allocateDirect((long)32L);
    }

    public static Bytes<Void> allocateSecretKey() {
        return Bytes.allocateDirect((long)64L);
    }

    public static Bytes<Void> generateRandomBytes(int length) {
        NativeBytes bytes = Bytes.allocateElasticDirect((long)length);
        Sodium.SODIUM.randombytes(bytes.addressForWrite(0L), length);
        bytes.readPositionRemaining(0L, (long)length);
        return bytes;
    }

    public static void privateToPublicAndSecret(Bytes<?> publicKey, Bytes<?> secretKey, BytesStore<?, ?> privateKey) {
        if (privateKey.readRemaining() != 32L) {
            throw new IllegalArgumentException("privateKey");
        }
        assert (privateKey.refCount() > 0L);
        assert (secretKey.refCount() > 0L);
        assert (publicKey.refCount() > 0L);
        publicKey.ensureCapacity(publicKey.writePosition() + 32L);
        secretKey.ensureCapacity(secretKey.writePosition() + 64L);
        assert (privateKey.isDirectMemory());
        assert (secretKey.isDirectMemory());
        assert (publicKey.isDirectMemory());
        Sodium.SODIUM.crypto_sign_ed25519_seed_keypair(publicKey.addressForWrite(publicKey.writePosition()), secretKey.addressForWrite(secretKey.writePosition()), privateKey.addressForRead(privateKey.readPosition()));
        publicKey.readPositionRemaining(publicKey.writePosition(), 32L);
        secretKey.readPositionRemaining(secretKey.writePosition(), 64L);
    }

    public static void sign(Bytes<?> sigAndMsg, BytesStore<?, ?> message, BytesStore<?, ?> secretKey) {
        sigAndMsg.ensureCapacity(sigAndMsg.writePosition() + 64L + message.readRemaining());
        assert (sigAndMsg.refCount() > 0L);
        assert (message.refCount() > 0L);
        assert (secretKey.refCount() > 0L);
        assert (sigAndMsg.isDirectMemory());
        assert (message.isDirectMemory());
        assert (secretKey.isDirectMemory());
        if (secretKey.readRemaining() != 64L) {
            throw new IllegalArgumentException("Must be a secretKey");
        }
        CACHED_CRYPTO.get().sign(sigAndMsg, message, secretKey);
    }

    public static boolean verify(BytesStore<?, ?> sigAndMsg, BytesStore<?, ?> publicKey) {
        assert (sigAndMsg.refCount() > 0L);
        assert (publicKey.refCount() > 0L);
        assert (sigAndMsg.isDirectMemory());
        assert (publicKey.isDirectMemory());
        if (sigAndMsg.readRemaining() < 64L) {
            throw new IllegalArgumentException("sigAndMsg");
        }
        if (publicKey.readRemaining() != 32L) {
            throw new IllegalArgumentException("publicKey");
        }
        return CACHED_CRYPTO.get().verify(sigAndMsg, publicKey);
    }

    public static void generatePrivateKey(Bytes<?> privateKey) {
        assert (privateKey.refCount() > 0L);
        privateKey.ensureCapacity(32L);
        assert (privateKey.isDirectMemory());
        Sodium.SODIUM.randombytes(privateKey.addressForWrite(0L), 32);
        privateKey.readPositionRemaining(0L, 32L);
    }

    public static Bytes<Void> generatePrivateKey() {
        VanillaBytes privateKey = Bytes.allocateDirect((long)32L);
        Ed25519.generatePrivateKey(privateKey);
        return privateKey;
    }

    public static void generatePublicAndSecretKey(Bytes<Void> publicKey, Bytes<Void> secretKey) {
        VanillaBytes privateKey = Bytes.allocateDirect((long)32L);
        try {
            Ed25519.generatePrivateKey(privateKey);
            Ed25519.privateToPublicAndSecret(publicKey, secretKey, privateKey);
        }
        finally {
            privateKey.release();
        }
    }

    static {
        $VALUES = new Ed25519[0];
        CACHED_CRYPTO = ThreadLocal.withInitial(LocalEd25519::new);
    }

    static class LocalEd25519 {
        final LongLongByReference sigLen = new LongLongByReference(0L);
        final Bytes<?> buffer = Bytes.allocateElasticDirect((long)64L);

        LocalEd25519() {
        }

        void sign(Bytes<?> sigAndMsg, BytesStore<?, ?> message, BytesStore<?, ?> secretKey) {
            int msgLen = (int)message.readRemaining();
            Sodium.checkValid(Sodium.SODIUM.crypto_sign_ed25519(sigAndMsg.addressForWrite(sigAndMsg.writePosition()), this.sigLen, message.addressForRead(message.readPosition()), msgLen, secretKey.addressForRead(secretKey.readPosition())), "Unable to sign");
            long bytesToSkip = this.sigLen.longValue();
            sigAndMsg.writeSkip(bytesToSkip);
        }

        boolean verify(BytesStore<?, ?> sigAndMsg, BytesStore<?, ?> publicKey) {
            int length = sigAndMsg.length();
            this.buffer.ensureCapacity((long)length);
            int ret = Sodium.SODIUM.crypto_sign_ed25519_open(this.buffer.addressForWrite(0L), this.sigLen, sigAndMsg.addressForRead(sigAndMsg.readPosition()), (int)sigAndMsg.readRemaining(), publicKey.addressForRead(publicKey.readPosition()));
            long l = this.sigLen.longValue();
            assert (l <= (long)length);
            return ret == 0;
        }
    }
}

